import 'package:flutter/material.dart';

class Styles {
  // #FFFFFF
  static const MaterialColor white = MaterialColor(4294967295, {
    50: Color(0xffffffff),
    100: Color(0xffffffff),
    200: Color(0xffffffff),
    300: Color(0xffffffff),
    400: Color(0xffffffff),
    500: Color(0xffffffff),
    600: Color(0xffe5e5e5),
    700: Color(0xffcccccc),
    800: Color(0xffb2b2b2),
    900: Color(0xff999999)
  });

  // 303030
  static const MaterialColor grey = MaterialColor(4281348144, {
    50: Color(0xff8d8d8d),
    100: Color(0xff838383),
    200: Color(0xff6e6e6e),
    300: Color(0xff595959),
    400: Color(0xff454545),
    500: Color(0xff303030),
    600: Color(0xff2b2b2b),
    700: Color(0xff262626),
    800: Color(0xff222222),
    900: Color(0xff1d1d1d)
  });

  // #121212
  static const MaterialColor darkGrey = MaterialColor(4279374354, {
    50: Color(0xff7d7d7d),
    100: Color(0xff717171),
    200: Color(0xff595959),
    300: Color(0xff414141),
    400: Color(0xff2a2a2a),
    500: Color(0xff121212),
    600: Color(0xff101010),
    700: Color(0xff0e0e0e),
    800: Color(0xff0d0d0d),
    900: Color(0xff0b0b0b)
  });

  // 3DC2FF
  static const MaterialColor ionicCyan = MaterialColor(4282237695, {
    50: Color(0xff94ddff),
    100: Color(0xff8bdaff),
    200: Color(0xff77d4ff),
    300: Color(0xff64ceff),
    400: Color(0xff50c8ff),
    500: Color(0xff3dc2ff),
    600: Color(0xff37afe5),
    700: Color(0xff319bcc),
    800: Color(0xff2b88b2),
    900: Color(0xff257499)
  });

  // #3880FF
  static const MaterialColor ionicBlue = MaterialColor(4281893119, {
    50: Color(0xff92b9ff),
    100: Color(0xff88b3ff),
    200: Color(0xff74a6ff),
    300: Color(0xff6099ff),
    400: Color(0xff4c8dff),
    500: Color(0xff3880ff),
    600: Color(0xff3273e5),
    700: Color(0xff2d66cc),
    800: Color(0xff275ab2),
    900: Color(0xff224d99)
  });

  // #5260FF
  static const MaterialColor ionicIndigo = MaterialColor(4283588863, {
    50: Color(0xffa0a8ff),
    100: Color(0xff97a0ff),
    200: Color(0xff8690ff),
    300: Color(0xff7580ff),
    400: Color(0xff6370ff),
    500: Color(0xff5260ff),
    600: Color(0xff4a56e5),
    700: Color(0xff424dcc),
    800: Color(0xff3943b2),
    900: Color(0xff313a99)
  });

  // 7C4DFF
  static const MaterialColor violet = MaterialColor(4286336511, {
    50: Color(0xffb79dff),
    100: Color(0xffb094ff),
    200: Color(0xffa382ff),
    300: Color(0xff9671ff),
    400: Color(0xff895fff),
    500: Color(0xff7c4dff),
    600: Color(0xff7045e5),
    700: Color(0xff633ecc),
    800: Color(0xff5736b2),
    900: Color(0xff4a2e99)
  });

  // E040FB
  static const MaterialColor purple = MaterialColor(4292886779, {
    50: Color(0xffee96fd),
    100: Color(0xffec8cfd),
    200: Color(0xffe979fc),
    300: Color(0xffe666fc),
    400: Color(0xffe353fb),
    500: Color(0xffe040fb),
    600: Color(0xffca3ae2),
    700: Color(0xffb333c9),
    800: Color(0xff9d2db0),
    900: Color(0xff862697)
  });

  // F00075
  static const MaterialColor pink = MaterialColor(4293918837, {
    50: Color(0xfff773b3),
    100: Color(0xfff666ac),
    200: Color(0xfff54d9e),
    300: Color(0xfff33391),
    400: Color(0xfff11983),
    500: Color(0xfff00075),
    600: Color(0xffd80069),
    700: Color(0xffc0005e),
    800: Color(0xffa80052),
    900: Color(0xff900046)
  });

  // EB0028
  static const MaterialColor oneplusRed = MaterialColor(4293591080, {
    50: Color(0xfff47389),
    100: Color(0xfff3667e),
    200: Color(0xfff14d69),
    300: Color(0xffef3353),
    400: Color(0xffed193d),
    500: Color(0xffeb0028),
    600: Color(0xffd30024),
    700: Color(0xffbc0020),
    800: Color(0xffa4001c),
    900: Color(0xff8d0018)
  });

  // #EB445A
  static const MaterialColor lightRed = MaterialColor(4293608538, {
    50: Color(0xfff498a4),
    100: Color(0xfff38f9c),
    200: Color(0xfff17c8c),
    300: Color(0xffef697b),
    400: Color(0xffed576a),
    500: Color(0xffeb445a),
    600: Color(0xffd33d51),
    700: Color(0xffbc3648),
    800: Color(0xffa4303f),
    900: Color(0xff8d2936)
  });

  // FF5722
  static const MaterialColor orange = MaterialColor(4294924066, {
    50: Color(0xffffa385),
    100: Color(0xffff9a7a),
    200: Color(0xffff8964),
    300: Color(0xffff794e),
    400: Color(0xffff6838),
    500: Color(0xffff5722),
    600: Color(0xffe54e1f),
    700: Color(0xffcc461b),
    800: Color(0xffb23d18),
    900: Color(0xff993414)
  });

  // 21EF8B
  static const MaterialColor aospExtendedGreen = MaterialColor(4280414091, {
    50: Color(0xff85f6bf),
    100: Color(0xff7af5b9),
    200: Color(0xff64f4ae),
    300: Color(0xff4df2a2),
    400: Color(0xff37f197),
    500: Color(0xff21ef8b),
    600: Color(0xff1ed77d),
    700: Color(0xff1abf6f),
    800: Color(0xff17a761),
    900: Color(0xff148f53)
  });

  static MaterialColor primaryBackgroundColor = darkGrey;
  static MaterialColor secondaryBackgroundColor = grey;
  static MaterialColor foregroundColor = white;
  static MaterialColor primaryColor = ionicBlue;
  static MaterialColor secondaryColor = lightRed;

  static final Map<String, MaterialColor> accentColors = {
    'Cyan': ionicCyan,
    'Blue': ionicBlue,
    'Indigo': ionicIndigo,
    'Violet': violet,
    'Purple': purple,
    'Pink': pink,
    'Red': oneplusRed,
    'Orange': orange,
    'Green': aospExtendedGreen,
  };
}
