# Ladderly.io Analytical Scripts

This directory contains scripts and data for various insights

## installation and usage

navigate to the directory containing this README in a terminal and create a virtual environment:

```bash
python3 -m venv .venv
source .venv/bin/activate
```

optionally upgrade pip:

```bash
pip install --upgrade pip
```

install the requirements file and run your script of choice!

```bash
python3 -m pip install -r requirements.txt
python3 blog-15-job-search-regression.py
```

Python 3.12.x is currently supported.

## contributing

1. ensure requirements are tracked in requirements.txt
2. include a comment at the top of the script summarizing the purpose.
   1. This comment should be terse, ideally tweet length or less. If you require a verbose explanation, consider creating a blog article instead and referencing the blog article from the script comment.
3. submit a pull request! optionally contact the team over Discord to get your work prioritized. To join the Discord:
   1. visit https://ladderly.io
   2. from the top navigation menu, click community -> Discord
   3. you can post about your PR in any channel. Within the specific #contributor-chat channel you can optionally tag `@everyone`
