import React from 'react'
import { Form, FormProps } from 'src/core/components/Form'
import { LabeledTextField } from 'src/core/components/LabeledTextField'

import { z } from 'zod'
export { FORM_ERROR } from 'src/core/components/Form'

export function ChecklistForm<S extends z.ZodType<any, any>>(
  props: FormProps<S>
) {
  return (
    <Form<S> {...props}>
      <LabeledTextField
        name="name"
        label="Name"
        placeholder="Name"
        type="text"
      />
      <LabeledTextField
        name="user"
        label="User"
        placeholder="User"
        type="text"
      />
      <LabeledTextField
        name="item"
        label="Item"
        placeholder="Item"
        type="text"
      />
      {/* template: <__component__ name="__fieldName__" label="__Field_Name__" placeholder="__Field_Name__"  type="__inputType__" /> */}
    </Form>
  )
}
