---
title: '16. The Century Project'
date: 8/5/24
author: John Vandivier
---

This article describes a Ladderly.io community initiative related to exercise called The Century Project (TCP).

## Why a Health Initiative?

Health is crucial to high performance, including high performance in cognitive work. Exercise is crucial to health, but general fitness guidance and online fitness communities are not tailored to cognitive work and Ladderly.io values.

## Core Values

The Century Project supports technical excellence in four core values. This sections defines these core values and elaborates on them using by noting related items that our community emphasizes, recognizes, and resolves to act on.

1. Holistic Health
   1. We recognize the importance of both physical and mental health.
   2. We recognize the role of activity, community, nutrition, and rest for optimal health.
2. Optimal Stress
   1. We recognize that stress can create positive and negative effects.
   2. We resolve to use personalized empirical analysis and time management to create a plan of intentional and optimal stress.
   3. We emphasize the value of cognitive performance, so we emphasize the value of constructive cognitive stress.
3. Failure as a Normal Good
   1. We recognize that plans are subject to error, failure, and surprise, and good plans are subject to measurable error, failure, and surprise.
   2. We recognize that error measurement is essential to improve planning, so we resolve to celebrate the observation of error.
   3. We recognize the endogeneity of attitude and cognitive performance, so we resolve to reframe negative mental models into positive mental models when such an action can be taken without a substantial loss in accuracy.
4. Technical Constellation
   1. We recognize that the identification of our community as a constellation means that we are a group of stars, so we resolve to maintain the image of our community as a community of technical celebrities and we emphasize the utility of the STAR method.
   2. We recognize the importance of brand building, content creation, social networking, learning in public, building in public, and collaboration for optimal career performance.
   3. We emphasize a desire for our technical constellation as a platform to generate social welfare alongside private gain within our community.
   4. We recognize that a powerful technique to bolster our image as a community of technical celebrities is to actually achieve a high bar of technical achievement.
   5. We recognize that a powerful technique to bolster our image as a community of technical celebrities is to celebrate the achievements of our peers in private and in public.
   6. We resolve to exploit social biases like the halo effect for practical career benefit by maintaining a high bar for appearance.
   7. We resolve to actively mitigate social and other biases in our own analysis and planning.

## Protocol

The project protocol has three parts:

1. The Exercise Protocol
   1. Exercise one hundred times each year.
   2. Complete at least one hundred repetitions during each workout.
2. The Holistic Protocol
   1. When you are in normal health, take one and only one rest day per week.
   2. Take at least one cognitive day per week.
      1. A cognitive day is devoted to learning, tinkering, mindfulness, or other mental exercise.
      2. Feel free to go on a walk, but avoid strenuous exercise.
   3. When you are not in normal health, care for yourself, heal, take all of the rest you need, and resist negative self-talk.
3. Public Participation
   1. Brag once per week about a physical achievement.
   2. Brag once per week about a cognitive achievement.
   3. Celebrate someone else at least once per week.
   4. Log your activity on the Ladderly.io platform (coming soon).

### Advanced Guidance on Exercise

Workouts can be categorized by the volume of repetitions and by degree of subjective difficulty. Let a workout be considered low, medium, or high in repetitions and low, medium, or high in difficulty. Now we can imagine a 3x3 matrix or grid of workout shapes.

Here is an L-shaped matrix, which would be discouraged:

|            | Easy | Medium | Hard |
| ---------- | ---- | ------ | ---- |
| High Rep   |      | X      |      |
| Medium Rep |      | X      |      |
| Low Rep    |      | X      | X    |

The Century Project is not a bodybuilding regime. TCP is not intended to maximize the growth of muscle mass. TCP actively seeks to avoid cardiovascular issues and other risk of injury associated with classic bodybuilding. Ladderly.io discourages easy workouts of any kind and also discourages low repetition workouts with high effort.

TCP is intended to optimize cognitive performance including cognitive toughness, resilience under stress, familiarity with cognitive stress, and even a level of comfort with cognitive stress. By advocating many repetitions with lower weight, TCP supports a high cognitive effort and pro-cardiovascular exercise experience by allowing a participant to get close to failure with lower injury risk compared to many alternatives.

With the exception of the L-shaped archetype, most mixes of medium and hard bouts are fine, and an intended outcome of TCP in the future is to observe the correlation of exercise patterns including these archetypes over time to career performance. Because hard data doesn't exist on these things yet, a strong recommendation isn't available, but Ladderly.io does weakly advocate for a Top-Right Square archetype to emphasize high repetition count and high exertion:

|            | Easy | Medium | Hard |
| ---------- | ---- | ------ | ---- |
| High Rep   |      | X      | X    |
| Medium Rep |      | X      | X    |
| Low Rep    |      |        |      |

Difficulty is entirely subjective, but Ladderly.io does give the following guidance on repetition count:

1. A high repetition workout is a Century Workout.
   1. A Century Workout consists of one or more Century Sets. A Century Set is a single set of at least one hundred repetitions. This is the inspiration for the project title of the Century Project.
2. A medium repetition workout includes at least one hundred repetitions of exercise, collected across any number of sets of any number of exercise types.
3. A low repetition workout includes less than one hundred repetitions of exercise.

These repetitions include all types of exercise including weight training, calisthenics, cardiovascular exercise, and more. For continuous exercise like walking, Ladderly.io encourages counting one minute of activity as a set.

Ladderly.io discourages logging a workout of less than ten repetitions. For instance, taking multiple walking breaks throughout the day on a cognitive day is great thing to do, but that would not count as a workout for the purpose of TCP tracking.
