---
title: '14. Impact Accounting'
date: 7/31/24
author: John Vandivier
---

In July of 2021, [John Vandivier dedicated his TikTok channel](https://www.tiktok.com/@johnvandivier/video/7397477281800752430) to programming education content. October of 2021 marks the [initial commit of the original Ladderly](https://github.com/Vandivier/ladderly-slides/commit/897b3066de1645e53e7afa2acf11fbc33dbcbf27) repository. This article tracks quantitative achievements over time. These metrics are useful when describing the impact of Ladderly.io in a word of mouth, marketing, behavioral interview, or other context.

## 10 Notable Achievements

This section describes ten notable achievements as of July 2024 in reverse metric size order, which is not identical to impact order but it is more straightforward to determine:

1. Ladderly.io has exceeded 15 million organic social impressions
   1. Just over 14.4 million views on [TikTok](https://www.tiktok.com/@johnvandivier)
      1. Just over 11 million of those views related to coding, career development, tech humor, and education content.
      2. Non-tech humor and socio-economic commentary were the major themes among the remainder.
   2. Over 1M from YouTube from April 1, 2023 to July 31, 2024
   3. At least 300k additional views from LinkedIn, Twitter, Instagram, Twitch, and Facebook.
2. Ladderly.io has exceeded 33k total social media followers and over 29k unique social social media followers
   1. Over 24.4k TikTok followers
   2. Over 3500 [LinkedIn followers](https://www.linkedin.com/in/john-vandivier/)
      1. I just created an [official company page](https://www.linkedin.com/company/ladderly-io), but I'm currently the only follower.
   3. Over 2800 [Twitter followers](https://twitter.com/JohnVandivier)
   4. Over 1750 [YouTube subscribers](https://www.youtube.com/channel/UCPvdqd363fzrAv68aN1Qk-A)
   5. Over 1400 [Facebook](https://www.facebook.com/ladderlyio/followers) followers
   6. There are hundreds, but not thousands, of additional followers on other platforms including Twitch and Instagram.
   7. In June of 2024, [John ran a poll](https://www.linkedin.com/posts/john-vandivier_i-wonder-how-much-overlap-my-network-has-activity-7206670687346851840-cept) that found that half of his LinkedIn followers were exclusive to LinkedIn. This article extrapolates that finding across channels to estimate the count of unique social subscribers as `24.4+(3.5+2.8+1.75+1.4)/2`, the result of which is greater than 29k.
3. Ladderly.io had over 3k unique and organic direct site visitors during the Google Analytics observation period from July 1, 2023 to July 31, 2024.
   1. About 2.2k are from the United States
4. The ladderly.io open source ecosystem consists of 790+ commits from seven individual contributors across six active repositories, earning 58 stars. The projects are:
   1. [ladderly-3](https://github.com/Vandivier/ladderly-3), which has over 105k lines of code.
   2. [ladderly-slides](https://github.com/Vandivier/ladderly-slides)
   3. [arias-tale-rpg](https://github.com/Vandivier/arias-tale-rpg)
   4. [arias-tale-tcg-python](https://github.com/Vandivier/arias-tale-tcg-python)
   5. [rect](https://github.com/Vandivier/rect)
   6. [redyellowgreen](https://github.com/Vandivier/redyellowgreen)
5. Ladderly.io generated $600 in revenue in 2024, largely driven by the first Ladderly Small Group cohort.
6. 271 unique users have signed up
7. 222 members have joined the Discord community
8. Ladderly.io had 28 unique paying customers over the period from June 2023 to July 2024.
9. The first Ladderly Small Group had six members of which five were job seekers. The pilot program and ran from February to mid-June, with one member accepting a new job offer within one month of completion!
10. Ladderly.io open source work has resulted in improvements to Pyodide, Blitz.js, and other notable projects.

## Achievements as of August 2024 and Later

This section is currently empty and it will be populated with notable achievements in chronological order. Feel free to submit a pull request if you have a notable metric or achievement regarding Ladderly.io impact!
