---
title: '13. Selecting Your Next Skill to Develop'
date: 6/12/24
author: John Vandivier, Max Tapp
---

Choosing the next skill to develop is a critical decision that can shape your career trajectory. At Ladderly, we treat this process as an optimal investment problem. The goal is to identify the skill that maximizes your return on investment (ROI) in terms of time, money, and effort, while also accounting for risk and leisure. Here’s a five-step process to help you select the most beneficial skill for your development.

## Step 1: Define Your Goals

Before diving into skill selection, start by defining your personal and professional goals. A personalized plan tailored to you will generally outperform a plan based on aggregate market research and data. Ask yourself:

1. What are your short-term and long-term career goals?
2. Which roles or industries are you targeting?
3. What are your interests and passions?

Clearly outlining your goals will provide a solid foundation for the subsequent steps.

## Step 2: Generate a List of Valued Skills

Ladderly is particularly concerned with helping you land your first or next programming role. We have crunched the numbers and found that full-stack development is an optimal entry point into the market. Here is an ordered list of the skills we generally recommend for most people:

1. Search skills
2. HTML
3. CSS
4. JavaScript
5. SQL
6. TypeScript

After attaining basic competency, not mastery, in the above skills, you may go on to select other skills to differentiate yourself or advance toward the senior level. Read the section called [Common Specializations](#common-specializations) for a prepared list of specializations for software engineers. Always feel free to append additional options of interest to this list. It is simply meant to be a helpful starting point.

The general process is to match employer demand with your own interests. Begin by identifying a list of skills that are in high demand among employers. Focus on skills that are commonly required for your target job roles, as these minimize the risk of not realizing value from your efforts. Avoid selecting skills based solely on their high attached wages, as these may be niche and less frequently hired for.

Ladderly recommends starting with a relatively small list of 5-10 skills and ultimately single-tasking to efficiently learn a single skill at a time, after this initial list is prioritized and reduced.

## Step 3: Evaluate Effort and Time Requirements

Once you have your list of potential skills, estimate the effort and time required to learn each one. This stage involves assessing your available time and how it fits into your current schedule. The optimal skill is not necessarily the easiest to pick up but the one that offers the best risk-adjusted value within the time you have.

Eliminate skills from your list that require an excessive time investment. Ensure that the remaining skills are feasible within your learning schedule.

Consider a financial expenditure to pay for a course, coach, tool, or other options to accelerate learning or make learning less difficult.

A skill can benefit you for many years. A conservative approach to the lifetime value of the skill is to multiply the expected salary benefit by five. With this number, you can then deduct any cost to obtain the skill, such as course fees. Finally, you can now sort your skills by benefit per time allocated, where the benefit is the net total lifetime value. More value for less effort is generally preferred.

## Step 4: Consider Leisure and Personal Preference

After you’ve sorted your skills based on demand and expected return, now factor in your personal preferences and leisure. If a skill seems more or less enjoyable to study, try to put a dollar amount on that enjoyment and run your return calculations again.

This step involves subjective evaluation to ensure that the skills you choose align with your interests and do not lead to burnout. If necessary, eliminate skills that do not fit your personal criteria for leisure and enjoyment.

## Step 5: Develop a Mix of Short-Term and Long-Term Skills

Balance your skill development between short-term and long-term goals. For instance, if you’ve recently been laid off, prioritize skills that can quickly lead to reemployment. If you’re comfortably employed, consider developing long-term skills that will pay off in the future.

### Short-Term Skills

- Job search skills: time management, communication, and social networking.
- Full-stack web development: HTML, CSS, JavaScript, and TypeScript.

### Long-Term Skills

- Growth mindset: Embrace challenges and view failures as opportunities for growth.
- Capacity for boredom: Integrate periods of mental rest to boost productivity when needed.

## Common Specializations

Common specializations are also mentioned alongside [Qualified Job Titles](https://www.ladderly.io/blog/2023-12-01-top-job-boards#qualified-job-titles) in Ladderly's article on [Top Job Boards](https://www.ladderly.io/blog/2023-12-01-top-job-boards).

Some common specializations include:

1. Security, Infosec, or Cybersec
2. DevOps
3. Testing
4. SEO
5. Accessibility
6. Data Visualization
7. Backend Development
8. Mobile Development
9. Data Engineering, Data Science, and DataOps
10. Learning Other Languages - Python and Java make great choices after TypeScript!

## Conclusion

Selecting the next skill to develop is a strategic process that requires careful consideration of multiple factors. By following this multi-stage approach, you can optimize your learning efforts and maximize your career growth. Remember to continuously evaluate and adjust your skill development plan as your career progresses.

Ladderly is here to support you in your learning journey. Consider [booking a coaching call](https://buy.stripe.com/cN2bMfbOQ2CX5dC7su) if you need personalized advice tailored to your specific situation.
