---
title: '12. At Least Ten Networking Tips'
date: 5/31/24
author: John Vandivier
---

This article provides three long-term and ten short-term networking tips, plus additional resources which contain even more tips to generate leads, referrals, enhance interview performance, and accelerate your career!

## Long-Term Networking

Three key long-term networking techniques include:

1. Participating in [social and professional communities](https://github.com/Vandivier/ladderly-slides/blob/main/docs/ENDORSED-COMMUNITIES.md). Attending relevant events like conferences.
2. Learning, building, and creating content online. Remaining active on major social media platforms.
3. Intentionally capturing and formalizing LinkedIn connections based on those prior items.

Ladderly recommends applying these strategies from the first day of learning. That's why joining the Discord is [our first recommended step on the basic checklist](https://www.ladderly.io/checklists/my-basic-checklist), far before anything related to code.

A common pitfall is waiting to create content until after you deem yourself worthy of being considered a thought leader. Avoid this and build a habit of public communication and creation early instead for at least the following three reasons:

1. Joining a community early improves your learning motivation, support, and outcomes.
2. By communicating your pain points transparently as a student, you enable teachers to update their material quickly and with specific relevance. You also build an authentic personal brand which will benefit you at job search time.
3. You begin growing a relevant social network and improve technical communication skills, which will improve your job search and on-the-job performance.
4. You are able to provide fresh and relevant help to fellow early-career peers.

## Short-Term Networking

Short-term networking techniques include warm and cold outreach techniques designed to yield rapid and tangible outcomes. These techniques are useful when you are actively on the job search or actively facing a technical blocker as a student.

Warm outreach means contacting someone in your network or close to it. Here are some ways to generate value on the job search through warm outreach:

1. Ask for a resume or portfolio review.
2. Ask for a practice interview round, or resources and advice about interview preparation.
3. Ask your direct contact for an introduction at their current or former company, or with a relevant contact in their network.

Ladderly provides [these suggested networking scripts](https://github.com/Vandivier/ladderly-slides/blob/main/docs/NETWORKING-SCRIPTS.md) and communication targets for cold outreach while on the job search. The three target job families are fellow individual contributors, hiring managers, and technical recruiters.

Beyond the previously-mentioned networking scripts, here are several additional tips for cold outreach:

1. Ask Clearly and Immediately

   - Send a LinkedIn connection request and use the "Add Note" feature where you concisely ask for a specific and easy to complete action.
   - [Don't just say hello](https://nohello.net/en/)!
   - Request a specific action, such as advice about which teams are higher impact at the company, or which level seems better aligned to your resume and profile.
   - Consider offering a 15-minute call if it works for their schedule.

2. Assume the Close

   - When you reach out, with a geniune question which they can easily answer. Often, avoiding open-ended questions will make it easier for them to answer.
   - Avoid asking about whether they think you would be useful anywhere at the company. Instead, assume you will be useful somewhere and demonstrate curiosity about the mutually best location.
   - Most people have an intrinsic desire to help others, particularly when given a relevant and easy request, improving response rate and outcome quality.

3. Connect with Multiple People

   - Reach out to several individuals within the company to increase your chances of getting a response and diverse opinions.
   - Reach out to a recruiter, the hiring manager, and a few contributors with relevant job titles. If you don't hear back after a few business days, follow up using [the Three Strikes Rule mentioned in the scripts document](https://github.com/Vandivier/ladderly-slides/blob/main/docs/NETWORKING-SCRIPTS.md#follow-up-script-preface-the-three-strikes-rule).

4. Say Thank You!

   - Directly and clearly express that you appreciate their time and effort. You can say `TYIA`, `thanks!`, or `thanks in advance!`.
   - There's no need to wait until after they help to thank them. This simple gesture can have a powerful impact on their willingness to help.

5. Overvalue the pre-application referral, but persue as post-application referral over no referral.

   - A basic rule that can be modified as needed is to conduct social outreach and wait three business days as a time box before applying to a role of interest.
   - If you receive a communication response, continue to delay application until you have closed the loop with that point of contact, eventually asking for a referral.
   - If you did not hear back at all by the end of the three day time box, go ahead and apply then execute a second wave of post-application social outreach.
   - Many application systems preclude post-application referral, but not all of them.

6. Connect with contributors at multiple levels

   - Contributors below your level are likely to be impressed with your profile and may be more willing to refer you.
   - Contributors at your level are likely to have better relevence in their anwers to questions about the role.
   - Contributors above your level can provide guidance and visibility into broader company information that others might not have.
   - These different perspectives will give you a more informed view and may increase your ability to gain a referral compared to a self-limiting approach of restricting the level you communicate with.

7. Consider a Coaching Session
   - Short-term strategic communication is a case where slightly rewording can significantly improve response rates and outcome quality.
   - Consider [booking a coaching call](https://buy.stripe.com/cN2bMfbOQ2CX5dC7su) if you would like help personalizing the generic advice in this article to your specific situation.
