---
title: '10. Understanding User Settings'
date: 2/16/24
author: John Vandivier
---

This article explains the purpose of each of <a href="/settings">your Ladderly user settings</a>. This guide will walk you through each setting, explain its purpose, and how you can use it to tailor your experience to your preferences.

## Personal Information

- **Email**: Your primary email address is crucial as it serves as your login identifier. It's essential for receiving important notifications and resetting your password, ensuring you have continuous access to your account.

- **Backup Email**: Think of your backup email as your account's safety net. Should you ever forget your password or lose access to your primary email, this secondary email ensures you can still regain access to your account.

- **Stripe Email**: For those who utilize Stripe for payments, this email ensures your account is credited correctly for transactions. It's particularly useful if your Stripe account uses a different email, guaranteeing seamless financial transactions.

## Profile Details

- **First and Last Name**: These fields help personalize your account, making interactions within the platform more engaging and friendly.

- **Profile Blurb**: This is a short description that allows you to share a bit about yourself with other users. It's your chance to highlight your interests, skills, or any fun facts you'd like to share.

- **Contact Email, GitHub, LinkedIn, and Homepage URLs**: These fields let you connect your professional and social profiles to your account, making it easier for employers, collaborators, and peers to find you and learn about your work.

- **Residence Country and US State**: Displaying your location on your public profile helps in matching you with in-person events and provides employers and recruiters with vital information to determine if you're a good fit for their roles.

## Interests & Preferences

- **Event Interests (In-Person, Live Stream, Online, Small Groups)**: Whether you're open to attending hackathons, conferences, meetups, or participating in small, instructor-led classes, these settings allow us to tailor event notifications to your preferences. Small groups offer an intimate learning environment with 4-14 students, focusing on project-based learning and peer interaction to enhance learning outcomes.

- **Work Availability (Open to Work)**: Indicating your job-seeking status helps connect you with potential employment opportunities and makes you visible to recruiters looking for candidates with your skill set.

- **Profile Visibility (Public Profile)**: Enabling this feature makes your profile visible to other site visitors, which is crucial for networking and opening up opportunities.

- **Shout Outs**: By enabling shout outs, you allow your public profile to be featured in a special banner on the site, increasing your visibility to site visitors.

## Understanding Your Settings for a Better Experience

We hope this guide has illuminated the purpose and potential of each setting within your account. By understanding and adjusting your settings, you're setting the stage for personalized learning, facilitated social networking, and an easier job search!
