---
title: '9. Resume Optimization'
date: 2/12/24
author: John Vandivier
---

This article contains details on how to improve your resume to optimize employer response and ATS approval. This article summarizes and builds on information provided in the 1-hour video [Resume Optimization: Crush the ATS!](https://www.youtube.com/watch?v=4VcgUw_ZFFk), so review the video if you are interested in more detail.

## General Principles

Ladderly recommendations optimize your return on investment to time and effort as a job seeker. Ladderly.io generally advises against targeting a single dream company and instead targeting a basket of employers who will support a desired role. As such, Ladderly.io discourages creating tailored resumes and cover letters for each job post. See additional research behind this strategy in blog article [15. On Cover Letters and Resume Tailoring](https://www.ladderly.io/blog/2024-08-04-no-cover-letters).

Ladderly recommends that you apply to about 80 job postings each week using a single resume that is generated from your LinkedIn profile. This resume should focus on skill keywords for full-stack web development, mentioning skill keywords three times each, in addition to the suggestions made by the resume scanner later discussed.

Ladderly recommends that you identify yourself as a Software Developer. After completing the Ladderly curriculum you will be qualified for many job titles, but at the time of writing Software Developer is the title with the largest quantity of job postings. This may vary over time. The general principle is that you should identify as the highest-value job title for which you are qualified. Do not, for example, identify as a UX Engineer on your LinkedIn profile, even though you will be perfectly qualified to apply to such roles.

This strategy is optimal for most job seekers, but not all job seekers. A small portion of job seekers are already happily employed and it would only make sense for them to change roles for a very small and select set of companies or niche roles. Such highly-targeted job seekers should review this article keeping in mind that they will optimize with a lower volume strategy with higher effort and larger quantity of relevant social networking for their target roles. There are also some additional techniques for highly targeted job search. Feel free to [book an expert session](https://buy.stripe.com/cN2bMfbOQ2CX5dC7su) if you are interested in this approach, but it is not recommended for most job seekers.

Finally, short resumes are extremely useful. Ladderly recommends constraining your resume to one or two pages. A short resume does not improve ATS acceptance, but it does improve your overall job search performance because humans will also be reviewing your resume.

## Start with LinkedIn

Before applying you should optimize your LinkedIn. This includes describing your education and experience on LinkedIn, linking your GitHub portfolio, adding projects, highlighting skills associated with those resume items, updating your title line, and providing a high-quality profile picture. Avoid demeaning self-labels such as referring to yourself as a junior.

It's important to ensure that you have a high-quality LinkedIn and GitHub before applying, because your resume will include links to those pages. In addition, LinkedIn now provides a resume generator that uses the content from your LinkedIn profile to generate an ATS-friendly resume.

## Upgrade with Indeed

[Indeed](https://www.indeed.com/) is another leading job board and they provide a high-quality free [Instant Resume Report](https://www.indeed.com/career-services/resume-help/resume-review/). Ladderly recommends you utilize this service. If you have difficulty updating your resume, Indeed also offers a resume writing service. If you are seeing low response rates in your job search, a recommended technique is to purchase a resume written by Indeed and then to compare and contrast it against your LinkedIn-derived resume. You can then A/B test three forms of your resume:

1. The LinkedIn Resume
2. The Indeed Resume
3. A synthesized form

## Use the Resume Properly

Apply with a job board profile when possible. This means using `Apply with LinkedIn` to LinkedIn job opportunities, using the Indeed profile to `Apply with Indeed` for job posts you encounter on Indeed, and so on. Only use your own resume when a board-native approach is not available.

After you apply, make sure to to follow up with an individual from a relevant role at your target company, and maintain a spreadsheet of your job funnel performance. Suggested networking scripts and descriptions of ideal contacts for networking are located [here](https://github.com/Vandivier/ladderly-slides/blob/main/docs/NETWORKING-SCRIPTS.md).

If you apply to a particular role and you do not here back within two weeks, consider this a failed response. Do not worry about your response rate during the first two weeks of your job search. Beginning in your third week, if your weekly response rate is less than ten percent, Ladderly considers this a critically low response rate and recommends that you [seek expert help](https://buy.stripe.com/cN2bMfbOQ2CX5dC7su) to understand bottlenecks in your search process. Of course, you can optionally and proactively seek help at any time, even if your response rate isn't critically low.
