---
title: "5. Aria's Tale: An Emergent Social Gaming Experience"
date: 12/25/23
author: John Vandivier
---

This article introduces [Aria's Tale](https://ariastale.com) and describes the value it brings to the ladderly.io community.

If you are looking for quick start or detailed instructions about how to play the game, please visit the official website [here](https://ariastale.com).

### High-Level Description

Aria's Tale is an emergent social role playing game and an experiment in generative artificial intelligence.

Aria's Tale uses familiar tabletop roleplaying game mechanics such as character stat sheets, dice roles, a deep focus on narrative development, and a game master. Aria's Tale also uses some less familiar mechanics such as play-by-comment over social media and artificially intelligent game master tools that serve as a fully-fledged co-game master.

Players utilize the game master tools and shared narrative background to execute campaigns. These campaigns are submitted for review by the community and may be canonized into official narrative. The official canon is intended for use in official books and even video episodes.

Canon includes not only textual contributions, but also images, audio, and video, with an emphasis on generation of these materials through generative artificial intelligence.

Aria's Tale draws narrative inspiration from fantasy, sci-fi, and scientific media and concepts including Sword Art Online, The Matrix, Lord of the Rings, and more.

Aria's Tale is open source, built with [Next.js](https://nextjs.org/), and deployed through [Vercel](https://vercel.com/). The GitHub repository is located [here](https://github.com/Vandivier/arias-tale-rpg). Read the latest narrative content [here](https://github.com/Vandivier/arias-tale-rpg/blob/main/docs/narrative.md) and the latest metagame content [here](https://github.com/Vandivier/arias-tale-rpg/blob/main/docs/metagame.md), including more detail about sources of inspiration.

### Aria's Tale and Ladderly

Aria's Tale serves as a pet project for ladderly.io community members. Contributions are often beginner-friendly due to the content-heavy nature of the site.

Aria's Tale is also a community growth and recruitment tool. It is a fun and entertaining game with relatable elements in nerd and pop culture, resulting in an ability to attract a larger and more diverse audience compared to typical programming-specific advertising techniques.

The diverse appeal of this approach is demonstrated in one case study [here](https://www.tiktok.com/@johnvandivier/video/7316673707550821663). A TikTok promotion about Aria's Tale had an 8 percent above target view frequency with a 60 percent female audience. This is substantially better than the usual gender distribution for programming material online. The promotion also received a like-to-view ratio better than 10 percent, which is a signal of strong performance.

### 8 Reasons Aria's Tale is Interesting to Play

1. It's open source and free
2. It's casually paced
3. It's played over social media and also in-person
4. It uses familiar and fun tabletop roleplaying mechanics like rolling dice
5. Audience feedback matters and influences the game world in a permanent and meaningful way
6. It's highly narrative-driven with deep fantasy and sci-fi themes and rich lore
7. It's highly visual
8. It uses generative artificial intelligence to create unpredictable and entertaining outcomes
