---
title: '2. Building a Quality Portfolio'
date: 10/1/23
author: John Vandivier
---

Ladderly suggests building a portfolio involving four key projects before applying for jobs and after completing a substantive educational program in web development. This article walks through the four projects, why they are important, and how to identify a substantive educational program.

## Identifying a Substantive Program

An ideal educational program maximizes the risk-adjusted return on investment to the time, effort, and expense of the student. Optimal educational strategy requires personalization, but there are some courses of study that are effective enough to warrant general endorsement from Ladderly. Ladderly considers the following options to constitute a substantive program:

1. A college degree
2. A prestigious coding bootcamp
3. The Codecademy Pro [Front-End](https://www.codecademy.com/learn/paths/front-end-engineer-career-path) or [Full-Stack](https://www.codecademy.com/learn/paths/full-stack-engineer-career-path) Engineer Paths
4. The [Meta Front-End Developer Professional Certificate](https://www.coursera.org/professional-certificates/meta-front-end-developer)
5. A personalized program created in consultation with a Ladderly Expert Mentor

Identify a prestigious Coding Bootcamp by following this procedure, based on research presented in [this paper](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3835966):

1. Visit [Course Report](https://www.coursereport.com)
2. Browse all schools
3. Sort by Most Reviewed
4. Find a school with a rating of 4.25/5 or higher and a minimum of 400 reviews
5. Prefer schools with a job placement guarantee and other options suitable to you such as schedule compatibility and affordability.

## The Big 4 Projects

Ladderly recommends starting with a simple pet project that is well known and easily understood by employers, using that pet project to build into more advanced skills, and finishing off with a unique Capstone project that showcases your personal interests. Here are the four projects we recommend:

1. A Vanilla JS Blog
2. A Next.js Blog
3. A Capstone Project
4. A Portfolio Site

The Trial by Fire illustrates the development of a basic Vanilla JS blog. Here is a [reference code implementation](https://github.com/Vandivier/trial-by-fire) and here is a [video](https://www.youtube.com/watch?v=V7yeF9AaBxM). This is intended to be frontend-only and it is essentially a toy project. The Next.js blog can be created using `create-next-app` as described in the [React official documentation](https://react.dev/learn/start-a-new-react-project).

The code for these projects should be open source and each project should be publically deployed, accessible, and include a well-written README that shows off the interesting features and purpose of the project.

Ladderly recommends using GitHub for your code repositories because it is well-recognized and feature rich. In particular, we recommend you take advantage of the [GitHub Profile README feature](https://docs.github.com/en/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/managing-your-profile-readme).

Many free hosting solutions are available to support this four-project portfolio, but a few tools are worth calling out as useful intelligent defaults:

1. The portfolio site and vanilla blog can be hosted using GitHub Pages
2. Vercel and Supabase can support the Next.js Blog and the Capstone Project.

The portfolio site is intended to be low effort. Feel free to use a template site like one of these:

1. [Basic Next.js Portfolio Site](https://github.com/Vandivier/basic-nextjs-portfolio)
2. [Next.js Social Home](https://github.com/Vandivier/not-johns-linktree/)
3. [Basic Vue Portfolio Site](https://github.com/Vandivier/basic-vue-portfolio)

Make sure to link your GitHub at the top of your resume and get ready to start applying!
