# Хеш-таблица представляет собой эффективную структуру данных для реализации словарей.

# Хотя на поиск элемента в хеш-таблице может в наихудшем случае потребоваться столько же времени,
# что и в связанном списке, а именно O(n), на практике хеширование исключительно эффективно.

# При вполне обоснованных допущениях математическое ожидание времени поиска элемента в хеш-таблице
# составляет O(1).

# Хеш-таблица (hash table) представляет собой обобщение обычного массива.

# Если количество реально хранящихся в массиве ключей мало по сравнению с количеством
# возможных значений ключей, эффективной альтернативой массива с прямой индексацией
# становится хеш-таблица, которая обычно использует массив с размером,
# пропорциональным количеству реально хранящихся в нем ключей.

# Вместо непосредственного использования ключа в качестве индекса массива,
# индекс вычисляется по значению ключа.

# Идея хеширования состоит в использовании некоторой частичной информации,
# полученной из ключа, т.е. вычисляется хеш-адрес h(key), который используется для индексации
# в хеш-таблице.

# Хеш-таблица это коллекция, хранящая проиндексированные элементы (значения).
# Каждая позиция в хеш-таблице - слот таблицы (slot, bucket) может содержать элемент,
# адресованный целочисленным не отрицательным индексом внутри таблицы.

# Т.е. в таблице есть слот с индексом 0, 1 и т.д. При создании все слоты в хеш-таблице пустые.
# В Python хеш-таблицу мужно реализовать в виде списка заполненного значениями None или
# их заменителями (для случаев, если пользователю нужно хранить в хеш-таблице значения None).

# В случае прямой адресации элемент с ключом k хранится в ячейке k.
# При хешировании этот элемент хранится в ячейке h(k), т.е. мы используем хеш-функцию
# h для вычисления ячейки для данного ключа k.

# Функция h отображает пространство ключей U на ячейки хеш-таблицы:
#                   h : U -> {0, 1, ..., m - 1}.
# Мы говорим, что элемент с ключом k хешируется в ячейку h(k), величина h(k)
# называется хеш-значением ключа k.
# Пример:

# T[0, ..., 10]; h(k) = k mod 11

h_t = [None for _ in range(11)]
print()
print('Пустая хэш-таблица:')
print(h_t)
print()

def h(k):
    return k % 11

keys1 = [54, 26, 93, 17, 77, 31]
h_t_2 = [h(k) for k in keys1]

for i in range(len(h_t_2)):
    h_t[h_t_2[i]] = keys1[i]

print('Хеш-таблица с 6-ю элементами:')
print(h_t)
print()
print('Список с хешированными индексами:')
print(h_t_2)

# Пустая хэш-таблица:
# [None, None, None, None, None, None, None, None, None, None, None]
#
# Хеш-таблица с 6-ю элементами:
# [77, None, None, None, 26, 93, 17, None, None, 31, 54]
#
# Список с хешированными индексами:
# [10, 4, 5, 6, 0, 9]