//
//  FAIcon+Customization.swift
//

import Foundation

extension FAType{
	
	static func withLookupKey(_ key: String) -> FAType?{
		guard let ix = map.values.index(of: key) else { return nil }
		return map.keys[ix]
	}
	
	static var allTypes: [FAType]{
		get{ return faTypes }
	}
	
	var lookupKey: String?{
		guard let ix = map.index(forKey: self) else { return nil }
		return map.values[ix]
	}
}

/* Autogenerated Map */

private let map : [FAType : String] = [
	FAType.FA500px : "500px",
	FAType.FAAddressBook : "address-book",
	FAType.FAAddressBookO : "address-book-o",
	FAType.FAAddressCard : "address-card",
	FAType.FAAddressCardO : "address-card-o",
	FAType.FAAdjust : "adjust",
	FAType.FAAdn : "adn",
	FAType.FAAlignCenter : "align-center",
	FAType.FAAlignJustify : "align-justify",
	FAType.FAAlignLeft : "align-left",
	FAType.FAAlignRight : "align-right",
	FAType.FAAmazon : "amazon",
	FAType.FAAmbulance : "ambulance",
	FAType.FAAmericanSignLanguageInterpreting : "american-sign-language-interpreting",
	FAType.FAAnchor : "anchor",
	FAType.FAAndroid : "android",
	FAType.FAAngellist : "angellist",
	FAType.FAAngleDoubleDown : "angle-double-down",
	FAType.FAAngleDoubleLeft : "angle-double-left",
	FAType.FAAngleDoubleRight : "angle-double-right",
	FAType.FAAngleDoubleUp : "angle-double-up",
	FAType.FAAngleDown : "angle-down",
	FAType.FAAngleLeft : "angle-left",
	FAType.FAAngleRight : "angle-right",
	FAType.FAAngleUp : "angle-up",
	FAType.FAApple : "apple",
	FAType.FAArchive : "archive",
	FAType.FAAreaChart : "area-chart",
	FAType.FAArrowCircleDown : "arrow-circle-down",
	FAType.FAArrowCircleLeft : "arrow-circle-left",
	FAType.FAArrowCircleODown : "arrow-circle-o-down",
	FAType.FAArrowCircleOLeft : "arrow-circle-o-left",
	FAType.FAArrowCircleORight : "arrow-circle-o-right",
	FAType.FAArrowCircleOUp : "arrow-circle-o-up",
	FAType.FAArrowCircleRight : "arrow-circle-right",
	FAType.FAArrowCircleUp : "arrow-circle-up",
	FAType.FAArrowDown : "arrow-down",
	FAType.FAArrowLeft : "arrow-left",
	FAType.FAArrowRight : "arrow-right",
	FAType.FAArrowUp : "arrow-up",
	FAType.FAArrows : "arrows",
	FAType.FAArrowsAlt : "arrows-alt",
	FAType.FAArrowsH : "arrows-h",
	FAType.FAArrowsV : "arrows-v",
	FAType.FAAssistiveListeningSystems : "assistive-listening-systems",
	FAType.FAAsterisk : "asterisk",
	FAType.FAAt : "at",
	FAType.FAAudioDescription : "audio-description",
	FAType.FABackward : "backward",
	FAType.FABalanceScale : "balance-scale",
	FAType.FABan : "ban",
	FAType.FABandcamp : "bandcamp",
	FAType.FABarChart : "bar-chart",
	FAType.FABarcode : "barcode",
	FAType.FABars : "bars",
	FAType.FABath : "bath",
	FAType.FABatteryEmpty : "battery-empty",
	FAType.FABatteryFull : "battery-full",
	FAType.FABatteryHalf : "battery-half",
	FAType.FABatteryQuarter : "battery-quarter",
	FAType.FABatteryThreeQuarters : "battery-three-quarters",
	FAType.FABed : "bed",
	FAType.FABeer : "beer",
	FAType.FABehance : "behance",
	FAType.FABehanceSquare : "behance-square",
	FAType.FABell : "bell",
	FAType.FABellO : "bell-o",
	FAType.FABellSlash : "bell-slash",
	FAType.FABellSlashO : "bell-slash-o",
	FAType.FABicycle : "bicycle",
	FAType.FABinoculars : "binoculars",
	FAType.FABirthdayCake : "birthday-cake",
	FAType.FABitbucket : "bitbucket",
	FAType.FABitbucketSquare : "bitbucket-square",
	FAType.FABlackTie : "black-tie",
	FAType.FABlind : "blind",
	FAType.FABluetooth : "bluetooth",
	FAType.FABluetoothB : "bluetooth-b",
	FAType.FABold : "bold",
	FAType.FABolt : "bolt",
	FAType.FABomb : "bomb",
	FAType.FABook : "book",
	FAType.FABookmark : "bookmark",
	FAType.FABookmarkO : "bookmark-o",
	FAType.FABraille : "braille",
	FAType.FABriefcase : "briefcase",
	FAType.FABtc : "btc",
	FAType.FABug : "bug",
	FAType.FABuilding : "building",
	FAType.FABuildingO : "building-o",
	FAType.FABullhorn : "bullhorn",
	FAType.FABullseye : "bullseye",
	FAType.FABus : "bus",
	FAType.FABuysellads : "buysellads",
	FAType.FACalculator : "calculator",
	FAType.FACalendar : "calendar",
	FAType.FACalendarCheckO : "calendar-check-o",
	FAType.FACalendarMinusO : "calendar-minus-o",
	FAType.FACalendarO : "calendar-o",
	FAType.FACalendarPlusO : "calendar-plus-o",
	FAType.FACalendarTimesO : "calendar-times-o",
	FAType.FACamera : "camera",
	FAType.FACameraRetro : "camera-retro",
	FAType.FACar : "car",
	FAType.FACaretDown : "caret-down",
	FAType.FACaretLeft : "caret-left",
	FAType.FACaretRight : "caret-right",
	FAType.FACaretSquareODown : "caret-square-o-down",
	FAType.FACaretSquareOLeft : "caret-square-o-left",
	FAType.FACaretSquareORight : "caret-square-o-right",
	FAType.FACaretSquareOUp : "caret-square-o-up",
	FAType.FACaretUp : "caret-up",
	FAType.FACartArrowDown : "cart-arrow-down",
	FAType.FACartPlus : "cart-plus",
	FAType.FACc : "cc",
	FAType.FACcAmex : "cc-amex",
	FAType.FACcDinersClub : "cc-diners-club",
	FAType.FACcDiscover : "cc-discover",
	FAType.FACcJcb : "cc-jcb",
	FAType.FACcMastercard : "cc-mastercard",
	FAType.FACcPaypal : "cc-paypal",
	FAType.FACcStripe : "cc-stripe",
	FAType.FACcVisa : "cc-visa",
	FAType.FACertificate : "certificate",
	FAType.FAChainBroken : "chain-broken",
	FAType.FACheck : "check",
	FAType.FACheckCircle : "check-circle",
	FAType.FACheckCircleO : "check-circle-o",
	FAType.FACheckSquare : "check-square",
	FAType.FACheckSquareO : "check-square-o",
	FAType.FAChevronCircleDown : "chevron-circle-down",
	FAType.FAChevronCircleLeft : "chevron-circle-left",
	FAType.FAChevronCircleRight : "chevron-circle-right",
	FAType.FAChevronCircleUp : "chevron-circle-up",
	FAType.FAChevronDown : "chevron-down",
	FAType.FAChevronLeft : "chevron-left",
	FAType.FAChevronRight : "chevron-right",
	FAType.FAChevronUp : "chevron-up",
	FAType.FAChild : "child",
	FAType.FAChrome : "chrome",
	FAType.FACircle : "circle",
	FAType.FACircleO : "circle-o",
	FAType.FACircleONotch : "circle-o-notch",
	FAType.FACircleThin : "circle-thin",
	FAType.FAClipboard : "clipboard",
	FAType.FAClockO : "clock-o",
	FAType.FAClone : "clone",
	FAType.FACloud : "cloud",
	FAType.FACloudDownload : "cloud-download",
	FAType.FACloudUpload : "cloud-upload",
	FAType.FACode : "code",
	FAType.FACodeFork : "code-fork",
	FAType.FACodepen : "codepen",
	FAType.FACodiepie : "codiepie",
	FAType.FACoffee : "coffee",
	FAType.FACog : "cog",
	FAType.FACogs : "cogs",
	FAType.FAColumns : "columns",
	FAType.FAComment : "comment",
	FAType.FACommentO : "comment-o",
	FAType.FACommenting : "commenting",
	FAType.FACommentingO : "commenting-o",
	FAType.FAComments : "comments",
	FAType.FACommentsO : "comments-o",
	FAType.FACompass : "compass",
	FAType.FACompress : "compress",
	FAType.FAConnectdevelop : "connectdevelop",
	FAType.FAContao : "contao",
	FAType.FACopyright : "copyright",
	FAType.FACreativeCommons : "creative-commons",
	FAType.FACreditCard : "credit-card",
	FAType.FACreditCardAlt : "credit-card-alt",
	FAType.FACrop : "crop",
	FAType.FACrosshairs : "crosshairs",
	FAType.FACss3 : "css3",
	FAType.FACube : "cube",
	FAType.FACubes : "cubes",
	FAType.FACutlery : "cutlery",
	FAType.FADashcube : "dashcube",
	FAType.FADatabase : "database",
	FAType.FADeaf : "deaf",
	FAType.FADelicious : "delicious",
	FAType.FADesktop : "desktop",
	FAType.FADeviantart : "deviantart",
	FAType.FADiamond : "diamond",
	FAType.FADigg : "digg",
	FAType.FADotCircleO : "dot-circle-o",
	FAType.FADownload : "download",
	FAType.FADribbble : "dribbble",
	FAType.FADropbox : "dropbox",
	FAType.FADrupal : "drupal",
	FAType.FAEdge : "edge",
	FAType.FAEercast : "eercast",
	FAType.FAEject : "eject",
	FAType.FAEllipsisH : "ellipsis-h",
	FAType.FAEllipsisV : "ellipsis-v",
	FAType.FAEmpire : "empire",
	FAType.FAEnvelope : "envelope",
	FAType.FAEnvelopeO : "envelope-o",
	FAType.FAEnvelopeOpen : "envelope-open",
	FAType.FAEnvelopeOpenO : "envelope-open-o",
	FAType.FAEnvelopeSquare : "envelope-square",
	FAType.FAEnvira : "envira",
	FAType.FAEraser : "eraser",
	FAType.FAEtsy : "etsy",
	FAType.FAEur : "eur",
	FAType.FAExchange : "exchange",
	FAType.FAExclamation : "exclamation",
	FAType.FAExclamationCircle : "exclamation-circle",
	FAType.FAExclamationTriangle : "exclamation-triangle",
	FAType.FAExpand : "expand",
	FAType.FAExpeditedssl : "expeditedssl",
	FAType.FAExternalLink : "external-link",
	FAType.FAExternalLinkSquare : "external-link-square",
	FAType.FAEye : "eye",
	FAType.FAEyeSlash : "eye-slash",
	FAType.FAEyedropper : "eyedropper",
	FAType.FAFacebook : "facebook",
	FAType.FAFacebookOfficial : "facebook-official",
	FAType.FAFacebookSquare : "facebook-square",
	FAType.FAFastBackward : "fast-backward",
	FAType.FAFastForward : "fast-forward",
	FAType.FAFax : "fax",
	FAType.FAFemale : "female",
	FAType.FAFighterJet : "fighter-jet",
	FAType.FAFile : "file",
	FAType.FAFileArchiveO : "file-archive-o",
	FAType.FAFileAudioO : "file-audio-o",
	FAType.FAFileCodeO : "file-code-o",
	FAType.FAFileExcelO : "file-excel-o",
	FAType.FAFileImageO : "file-image-o",
	FAType.FAFileO : "file-o",
	FAType.FAFilePdfO : "file-pdf-o",
	FAType.FAFilePowerpointO : "file-powerpoint-o",
	FAType.FAFileText : "file-text",
	FAType.FAFileTextO : "file-text-o",
	FAType.FAFileVideoO : "file-video-o",
	FAType.FAFileWordO : "file-word-o",
	FAType.FAFilesO : "files-o",
	FAType.FAFilm : "film",
	FAType.FAFilter : "filter",
	FAType.FAFire : "fire",
	FAType.FAFireExtinguisher : "fire-extinguisher",
	FAType.FAFirefox : "firefox",
	FAType.FAFirstOrder : "first-order",
	FAType.FAFlag : "flag",
	FAType.FAFlagCheckered : "flag-checkered",
	FAType.FAFlagO : "flag-o",
	FAType.FAFlask : "flask",
	FAType.FAFlickr : "flickr",
	FAType.FAFloppyO : "floppy-o",
	FAType.FAFolder : "folder",
	FAType.FAFolderO : "folder-o",
	FAType.FAFolderOpen : "folder-open",
	FAType.FAFolderOpenO : "folder-open-o",
	FAType.FAFont : "font",
	FAType.FAFontAwesome : "font-awesome",
	FAType.FAFonticons : "fonticons",
	FAType.FAFortAwesome : "fort-awesome",
	FAType.FAForumbee : "forumbee",
	FAType.FAForward : "forward",
	FAType.FAFoursquare : "foursquare",
	FAType.FAFreeCodeCamp : "free-code-camp",
	FAType.FAFrownO : "frown-o",
	FAType.FAFutbolO : "futbol-o",
	FAType.FAGamepad : "gamepad",
	FAType.FAGavel : "gavel",
	FAType.FAGbp : "gbp",
	FAType.FAGenderless : "genderless",
	FAType.FAGetPocket : "get-pocket",
	FAType.FAGg : "gg",
	FAType.FAGgCircle : "gg-circle",
	FAType.FAGift : "gift",
	FAType.FAGit : "git",
	FAType.FAGitSquare : "git-square",
	FAType.FAGithub : "github",
	FAType.FAGithubAlt : "github-alt",
	FAType.FAGithubSquare : "github-square",
	FAType.FAGitlab : "gitlab",
	FAType.FAGlass : "glass",
	FAType.FAGlide : "glide",
	FAType.FAGlideG : "glide-g",
	FAType.FAGlobe : "globe",
	FAType.FAGoogle : "google",
	FAType.FAGooglePlus : "google-plus",
	FAType.FAGooglePlusOfficial : "google-plus-official",
	FAType.FAGooglePlusSquare : "google-plus-square",
	FAType.FAGoogleWallet : "google-wallet",
	FAType.FAGraduationCap : "graduation-cap",
	FAType.FAGratipay : "gratipay",
	FAType.FAGrav : "grav",
	FAType.FAHSquare : "h-square",
	FAType.FAHackerNews : "hacker-news",
	FAType.FAHandLizardO : "hand-lizard-o",
	FAType.FAHandODown : "hand-o-down",
	FAType.FAHandOLeft : "hand-o-left",
	FAType.FAHandORight : "hand-o-right",
	FAType.FAHandOUp : "hand-o-up",
	FAType.FAHandPaperO : "hand-paper-o",
	FAType.FAHandPeaceO : "hand-peace-o",
	FAType.FAHandPointerO : "hand-pointer-o",
	FAType.FAHandRockO : "hand-rock-o",
	FAType.FAHandScissorsO : "hand-scissors-o",
	FAType.FAHandSpockO : "hand-spock-o",
	FAType.FAHandshakeO : "handshake-o",
	FAType.FAHashtag : "hashtag",
	FAType.FAHddO : "hdd-o",
	FAType.FAHeader : "header",
	FAType.FAHeadphones : "headphones",
	FAType.FAHeart : "heart",
	FAType.FAHeartO : "heart-o",
	FAType.FAHeartbeat : "heartbeat",
	FAType.FAHistory : "history",
	FAType.FAHome : "home",
	FAType.FAHospitalO : "hospital-o",
	FAType.FAHourglass : "hourglass",
	FAType.FAHourglassEnd : "hourglass-end",
	FAType.FAHourglassHalf : "hourglass-half",
	FAType.FAHourglassO : "hourglass-o",
	FAType.FAHourglassStart : "hourglass-start",
	FAType.FAHouzz : "houzz",
	FAType.FAHtml5 : "html5",
	FAType.FAICursor : "i-cursor",
	FAType.FAIdBadge : "id-badge",
	FAType.FAIdCard : "id-card",
	FAType.FAIdCardO : "id-card-o",
	FAType.FAIls : "ils",
	FAType.FAImdb : "imdb",
	FAType.FAInbox : "inbox",
	FAType.FAIndent : "indent",
	FAType.FAIndustry : "industry",
	FAType.FAInfo : "info",
	FAType.FAInfoCircle : "info-circle",
	FAType.FAInr : "inr",
	FAType.FAInstagram : "instagram",
	FAType.FAInternetExplorer : "internet-explorer",
	FAType.FAIoxhost : "ioxhost",
	FAType.FAItalic : "italic",
	FAType.FAJoomla : "joomla",
	FAType.FAJpy : "jpy",
	FAType.FAJsfiddle : "jsfiddle",
	FAType.FAKey : "key",
	FAType.FAKeyboardO : "keyboard-o",
	FAType.FAKrw : "krw",
	FAType.FALanguage : "language",
	FAType.FALaptop : "laptop",
	FAType.FALastfm : "lastfm",
	FAType.FALastfmSquare : "lastfm-square",
	FAType.FALeaf : "leaf",
	FAType.FALeanpub : "leanpub",
	FAType.FALemonO : "lemon-o",
	FAType.FALevelDown : "level-down",
	FAType.FALevelUp : "level-up",
	FAType.FALifeRing : "life-ring",
	FAType.FALightbulbO : "lightbulb-o",
	FAType.FALineChart : "line-chart",
	FAType.FALink : "link",
	FAType.FALinkedin : "linkedin",
	FAType.FALinkedinSquare : "linkedin-square",
	FAType.FALinode : "linode",
	FAType.FALinux : "linux",
	FAType.FAList : "list",
	FAType.FAListAlt : "list-alt",
	FAType.FAListOl : "list-ol",
	FAType.FAListUl : "list-ul",
	FAType.FALocationArrow : "location-arrow",
	FAType.FALock : "lock",
	FAType.FALongArrowDown : "long-arrow-down",
	FAType.FALongArrowLeft : "long-arrow-left",
	FAType.FALongArrowRight : "long-arrow-right",
	FAType.FALongArrowUp : "long-arrow-up",
	FAType.FALowVision : "low-vision",
	FAType.FAMagic : "magic",
	FAType.FAMagnet : "magnet",
	FAType.FAMale : "male",
	FAType.FAMap : "map",
	FAType.FAMapMarker : "map-marker",
	FAType.FAMapO : "map-o",
	FAType.FAMapPin : "map-pin",
	FAType.FAMapSigns : "map-signs",
	FAType.FAMars : "mars",
	FAType.FAMarsDouble : "mars-double",
	FAType.FAMarsStroke : "mars-stroke",
	FAType.FAMarsStrokeH : "mars-stroke-h",
	FAType.FAMarsStrokeV : "mars-stroke-v",
	FAType.FAMaxcdn : "maxcdn",
	FAType.FAMeanpath : "meanpath",
	FAType.FAMedium : "medium",
	FAType.FAMedkit : "medkit",
	FAType.FAMeetup : "meetup",
	FAType.FAMehO : "meh-o",
	FAType.FAMercury : "mercury",
	FAType.FAMicrochip : "microchip",
	FAType.FAMicrophone : "microphone",
	FAType.FAMicrophoneSlash : "microphone-slash",
	FAType.FAMinus : "minus",
	FAType.FAMinusCircle : "minus-circle",
	FAType.FAMinusSquare : "minus-square",
	FAType.FAMinusSquareO : "minus-square-o",
	FAType.FAMixcloud : "mixcloud",
	FAType.FAMobile : "mobile",
	FAType.FAModx : "modx",
	FAType.FAMoney : "money",
	FAType.FAMoonO : "moon-o",
	FAType.FAMotorcycle : "motorcycle",
	FAType.FAMousePointer : "mouse-pointer",
	FAType.FAMusic : "music",
	FAType.FANeuter : "neuter",
	FAType.FANewspaperO : "newspaper-o",
	FAType.FAObjectGroup : "object-group",
	FAType.FAObjectUngroup : "object-ungroup",
	FAType.FAOdnoklassniki : "odnoklassniki",
	FAType.FAOdnoklassnikiSquare : "odnoklassniki-square",
	FAType.FAOpencart : "opencart",
	FAType.FAOpenid : "openid",
	FAType.FAOpera : "opera",
	FAType.FAOptinMonster : "optin-monster",
	FAType.FAOutdent : "outdent",
	FAType.FAPagelines : "pagelines",
	FAType.FAPaintBrush : "paint-brush",
	FAType.FAPaperPlane : "paper-plane",
	FAType.FAPaperPlaneO : "paper-plane-o",
	FAType.FAPaperclip : "paperclip",
	FAType.FAParagraph : "paragraph",
	FAType.FAPause : "pause",
	FAType.FAPauseCircle : "pause-circle",
	FAType.FAPauseCircleO : "pause-circle-o",
	FAType.FAPaw : "paw",
	FAType.FAPaypal : "paypal",
	FAType.FAPencil : "pencil",
	FAType.FAPencilSquare : "pencil-square",
	FAType.FAPencilSquareO : "pencil-square-o",
	FAType.FAPercent : "percent",
	FAType.FAPhone : "phone",
	FAType.FAPhoneSquare : "phone-square",
	FAType.FAPictureO : "picture-o",
	FAType.FAPieChart : "pie-chart",
	FAType.FAPiedPiper : "pied-piper",
	FAType.FAPiedPiperAlt : "pied-piper-alt",
	FAType.FAPiedPiperPp : "pied-piper-pp",
	FAType.FAPinterest : "pinterest",
	FAType.FAPinterestP : "pinterest-p",
	FAType.FAPinterestSquare : "pinterest-square",
	FAType.FAPlane : "plane",
	FAType.FAPlay : "play",
	FAType.FAPlayCircle : "play-circle",
	FAType.FAPlayCircleO : "play-circle-o",
	FAType.FAPlug : "plug",
	FAType.FAPlus : "plus",
	FAType.FAPlusCircle : "plus-circle",
	FAType.FAPlusSquare : "plus-square",
	FAType.FAPlusSquareO : "plus-square-o",
	FAType.FAPodcast : "podcast",
	FAType.FAPowerOff : "power-off",
	FAType.FAPrint : "print",
	FAType.FAProductHunt : "product-hunt",
	FAType.FAPuzzlePiece : "puzzle-piece",
	FAType.FAQq : "qq",
	FAType.FAQrcode : "qrcode",
	FAType.FAQuestion : "question",
	FAType.FAQuestionCircle : "question-circle",
	FAType.FAQuestionCircleO : "question-circle-o",
	FAType.FAQuora : "quora",
	FAType.FAQuoteLeft : "quote-left",
	FAType.FAQuoteRight : "quote-right",
	FAType.FARandom : "random",
	FAType.FARavelry : "ravelry",
	FAType.FARebel : "rebel",
	FAType.FARecycle : "recycle",
	FAType.FAReddit : "reddit",
	FAType.FARedditAlien : "reddit-alien",
	FAType.FARedditSquare : "reddit-square",
	FAType.FARefresh : "refresh",
	FAType.FARegistered : "registered",
	FAType.FARenren : "renren",
	FAType.FARepeat : "repeat",
	FAType.FAReply : "reply",
	FAType.FAReplyAll : "reply-all",
	FAType.FARetweet : "retweet",
	FAType.FARoad : "road",
	FAType.FARocket : "rocket",
	FAType.FARss : "rss",
	FAType.FARssSquare : "rss-square",
	FAType.FARub : "rub",
	FAType.FASafari : "safari",
	FAType.FAScissors : "scissors",
	FAType.FAScribd : "scribd",
	FAType.FASearch : "search",
	FAType.FASearchMinus : "search-minus",
	FAType.FASearchPlus : "search-plus",
	FAType.FASellsy : "sellsy",
	FAType.FAServer : "server",
	FAType.FAShare : "share",
	FAType.FAShareAlt : "share-alt",
	FAType.FAShareAltSquare : "share-alt-square",
	FAType.FAShareSquare : "share-square",
	FAType.FAShareSquareO : "share-square-o",
	FAType.FAShield : "shield",
	FAType.FAShip : "ship",
	FAType.FAShirtsinbulk : "shirtsinbulk",
	FAType.FAShoppingBag : "shopping-bag",
	FAType.FAShoppingBasket : "shopping-basket",
	FAType.FAShoppingCart : "shopping-cart",
	FAType.FAShower : "shower",
	FAType.FASignIn : "sign-in",
	FAType.FASignLanguage : "sign-language",
	FAType.FASignOut : "sign-out",
	FAType.FASignal : "signal",
	FAType.FASimplybuilt : "simplybuilt",
	FAType.FASitemap : "sitemap",
	FAType.FASkyatlas : "skyatlas",
	FAType.FASkype : "skype",
	FAType.FASlack : "slack",
	FAType.FASliders : "sliders",
	FAType.FASlideshare : "slideshare",
	FAType.FASmileO : "smile-o",
	FAType.FASnapchat : "snapchat",
	FAType.FASnapchatGhost : "snapchat-ghost",
	FAType.FASnapchatSquare : "snapchat-square",
	FAType.FASnowflakeO : "snowflake-o",
	FAType.FASort : "sort",
	FAType.FASortAlphaAsc : "sort-alpha-asc",
	FAType.FASortAlphaDesc : "sort-alpha-desc",
	FAType.FASortAmountAsc : "sort-amount-asc",
	FAType.FASortAmountDesc : "sort-amount-desc",
	FAType.FASortAsc : "sort-asc",
	FAType.FASortDesc : "sort-desc",
	FAType.FASortNumericAsc : "sort-numeric-asc",
	FAType.FASortNumericDesc : "sort-numeric-desc",
	FAType.FASoundcloud : "soundcloud",
	FAType.FASpaceShuttle : "space-shuttle",
	FAType.FASpinner : "spinner",
	FAType.FASpoon : "spoon",
	FAType.FASpotify : "spotify",
	FAType.FASquare : "square",
	FAType.FASquareO : "square-o",
	FAType.FAStackExchange : "stack-exchange",
	FAType.FAStackOverflow : "stack-overflow",
	FAType.FAStar : "star",
	FAType.FAStarHalf : "star-half",
	FAType.FAStarHalfO : "star-half-o",
	FAType.FAStarO : "star-o",
	FAType.FASteam : "steam",
	FAType.FASteamSquare : "steam-square",
	FAType.FAStepBackward : "step-backward",
	FAType.FAStepForward : "step-forward",
	FAType.FAStethoscope : "stethoscope",
	FAType.FAStickyNote : "sticky-note",
	FAType.FAStickyNoteO : "sticky-note-o",
	FAType.FAStop : "stop",
	FAType.FAStopCircle : "stop-circle",
	FAType.FAStopCircleO : "stop-circle-o",
	FAType.FAStreetView : "street-view",
	FAType.FAStrikethrough : "strikethrough",
	FAType.FAStumbleupon : "stumbleupon",
	FAType.FAStumbleuponCircle : "stumbleupon-circle",
	FAType.FASubscript : "subscript",
	FAType.FASubway : "subway",
	FAType.FASuitcase : "suitcase",
	FAType.FASunO : "sun-o",
	FAType.FASuperpowers : "superpowers",
	FAType.FASuperscript : "superscript",
	FAType.FATable : "table",
	FAType.FATablet : "tablet",
	FAType.FATachometer : "tachometer",
	FAType.FATag : "tag",
	FAType.FATags : "tags",
	FAType.FATasks : "tasks",
	FAType.FATaxi : "taxi",
	FAType.FATelegram : "telegram",
	FAType.FATelevision : "television",
	FAType.FATencentWeibo : "tencent-weibo",
	FAType.FATerminal : "terminal",
	FAType.FATextHeight : "text-height",
	FAType.FATextWidth : "text-width",
	FAType.FATh : "th",
	FAType.FAThLarge : "th-large",
	FAType.FAThList : "th-list",
	FAType.FAThemeisle : "themeisle",
	FAType.FAThermometerEmpty : "thermometer-empty",
	FAType.FAThermometerFull : "thermometer-full",
	FAType.FAThermometerHalf : "thermometer-half",
	FAType.FAThermometerQuarter : "thermometer-quarter",
	FAType.FAThermometerThreeQuarters : "thermometer-three-quarters",
	FAType.FAThumbTack : "thumb-tack",
	FAType.FAThumbsDown : "thumbs-down",
	FAType.FAThumbsODown : "thumbs-o-down",
	FAType.FAThumbsOUp : "thumbs-o-up",
	FAType.FAThumbsUp : "thumbs-up",
	FAType.FATicket : "ticket",
	FAType.FATimes : "times",
	FAType.FATimesCircle : "times-circle",
	FAType.FATimesCircleO : "times-circle-o",
	FAType.FATint : "tint",
	FAType.FAToggleOff : "toggle-off",
	FAType.FAToggleOn : "toggle-on",
	FAType.FATrademark : "trademark",
	FAType.FATrain : "train",
	FAType.FATransgender : "transgender",
	FAType.FATransgenderAlt : "transgender-alt",
	FAType.FATrash : "trash",
	FAType.FATrashO : "trash-o",
	FAType.FATree : "tree",
	FAType.FATrello : "trello",
	FAType.FATripadvisor : "tripadvisor",
	FAType.FATrophy : "trophy",
	FAType.FATruck : "truck",
	FAType.FATry : "try",
	FAType.FATty : "tty",
	FAType.FATumblr : "tumblr",
	FAType.FATumblrSquare : "tumblr-square",
	FAType.FATwitch : "twitch",
	FAType.FATwitter : "twitter",
	FAType.FATwitterSquare : "twitter-square",
	FAType.FAUmbrella : "umbrella",
	FAType.FAUnderline : "underline",
	FAType.FAUndo : "undo",
	FAType.FAUniversalAccess : "universal-access",
	FAType.FAUniversity : "university",
	FAType.FAUnlock : "unlock",
	FAType.FAUnlockAlt : "unlock-alt",
	FAType.FAUpload : "upload",
	FAType.FAUsb : "usb",
	FAType.FAUsd : "usd",
	FAType.FAUser : "user",
	FAType.FAUserCircle : "user-circle",
	FAType.FAUserCircleO : "user-circle-o",
	FAType.FAUserMd : "user-md",
	FAType.FAUserO : "user-o",
	FAType.FAUserPlus : "user-plus",
	FAType.FAUserSecret : "user-secret",
	FAType.FAUserTimes : "user-times",
	FAType.FAUsers : "users",
	FAType.FAVenus : "venus",
	FAType.FAVenusDouble : "venus-double",
	FAType.FAVenusMars : "venus-mars",
	FAType.FAViacoin : "viacoin",
	FAType.FAViadeo : "viadeo",
	FAType.FAViadeoSquare : "viadeo-square",
	FAType.FAVideoCamera : "video-camera",
	FAType.FAVimeo : "vimeo",
	FAType.FAVimeoSquare : "vimeo-square",
	FAType.FAVine : "vine",
	FAType.FAVk : "vk",
	FAType.FAVolumeControlPhone : "volume-control-phone",
	FAType.FAVolumeDown : "volume-down",
	FAType.FAVolumeOff : "volume-off",
	FAType.FAVolumeUp : "volume-up",
	FAType.FAWeibo : "weibo",
	FAType.FAWeixin : "weixin",
	FAType.FAWhatsapp : "whatsapp",
	FAType.FAWheelchair : "wheelchair",
	FAType.FAWheelchairAlt : "wheelchair-alt",
	FAType.FAWifi : "wifi",
	FAType.FAWikipediaW : "wikipedia-w",
	FAType.FAWindowClose : "window-close",
	FAType.FAWindowCloseO : "window-close-o",
	FAType.FAWindowMaximize : "window-maximize",
	FAType.FAWindowMinimize : "window-minimize",
	FAType.FAWindowRestore : "window-restore",
	FAType.FAWindows : "windows",
	FAType.FAWordpress : "wordpress",
	FAType.FAWpbeginner : "wpbeginner",
	FAType.FAWpexplorer : "wpexplorer",
	FAType.FAWpforms : "wpforms",
	FAType.FAWrench : "wrench",
	FAType.FAXing : "xing",
	FAType.FAXingSquare : "xing-square",
	FAType.FAYCombinator : "y-combinator",
	FAType.FAYahoo : "yahoo",
	FAType.FAYelp : "yelp",
	FAType.FAYoast : "yoast",
	FAType.FAYoutube : "youtube",
	FAType.FAYoutubePlay : "youtube-play",
	FAType.FAYoutubeSquare : "youtube-square",
]

private let faTypes : [FAType] = [
	FAType.FA500px,
	FAType.FAAddressBook,
	FAType.FAAddressBookO,
	FAType.FAAddressCard,
	FAType.FAAddressCardO,
	FAType.FAAdjust,
	FAType.FAAdn,
	FAType.FAAlignCenter,
	FAType.FAAlignJustify,
	FAType.FAAlignLeft,
	FAType.FAAlignRight,
	FAType.FAAmazon,
	FAType.FAAmbulance,
	FAType.FAAmericanSignLanguageInterpreting,
	FAType.FAAnchor,
	FAType.FAAndroid,
	FAType.FAAngellist,
	FAType.FAAngleDoubleDown,
	FAType.FAAngleDoubleLeft,
	FAType.FAAngleDoubleRight,
	FAType.FAAngleDoubleUp,
	FAType.FAAngleDown,
	FAType.FAAngleLeft,
	FAType.FAAngleRight,
	FAType.FAAngleUp,
	FAType.FAApple,
	FAType.FAArchive,
	FAType.FAAreaChart,
	FAType.FAArrowCircleDown,
	FAType.FAArrowCircleLeft,
	FAType.FAArrowCircleODown,
	FAType.FAArrowCircleOLeft,
	FAType.FAArrowCircleORight,
	FAType.FAArrowCircleOUp,
	FAType.FAArrowCircleRight,
	FAType.FAArrowCircleUp,
	FAType.FAArrowDown,
	FAType.FAArrowLeft,
	FAType.FAArrowRight,
	FAType.FAArrowUp,
	FAType.FAArrows,
	FAType.FAArrowsAlt,
	FAType.FAArrowsH,
	FAType.FAArrowsV,
	FAType.FAAssistiveListeningSystems,
	FAType.FAAsterisk,
	FAType.FAAt,
	FAType.FAAudioDescription,
	FAType.FABackward,
	FAType.FABalanceScale,
	FAType.FABan,
	FAType.FABandcamp,
	FAType.FABarChart,
	FAType.FABarcode,
	FAType.FABars,
	FAType.FABath,
	FAType.FABatteryEmpty,
	FAType.FABatteryFull,
	FAType.FABatteryHalf,
	FAType.FABatteryQuarter,
	FAType.FABatteryThreeQuarters,
	FAType.FABed,
	FAType.FABeer,
	FAType.FABehance,
	FAType.FABehanceSquare,
	FAType.FABell,
	FAType.FABellO,
	FAType.FABellSlash,
	FAType.FABellSlashO,
	FAType.FABicycle,
	FAType.FABinoculars,
	FAType.FABirthdayCake,
	FAType.FABitbucket,
	FAType.FABitbucketSquare,
	FAType.FABlackTie,
	FAType.FABlind,
	FAType.FABluetooth,
	FAType.FABluetoothB,
	FAType.FABold,
	FAType.FABolt,
	FAType.FABomb,
	FAType.FABook,
	FAType.FABookmark,
	FAType.FABookmarkO,
	FAType.FABraille,
	FAType.FABriefcase,
	FAType.FABtc,
	FAType.FABug,
	FAType.FABuilding,
	FAType.FABuildingO,
	FAType.FABullhorn,
	FAType.FABullseye,
	FAType.FABus,
	FAType.FABuysellads,
	FAType.FACalculator,
	FAType.FACalendar,
	FAType.FACalendarCheckO,
	FAType.FACalendarMinusO,
	FAType.FACalendarO,
	FAType.FACalendarPlusO,
	FAType.FACalendarTimesO,
	FAType.FACamera,
	FAType.FACameraRetro,
	FAType.FACar,
	FAType.FACaretDown,
	FAType.FACaretLeft,
	FAType.FACaretRight,
	FAType.FACaretSquareODown,
	FAType.FACaretSquareOLeft,
	FAType.FACaretSquareORight,
	FAType.FACaretSquareOUp,
	FAType.FACaretUp,
	FAType.FACartArrowDown,
	FAType.FACartPlus,
	FAType.FACc,
	FAType.FACcAmex,
	FAType.FACcDinersClub,
	FAType.FACcDiscover,
	FAType.FACcJcb,
	FAType.FACcMastercard,
	FAType.FACcPaypal,
	FAType.FACcStripe,
	FAType.FACcVisa,
	FAType.FACertificate,
	FAType.FAChainBroken,
	FAType.FACheck,
	FAType.FACheckCircle,
	FAType.FACheckCircleO,
	FAType.FACheckSquare,
	FAType.FACheckSquareO,
	FAType.FAChevronCircleDown,
	FAType.FAChevronCircleLeft,
	FAType.FAChevronCircleRight,
	FAType.FAChevronCircleUp,
	FAType.FAChevronDown,
	FAType.FAChevronLeft,
	FAType.FAChevronRight,
	FAType.FAChevronUp,
	FAType.FAChild,
	FAType.FAChrome,
	FAType.FACircle,
	FAType.FACircleO,
	FAType.FACircleONotch,
	FAType.FACircleThin,
	FAType.FAClipboard,
	FAType.FAClockO,
	FAType.FAClone,
	FAType.FACloud,
	FAType.FACloudDownload,
	FAType.FACloudUpload,
	FAType.FACode,
	FAType.FACodeFork,
	FAType.FACodepen,
	FAType.FACodiepie,
	FAType.FACoffee,
	FAType.FACog,
	FAType.FACogs,
	FAType.FAColumns,
	FAType.FAComment,
	FAType.FACommentO,
	FAType.FACommenting,
	FAType.FACommentingO,
	FAType.FAComments,
	FAType.FACommentsO,
	FAType.FACompass,
	FAType.FACompress,
	FAType.FAConnectdevelop,
	FAType.FAContao,
	FAType.FACopyright,
	FAType.FACreativeCommons,
	FAType.FACreditCard,
	FAType.FACreditCardAlt,
	FAType.FACrop,
	FAType.FACrosshairs,
	FAType.FACss3,
	FAType.FACube,
	FAType.FACubes,
	FAType.FACutlery,
	FAType.FADashcube,
	FAType.FADatabase,
	FAType.FADeaf,
	FAType.FADelicious,
	FAType.FADesktop,
	FAType.FADeviantart,
	FAType.FADiamond,
	FAType.FADigg,
	FAType.FADotCircleO,
	FAType.FADownload,
	FAType.FADribbble,
	FAType.FADropbox,
	FAType.FADrupal,
	FAType.FAEdge,
	FAType.FAEercast,
	FAType.FAEject,
	FAType.FAEllipsisH,
	FAType.FAEllipsisV,
	FAType.FAEmpire,
	FAType.FAEnvelope,
	FAType.FAEnvelopeO,
	FAType.FAEnvelopeOpen,
	FAType.FAEnvelopeOpenO,
	FAType.FAEnvelopeSquare,
	FAType.FAEnvira,
	FAType.FAEraser,
	FAType.FAEtsy,
	FAType.FAEur,
	FAType.FAExchange,
	FAType.FAExclamation,
	FAType.FAExclamationCircle,
	FAType.FAExclamationTriangle,
	FAType.FAExpand,
	FAType.FAExpeditedssl,
	FAType.FAExternalLink,
	FAType.FAExternalLinkSquare,
	FAType.FAEye,
	FAType.FAEyeSlash,
	FAType.FAEyedropper,
	FAType.FAFacebook,
	FAType.FAFacebookOfficial,
	FAType.FAFacebookSquare,
	FAType.FAFastBackward,
	FAType.FAFastForward,
	FAType.FAFax,
	FAType.FAFemale,
	FAType.FAFighterJet,
	FAType.FAFile,
	FAType.FAFileArchiveO,
	FAType.FAFileAudioO,
	FAType.FAFileCodeO,
	FAType.FAFileExcelO,
	FAType.FAFileImageO,
	FAType.FAFileO,
	FAType.FAFilePdfO,
	FAType.FAFilePowerpointO,
	FAType.FAFileText,
	FAType.FAFileTextO,
	FAType.FAFileVideoO,
	FAType.FAFileWordO,
	FAType.FAFilesO,
	FAType.FAFilm,
	FAType.FAFilter,
	FAType.FAFire,
	FAType.FAFireExtinguisher,
	FAType.FAFirefox,
	FAType.FAFirstOrder,
	FAType.FAFlag,
	FAType.FAFlagCheckered,
	FAType.FAFlagO,
	FAType.FAFlask,
	FAType.FAFlickr,
	FAType.FAFloppyO,
	FAType.FAFolder,
	FAType.FAFolderO,
	FAType.FAFolderOpen,
	FAType.FAFolderOpenO,
	FAType.FAFont,
	FAType.FAFontAwesome,
	FAType.FAFonticons,
	FAType.FAFortAwesome,
	FAType.FAForumbee,
	FAType.FAForward,
	FAType.FAFoursquare,
	FAType.FAFreeCodeCamp,
	FAType.FAFrownO,
	FAType.FAFutbolO,
	FAType.FAGamepad,
	FAType.FAGavel,
	FAType.FAGbp,
	FAType.FAGenderless,
	FAType.FAGetPocket,
	FAType.FAGg,
	FAType.FAGgCircle,
	FAType.FAGift,
	FAType.FAGit,
	FAType.FAGitSquare,
	FAType.FAGithub,
	FAType.FAGithubAlt,
	FAType.FAGithubSquare,
	FAType.FAGitlab,
	FAType.FAGlass,
	FAType.FAGlide,
	FAType.FAGlideG,
	FAType.FAGlobe,
	FAType.FAGoogle,
	FAType.FAGooglePlus,
	FAType.FAGooglePlusOfficial,
	FAType.FAGooglePlusSquare,
	FAType.FAGoogleWallet,
	FAType.FAGraduationCap,
	FAType.FAGratipay,
	FAType.FAGrav,
	FAType.FAHSquare,
	FAType.FAHackerNews,
	FAType.FAHandLizardO,
	FAType.FAHandODown,
	FAType.FAHandOLeft,
	FAType.FAHandORight,
	FAType.FAHandOUp,
	FAType.FAHandPaperO,
	FAType.FAHandPeaceO,
	FAType.FAHandPointerO,
	FAType.FAHandRockO,
	FAType.FAHandScissorsO,
	FAType.FAHandSpockO,
	FAType.FAHandshakeO,
	FAType.FAHashtag,
	FAType.FAHddO,
	FAType.FAHeader,
	FAType.FAHeadphones,
	FAType.FAHeart,
	FAType.FAHeartO,
	FAType.FAHeartbeat,
	FAType.FAHistory,
	FAType.FAHome,
	FAType.FAHospitalO,
	FAType.FAHourglass,
	FAType.FAHourglassEnd,
	FAType.FAHourglassHalf,
	FAType.FAHourglassO,
	FAType.FAHourglassStart,
	FAType.FAHouzz,
	FAType.FAHtml5,
	FAType.FAICursor,
	FAType.FAIdBadge,
	FAType.FAIdCard,
	FAType.FAIdCardO,
	FAType.FAIls,
	FAType.FAImdb,
	FAType.FAInbox,
	FAType.FAIndent,
	FAType.FAIndustry,
	FAType.FAInfo,
	FAType.FAInfoCircle,
	FAType.FAInr,
	FAType.FAInstagram,
	FAType.FAInternetExplorer,
	FAType.FAIoxhost,
	FAType.FAItalic,
	FAType.FAJoomla,
	FAType.FAJpy,
	FAType.FAJsfiddle,
	FAType.FAKey,
	FAType.FAKeyboardO,
	FAType.FAKrw,
	FAType.FALanguage,
	FAType.FALaptop,
	FAType.FALastfm,
	FAType.FALastfmSquare,
	FAType.FALeaf,
	FAType.FALeanpub,
	FAType.FALemonO,
	FAType.FALevelDown,
	FAType.FALevelUp,
	FAType.FALifeRing,
	FAType.FALightbulbO,
	FAType.FALineChart,
	FAType.FALink,
	FAType.FALinkedin,
	FAType.FALinkedinSquare,
	FAType.FALinode,
	FAType.FALinux,
	FAType.FAList,
	FAType.FAListAlt,
	FAType.FAListOl,
	FAType.FAListUl,
	FAType.FALocationArrow,
	FAType.FALock,
	FAType.FALongArrowDown,
	FAType.FALongArrowLeft,
	FAType.FALongArrowRight,
	FAType.FALongArrowUp,
	FAType.FALowVision,
	FAType.FAMagic,
	FAType.FAMagnet,
	FAType.FAMale,
	FAType.FAMap,
	FAType.FAMapMarker,
	FAType.FAMapO,
	FAType.FAMapPin,
	FAType.FAMapSigns,
	FAType.FAMars,
	FAType.FAMarsDouble,
	FAType.FAMarsStroke,
	FAType.FAMarsStrokeH,
	FAType.FAMarsStrokeV,
	FAType.FAMaxcdn,
	FAType.FAMeanpath,
	FAType.FAMedium,
	FAType.FAMedkit,
	FAType.FAMeetup,
	FAType.FAMehO,
	FAType.FAMercury,
	FAType.FAMicrochip,
	FAType.FAMicrophone,
	FAType.FAMicrophoneSlash,
	FAType.FAMinus,
	FAType.FAMinusCircle,
	FAType.FAMinusSquare,
	FAType.FAMinusSquareO,
	FAType.FAMixcloud,
	FAType.FAMobile,
	FAType.FAModx,
	FAType.FAMoney,
	FAType.FAMoonO,
	FAType.FAMotorcycle,
	FAType.FAMousePointer,
	FAType.FAMusic,
	FAType.FANeuter,
	FAType.FANewspaperO,
	FAType.FAObjectGroup,
	FAType.FAObjectUngroup,
	FAType.FAOdnoklassniki,
	FAType.FAOdnoklassnikiSquare,
	FAType.FAOpencart,
	FAType.FAOpenid,
	FAType.FAOpera,
	FAType.FAOptinMonster,
	FAType.FAOutdent,
	FAType.FAPagelines,
	FAType.FAPaintBrush,
	FAType.FAPaperPlane,
	FAType.FAPaperPlaneO,
	FAType.FAPaperclip,
	FAType.FAParagraph,
	FAType.FAPause,
	FAType.FAPauseCircle,
	FAType.FAPauseCircleO,
	FAType.FAPaw,
	FAType.FAPaypal,
	FAType.FAPencil,
	FAType.FAPencilSquare,
	FAType.FAPencilSquareO,
	FAType.FAPercent,
	FAType.FAPhone,
	FAType.FAPhoneSquare,
	FAType.FAPictureO,
	FAType.FAPieChart,
	FAType.FAPiedPiper,
	FAType.FAPiedPiperAlt,
	FAType.FAPiedPiperPp,
	FAType.FAPinterest,
	FAType.FAPinterestP,
	FAType.FAPinterestSquare,
	FAType.FAPlane,
	FAType.FAPlay,
	FAType.FAPlayCircle,
	FAType.FAPlayCircleO,
	FAType.FAPlug,
	FAType.FAPlus,
	FAType.FAPlusCircle,
	FAType.FAPlusSquare,
	FAType.FAPlusSquareO,
	FAType.FAPodcast,
	FAType.FAPowerOff,
	FAType.FAPrint,
	FAType.FAProductHunt,
	FAType.FAPuzzlePiece,
	FAType.FAQq,
	FAType.FAQrcode,
	FAType.FAQuestion,
	FAType.FAQuestionCircle,
	FAType.FAQuestionCircleO,
	FAType.FAQuora,
	FAType.FAQuoteLeft,
	FAType.FAQuoteRight,
	FAType.FARandom,
	FAType.FARavelry,
	FAType.FARebel,
	FAType.FARecycle,
	FAType.FAReddit,
	FAType.FARedditAlien,
	FAType.FARedditSquare,
	FAType.FARefresh,
	FAType.FARegistered,
	FAType.FARenren,
	FAType.FARepeat,
	FAType.FAReply,
	FAType.FAReplyAll,
	FAType.FARetweet,
	FAType.FARoad,
	FAType.FARocket,
	FAType.FARss,
	FAType.FARssSquare,
	FAType.FARub,
	FAType.FASafari,
	FAType.FAScissors,
	FAType.FAScribd,
	FAType.FASearch,
	FAType.FASearchMinus,
	FAType.FASearchPlus,
	FAType.FASellsy,
	FAType.FAServer,
	FAType.FAShare,
	FAType.FAShareAlt,
	FAType.FAShareAltSquare,
	FAType.FAShareSquare,
	FAType.FAShareSquareO,
	FAType.FAShield,
	FAType.FAShip,
	FAType.FAShirtsinbulk,
	FAType.FAShoppingBag,
	FAType.FAShoppingBasket,
	FAType.FAShoppingCart,
	FAType.FAShower,
	FAType.FASignIn,
	FAType.FASignLanguage,
	FAType.FASignOut,
	FAType.FASignal,
	FAType.FASimplybuilt,
	FAType.FASitemap,
	FAType.FASkyatlas,
	FAType.FASkype,
	FAType.FASlack,
	FAType.FASliders,
	FAType.FASlideshare,
	FAType.FASmileO,
	FAType.FASnapchat,
	FAType.FASnapchatGhost,
	FAType.FASnapchatSquare,
	FAType.FASnowflakeO,
	FAType.FASort,
	FAType.FASortAlphaAsc,
	FAType.FASortAlphaDesc,
	FAType.FASortAmountAsc,
	FAType.FASortAmountDesc,
	FAType.FASortAsc,
	FAType.FASortDesc,
	FAType.FASortNumericAsc,
	FAType.FASortNumericDesc,
	FAType.FASoundcloud,
	FAType.FASpaceShuttle,
	FAType.FASpinner,
	FAType.FASpoon,
	FAType.FASpotify,
	FAType.FASquare,
	FAType.FASquareO,
	FAType.FAStackExchange,
	FAType.FAStackOverflow,
	FAType.FAStar,
	FAType.FAStarHalf,
	FAType.FAStarHalfO,
	FAType.FAStarO,
	FAType.FASteam,
	FAType.FASteamSquare,
	FAType.FAStepBackward,
	FAType.FAStepForward,
	FAType.FAStethoscope,
	FAType.FAStickyNote,
	FAType.FAStickyNoteO,
	FAType.FAStop,
	FAType.FAStopCircle,
	FAType.FAStopCircleO,
	FAType.FAStreetView,
	FAType.FAStrikethrough,
	FAType.FAStumbleupon,
	FAType.FAStumbleuponCircle,
	FAType.FASubscript,
	FAType.FASubway,
	FAType.FASuitcase,
	FAType.FASunO,
	FAType.FASuperpowers,
	FAType.FASuperscript,
	FAType.FATable,
	FAType.FATablet,
	FAType.FATachometer,
	FAType.FATag,
	FAType.FATags,
	FAType.FATasks,
	FAType.FATaxi,
	FAType.FATelegram,
	FAType.FATelevision,
	FAType.FATencentWeibo,
	FAType.FATerminal,
	FAType.FATextHeight,
	FAType.FATextWidth,
	FAType.FATh,
	FAType.FAThLarge,
	FAType.FAThList,
	FAType.FAThemeisle,
	FAType.FAThermometerEmpty,
	FAType.FAThermometerFull,
	FAType.FAThermometerHalf,
	FAType.FAThermometerQuarter,
	FAType.FAThermometerThreeQuarters,
	FAType.FAThumbTack,
	FAType.FAThumbsDown,
	FAType.FAThumbsODown,
	FAType.FAThumbsOUp,
	FAType.FAThumbsUp,
	FAType.FATicket,
	FAType.FATimes,
	FAType.FATimesCircle,
	FAType.FATimesCircleO,
	FAType.FATint,
	FAType.FAToggleOff,
	FAType.FAToggleOn,
	FAType.FATrademark,
	FAType.FATrain,
	FAType.FATransgender,
	FAType.FATransgenderAlt,
	FAType.FATrash,
	FAType.FATrashO,
	FAType.FATree,
	FAType.FATrello,
	FAType.FATripadvisor,
	FAType.FATrophy,
	FAType.FATruck,
	FAType.FATry,
	FAType.FATty,
	FAType.FATumblr,
	FAType.FATumblrSquare,
	FAType.FATwitch,
	FAType.FATwitter,
	FAType.FATwitterSquare,
	FAType.FAUmbrella,
	FAType.FAUnderline,
	FAType.FAUndo,
	FAType.FAUniversalAccess,
	FAType.FAUniversity,
	FAType.FAUnlock,
	FAType.FAUnlockAlt,
	FAType.FAUpload,
	FAType.FAUsb,
	FAType.FAUsd,
	FAType.FAUser,
	FAType.FAUserCircle,
	FAType.FAUserCircleO,
	FAType.FAUserMd,
	FAType.FAUserO,
	FAType.FAUserPlus,
	FAType.FAUserSecret,
	FAType.FAUserTimes,
	FAType.FAUsers,
	FAType.FAVenus,
	FAType.FAVenusDouble,
	FAType.FAVenusMars,
	FAType.FAViacoin,
	FAType.FAViadeo,
	FAType.FAViadeoSquare,
	FAType.FAVideoCamera,
	FAType.FAVimeo,
	FAType.FAVimeoSquare,
	FAType.FAVine,
	FAType.FAVk,
	FAType.FAVolumeControlPhone,
	FAType.FAVolumeDown,
	FAType.FAVolumeOff,
	FAType.FAVolumeUp,
	FAType.FAWeibo,
	FAType.FAWeixin,
	FAType.FAWhatsapp,
	FAType.FAWheelchair,
	FAType.FAWheelchairAlt,
	FAType.FAWifi,
	FAType.FAWikipediaW,
	FAType.FAWindowClose,
	FAType.FAWindowCloseO,
	FAType.FAWindowMaximize,
	FAType.FAWindowMinimize,
	FAType.FAWindowRestore,
	FAType.FAWindows,
	FAType.FAWordpress,
	FAType.FAWpbeginner,
	FAType.FAWpexplorer,
	FAType.FAWpforms,
	FAType.FAWrench,
	FAType.FAXing,
	FAType.FAXingSquare,
	FAType.FAYCombinator,
	FAType.FAYahoo,
	FAType.FAYelp,
	FAType.FAYoast,
	FAType.FAYoutube,
	FAType.FAYoutubePlay,
	FAType.FAYoutubeSquare,
]

/* End of Autogenerated Map */
