
#                                           Spring Boot Projects - Full Stack
   Total projects provide Source Codes/Guides/App, indeed down below represents. We take an opinionated view of the Spring platform and several-party libraries so you can get started with as Spring Boot.
   
   ----
  ## Advanced Spring Security just [click](https://github.com/Urunov/SpringBoot-Projects-FullStack/tree/master/Advanced-SpringSecure/1.%20simple-secure/secure-start) 
   
#  
![springMove1](https://user-images.githubusercontent.com/11626327/82535952-a5ec4500-9b82-11ea-97e1-688ac0d4410b.jpg)


## Configuration table
  
   | Components  | Technology  | 
   | :---        |    :----:   |   
   | Frontend  | BootStrap, Jsp/ React 16+  | 
   | Backend   | Spring Boot 2.1+, Java 8/Java 11+ |
   | Security |  Spring Security, SSL, Form, https, JWT|
   | Database | JPA-Hibernate, H2, MySQL, Oracle, MangoDB, Postgresql|
   | API Documentation	| Swagger API + (Hub)|
   | Client Build | npm, yarn, webpack|
   | Server Build| Maven / Gradle|
   | API testing| POSTMAN / insomnia|
   | Tool | Intellj Idea/VSC|


# Part-1: Spring Boot Basics and Fundamentals with Projects
    (Attention: When You click  RESOURE OR CODE, indeed, Detail explanations are inside the sources!)

 * ### [ (resource](https://dev.to/hamdamboy/spring-boot-basics-and-fundamentals-with-projects-5967) / [ code) ]( https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-1%20Spring%20Boot%20Basic%20Fund%20Projects/SpringBootSourceCode) Getting Started with Spring Boot
 
   *  Installing Spring Boot +  Maven (pom.xml) : (code) SpringBootFamilyMember
   *  Spring Boot + Gradle : (code) Spring Gradle
   *  Spring Boot 2 Hello World Application "Welcome-Back Again" : (code) SpringBootHelloWorld
   *  Important Spring Boot Standalone : (code) SpringStandalone
   *  Migrating from Spring to Spring Boot : (code) SpringDownloadFiles
    
*  ### [ (resource](https://dev.to/hamdamboy/spring-boot-basics-and-fundamentals-with-projects-5967) / [ code) ]( https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-1%20Spring%20Boot%20Basic%20Fund%20Projects/SpringBootSources ) RESTfull API: Spring REST Template-Spring REST Client Methods
   
   *  Spring REST Client Methods (GET, POST, PUT and DELETE) : (code) SpringRestAPI
   *  Spring Boot How to Change Port and Context Path : (code) SpringEmailProcess
   *  Spring Boot2 Deploy WAR file to External Tomcat : (code) SpringWebJar
   *  Bonus: Additional source codes
      
#

# Part-2: Spring Boot Configuration
 * ### [(resource](https://dev.to/hamdamboy/twitter-sms-services-spring-boot-possible-xml-configuration-2p9m)/[ code)]( https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-2%20Spring%20Boot%20Configuration ) Configuration in Practical way
 
    *  Spring Boot 2 + Java Based Configuration 
    *  Spring Boot 2 + XML Configuration 
    *  Migrating from Spring to Spring Boot
#
# Part-3: Spring Boot Annotations 

 * ### ([resource](https://dev.to/hamdamboy/cognitive-control-annotations-in-spring-boot-23io) /  [ code ]( https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-3%20Spring%20Boot%20Annotations))  Practical Experience with Annotation  
  
     *  Spring Boot Annotations Definiation and Practics
     *  Spring Boot @EnableAutoConfiguration Annotation with Example
     *  Spring Boot @SpringBootApplication Annotation with Example
     *  Spring Boot - Creating Asynchronous Methods using @Async Annotation

#
# Part-4: Spring Boot + REST API
 * ### ([resource](https://dev.to/hamdamboy/truly-there-is-no-difference-in-implementation-integrating-spring-with-jersey-and-integrating-jersey-with-spring-m2k)/ [ code ](https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-4%20Spring%20Boot%20REST%20API)) Database interconnections




    * Aspect Orient Programming (AOP) in Spring
    * Spring Boot 2 Hibernate 5 MySQL CRUD REST API Tutorial
    * Spring Boot 2 JPA MySQL CRUD Example
    * Spring Boot 2 CRUD REST APIs Validation Example
    * Spring Data JPA Auditing with Spring Boot 2 and MySQL Example
    * Spring Boot 2 Exception Handling for REST APIs
    * Spring Boot 2 Logging SLF4j Logback and LOG4j2 Example
    * Spring Boot 2 + Jersey REST + JPA + Hibernate 5 CRUD REST APIs 
    * Spring Boot 2 - Scheduling Tasks
    * Spring Boot 2 RESTful API Documentation with Swagger 2 
    * Spring Boot 2 - File Upload and Download Rest API Tutorial // LATEST
#

# Part-5: Spring Boot + Web Application 
 * ### (resource/[code](https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-5%20Spring%20Boot%20Web%20Application))  Web applicaiton develops
 
   * Spring MVC + Spring Boot2 + JSP + JPA + Hibernate 5 + MySQL Example
   * Spring Boot 2 MVC Web Application Thymeleaf JPA MySQL Example
   * Spring Boot 2 - Spring MVC + Thymeleaf Input Form Validation
   * Spring Boot JPA Multiple Data Sources Example

#
# Part-6: Spring Boot + Security 
 * ### ([resource](https://dev.to/urunov/already-hacked-security-environment-of-the-system-1b82)/[code]( https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/Part-6%20Spring%20Boot%20Security))  Security possiblities
  
     * Spring Boot 2 + Spring MVC + Role Based Spring Security + JPA + Thymeleaf + MySQL 
     * Authenticating a User with LDAP using Spring Boot and Spring Security
     * User Registration Module using Spring Boot 2 + Spring MVC + Spring Security + Hibernate 5 + Thymeleaf + MySQL
#
# Part-7: TEST: Spring Boot 
 * ### (resource/[code](https://github.com/Urunov/SpringBoot-Projects-FullStack/tree/master/Part-7%20Spring%20Boot%20TEST))  Security possiblities
 
   * Spring Data JPA + Repository Testing using Spring Boot + @DataJpaTest
   * Spring Boot 2 + REST APIs Integration Testing
   * Spring Boot 2 with JUnit 5 Testing Example
#

# Part-8: Spring Boot Real Project [Backend and Frontend]
  * ### (resource/[code](https://github.com/Urunov/SpringBoot-Projects-FullStack/tree/master/Part-8%20Spring%20Boot%20Real%20Projects)) Project: Spring Boot  (toddler steps) 
 
    * Spring Boot + PostgreSQL + JPA/Hibernate CRUD Restful API Tutorial
    * Spring Boot + Spring JDBC + MySQL CRUD (Simple Project) 
    * Spring Boot Thymeleaf CRUD Example Tutorial
     
 # Part-9: Full Stack [Spring Boot and React JS]
  * ### (resource/[code](https://github.com/Urunov/SpringBoot-Projects-FullStack/tree/master/Part-9.SpringBoot-React-Projects)) 
 
 Included README inside the folder. There are several projects and more detail information. 
    
     * Part-1. FullStack : Spring Boot React JS CRUD Swagger API 
            > Company Employee ver1. Full Stack 
                  - Spring Boot 
                  - ReactJS
                  - Swagger API
                  - Database (MySQL)
                  
     
     
# Reference Resources 
  * [ Spring Documentation](https://docs.spring.io/spring-boot/docs/current/reference/html/spring-boot-features.html#boot-features-kotlin)
  * [ Spring Annotation ](https://www.journaldev.com/16966/spring-annotations#spring-annotations-list)

  * [ Spring MVC  ](https://www.java67.com/2019/04/top-10-spring-mvc-and-rest-annotations-examples-java.html)
  
  * [ Spring Books  ](https://github.com/Hamdambek/SpringBoot-Projects-FullStack/tree/master/InAddition)
  
  * [ Spring Boot React JS](https://www.tutofox.com/spring/crud-spring-boot-reactjs-api-rest-mysql-1-starter/)
 
  * [Spring Boot React JS](https://www.youtube.com/watch?v=VhqG3SgRRRc&list=PLxnmNhAZjt7wHyMuaqkjXzKBBwAiCxIR7&index=13)
  
  * [Spring Boot React Maven](https://www.youtube.com/watch?v=7XxH-G9ckeU)
  
  * [Spring, MicroService, GraphQL, API](https://github.com/Java-Techie-jt)
 

#   
