﻿CREATE TABLE dbo.Users
(
	Id INT IDENTITY(1, 1) NOT NULL CONSTRAINT PK_Users PRIMARY KEY,
	Name NVARCHAR(255) NOT NULL,
	Role VARCHAR(255) NOT NULL,
	SteamId CHAR(17) NOT NULL,
	AvatarImageId INT NULL CONSTRAINT FK_Users_AvatarImageId FOREIGN KEY REFERENCES dbo.Images(Id),
	Color VARCHAR(255) NULL,
	Avatar VARBINARY(MAX) NULL,
	IsPayPalEnabled BIT NOT NULL CONSTRAINT DF_Users_IsPayPalEnabled DEFAULT 0,
	PayPalAddress NVARCHAR(255) NULL,
	IsNanoEnabled BIT NOT NULL CONSTRAINT DF_Users_IsNanoEnabled DEFAULT 0,
	NanoAddress NVARCHAR(255) NULL,
	IsStripeEnabled BIT NOT NULL CONSTRAINT DF_Users_IsStripeEnabled DEFAULT 0,
	StripeAccountId NVARCHAR(255) NULL,
	DiscordWebhookUrl NVARCHAR(255) NULL,
	TermsAndConditions NVARCHAR(4000) NULL,
	Biography NVARCHAR(4000) NULL,
	IsVerifiedSeller BIT NOT NULL CONSTRAINT DF_Users_IsVerifiedSeller DEFAULT 0,
	CreateDate DATETIME2(0) NOT NULL CONSTRAINT DF_Users_CreateDate DEFAULT SYSDATETIME(),
	CONSTRAINT UK_Users_SteamId UNIQUE (SteamId)
)
