﻿CREATE TABLE dbo.ProductSales
(
	Id INT IDENTITY(1, 1) NOT NULL CONSTRAINT PK_ProductSales PRIMARY KEY,
	ProductId INT NOT NULL CONSTRAINT FK_ProductSales_ProductId FOREIGN KEY REFERENCES dbo.Products(Id),
	ProductPrice DECIMAL(9, 2) NOT NULL,
	SaleName NVARCHAR(30) NOT NULL,
	SaleMultiplier DECIMAL(9, 2) NOT NULL,
	StartDate DATETIME2(0) NOT NULL CONSTRAINT DF_ProductSales_StartDate DEFAULT SYSDATETIME(),
	EndDate DATETIME2(0) NOT NULL,
	IsExpired AS CONVERT(BIT, CASE WHEN EndDate < SYSDATETIME() THEN 1 ELSE 0 END),
	IsActive AS CONVERT(BIT, CASE WHEN SYSDATETIME() <= EndDate AND StartDate <= SYSDATETIME() THEN 1 ELSE 0 END)
)
