﻿CREATE TABLE dbo.ProductReviews
(
	Id INT IDENTITY(1,1) NOT NULL CONSTRAINT PK_ProductReviews PRIMARY KEY,
	Title NVARCHAR(255) NOT NULL,
	Body NVARCHAR(2000) NOT NULL,
	Rating TINYINT NOT NULL,
	ProductId INT NOT NULL CONSTRAINT FK_ProductReviews_ProductId FOREIGN KEY REFERENCES dbo.Products(Id),
	UserId INT NOT NULL CONSTRAINT FK_ProductReviews_UserId FOREIGN KEY REFERENCES dbo.Users(Id),
	LastUpdate DATETIME2(0) NOT NULL CONSTRAINT DF_ProductReviews_LastUpdate DEFAULT SYSDATETIME(),
	CreateDate DATETIME2(0) NOT NULL CONSTRAINT DF_ProductReviews_CreateDate DEFAULT SYSDATETIME(),
	CONSTRAINT UK_ProductReviews UNIQUE (ProductId, UserId)
)
