﻿CREATE TABLE dbo.ProductReviewReplies
(
	Id INT IDENTITY(1,1) NOT NULL CONSTRAINT PK_ProductReviewReplies PRIMARY KEY,
	Body NVARCHAR(1000) NOT NULL,
	ReviewId INT NOT NULL CONSTRAINT FK_ProductReviewReplies_ReviewId FOREIGN KEY REFERENCES dbo.ProductReviews(Id) ON DELETE CASCADE,
	UserId INT NOT NULL CONSTRAINT FK_ProductReviewReplies_UserId FOREIGN KEY REFERENCES dbo.Users(Id) ON DELETE CASCADE,
	LastUpdate DATETIME2(0) NOT NULL CONSTRAINT DF_ProductReviewReplies_LastUpdate DEFAULT SYSDATETIME(),
	CreateDate DATETIME2(0) NOT NULL CONSTRAINT DF_ProductReviewReplies_CreateDate DEFAULT SYSDATETIME(),
	CONSTRAINT UK_ProductReviewReplies UNIQUE (ReviewId, UserId)
)
