@file:Suppress("LongMethod")

package org.noiseplanet.noisecapture.audio.signal


data class SpectrumChannelConfiguration(
    val bandpass: List<Bandpass>,
    val antiAliasing: AntiAliasing,
    val aWeighting: DigitalFilterConfiguration?,
    val cWeighting: DigitalFilterConfiguration?,
    val configuration: GeneralConfiguration,
)

data class DigitalFilterConfiguration(
    val filterDenominator: DoubleArray,
    val filterNumerator: DoubleArray,
)

data class AntiAliasing(
    val a1: DoubleArray,
    val a2: DoubleArray,
    val b0: DoubleArray,
    val b1: DoubleArray,
    val b2: DoubleArray,
    val sampleRatio: Int,
)

data class Bandpass(
    val centerFrequency: Double,
    val maxFrequency: Double,
    val minFrequency: Double,
    val nominalFrequency: Double,
    val subsamplingDepth: Int,
    val sos: Sos,
    val subsamplingFilter: SubsamplingFilter,
)

data class GeneralConfiguration(
    val sampleRate: Int,
)

data class Sos(
    val a1: DoubleArray,
    val a2: DoubleArray,
    val b0: DoubleArray,
    val b1: DoubleArray,
    val b2: DoubleArray,
)

data class SubsamplingFilter(
    val centerFrequency: Double,
    val maxFrequency: Double,
    val minFrequency: Double,
    val nominalFrequency: Double,
    val sos: Sos,
)


fun get44100HZ(): SpectrumChannelConfiguration {
    return SpectrumChannelConfiguration(
        bandpass = listOf(
            Bandpass(
                49.60628287400625,
                55.681169883771226,
                44.19417382415923,
                50.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9983198086546723,
                        -1.9984209770619399,
                        -1.99868995344204,
                        -1.9988956714388693,
                        -1.9994669879419251,
                        -1.9995836340086606
                    ),
                    a2 = doubleArrayOf(
                        0.9983728225106281,
                        0.9984679700150535,
                        0.9987487770098534,
                        0.9989380410501625,
                        0.9995294236302933,
                        0.999623581666138
                    ),
                    b0 = doubleArrayOf(2.993188043570381e-19, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.986376087140762e-19, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.993188043570381e-19, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    49.60628287400625,
                    55.681169883771226,
                    44.19417382415923,
                    50.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9983198086546723,
                            -1.9984209770619399,
                            -1.99868995344204,
                            -1.9988956714388693,
                            -1.9994669879419251,
                            -1.9995836340086606
                        ),
                        a2 = doubleArrayOf(
                            0.9983728225106281,
                            0.9984679700150535,
                            0.9987487770098534,
                            0.9989380410501625,
                            0.9995294236302933,
                            0.999623581666138
                        ),
                        b0 = doubleArrayOf(2.993188043570381e-19, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(5.986376087140762e-19, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.993188043570381e-19, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                62.5,
                70.15387801933582,
                55.681169883771204,
                63.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.997866182386905,
                        -1.9979955649826082,
                        -1.9983304542326876,
                        -1.9985949509811112,
                        -1.9993080437878314,
                        -1.9994623556213569
                    ),
                    a2 = doubleArrayOf(
                        0.9979503186377896,
                        0.9980701466331582,
                        0.9984238153827981,
                        0.9986621991296034,
                        0.9994071479024906,
                        0.9995257653492752
                    ),
                    b0 = doubleArrayOf(1.196292648558012e-18, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.392585297116024e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.196292648558012e-18, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    62.5,
                    70.15387801933582,
                    55.681169883771204,
                    63.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.997866182386905,
                            -1.9979955649826082,
                            -1.9983304542326876,
                            -1.9985949509811112,
                            -1.9993080437878314,
                            -1.9994623556213569
                        ),
                        a2 = doubleArrayOf(
                            0.9979503186377896,
                            0.9980701466331582,
                            0.9984238153827981,
                            0.9986621991296034,
                            0.9994071479024906,
                            0.9995257653492752
                        ),
                        b0 = doubleArrayOf(1.196292648558012e-18, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.392585297116024e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.196292648558012e-18, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                78.74506561842958,
                88.38834764831844,
                70.15387801933582,
                80.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9972847298727139,
                        -1.9974507843363472,
                        -1.9978663704766202,
                        -1.9982080364995807,
                        -1.9990958070523397,
                        -1.9993018875143298
                    ),
                    a2 = doubleArrayOf(
                        0.997418251755548,
                        0.9975691452302478,
                        0.9980145410531994,
                        0.9983147673823352,
                        0.9992531121476155,
                        0.999402537668409
                    ),
                    b0 = doubleArrayOf(4.780224578976738e-18, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.560449157953475e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.780224578976738e-18, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    78.74506561842958,
                    88.38834764831844,
                    70.15387801933582,
                    80.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9972847298727139,
                            -1.9974507843363472,
                            -1.9978663704766202,
                            -1.9982080364995807,
                            -1.9990958070523397,
                            -1.9993018875143298
                        ),
                        a2 = doubleArrayOf(
                            0.997418251755548,
                            0.9975691452302478,
                            0.9980145410531994,
                            0.9983147673823352,
                            0.9992531121476155,
                            0.999402537668409
                        ),
                        b0 = doubleArrayOf(4.780224578976738e-18, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(9.560449157953475e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(4.780224578976738e-18, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                99.21256574801247,
                111.36233976754241,
                88.38834764831843,
                100.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9965364131606704,
                        -1.996750453198385,
                        -1.9972639850393383,
                        -1.9977078138459268,
                        -1.9988093943603864,
                        -1.9990875422352576
                    ),
                    a2 = doubleArrayOf(
                        0.996748293529012,
                        0.9969382790329787,
                        0.9974991288319082,
                        0.9978772006004107,
                        0.999059074482199,
                        0.9992473012061489
                    ),
                    b0 = doubleArrayOf(1.9096008867615595e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.819201773523119e-17, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.9096008867615595e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    99.21256574801247,
                    111.36233976754241,
                    88.38834764831843,
                    100.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9965364131606704,
                            -1.996750453198385,
                            -1.9972639850393383,
                            -1.9977078138459268,
                            -1.9988093943603864,
                            -1.9990875422352576
                        ),
                        a2 = doubleArrayOf(
                            0.996748293529012,
                            0.9969382790329787,
                            0.9974991288319082,
                            0.9978772006004107,
                            0.999059074482199,
                            0.9992473012061489
                        ),
                        b0 = doubleArrayOf(1.9096008867615595e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(3.819201773523119e-17, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.9096008867615595e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                125.0,
                140.30775603867164,
                111.36233976754241,
                125.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9955686463431954,
                        -1.9958459676577474,
                        -1.9964769915778326,
                        -1.9970573610880828,
                        -1.9984183696347848,
                        -1.9987981731888196
                    ),
                    a2 = doubleArrayOf(
                        0.9959048400703698,
                        0.9961440013871193,
                        0.9968501336181875,
                        0.9973261694669386,
                        0.9988146588348366,
                        0.999051747964678
                    ),
                    b0 = doubleArrayOf(7.625883439127173e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.5251766878254346e-16, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.625883439127173e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    125.0,
                    140.30775603867164,
                    111.36233976754241,
                    125.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9955686463431954,
                            -1.9958459676577474,
                            -1.9964769915778326,
                            -1.9970573610880828,
                            -1.9984183696347848,
                            -1.9987981731888196
                        ),
                        a2 = doubleArrayOf(
                            0.9959048400703698,
                            0.9961440013871193,
                            0.9968501336181875,
                            0.9973261694669386,
                            0.9988146588348366,
                            0.999051747964678
                        ),
                        b0 = doubleArrayOf(7.625883439127173e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.5251766878254346e-16, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(7.625883439127173e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                157.49013123685916,
                176.7766952966369,
                140.30775603867164,
                160.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9943097900886524,
                        -1.9946713116001737,
                        -1.9954409879611368,
                        -1.9962057847910375,
                        -1.997877844403779,
                        -1.9984029467524744
                    ),
                    a2 = doubleArrayOf(
                        0.9948431721342493,
                        0.9951441671210961,
                        0.9960330611133081,
                        0.9966323377918527,
                        0.9985068052423528,
                        0.9988054170367806
                    ),
                    b0 = doubleArrayOf(3.044058450203638e-16, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(6.088116900407276e-16, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(3.044058450203638e-16, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    157.49013123685916,
                    176.7766952966369,
                    140.30775603867164,
                    160.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9943097900886524,
                            -1.9946713116001737,
                            -1.9954409879611368,
                            -1.9962057847910375,
                            -1.997877844403779,
                            -1.9984029467524744
                        ),
                        a2 = doubleArrayOf(
                            0.9948431721342493,
                            0.9951441671210961,
                            0.9960330611133081,
                            0.9966323377918527,
                            0.9985068052423528,
                            0.9988054170367806
                        ),
                        b0 = doubleArrayOf(3.044058450203638e-16, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(6.088116900407276e-16, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(3.044058450203638e-16, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                198.42513149602493,
                222.72467953508482,
                176.77669529663686,
                200.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9926610639212046,
                        -1.993135746076362,
                        -1.9940652391539457,
                        -1.995082032908412,
                        -1.997120891752752,
                        -1.997856368425131
                    ),
                    a2 = doubleArrayOf(
                        0.9935071670438599,
                        0.9938858674931755,
                        0.995004585865703,
                        0.995758833577239,
                        0.9981190804995169,
                        0.9984951384537887
                    ),
                    b0 = doubleArrayOf(1.214460313047029e-15, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.428920626094058e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.214460313047029e-15, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    198.42513149602493,
                    222.72467953508482,
                    176.77669529663686,
                    200.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9926610639212046,
                            -1.993135746076362,
                            -1.9940652391539457,
                            -1.995082032908412,
                            -1.997120891752752,
                            -1.997856368425131
                        ),
                        a2 = doubleArrayOf(
                            0.9935071670438599,
                            0.9938858674931755,
                            0.995004585865703,
                            0.995758833577239,
                            0.9981190804995169,
                            0.9984951384537887
                        ),
                        b0 = doubleArrayOf(1.214460313047029e-15, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.428920626094058e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.214460313047029e-15, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                250.0,
                280.6155120773433,
                222.72467953508482,
                250.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.990484543589923,
                        -1.9911129858369792,
                        -1.9922202506858138,
                        -1.9935856131585172,
                        -1.9960467535953117,
                        -1.9970905797877736
                    ),
                    a2 = doubleArrayOf(
                        0.9918264632393188,
                        0.9923027422852423,
                        0.9937103364002111,
                        0.9946593406583514,
                        0.9976308150496469,
                        0.9981043341042959
                    ),
                    b0 = doubleArrayOf(4.841959696459329e-15, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.683919392918658e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.841959696459329e-15, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    250.0,
                    280.6155120773433,
                    222.72467953508482,
                    250.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.990484543589923,
                            -1.9911129858369792,
                            -1.9922202506858138,
                            -1.9935856131585172,
                            -1.9960467535953117,
                            -1.9970905797877736
                        ),
                        a2 = doubleArrayOf(
                            0.9918264632393188,
                            0.9923027422852423,
                            0.9937103364002111,
                            0.9946593406583514,
                            0.9976308150496469,
                            0.9981043341042959
                        ),
                        b0 = doubleArrayOf(4.841959696459329e-15, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(9.683919392918658e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(4.841959696459329e-15, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                314.9802624737183,
                353.5533905932738,
                280.6155120773433,
                315.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9875851916090912,
                        -1.9884250270785415,
                        -1.9897188898480878,
                        -1.9915725553870065,
                        -1.9945024522551325,
                        -1.9960033805175177
                    ),
                    a2 = doubleArrayOf(
                        0.9897129626266903,
                        0.9903116554314061,
                        0.9920821533812527,
                        0.9932757218314784,
                        0.9970160247033005,
                        0.997612139139008
                    ),
                    b0 = doubleArrayOf(1.9288175446367492e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.8576350892734984e-14, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.9288175446367492e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    314.9802624737183,
                    353.5533905932738,
                    280.6155120773433,
                    315.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9875851916090912,
                            -1.9884250270785415,
                            -1.9897188898480878,
                            -1.9915725553870065,
                            -1.9945024522551325,
                            -1.9960033805175177
                        ),
                        a2 = doubleArrayOf(
                            0.9897129626266903,
                            0.9903116554314061,
                            0.9920821533812527,
                            0.9932757218314784,
                            0.9970160247033005,
                            0.997612139139008
                        ),
                        b0 = doubleArrayOf(1.9288175446367492e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(3.8576350892734984e-14, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.9288175446367492e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                396.8502629920499,
                445.44935907016975,
                353.5533905932738,
                400.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.983683760843643,
                        -1.9848177973188836,
                        -1.9862875464023864,
                        -1.9888340386407348,
                        -1.9922540564683868,
                        -1.9944395456030453
                    ),
                    a2 = doubleArrayOf(
                        0.9870565418362137,
                        0.9878086030156703,
                        0.9900347138507755,
                        0.9915350658113805,
                        0.996242067775943,
                        0.9969922977121467
                    ),
                    b0 = doubleArrayOf(7.675358798811291e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.5350717597622583e-13, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.675358798811291e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    396.8502629920499,
                    445.44935907016975,
                    353.5533905932738,
                    400.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.983683760843643,
                            -1.9848177973188836,
                            -1.9862875464023864,
                            -1.9888340386407348,
                            -1.9922540564683868,
                            -1.9944395456030453
                        ),
                        a2 = doubleArrayOf(
                            0.9870565418362137,
                            0.9878086030156703,
                            0.9900347138507755,
                            0.9915350658113805,
                            0.996242067775943,
                            0.9969922977121467
                        ),
                        b0 = doubleArrayOf(7.675358798811291e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.5350717597622583e-13, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(7.675358798811291e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                500.0,
                561.2310241546866,
                445.44935907016963,
                500.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.978375713144662,
                        -1.9799242729184654,
                        -1.9815219064760534,
                        -1.9850636820103815,
                        -1.9889417297107825,
                        -1.9921616221501939
                    ),
                    a2 = doubleArrayOf(
                        0.9837198346904802,
                        0.9846637063121387,
                        0.9874614057534,
                        0.9893460286738955,
                        0.9952679803456205,
                        0.9962117744393044
                    ),
                    b0 = doubleArrayOf(3.050178389757522e-13, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(6.100356779515044e-13, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(3.050178389757522e-13, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    500.0,
                    561.2310241546866,
                    445.44935907016963,
                    500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.978375713144662,
                            -1.9799242729184654,
                            -1.9815219064760534,
                            -1.9850636820103815,
                            -1.9889417297107825,
                            -1.9921616221501939
                        ),
                        a2 = doubleArrayOf(
                            0.9837198346904802,
                            0.9846637063121387,
                            0.9874614057534,
                            0.9893460286738955,
                            0.9952679803456205,
                            0.9962117744393044
                        ),
                        b0 = doubleArrayOf(3.050178389757522e-13, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(6.100356779515044e-13, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(3.050178389757522e-13, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                629.9605249474366,
                707.1067811865476,
                561.2310241546866,
                630.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9710687181060893,
                        -1.9732083856639946,
                        -1.97481898635759,
                        -1.9798073097638182,
                        -1.984009403826708,
                        -1.9888042278234839
                    ),
                    a2 = doubleArrayOf(
                        0.9795319509086966,
                        0.9807151306083703,
                        0.9842293382669933,
                        0.9865943148708757,
                        0.9940424264123358,
                        0.9952290061875053
                    ),
                    b0 = doubleArrayOf(1.2101032033538562e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.4202064067077124e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.2101032033538562e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    629.9605249474366,
                    707.1067811865476,
                    561.2310241546866,
                    630.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9710687181060893,
                            -1.9732083856639946,
                            -1.97481898635759,
                            -1.9798073097638182,
                            -1.984009403826708,
                            -1.9888042278234839
                        ),
                        a2 = doubleArrayOf(
                            0.9795319509086966,
                            0.9807151306083703,
                            0.9842293382669933,
                            0.9865943148708757,
                            0.9940424264123358,
                            0.9952290061875053
                        ),
                        b0 = doubleArrayOf(1.2101032033538562e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.4202064067077124e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.2101032033538562e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                793.7005259840998,
                890.8987181403395,
                707.1067811865476,
                800.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9608874446844493,
                        -1.963879545064532,
                        -1.965272672649919,
                        -1.9723856664756494,
                        -1.97659489715021,
                        -1.9838025235597203
                    ),
                    a2 = doubleArrayOf(
                        0.9742810207967747,
                        0.9757617669177364,
                        0.9801733960432047,
                        0.9831371116044616,
                        0.9925011997680455,
                        0.9939916952442285
                    ),
                    b0 = doubleArrayOf(4.790763704092158e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.581527408184316e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.790763704092158e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    793.7005259840998,
                    890.8987181403395,
                    707.1067811865476,
                    800.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9608874446844493,
                            -1.963879545064532,
                            -1.965272672649919,
                            -1.9723856664756494,
                            -1.97659489715021,
                            -1.9838025235597203
                        ),
                        a2 = doubleArrayOf(
                            0.9742810207967747,
                            0.9757617669177364,
                            0.9801733960432047,
                            0.9831371116044616,
                            0.9925011997680455,
                            0.9939916952442285
                        ),
                        b0 = doubleArrayOf(4.790763704092158e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(9.581527408184316e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(4.790763704092158e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1000.0,
                1122.4620483093731,
                890.8987181403393,
                1000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9465287395721516,
                        -1.9507624588529555,
                        -1.9515135594143518,
                        -1.9617755601288898,
                        -1.9653587645094899,
                        -1.9762804069485385
                    ),
                    a2 = doubleArrayOf(
                        0.9677055193767125,
                        0.9695545234083117,
                        0.9750893095099044,
                        0.9787962486896891,
                        0.9905642285037186,
                        0.9924340097579212
                    ),
                    b0 = doubleArrayOf(1.8916509736126712e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.7833019472253423e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.8916509736126712e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1000.0,
                    1122.4620483093731,
                    890.8987181403393,
                    1000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9465287395721516,
                            -1.9507624588529555,
                            -1.9515135594143518,
                            -1.9617755601288898,
                            -1.9653587645094899,
                            -1.9762804069485385
                        ),
                        a2 = doubleArrayOf(
                            0.9677055193767125,
                            0.9695545234083117,
                            0.9750893095099044,
                            0.9787962486896891,
                            0.9905642285037186,
                            0.9924340097579212
                        ),
                        b0 = doubleArrayOf(1.8916509736126712e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(3.7833019472253423e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.8916509736126712e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1259.9210498948732,
                1414.213562373095,
                1122.4620483093731,
                1250.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9260424262170373,
                        -1.9320996286683723,
                        -1.9314647877308484,
                        -1.9464276256666304,
                        -1.9482192536879337,
                        -1.9648762820351429
                    ),
                    a2 = doubleArrayOf(
                        0.959484453052192,
                        0.9617861010981933,
                        0.9687258551697253,
                        0.9733497927864203,
                        0.9881320776548521,
                        0.9904730011558084
                    ),
                    b0 = doubleArrayOf(7.444638326450626e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.4889276652901253e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.444638326450626e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1259.9210498948732,
                    1414.213562373095,
                    1122.4620483093731,
                    1250.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9260424262170373,
                            -1.9320996286683723,
                            -1.9314647877308484,
                            -1.9464276256666304,
                            -1.9482192536879337,
                            -1.9648762820351429
                        ),
                        a2 = doubleArrayOf(
                            0.959484453052192,
                            0.9617861010981933,
                            0.9687258551697253,
                            0.9733497927864203,
                            0.9881320776548521,
                            0.9904730011558084
                        ),
                        b0 = doubleArrayOf(7.444638326450626e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.4889276652901253e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(7.444638326450626e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1587.4010519681995,
                1781.7974362806785,
                1414.2135623730949,
                1600.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.8965027818651838,
                        -1.9052541730305297,
                        -1.9019737635216158,
                        -1.9239887853351916,
                        -1.9219458962629674,
                        -1.9474731148985207
                    ),
                    a2 = doubleArrayOf(
                        0.9492267296230263,
                        0.95207917414863,
                        0.9607765846022719,
                        0.9665216737012422,
                        0.9850820532134703,
                        0.9880039518087411
                    ),
                    b0 = doubleArrayOf(2.917804238031064e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.835608476062128e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.917804238031064e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1587.4010519681995,
                    1781.7974362806785,
                    1414.2135623730949,
                    1600.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.8965027818651838,
                            -1.9052541730305297,
                            -1.9019737635216158,
                            -1.9239887853351916,
                            -1.9219458962629674,
                            -1.9474731148985207
                        ),
                        a2 = doubleArrayOf(
                            0.9492267296230263,
                            0.95207917414863,
                            0.9607765846022719,
                            0.9665216737012422,
                            0.9850820532134703,
                            0.9880039518087411
                        ),
                        b0 = doubleArrayOf(2.917804238031064e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(5.835608476062128e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.917804238031064e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                2000.0,
                2244.9240966187463,
                1781.7974362806785,
                2000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.853524646230276,
                        -1.8662693215227235,
                        -1.8582666776011347,
                        -1.8908847111532185,
                        -1.881546589134322,
                        -1.9207843344407987
                    ),
                    a2 = doubleArrayOf(
                        0.9364604437606376,
                        0.9399729439539108,
                        0.9508720272624499,
                        0.9579687210223301,
                        0.9812642472067368,
                        0.9848941893771724
                    ),
                    b0 = doubleArrayOf(1.1377293181749668e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.2754586363499337e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.1377293181749668e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    2000.0,
                    2244.9240966187463,
                    1781.7974362806785,
                    2000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.853524646230276,
                            -1.8662693215227235,
                            -1.8582666776011347,
                            -1.8908847111532185,
                            -1.881546589134322,
                            -1.9207843344407987
                        ),
                        a2 = doubleArrayOf(
                            0.9364604437606376,
                            0.9399729439539108,
                            0.9508720272624499,
                            0.9579687210223301,
                            0.9812642472067368,
                            0.9848941893771724
                        ),
                        b0 = doubleArrayOf(1.1377293181749668e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.2754586363499337e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.1377293181749668e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                2519.8420997897465,
                2828.42712474619,
                2244.9240966187463,
                2500.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.7905716270112106,
                        -1.809232149768823,
                        -1.7931653070496998,
                        -1.8417048438803578,
                        -1.8193689745652162,
                        -1.8797292043052978
                    ),
                    a2 = doubleArrayOf(
                        0.9206234986422084,
                        0.9249080336194182,
                        0.9385743411553938,
                        0.9472640245029827,
                        0.9764983624230299,
                        0.9809745604874052
                    ),
                    b0 = doubleArrayOf(4.408111664350121e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(8.816223328700242e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.408111664350121e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    2519.8420997897465,
                    2828.42712474619,
                    2244.9240966187463,
                    2500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.7905716270112106,
                            -1.809232149768823,
                            -1.7931653070496998,
                            -1.8417048438803578,
                            -1.8193689745652162,
                            -1.8797292043052978
                        ),
                        a2 = doubleArrayOf(
                            0.9206234986422084,
                            0.9249080336194182,
                            0.9385743411553938,
                            0.9472640245029827,
                            0.9764983624230299,
                            0.9809745604874052
                        ),
                        b0 = doubleArrayOf(4.408111664350121e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(8.816223328700242e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(4.408111664350121e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                3174.8021039363994,
                3563.594872561358,
                2828.42712474619,
                3150.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.698018049211772,
                        -1.7253955989854663,
                        -1.6960230821791877,
                        -1.768329526959257,
                        -1.7238475768878447,
                        -1.8165175010628238
                    ),
                    a2 = doubleArrayOf(
                        0.9010581254789203,
                        0.9062094836371017,
                        0.9233783287144209,
                        0.9338745051748574,
                        0.9705731974939211,
                        0.9760270510168769
                    ),
                    b0 = doubleArrayOf(1.6944944571208185e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.388988914241637e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.6944944571208185e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    3174.8021039363994,
                    3563.594872561358,
                    2828.42712474619,
                    3150.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.698018049211772,
                            -1.7253955989854663,
                            -1.6960230821791877,
                            -1.768329526959257,
                            -1.7238475768878447,
                            -1.8165175010628238
                        ),
                        a2 = doubleArrayOf(
                            0.9010581254789203,
                            0.9062094836371017,
                            0.9233783287144209,
                            0.9338745051748574,
                            0.9705731974939211,
                            0.9760270510168769
                        ),
                        b0 = doubleArrayOf(1.6944944571208185e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(3.388988914241637e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.6944944571208185e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                4000.0,
                4489.8481932374925,
                3563.594872561357,
                4000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.5620018562313807,
                        -1.6020680617209626,
                        -1.5514295488390417,
                        -1.6587733605130148,
                        -1.5779211014645125,
                        -1.7193763872935146
                    ),
                    a2 = doubleArrayOf(
                        0.8770137966311882,
                        0.8830668098889431,
                        0.9047265072461494,
                        0.9171282371849951,
                        0.9632528802297299,
                        0.9697655086311445
                    ),
                    b0 = doubleArrayOf(6.450735040335462e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.2901470080670925e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(6.450735040335462e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    4000.0,
                    4489.8481932374925,
                    3563.594872561357,
                    4000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.5620018562313807,
                            -1.6020680617209626,
                            -1.5514295488390417,
                            -1.6587733605130148,
                            -1.5779211014645125,
                            -1.7193763872935146
                        ),
                        a2 = doubleArrayOf(
                            0.8770137966311882,
                            0.8830668098889431,
                            0.9047265072461494,
                            0.9171282371849951,
                            0.9632528802297299,
                            0.9697655086311445
                        ),
                        b0 = doubleArrayOf(6.450735040335462e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.2901470080670925e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(6.450735040335462e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                5039.684199579493,
                5656.85424949238,
                4489.8481932374925,
                5000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.3633369519581289,
                        -1.4214643083634073,
                        -1.3380146172088572,
                        -1.495861751008069,
                        -1.3574610576475574,
                        -1.570954880985224
                    ),
                    a2 = doubleArrayOf(
                        0.8476665728706247,
                        0.8545076730564747,
                        0.8820537169725038,
                        0.896161432848994,
                        0.954298805785257,
                        0.9618028595678236
                    ),
                    b0 = doubleArrayOf(2.426697477611551e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(4.853394955223102e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.426697477611551e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    5039.684199579493,
                    5656.85424949238,
                    4489.8481932374925,
                    5000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.3633369519581289,
                            -1.4214643083634073,
                            -1.3380146172088572,
                            -1.495861751008069,
                            -1.3574610576475574,
                            -1.570954880985224
                        ),
                        a2 = doubleArrayOf(
                            0.8476665728706247,
                            0.8545076730564747,
                            0.8820537169725038,
                            0.896161432848994,
                            0.954298805785257,
                            0.9618028595678236
                        ),
                        b0 = doubleArrayOf(2.426697477611551e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(4.853394955223102e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.426697477611551e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                6349.604207872798,
                7127.189745122714,
                5656.8542494923795,
                6300.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -1.0773395486328345,
                        -1.1602031096288796,
                        -1.0283985417327675,
                        -1.256274714648876,
                        -1.0309072558826313,
                        -1.3467894695867646
                    ),
                    a2 = doubleArrayOf(
                        0.8121705498843197,
                        0.8193547936396985,
                        0.8548947631581487,
                        0.869820439177322,
                        0.9435278418933211,
                        0.9515891151377003
                    ),
                    b0 = doubleArrayOf(8.998148499223296e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.7996296998446593e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(8.998148499223296e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    6349.604207872798,
                    7127.189745122714,
                    5656.8542494923795,
                    6300.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.0773395486328345,
                            -1.1602031096288796,
                            -1.0283985417327675,
                            -1.256274714648876,
                            -1.0309072558826313,
                            -1.3467894695867646
                        ),
                        a2 = doubleArrayOf(
                            0.8121705498843197,
                            0.8193547936396985,
                            0.8548947631581487,
                            0.869820439177322,
                            0.9435278418933211,
                            0.9515891151377003
                        ),
                        b0 = doubleArrayOf(8.998148499223296e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.7996296998446593e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(8.998148499223296e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                8000.0,
                8979.696386474985,
                7127.189745122714,
                8000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -0.6767266245218572,
                        -0.7912873195095531,
                        -0.5929092846277738,
                        -0.9115385133184579,
                        -0.563294468815372,
                        -1.0151634969766976
                    ),
                    a2 = doubleArrayOf(
                        0.7697779369631321,
                        0.7761347143350338,
                        0.8231381617779963,
                        0.8364515353139432,
                        0.9309588850819872,
                        0.9382780377204392
                    ),
                    b0 = doubleArrayOf(3.279097356293735e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(6.55819471258747e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(3.279097356293735e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    8000.0,
                    8979.696386474985,
                    7127.189745122714,
                    8000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -0.6767266245218572,
                            -0.7912873195095531,
                            -0.5929092846277738,
                            -0.9115385133184579,
                            -0.563294468815372,
                            -1.0151634969766976
                        ),
                        a2 = doubleArrayOf(
                            0.7697779369631321,
                            0.7761347143350338,
                            0.8231381617779963,
                            0.8364515353139432,
                            0.9309588850819872,
                            0.9382780377204392
                        ),
                        b0 = doubleArrayOf(3.279097356293735e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(6.55819471258747e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(3.279097356293735e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                10079.368399158986,
                11313.70849898476,
                8979.696386474985,
                10000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        -0.14222192561841182,
                        -0.29277856105906586,
                        -0.012595844464301289,
                        -0.4348904602476619,
                        0.06824248192606285,
                        -0.5419579256858204
                    ),
                    a2 = doubleArrayOf(
                        0.7201408449235422,
                        0.7228312366826449,
                        0.7876833682787011,
                        0.7933613741944567,
                        0.9172048817957851,
                        0.9203880227993824
                    ),
                    b0 = doubleArrayOf(1.170610624091675e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.34122124818335e-05, 2.0, -2.0, -2.0, 2.0, -2.0),
                    b2 = doubleArrayOf(1.170610624091675e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    10079.368399158986,
                    11313.70849898476,
                    8979.696386474985,
                    10000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -0.14222192561841182,
                            -0.29277856105906586,
                            -0.012595844464301289,
                            -0.4348904602476619,
                            0.06824248192606285,
                            -0.5419579256858204
                        ),
                        a2 = doubleArrayOf(
                            0.7201408449235422,
                            0.7228312366826449,
                            0.7876833682787011,
                            0.7933613741944567,
                            0.9172048817957851,
                            0.9203880227993824
                        ),
                        b0 = doubleArrayOf(1.170610624091675e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.34122124818335e-05, 2.0, -2.0, -2.0, 2.0, -2.0),
                        b2 = doubleArrayOf(1.170610624091675e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                12699.208415745596,
                14254.379490245428,
                11313.708498984759,
                12500.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        0.32848784493062516,
                        0.5111660791529813,
                        0.17733074339349109,
                        0.6895165716585276,
                        0.09114717463945445,
                        0.8350589885757965
                    ),
                    a2 = doubleArrayOf(
                        0.656000255318543,
                        0.6643131072250139,
                        0.7350225079427642,
                        0.7526237525351431,
                        0.8946980509545702,
                        0.9047450752107424
                    ),
                    b0 = doubleArrayOf(4.079796937465318e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(-8.159593874930636e-05, -2.0, -2.0, 2.0, 2.0, 2.0),
                    b2 = doubleArrayOf(4.079796937465318e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.32848784493062516,
                            0.5111660791529813,
                            0.17733074339349109,
                            0.6895165716585276,
                            0.09114717463945445,
                            0.8350589885757965
                        ),
                        a2 = doubleArrayOf(
                            0.656000255318543,
                            0.6643131072250139,
                            0.7350225079427642,
                            0.7526237525351431,
                            0.8946980509545702,
                            0.9047450752107424
                        ),
                        b0 = doubleArrayOf(4.079796937465318e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-8.159593874930636e-05, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(4.079796937465318e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                16000.0,
                17959.39277294997,
                14254.379490245428,
                16000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        0.982782646682872,
                        1.1871163009075574,
                        0.8498066536564547,
                        1.3967580458961404,
                        0.837324208994016,
                        1.5838701207898134
                    ),
                    a2 = doubleArrayOf(
                        0.5651700023975551,
                        0.6111614520796955,
                        0.6434040840366426,
                        0.7378609025916056,
                        0.8507018518753098,
                        0.9043557997025693
                    ),
                    b0 = doubleArrayOf(0.00013834805505964022, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(-0.00027669611011928044, -2.0, -2.0, 2.0, 2.0, 2.0),
                    b2 = doubleArrayOf(0.00013834805505964022, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.982782646682872,
                            1.1871163009075574,
                            0.8498066536564547,
                            1.3967580458961404,
                            0.837324208994016,
                            1.5838701207898134
                        ),
                        a2 = doubleArrayOf(
                            0.5651700023975551,
                            0.6111614520796955,
                            0.6434040840366426,
                            0.7378609025916056,
                            0.8507018518753098,
                            0.9043557997025693
                        ),
                        b0 = doubleArrayOf(0.00013834805505964022, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00027669611011928044, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(0.00013834805505964022, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            )
        ),
        antiAliasing = AntiAliasing(
            a1 = doubleArrayOf(
                -1.2446640940133593e-16,
                -1.630640067418199e-16,
                -1.387778780781446e-16,
                -2.4980018054066027e-16,
                -1.9428902930940244e-16,
                -1.6653345369377353e-16,
                -2.775557561562892e-16,
                -1.1102230246251565e-16,
                -2.220446049250313e-16,
                -2.2204460492503136e-16
            ),
            a2 = doubleArrayOf(
                0.001543712508674131,
                0.014008568735804144,
                0.03956612989658006,
                0.07954045177320418,
                0.13610158059098823,
                0.21252682194185937,
                0.31363013821503233,
                0.4464626921716894,
                0.6214743340943358,
                0.8544977810681018
            ),
            b0 = doubleArrayOf(8.555155699386506e-06, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0),
            b1 = doubleArrayOf(1.7110311398773013e-05, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0),
            b2 = doubleArrayOf(8.555155699386506e-06, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0),
            sampleRatio = 2
        ),
        aWeighting = DigitalFilterConfiguration(
            filterDenominator = doubleArrayOf(
                1.0,
                -4.01958210258393,
                6.18944019937876,
                -4.453264993081893,
                1.420898591796445,
                -0.14184390392723248,
                0.004352219710019002
            ),
            filterNumerator = doubleArrayOf(
                0.25574354103517516,
                -0.5114870820703503,
                -0.2557435410351751,
                1.0229741641407009,
                -0.25574354103517505,
                -0.5114870820703503,
                0.25574354103517516
            )
        ),
        cWeighting = DigitalFilterConfiguration(
            filterDenominator = doubleArrayOf(
                1.0,
                -2.134692386318322,
                1.279369764820266,
                -0.14957989013271009,
                0.004909935845510762
            ),
            filterNumerator = doubleArrayOf(
                0.21700689624574065,
                0.0,
                -0.4340137924914813,
                0.0,
                0.21700689624574065
            )
        ),
        configuration = GeneralConfiguration(sampleRate = 44100)
    )
}


fun get48000HZ(): SpectrumChannelConfiguration {
    return SpectrumChannelConfiguration(
        bandpass = listOf(
            Bandpass(
                49.60628287400625,
                55.681169883771226,
                44.19417382415923,
                50.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9984601797146522,
                        -1.998552690675498,
                        -1.998800724570471,
                        -1.9989885175100113,
                        -1.999514946443491,
                        -1.9996204400445106
                    ),
                    a2 = doubleArrayOf(
                        0.9985049317808966,
                        0.9985923599926457,
                        0.9988503801969798,
                        0.9990242833273026,
                        0.9995676495557392,
                        0.9996541604577023
                    ),
                    b0 = doubleArrayOf(1.8006511759597513e-19, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.6013023519195027e-19, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.8006511759597513e-19, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    793.7005259840998,
                    890.8987181403395,
                    707.1067811865476,
                    800.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.965026429970155,
                            -1.967668597254471,
                            -1.9691783807266252,
                            -1.9754146534405037,
                            -1.979674406907778,
                            -1.9858749551591182
                        ),
                        a2 = doubleArrayOf(
                            0.9763456895906536,
                            0.9777097806866464,
                            0.9817686375136939,
                            0.9844974374007367,
                            0.9931078103210836,
                            0.9944788918207288
                        ),
                        b0 = doubleArrayOf(2.893016243936537e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(5.786032487873074e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.893016243936537e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                62.5,
                70.15387801933582,
                55.681169883771204,
                63.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9980456727590987,
                        -1.9981638490205884,
                        -1.998472975728957,
                        -1.9987140616601067,
                        -1.9993716476778767,
                        -1.9995107633757623
                    ),
                    a2 = doubleArrayOf(
                        0.9981166982879324,
                        0.998226808502417,
                        0.9985517871612583,
                        0.9987708290608652,
                        0.9994553037380881,
                        0.9995642887013393
                    ),
                    b0 = doubleArrayOf(7.1971733989403265e-19, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.4394346797880653e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.1971733989403265e-19, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1000.0,
                    1122.4620483093731,
                    890.8987181403393,
                    1000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9523863069067073,
                            -1.956108973076721,
                            -1.9571616552873032,
                            -1.9661212030625006,
                            -1.9700353114553955,
                            -1.979405001055496
                        ),
                        a2 = doubleArrayOf(
                            0.9702899031224652,
                            0.9719947859444387,
                            0.977088153176812,
                            0.9805039267142269,
                            0.9913264267319474,
                            0.9930473480576114
                        ),
                        b0 = doubleArrayOf(1.1435038769653862e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.2870077539307723e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.1435038769653862e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                78.74506561842958,
                88.38834764831844,
                70.15387801933582,
                80.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9975150516721296,
                        -1.997666513582322,
                        -1.9980506301304577,
                        -1.9983614893563468,
                        -1.999180989630783,
                        -1.9993661073959705
                    ),
                    a2 = doubleArrayOf(
                        0.9976277697102935,
                        0.9977664322112939,
                        0.9981757114692286,
                        0.998451587351376,
                        0.9993137754070069,
                        0.9994510685212221
                    ),
                    b0 = doubleArrayOf(2.876135110287808e-18, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.752270220575616e-18, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.876135110287808e-18, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1259.9210498948732,
                    1414.213562373095,
                    1122.4620483093731,
                    1250.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9344269032418544,
                            -1.9397319953310073,
                            -1.9397192012263036,
                            -1.9527343232383667,
                            -1.955364536130128,
                            -1.969623329484771
                        ),
                        a2 = doubleArrayOf(
                            0.962713847798208,
                            0.9648387911194759,
                            0.9712264142580659,
                            0.9754919104957473,
                            0.9890888216359307,
                            0.9912451584685964
                        ),
                        b0 = doubleArrayOf(4.506127850247666e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(9.012255700495332e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(4.506127850247666e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                99.21256574801247,
                111.36233976754241,
                88.38834764831843,
                100.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9968332267646434,
                        -1.9970281309710414,
                        -1.9975035831956809,
                        -1.997906519235211,
                        -1.9989247264019108,
                        -1.9991735803604036
                    ),
                    a2 = doubleArrayOf(
                        0.9970120994122506,
                        0.9971866951423459,
                        0.9977020891971378,
                        0.9980495114976516,
                        0.9991354905208201,
                        0.9993084375601545
                    ),
                    b0 = doubleArrayOf(1.1490779436069693e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.2981558872139386e-17, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.1490779436069693e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    1587.4010519681995,
                    1781.7974362806785,
                    1414.2135623730949,
                    1600.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.9086271549871285,
                            -1.916265810798378,
                            -1.9141456550592422,
                            -1.9332356686147505,
                            -1.9329115625897635,
                            -1.954729191654851
                        ),
                        a2 = doubleArrayOf(
                            0.9532534031282983,
                            0.9558916290464894,
                            0.9638981867815446,
                            0.9692065253993708,
                            0.9862812992117321,
                            0.9889762139111492
                        ),
                        b0 = doubleArrayOf(1.7689636295331422e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(3.5379272590662843e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.7689636295331422e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                125.0,
                140.30775603867164,
                111.36233976754241,
                125.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9959531145933485,
                        -1.996205137556247,
                        -1.99679067441179,
                        -1.997316227634658,
                        -1.9985763869742814,
                        -1.9989147095139637
                    ),
                    a2 = doubleArrayOf(
                        0.9962369446432664,
                        0.9964567486353729,
                        0.9971056859894822,
                        0.9975431546301207,
                        0.9989109131331084,
                        0.9991287613275411
                    ),
                    b0 = doubleArrayOf(4.5893885449978465e-17, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.178777089995693e-17, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.5893885449978465e-17, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    2000.0,
                    2244.9240966187463,
                    1781.7974362806785,
                    2000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.871205384376715,
                            -1.8823000944590687,
                            -1.8763388947791837,
                            -1.904558436948833,
                            -1.8984178521059683,
                            -1.9319247221181628
                        ),
                        a2 = doubleArrayOf(
                            0.941467504228004,
                            0.944724780930314,
                            0.954757924553905,
                            0.9613309174454501,
                            0.9827643692222471,
                            0.9861189380456511
                        ),
                        b0 = doubleArrayOf(6.91156650726858e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.382313301453716e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(6.91156650726858e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                157.49013123685916,
                176.7766952966369,
                140.30775603867164,
                160.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9948108434480472,
                        -1.995138608941705,
                        -1.9958549254625118,
                        -1.99654543832831,
                        -1.9980970962795688,
                        -1.998562682476333
                    ),
                    a2 = doubleArrayOf(
                        0.9952611693790621,
                        0.9955378281154749,
                        0.9963547796390351,
                        0.9969055435967796,
                        0.9986280396391475,
                        0.9989024265317586
                    ),
                    b0 = doubleArrayOf(1.832273856726884e-16, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.664547713453768e-16, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.832273856726884e-16, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    2519.8420997897465,
                    2828.42712474619,
                    2244.9240966187463,
                    2500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.8165097119283033,
                            -1.8327278364989417,
                            -1.8201108586209922,
                            -1.8620520708389903,
                            -1.8453324823283772,
                            -1.8968763455852142
                        ),
                        a2 = doubleArrayOf(
                            0.9268280488124225,
                            0.9308168891662456,
                            0.9433931969114127,
                            0.9514711240169829,
                            0.9783691390918853,
                            0.9825187465670534
                        ),
                        b0 = doubleArrayOf(2.684574372673378e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(5.369148745346756e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.684574372673378e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                198.42513149602493,
                222.72467953508482,
                176.77669529663686,
                200.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9933187384467437,
                        -1.9937479129040492,
                        -1.9946164416668248,
                        -1.9955313782127055,
                        -1.9974291162822255,
                        -1.998078105503138
                    ),
                    a2 = doubleArrayOf(
                        0.9940331313329048,
                        0.9943812547620593,
                        0.9954095160792754,
                        0.996102770070116,
                        0.9982717642479774,
                        0.9986173297121667
                    ),
                    b0 = doubleArrayOf(7.31159711822096e-16, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.462319423644192e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.31159711822096e-16, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    3174.8021039363994,
                    3563.594872561358,
                    2828.42712474619,
                    3150.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.7361720647072763,
                            -1.7599595298520214,
                            -1.7362282609156778,
                            -1.7987101471164402,
                            -1.7636941439008764,
                            -1.8429155834449047
                        ),
                        a2 = doubleArrayOf(
                            0.9087125903565318,
                            0.9135375076733302,
                            0.9293227322337309,
                            0.9391361195874267,
                            0.9728955015176468,
                            0.97797732690065
                        ),
                        b0 = doubleArrayOf(1.0351518141960393e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.0703036283920787e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.0351518141960393e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                250.0,
                280.6155120773433,
                222.72467953508482,
                250.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9913549482178523,
                        -1.9919213473960666,
                        -1.992961734561673,
                        -1.9941856866943861,
                        -1.9964858191009422,
                        -1.9974024456375816
                    ),
                    a2 = doubleArrayOf(
                        0.9924880597760736,
                        0.9929259516314002,
                        0.9942198634821799,
                        0.9950922308001783,
                        0.997823084005514,
                        0.998258234393528
                    ),
                    b0 = doubleArrayOf(2.915850405403221e-15, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.831700810806442e-15, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.915850405403221e-15, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    4000.0,
                    4489.8481932374925,
                    3563.594872561357,
                    4000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.6180238146105717,
                            -1.6528894834371832,
                            -1.6111845676577818,
                            -1.7041154148090003,
                            -1.638653915827305,
                            -1.7599015767615853
                        ),
                        a2 = doubleArrayOf(
                            0.8864034769752915,
                            0.8921284562827796,
                            0.9120050759349341,
                            0.9237096620549838,
                            0.9661151955423802,
                            0.9722364024371097
                        ),
                        b0 = doubleArrayOf(3.955684226935954e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(7.911368453871908e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(3.955684226935954e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                314.9802624737183,
                353.5533905932738,
                280.6155120773433,
                315.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9887479618777701,
                        -1.9895021967303281,
                        -1.9907275393254193,
                        -1.992382364609799,
                        -1.99513606793578,
                        -1.996447847380435
                    ),
                    a2 = doubleArrayOf(
                        0.9905448150503697,
                        0.9910953670304777,
                        0.9927230754790283,
                        0.9938204340344118,
                        0.997258104736648,
                        0.9978059631311219
                    ),
                    b0 = doubleArrayOf(1.1619301238020158e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.3238602476040316e-14, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.1619301238020158e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    5039.684199579493,
                    5656.85424949238,
                    4489.8481932374925,
                    5000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.444929044061489,
                            -1.4957170043735097,
                            -1.4258973038465004,
                            -1.563146402998311,
                            -1.4488230224705272,
                            -1.6327258020473276
                        ),
                        a2 = doubleArrayOf(
                            0.8590998950465403,
                            0.8656805160974435,
                            0.8908697742725937,
                            0.9044065217137992,
                            0.95778643697265,
                            0.9649510549793255
                        ),
                        b0 = doubleArrayOf(1.4950003260908323e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(2.9900006521816645e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(1.4950003260908323e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                396.8502629920499,
                445.44935907016975,
                353.5533905932738,
                400.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.985253318813393,
                        -1.9862677916946907,
                        -1.9876761395004403,
                        -1.9899394676176885,
                        -1.993179826793365,
                        -1.9950812653258392
                    ),
                    a2 = doubleArrayOf(
                        0.9881019056669826,
                        0.9887936803667451,
                        0.9908405610202708,
                        0.9922202715949308,
                        0.9965468014759469,
                        0.9972363820904895
                    ),
                    b0 = doubleArrayOf(4.625615616925849e-14, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.251231233851698e-14, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.625615616925849e-14, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    6349.604207872798,
                    7127.189745122714,
                    5656.8542494923795,
                    6300.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -1.1941149006127025,
                            -1.2670743205284096,
                            -1.1550415228967335,
                            -1.3547778680343292,
                            -1.1652346750852467,
                            -1.4396698084572528
                        ),
                        a2 = doubleArrayOf(
                            0.8259548961648948,
                            0.8330985104737876,
                            0.8653960229572148,
                            0.8801955148623766,
                            0.9476951530180628,
                            0.9556413101528509
                        ),
                        b0 = doubleArrayOf(5.574640991696916e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.1149281983393831e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(5.574640991696916e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                500.0,
                561.2310241546866,
                445.44935907016963,
                500.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9805183605881083,
                        -1.9818978551492608,
                        -1.9834575729707877,
                        -1.9865911374749832,
                        -1.9903100156946432,
                        -1.9930996785658013
                    ),
                    a2 = doubleArrayOf(
                        0.9850326275872681,
                        0.985901148759386,
                        0.9884740475498774,
                        0.9902076356199037,
                        0.9956514788832681,
                        0.9965191245238226
                    ),
                    b0 = doubleArrayOf(1.8391819354137517e-13, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.6783638708275035e-13, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.8391819354137517e-13, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    8000.0,
                    8979.696386474985,
                    7127.189745122714,
                    8000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -0.8385656218768355,
                            -0.9407668149562102,
                            -0.7689289266746798,
                            -1.0520645541182183,
                            -0.7531924297464213,
                            -1.1514952746822522
                        ),
                        a2 = doubleArrayOf(
                            0.786163458984544,
                            0.7930340162566856,
                            0.8352970884716027,
                            0.8496435477623626,
                            0.935759288200993,
                            0.9435931378701163
                        ),
                        b0 = doubleArrayOf(2.0452147968403255e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(4.090429593680651e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(2.0452147968403255e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                629.9605249474366,
                707.1067811865476,
                561.2310241546866,
                630.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9740286599079484,
                        -1.9759264207270635,
                        -1.9775515830152486,
                        -1.981944694593259,
                        -1.9860528263876591,
                        -1.9901913146712302
                    ),
                    a2 = doubleArrayOf(
                        0.981179187823968,
                        0.9822684388078915,
                        0.9855009207967405,
                        0.9876772349651166,
                        0.9945248701796774,
                        0.9956159845310506
                    ),
                    b0 = doubleArrayOf(7.301444354678124e-13, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.4602888709356248e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.301444354678124e-13, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    10079.368399158986,
                    11313.70849898476,
                    8979.696386474985,
                    10000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            -0.35405154763185304,
                            -0.49128251707257314,
                            -0.24223050428288867,
                            -0.6261645675731202,
                            -0.18240420331818913,
                            -0.7338155809134382
                        ),
                        a2 = doubleArrayOf(
                            0.7391734396217206,
                            0.7437188888138072,
                            0.8009751006663193,
                            0.8105429251807174,
                            0.9222982330633457,
                            0.927623171295239
                        ),
                        b0 = doubleArrayOf(7.359484224824578e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(1.4718968449649156e-05, 2.0, 2.0, -2.0, -2.0, -2.0),
                        b2 = doubleArrayOf(7.359484224824578e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                793.7005259840998,
                890.8987181403395,
                707.1067811865476,
                800.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.965026429970155,
                        -1.967668597254471,
                        -1.9691783807266252,
                        -1.9754146534405037,
                        -1.979674406907778,
                        -1.9858749551591182
                    ),
                    a2 = doubleArrayOf(
                        0.9763456895906536,
                        0.9777097806866464,
                        0.9817686375136939,
                        0.9844974374007367,
                        0.9931078103210836,
                        0.9944788918207288
                    ),
                    b0 = doubleArrayOf(2.893016243936537e-12, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.786032487873074e-12, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.893016243936537e-12, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.08931454551996315,
                            0.26142519691480276,
                            -0.06094975521093459,
                            0.4225931350065996,
                            -0.15897989987756816,
                            0.5440792188366831
                        ),
                        a2 = doubleArrayOf(
                            0.6824341186617071,
                            0.6852999529629943,
                            0.7588006314601975,
                            0.7648681667234911,
                            0.9053884151557717,
                            0.9088313442453133
                        ),
                        b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                        b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1000.0,
                1122.4620483093731,
                890.8987181403393,
                1000.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9523863069067073,
                        -1.956108973076721,
                        -1.9571616552873032,
                        -1.9661212030625006,
                        -1.9700353114553955,
                        -1.979405001055496
                    ),
                    a2 = doubleArrayOf(
                        0.9702899031224652,
                        0.9719947859444387,
                        0.977088153176812,
                        0.9805039267142269,
                        0.9913264267319474,
                        0.9930473480576114
                    ),
                    b0 = doubleArrayOf(1.1435038769653862e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.2870077539307723e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.1435038769653862e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.7511127884288892,
                            0.9474349259843516,
                            0.6077435414237824,
                            1.1492032880591414,
                            0.5590818870997089,
                            1.3287692023317226
                        ),
                        a2 = doubleArrayOf(
                            0.6029568566338351,
                            0.6285948136865629,
                            0.6836472041890249,
                            0.7374497853902116,
                            0.8705313801288671,
                            0.9013601600372116
                        ),
                        b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1259.9210498948732,
                1414.213562373095,
                1122.4620483093731,
                1250.0,
                4,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9344269032418544,
                        -1.9397319953310073,
                        -1.9397192012263036,
                        -1.9527343232383667,
                        -1.955364536130128,
                        -1.969623329484771
                    ),
                    a2 = doubleArrayOf(
                        0.962713847798208,
                        0.9648387911194759,
                        0.9712264142580659,
                        0.9754919104957473,
                        0.9890888216359307,
                        0.9912451584685964
                    ),
                    b0 = doubleArrayOf(4.506127850247666e-11, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(9.012255700495332e-11, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(4.506127850247666e-11, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    20158.73679831797,
                    22627.416997969518,
                    17959.392772949966,
                    20000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            1.2413737222383092,
                            1.1545812920689111,
                            1.5913330473935272,
                            1.2692295742308106,
                            1.7813978059062259,
                            1.9088059626392415
                        ),
                        a2 = doubleArrayOf(
                            0.4389237157990629,
                            0.5162530772033582,
                            0.6535489122217201,
                            0.7880153266268755,
                            0.8189707787110215,
                            0.9408658628045891
                        ),
                        b0 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.0005903384891348293, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                1587.4010519681995,
                1781.7974362806785,
                1414.2135623730949,
                1600.0,
                3,
                Sos(
                    a1 = doubleArrayOf(
                        -1.9086271549871285,
                        -1.916265810798378,
                        -1.9141456550592422,
                        -1.9332356686147505,
                        -1.9329115625897635,
                        -1.954729191654851
                    ),
                    a2 = doubleArrayOf(
                        0.9532534031282983,
                        0.9558916290464894,
                        0.9638981867815446,
                        0.9692065253993708,
                        0.9862812992117321,
                        0.9889762139111492
                    ),
                    b0 = doubleArrayOf(1.7689636295331422e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(3.5379272590662843e-10, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.7689636295331422e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.08931454551996315,
                            0.26142519691480276,
                            -0.06094975521093459,
                            0.4225931350065996,
                            -0.15897989987756816,
                            0.5440792188366831
                        ),
                        a2 = doubleArrayOf(
                            0.6824341186617071,
                            0.6852999529629943,
                            0.7588006314601975,
                            0.7648681667234911,
                            0.9053884151557717,
                            0.9088313442453133
                        ),
                        b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                        b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                2000.0,
                2244.9240966187463,
                1781.7974362806785,
                2000.0,
                3,
                Sos(
                    a1 = doubleArrayOf(
                        -1.871205384376715,
                        -1.8823000944590687,
                        -1.8763388947791837,
                        -1.904558436948833,
                        -1.8984178521059683,
                        -1.9319247221181628
                    ),
                    a2 = doubleArrayOf(
                        0.941467504228004,
                        0.944724780930314,
                        0.954757924553905,
                        0.9613309174454501,
                        0.9827643692222471,
                        0.9861189380456511
                    ),
                    b0 = doubleArrayOf(6.91156650726858e-10, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.382313301453716e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(6.91156650726858e-10, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.7511127884288892,
                            0.9474349259843516,
                            0.6077435414237824,
                            1.1492032880591414,
                            0.5590818870997089,
                            1.3287692023317226
                        ),
                        a2 = doubleArrayOf(
                            0.6029568566338351,
                            0.6285948136865629,
                            0.6836472041890249,
                            0.7374497853902116,
                            0.8705313801288671,
                            0.9013601600372116
                        ),
                        b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                2519.8420997897465,
                2828.42712474619,
                2244.9240966187463,
                2500.0,
                3,
                Sos(
                    a1 = doubleArrayOf(
                        -1.8165097119283033,
                        -1.8327278364989417,
                        -1.8201108586209922,
                        -1.8620520708389903,
                        -1.8453324823283772,
                        -1.8968763455852142
                    ),
                    a2 = doubleArrayOf(
                        0.9268280488124225,
                        0.9308168891662456,
                        0.9433931969114127,
                        0.9514711240169829,
                        0.9783691390918853,
                        0.9825187465670534
                    ),
                    b0 = doubleArrayOf(2.684574372673378e-09, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(5.369148745346756e-09, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.684574372673378e-09, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    20158.73679831797,
                    22627.416997969518,
                    17959.392772949966,
                    20000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            1.2413737222383092,
                            1.1545812920689111,
                            1.5913330473935272,
                            1.2692295742308106,
                            1.7813978059062259,
                            1.9088059626392415
                        ),
                        a2 = doubleArrayOf(
                            0.4389237157990629,
                            0.5162530772033582,
                            0.6535489122217201,
                            0.7880153266268755,
                            0.8189707787110215,
                            0.9408658628045891
                        ),
                        b0 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.0005903384891348293, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                3174.8021039363994,
                3563.594872561358,
                2828.42712474619,
                3150.0,
                2,
                Sos(
                    a1 = doubleArrayOf(
                        -1.7361720647072763,
                        -1.7599595298520214,
                        -1.7362282609156778,
                        -1.7987101471164402,
                        -1.7636941439008764,
                        -1.8429155834449047
                    ),
                    a2 = doubleArrayOf(
                        0.9087125903565318,
                        0.9135375076733302,
                        0.9293227322337309,
                        0.9391361195874267,
                        0.9728955015176468,
                        0.97797732690065
                    ),
                    b0 = doubleArrayOf(1.0351518141960393e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.0703036283920787e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.0351518141960393e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.08931454551996315,
                            0.26142519691480276,
                            -0.06094975521093459,
                            0.4225931350065996,
                            -0.15897989987756816,
                            0.5440792188366831
                        ),
                        a2 = doubleArrayOf(
                            0.6824341186617071,
                            0.6852999529629943,
                            0.7588006314601975,
                            0.7648681667234911,
                            0.9053884151557717,
                            0.9088313442453133
                        ),
                        b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                        b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                4000.0,
                4489.8481932374925,
                3563.594872561357,
                4000.0,
                2,
                Sos(
                    a1 = doubleArrayOf(
                        -1.6180238146105717,
                        -1.6528894834371832,
                        -1.6111845676577818,
                        -1.7041154148090003,
                        -1.638653915827305,
                        -1.7599015767615853
                    ),
                    a2 = doubleArrayOf(
                        0.8864034769752915,
                        0.8921284562827796,
                        0.9120050759349341,
                        0.9237096620549838,
                        0.9661151955423802,
                        0.9722364024371097
                    ),
                    b0 = doubleArrayOf(3.955684226935954e-08, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(7.911368453871908e-08, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(3.955684226935954e-08, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.7511127884288892,
                            0.9474349259843516,
                            0.6077435414237824,
                            1.1492032880591414,
                            0.5590818870997089,
                            1.3287692023317226
                        ),
                        a2 = doubleArrayOf(
                            0.6029568566338351,
                            0.6285948136865629,
                            0.6836472041890249,
                            0.7374497853902116,
                            0.8705313801288671,
                            0.9013601600372116
                        ),
                        b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                5039.684199579493,
                5656.85424949238,
                4489.8481932374925,
                5000.0,
                2,
                Sos(
                    a1 = doubleArrayOf(
                        -1.444929044061489,
                        -1.4957170043735097,
                        -1.4258973038465004,
                        -1.563146402998311,
                        -1.4488230224705272,
                        -1.6327258020473276
                    ),
                    a2 = doubleArrayOf(
                        0.8590998950465403,
                        0.8656805160974435,
                        0.8908697742725937,
                        0.9044065217137992,
                        0.95778643697265,
                        0.9649510549793255
                    ),
                    b0 = doubleArrayOf(1.4950003260908323e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(2.9900006521816645e-07, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(1.4950003260908323e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    20158.73679831797,
                    22627.416997969518,
                    17959.392772949966,
                    20000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            1.2413737222383092,
                            1.1545812920689111,
                            1.5913330473935272,
                            1.2692295742308106,
                            1.7813978059062259,
                            1.9088059626392415
                        ),
                        a2 = doubleArrayOf(
                            0.4389237157990629,
                            0.5162530772033582,
                            0.6535489122217201,
                            0.7880153266268755,
                            0.8189707787110215,
                            0.9408658628045891
                        ),
                        b0 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.0005903384891348293, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                6349.604207872798,
                7127.189745122714,
                5656.8542494923795,
                6300.0,
                1,
                Sos(
                    a1 = doubleArrayOf(
                        -1.1941149006127025,
                        -1.2670743205284096,
                        -1.1550415228967335,
                        -1.3547778680343292,
                        -1.1652346750852467,
                        -1.4396698084572528
                    ),
                    a2 = doubleArrayOf(
                        0.8259548961648948,
                        0.8330985104737876,
                        0.8653960229572148,
                        0.8801955148623766,
                        0.9476951530180628,
                        0.9556413101528509
                    ),
                    b0 = doubleArrayOf(5.574640991696916e-07, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.1149281983393831e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(5.574640991696916e-07, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.08931454551996315,
                            0.26142519691480276,
                            -0.06094975521093459,
                            0.4225931350065996,
                            -0.15897989987756816,
                            0.5440792188366831
                        ),
                        a2 = doubleArrayOf(
                            0.6824341186617071,
                            0.6852999529629943,
                            0.7588006314601975,
                            0.7648681667234911,
                            0.9053884151557717,
                            0.9088313442453133
                        ),
                        b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                        b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                8000.0,
                8979.696386474985,
                7127.189745122714,
                8000.0,
                1,
                Sos(
                    a1 = doubleArrayOf(
                        -0.8385656218768355,
                        -0.9407668149562102,
                        -0.7689289266746798,
                        -1.0520645541182183,
                        -0.7531924297464213,
                        -1.1514952746822522
                    ),
                    a2 = doubleArrayOf(
                        0.786163458984544,
                        0.7930340162566856,
                        0.8352970884716027,
                        0.8496435477623626,
                        0.935759288200993,
                        0.9435931378701163
                    ),
                    b0 = doubleArrayOf(2.0452147968403255e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(4.090429593680651e-06, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(2.0452147968403255e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.7511127884288892,
                            0.9474349259843516,
                            0.6077435414237824,
                            1.1492032880591414,
                            0.5590818870997089,
                            1.3287692023317226
                        ),
                        a2 = doubleArrayOf(
                            0.6029568566338351,
                            0.6285948136865629,
                            0.6836472041890249,
                            0.7374497853902116,
                            0.8705313801288671,
                            0.9013601600372116
                        ),
                        b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                10079.368399158986,
                11313.70849898476,
                8979.696386474985,
                10000.0,
                1,
                Sos(
                    a1 = doubleArrayOf(
                        -0.35405154763185304,
                        -0.49128251707257314,
                        -0.24223050428288867,
                        -0.6261645675731202,
                        -0.18240420331818913,
                        -0.7338155809134382
                    ),
                    a2 = doubleArrayOf(
                        0.7391734396217206,
                        0.7437188888138072,
                        0.8009751006663193,
                        0.8105429251807174,
                        0.9222982330633457,
                        0.927623171295239
                    ),
                    b0 = doubleArrayOf(7.359484224824578e-06, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(1.4718968449649156e-05, 2.0, 2.0, -2.0, -2.0, -2.0),
                    b2 = doubleArrayOf(7.359484224824578e-06, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    20158.73679831797,
                    22627.416997969518,
                    17959.392772949966,
                    20000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            1.2413737222383092,
                            1.1545812920689111,
                            1.5913330473935272,
                            1.2692295742308106,
                            1.7813978059062259,
                            1.9088059626392415
                        ),
                        a2 = doubleArrayOf(
                            0.4389237157990629,
                            0.5162530772033582,
                            0.6535489122217201,
                            0.7880153266268755,
                            0.8189707787110215,
                            0.9408658628045891
                        ),
                        b0 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.0005903384891348293, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(0.0002951692445674146, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                12699.208415745596,
                14254.379490245428,
                11313.708498984759,
                12500.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        0.08931454551996315,
                        0.26142519691480276,
                        -0.06094975521093459,
                        0.4225931350065996,
                        -0.15897989987756816,
                        0.5440792188366831
                    ),
                    a2 = doubleArrayOf(
                        0.6824341186617071,
                        0.6852999529629943,
                        0.7588006314601975,
                        0.7648681667234911,
                        0.9053884151557717,
                        0.9088313442453133
                    ),
                    b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                    b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    12699.208415745596,
                    14254.379490245428,
                    11313.708498984759,
                    12500.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.08931454551996315,
                            0.26142519691480276,
                            -0.06094975521093459,
                            0.4225931350065996,
                            -0.15897989987756816,
                            0.5440792188366831
                        ),
                        a2 = doubleArrayOf(
                            0.6824341186617071,
                            0.6852999529629943,
                            0.7588006314601975,
                            0.7648681667234911,
                            0.9053884151557717,
                            0.9088313442453133
                        ),
                        b0 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-5.177306444963838e-05, 2.0, -2.0, 2.0, -2.0, 2.0),
                        b2 = doubleArrayOf(2.588653222481919e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            ),
            Bandpass(
                16000.0,
                17959.39277294997,
                14254.379490245428,
                16000.0,
                0,
                Sos(
                    a1 = doubleArrayOf(
                        0.7511127884288892,
                        0.9474349259843516,
                        0.6077435414237824,
                        1.1492032880591414,
                        0.5590818870997089,
                        1.3287692023317226
                    ),
                    a2 = doubleArrayOf(
                        0.6029568566338351,
                        0.6285948136865629,
                        0.6836472041890249,
                        0.7374497853902116,
                        0.8705313801288671,
                        0.9013601600372116
                    ),
                    b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                    b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                    b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                ),
                subsamplingFilter = SubsamplingFilter(
                    16000.0,
                    17959.39277294997,
                    14254.379490245428,
                    16000.0,
                    sos = Sos(
                        a1 = doubleArrayOf(
                            0.7511127884288892,
                            0.9474349259843516,
                            0.6077435414237824,
                            1.1492032880591414,
                            0.5590818870997089,
                            1.3287692023317226
                        ),
                        a2 = doubleArrayOf(
                            0.6029568566338351,
                            0.6285948136865629,
                            0.6836472041890249,
                            0.7374497853902116,
                            0.8705313801288671,
                            0.9013601600372116
                        ),
                        b0 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0),
                        b1 = doubleArrayOf(-0.00017740280306388184, -2.0, -2.0, 2.0, 2.0, 2.0),
                        b2 = doubleArrayOf(8.870140153194092e-05, 1.0, 1.0, 1.0, 1.0, 1.0)
                    )
                )
            )
        ),
        antiAliasing = AntiAliasing(
            a1 = doubleArrayOf(
                -1.2446640940133593e-16,
                -1.630640067418199e-16,
                -1.387778780781446e-16,
                -2.4980018054066027e-16,
                -1.9428902930940244e-16,
                -1.6653345369377353e-16,
                -2.775557561562892e-16,
                -1.1102230246251565e-16,
                -2.220446049250313e-16,
                -2.2204460492503136e-16
            ),
            a2 = doubleArrayOf(
                0.001543712508674131,
                0.014008568735804144,
                0.03956612989658006,
                0.07954045177320418,
                0.13610158059098823,
                0.21252682194185937,
                0.31363013821503233,
                0.4464626921716894,
                0.6214743340943358,
                0.8544977810681018
            ),
            b0 = doubleArrayOf(8.555155699386506e-06, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0),
            b1 = doubleArrayOf(1.7110311398773013e-05, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0),
            b2 = doubleArrayOf(8.555155699386506e-06, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0),
            sampleRatio = 2
        ),
        aWeighting = DigitalFilterConfiguration(
            filterDenominator = doubleArrayOf(
                1.0,
                -4.11305010732996,
                6.553157702958688,
                -4.990918046664834,
                1.7857953826173913,
                -0.24621080268676002,
                0.011225878476736176
            ),
            filterNumerator = doubleArrayOf(
                0.23430394285372055,
                -0.4686078857074411,
                -0.23430394285372066,
                0.937215771414882,
                -0.2343039428537206,
                -0.4686078857074411,
                0.23430394285372055
            )
        ),
        cWeighting = DigitalFilterConfiguration(
            filterDenominator = doubleArrayOf(
                1.0,
                -2.219190223295007,
                1.4551725795223749,
                -0.24851742382307854,
                0.012540782192183809
            ),
            filterNumerator = doubleArrayOf(
                0.1978854554445731,
                0.0,
                -0.3957709108891462,
                0.0,
                0.1978854554445731
            )
        ),
        configuration = GeneralConfiguration(sampleRate = 48000)
    )
}
