#!/usr/bin/env bash

PROTODIR=$1
JSDIR=$2

PROTOC_GEN_TS_PATH="./node_modules/.bin/protoc-gen-ts"
GRPC_TOOLS_NODE_PROTOC_PLUGIN="./node_modules/.bin/grpc_tools_node_protoc_plugin"
GRPC_TOOLS_NODE_PROTOC="./node_modules/.bin/grpc_tools_node_protoc"

mkdir -p ${JSDIR}

echo "Compiling proto files:"

for f in $PROTODIR/*; do

  echo $f
  # loop over all the available proto files and compile them into respective dir
  # JavaScript code generating
  ${GRPC_TOOLS_NODE_PROTOC} \
      --js_out=import_style=commonjs,binary:"${JSDIR}" \
      --grpc_out="${JSDIR}" \
      --plugin=protoc-gen-grpc="${GRPC_TOOLS_NODE_PROTOC_PLUGIN}" \
      -I "${PROTODIR}" \
      "${f}"

  ${GRPC_TOOLS_NODE_PROTOC} \
      --plugin=protoc-gen-ts="${PROTOC_GEN_TS_PATH}" \
      --ts_out="${JSDIR}" \
      -I "${PROTODIR}" \
      "${f}"

done
