# Fine-tune test generation

You have already configured some settings with the _UTBot: Quickstart_ wizard, and you may change them later. You
can also adjust additional settings for your testing purposes.

Go to **File** > **Preferences** > **Settings** and navigate to **Extensions** > **UnitTestBot**.

[[images/vscode/vscode-settings.PNG|UnitTestBot settings]]

Adjust the settings, if necessary:

| Setting                       | Default value | Comments                                                                                                                                                                   |
|-------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Deployment**                |         |                                                                                                                                                                            |
| UTBot Host                    | `127.0.0.1` | UnitTestBot server name or IP address.                                                                                                                                     |
| UTBot Port                    | `2121`  | The port used by the client to connect to a server via a gRPC channel.                                                                                                     |
| Remote Path                   |         | The relative path to your project on the server host.                                                                                                                      |
| **Paths**                     |         |                                                                                                                                                                            |
| Build Directory               | `build` | Contains `compile_commands.json` and `link_commands.json`.                                                                                                                 |
| CMake options                 | `-DCMAKE_EXPORT_COMPILE_COMMANDS=ON`<br>`-DCMAKE_EXPORT_LINK_COMMANDS=ON` | Options passed to CMake command to automatically build your project.                                                                                                       |
| Initial Teardown Functions    |        | Relative paths to json, that contains list of initial and teardown functions. [Format example](https://github.com/UnitTestBot/UTBotCpp/blob/main/integration-tests/c-example/itf.json)                                                                                                       |
| Source Directories            |        | Relative paths to the projects you would like to generate tests for.                                                                                                       |
| Test Directory                | `tests`| Relative path to a directory to store your test code.                                                                                                                      |
| **Test Generation**           |   |                                                                                                                                                                            |
| Generate for Static Functions | `True`      | Set to `True` to generate tests for the C static functions.                                                                                                                |
| Verbose formatting            | `False`     | Set to `True` to generate structured tests with more detail.                                                                                                               |
| Error Mode                    | `Failing`   | _Failing_ error tests fail then run.<br>_Passing_ error tests pass the checks.                                                                                             |
| Different Variables Of The Same Type | `False`   | set to `True` if you want different value for same type of parameters.                                                                                             |
| Skip object without source    | `False`     | set to `True` if you want skip precompiled object files.                                                                                             |
| **Stubs**                     |     |                                                                                                                                                                            |
| Use Stubs                     | `False`     | Set to `True` to use autogenerated stubs.                                                                                                                                  |
| **Visual**                    |     |                                                                                                                                                                            |
| Show Test Results             | `True`      | Set to `True` to display the results of test runs on the left side of the test headers.<br>Set to `False` if you use a separate test run extension for Visual Studio Code. |
| **Advanced**                  |    |                                                                                                                                                                            |
| Enable Developer Mode         | `False`       | Enable hidden developer commands useful for debug.                                                                                                                         |
| Use Deterministic Searcher    | `False`       | Use deterministic searcher to traverse bitcode in the same way every time.<br>It may significantly slow down test generation.                                              |
| Timeout Per Function (s)      | `30`          | Set timeout to generate tests for a given function.<br>Set to `0` to disable it.                                                                                           |
| Timeout Per Test (s)          | `0`        | To prevent hanging tests, set timeout to run a single test. As soon as timeout exceeds,<br>the test is automatically cancelled. Set to `0` to disable it.                  |
