# Fine-tune test generation

You have already configured some settings with the _UTBot: Quickstart_ wizard, and you may change them later. You
can also adjust additional settings for your testing purposes.

Go to **Settings** > **Tools** > **UTBot Settings**.

[[images/clion/clion-settings-initial.PNG|UnitTestBot settings]]

Adjust the settings, if necessary:

| Setting                            | Default value                                                             | Comments                                                                                                                                                  |
|------------------------------------|---------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Connection Settings**            |                                                                           |                                                                                                                                                           |
| Server port:                       | `5521`                                                                    | The port used by the client to connect to a server via a gRPC channel.                                                                                    |
| Server host name:                  | `127.0.0.1`                                                               | UnitTestBot server name or IP address.                                                                                                                    |
| Path to project on remote machine: | `/home/utbot/remote/c-example`                                            | The relative path to your project on the server host.                                                                                                     |
| **Paths**                          |                                                                           |                                                                                                                                                           |
| Build directory:                   | `build`                                                                   | Contains `compile_commands.json` and `link_commands.json`.                                                                                                |
| Test directory:                    | `tests`                                                                   |                                                                                                                                                           |
| Source paths:                      |                                                                           | Paths to the projects you would like to generate tests for.                                                                                               |
| **CMake**                          |                                                                           |                                                                                                                                                           |
| CMake options:                     | `-DCMAKE_EXPORT_COMPILE_COMMANDS=ON`<br>`-DCMAKE_EXPORT_LINK_COMMANDS=ON` | Options passed to CMake command to automatically build your project.                                                                                      |
| **Generator Settings**             |                                                                           |                                                                                                                                                           |
| Use stubs                          |                                                                           | Select to use autogenerated stubs.                                                                                                                        |
| Use verbose mode                   |                                                                           | Select to generate structured tests with more detail.                                                                                                     |
| Use deterministic searcher         |                                                                           | Use deterministic searcher to traverse bitcode in the same way every time.<br>It may significantly slow down test generation.                             |
| Generate for static functions      |                                                                           | Select to generate tests for the C static functions.                                                                                                      |
| Timeout per function: (s)          | `30`                                                                      | Set timeout to generate tests for a given function.<br>Set to `0` to disable it.                                                                          |
| Timeout per test: (s)              |                                                                           | To prevent hanging tests, set timeout to run a single test. As soon as timeout exceeds,<br>the test is automatically cancelled. Set to `0` to disable it. |
