# User guide

## [System requirements](system-requirements)

## [UnitTestBot server](install-server)

* [**Linux**](linux)
   * [Local installation](install-server-on-ubuntu)
   * [Remote installation via Docker](linux-remote)
* [**Windows**](windows)
   * [Local installation via WSL](windows-local)
   * [Remote installation via Docker](windows-remote)
* [**macOS**](macos)

## [UnitTestBot client](install_client)

### [Visual Studio Code plugin](vscode-overall)

* [Install and configure the plugin](vscode-install-and-configure)
* [Generate tests with default configuration](vscode-generate-tests)
* [Fine-tune test generation](vscode-fine-tune)
* [Get use of test results](vscode-get-use-of-results)

### [CLion plugin](clion-overall)

* [Install and configure the plugin](clion-install-and-configure)
* [Generate tests with default configuration](clion-generate-tests)
* [Fine-tune test generation](clion-fine-tune)
* [Get use of test results](clion-get-use-of-results)

## [GitHub Action](GitHub-action)

## Supported syntax

* [C](c-syntax)
* [C++](cpp-syntax)

# Contributor guides

## Developer guides

* [To do](todo)
* [Create a release](create-release)
* [Testing release in Docker](testing-release-utbotcpp-in-docker)
* [Label usage guideline](Labels-usage-guidelines)
* [Troubleshooting](troubleshooting)

## Advanced

* [How UTBot Works](utbot-inside)
* [How types are fetched and stored](types-fetching)
* [Makefiles](makefiles)
* [Symbolic Stdin](symbolic-stdin)
* [UTBot Logging Principles](utbot-logging)
* [Targets](targets)
* [Compile database](compile-database)
* [Coverage](coverage)
* [Generating and running test](generating-and-running-tests)
* [Incrementality](incrementality)
* [Linking bitcode](linking-bitcode)
* [Preparing source for klee](preparing-sources-for-klee)
* [Stubs inside](stubs-inside)
* [KLEE patches](klee-patches)
* [Lazy initialization](LI)
* [Symcretes](Symcretes)
* [Objects of symbolic size](Symsizes)
