# Use cases

This section contains walkthroughs and techniques for common end-to-end use tasks.

We hope to guide users through some official best practices to get up to speed and learn pne at a lower cost. Before doing so, please make sure you have read [quick start](/get_started/quick_start.md#quick-start) and [awesome chat](/use_cases/chat_usage.md)

If you're looking to build something specific or are more of a hands-on learner, try one out! While they reference building blocks that are explained in greater detail in other sections, we absolutely encourage folks to get started by going through them and picking apart the code in a real-world context.

- [Build streamlit chatbot by pne](/use_cases/streamlit-chatbot#build-a-simple-chatbot-using-streamlit-and-pne)
- [Build gradio chatbot by pne](/use_cases/gradio-chatbot#build-gradio-chatbot-by-pne)
- [Build math application with agent](/use_cases/build-math-application-with-agent.md#building-a-math-application-with-promptulate-agents)
- [Groq, llama3, Streamlit to build a application](/use_cases/streamlit-groq-llama3.md#groq-llama3-streamlit-to-build-a-application)
- [Build knowledge map with streamlit and pne](/use_cases/llmapper.md#llmapper)
- [Build a chatbot using pne+streamlit to chat with GitHub repo](/use_cases/chat-to-github-repo.md#build-a-chatbot-using-pne-streamlit-to-chat-with-GitHub-repo)


- [Build a math application with agent [Steamlit, ToolAgent, Hooks].](/use_cases/build-math-application-with-agent.md)
- [A Mulitmodal Robot Agent framework of ROS2 and Promptulate [Agent]](https://github.com/Undertone0809/Athena)
- [Use streamlit and pne to compare different model a playground. [Streamlit]](https://github.com/Undertone0809/pne-playground-model-comparison)
- [gcop:Your git AI copilot, based on promptulate](https://github.com/Undertone0809/gcop)