package io.udash.web.guide.demos.frontend

import io.udash.web.SeleniumTest
import org.openqa.selenium.By.ById

class FrontendIntroTest extends SeleniumTest {
  override protected final val url = "/frontend"

  "FrontendIntro view" should {
    "give response on init values" in {
      val demo = findElementById("frontend-intro-demo")
      val valid = demo.findElement(new ById("valid"))

      eventually {
        valid.getText should be("Yes")
      }
    }

    "report invalid values" in {
      val demo = findElementById("frontend-intro-demo")
      val minimum = demo.findElement(new ById("minimum"))
      val between = demo.findElement(new ById("between"))
      val maximum = demo.findElement(new ById("maximum"))
      def valid = demo.findElement(new ById("valid"))

      def setValues(a: Int, b: Int, c: Int) = {
        minimum.clear()
        between.clear()
        maximum.clear()
        minimum.sendKeys(a.toString)
        between.sendKeys(b.toString)
        maximum.sendKeys(c.toString)
      }

      setValues(15, -15, 15)
      eventually {
        valid.getText.startsWith("No") should be(true)
      }

      setValues(15, 15, 15)
      eventually {
        valid.getText should be("Yes")
      }

      setValues(20, 15, 15)
      eventually {
        valid.getText.startsWith("No") should be(true)
      }

      setValues(-15, 15, 15)
      eventually {
        valid.getText should be("Yes")
      }

      setValues(8, 15, 7)
      eventually {
        valid.getText.startsWith("No") should be(true)
      }

      setValues(-15, 8, 15)
      eventually {
        valid.getText should be("Yes")
      }

      setValues(8, 15, 10)
      eventually {
        valid.getText.startsWith("No") should be(true)
      }

      setValues(-15, -15, 15)
      eventually {
        valid.getText should be("Yes")
      }
    }

    "randomize values on button click" in {
      val demo = findElementById("frontend-intro-demo")
      val randomizeButton = eventually { demo.findElement(new ById("randomize")) }
      val minimum = demo.findElement(new ById("minimum"))
      val between = demo.findElement(new ById("between"))
      val maximum = demo.findElement(new ById("maximum"))

      var lastMinimum = minimum.getDomProperty("value")
      var lastBetween = between.getDomProperty("value")
      var lastMaximum = maximum.getDomProperty("value")

      for (_ <- 1 to 5) {
        randomizeButton.click()
        eventually {
          (lastMinimum != minimum.getDomProperty("value") ||
            lastBetween != between.getDomProperty("value") ||
            lastMaximum != maximum.getDomProperty("value")) should be(true)
        }

        lastMinimum = minimum.getDomProperty("value")
        lastBetween = between.getDomProperty("value")
        lastMaximum = maximum.getDomProperty("value")
      }
    }
  }
}
