package io.udash.web.homepage

import io.udash._

class RoutingRegistryDef extends RoutingRegistry[RoutingState] {
  def matchUrl(url: Url): RoutingState =
    url2State.applyOrElse("/" + url.value.stripPrefix("/").stripSuffix("/"), (_: String) => ErrorState)

  def matchState(state: RoutingState): Url =
    Url(state2Url.apply(state))

  private val (url2State, state2Url) = bidirectional {
    case "/" => HelloState
    case "/demo" / "select" => SelectState
  }
}