# Udash [<img align="right" height="50px" src="https://avsystem.github.io/Anjay-doc/_images/avsystem_logo.png">](http://www.avsystem.com/)
![Build Status](https://github.com/UdashFramework/udash-core/workflows/CI/badge.svg?branch=master&event=push)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/io.udash/udash-core_2.13/badge.svg)](https://maven-badges.herokuapp.com/maven-central/io.udash/udash-core_2.12)
[![Join the chat at https://gitter.im/UdashFramework/udash-core](https://badges.gitter.im/UdashFramework/udash-core.svg)](https://gitter.im/UdashFramework/udash-core?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Scala Steward badge](https://img.shields.io/badge/Scala_Steward-helping-blue.svg?style=flat&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAQCAMAAAARSr4IAAAAVFBMVEUAAACHjojlOy5NWlrKzcYRKjGFjIbp293YycuLa3pYY2LSqql4f3pCUFTgSjNodYRmcXUsPD/NTTbjRS+2jomhgnzNc223cGvZS0HaSD0XLjbaSjElhIr+AAAAAXRSTlMAQObYZgAAAHlJREFUCNdNyosOwyAIhWHAQS1Vt7a77/3fcxxdmv0xwmckutAR1nkm4ggbyEcg/wWmlGLDAA3oL50xi6fk5ffZ3E2E3QfZDCcCN2YtbEWZt+Drc6u6rlqv7Uk0LdKqqr5rk2UCRXOk0vmQKGfc94nOJyQjouF9H/wCc9gECEYfONoAAAAASUVORK5CYII=)](https://scala-steward.org)

[Udash](http://udash.io/) is a Scala.js framework for building beautiful and maintainable web applications.

# Combined forces of Scala & JavaScript

### Type safe (HTML, CSS & JS)
In cooperation with ScalaTags and ScalaCSS libraries, Udash provides a type safe layer over HTML, CSS and JS 
with powerful data binding into DOM templates.

### Compiled to JS
Scala is compiled to highly efficient JavaScript with no need to maintain Javascript code. 
It is also easy to use it with good, old JavaScript libraries like Twitter Bootstrap or jQuery.

### Shared Scala code
Udash brings out of the box the RPC system with a shared data model and interfaces between frontend and backend, 
which boosts development and keeps the codebase consistent.

# Why Udash?

### Reactive Data Bindings
Automatically synchronise user interface with your data model.

### Type-safe RPC & REST
A client↔server communication based on typed interfaces. Bidirectional RPC via WebSockets out of the box.

### User Interface Components
Twitter Bootstrap components enriched with Udash features.

### Routing
Udash provides a frontend routing mechanism based on URL path or fragment, states and views.

### i18n
Translations served by the backend or compiled into JavaScript.

### Project generator 
Generate a customized application from a [Giter8 template](https://github.com/UdashFramework/udash.g8), compile and try it out in 5 minutes.

### Backend-independent
Udash provides a complete support for your web application and the communication with the server but does not influence your backend implementation.

### Open-source
The whole framework code is available on GitHub under Apache v2 license.

### IDE support
With any IDE supporting the Scala language. No extra plugin needed.
