<!--

Choose your template
Because Github only accommodates one issue template at a time, this file lays out templates for a few of the different kinds of issues we need to create.

NOTE: When you create a new issue, just take out the template you need from the code section and delete everything else you don't need.

-->
## <a name="task">Task template</a>
Task issues document a specific action we need to take to support a feature.
Their names usually start with a verb such as `design`, `build`, or `decide`.

*E.g. Design the grade step filter option. OR Build the grade step filter option.*

Since they are action-oriented, they are either in the backlog ready to be worked on or currently assigned to a sprint.
When they move into a sprint, they are assigned to a team member.
They often result in a PR and, if so, are closed by a reviewer who confirms implementation.   

## Template
### Story
Take the main story from the Epic issue and adapt it as needed.

### Currently
If possible, describe the current situation, with supporting illustrations as needed.

### Desired
Describe a potential improvement to the current situation based on our research, in as much detail as you have at the moment. You can change this as you go.

### Steps
- [ ] To-do item one
- [ ] To-do item two [...]

### Acceptance criteria
Acceptance criteria tie back to the Epic, but do not dictate the solution which the team will need to create. *E.g. Define user interface elements that should be used.* We will know that the story has been resolved when someone walking through a solution can accomplish the task laid out in the issue. List out what a reviewer should be able to do here.
* Acceptance criteria
* Acceptance criteria
* Acceptance criteria [...]

### Resources
Any assets or links that will be helpful for the people taking on this issue
* Resource
* Resource [...]

## <a name="feature">Epic template</a>
We create Epic tracking issues when we need to manage a growing number of tasks relating to an overarching activity we're trying to support, such as "Placing a bid."

## Template
### Story
As a [person performing an activity],
I need [some way to do it],
So that I can [reference to higher goal or need that the current activity supports]

### Acceptance criteria
Acceptance criteria tie back to the story, but do not dictate the solution which the team will need to create. *E.g. Define user interface elements that should be used.* We will know that the story has been resolved when someone walking through a solution can accomplish the main activity. List out what a reviewer should be able to do here.
* Acceptance criteria
* Acceptance criteria
* Acceptance criteria [...]

### Resources
Any assets or links that will be helpful for the people taking on this issue.
* Resource
* Resource [...]

## <a name="bug">Bug or small fix report template</a>

Before opening a new bug issue, please make sure it has not already been reported. In addition, please ask if the latest code has been deployed. It's possible that the bug you are seeing is fixed in the code, but hasn't been deployed yet.

Once you are sure the issue is valid, please fill out the details below. Label your new issue `Bug`.

## Template
### Steps to reproduce the issue (please be as specific as possible)
1. Step 1
1. Step 2 [...]

### Expected behavior
* Behavior 1
* Behavior 2 [...]

### Actual behavior

When submitting a bug report, it's helpful to include any details that may be necessary to reproduce the bug, including:

- A screenshot
- URLs, if applicable
- Web browser and version (Internet Explorer 9,
Chrome 52.0.2743.116 (64-bit), etc.)
- Date, specific time and time zone when issue was found.
Example: 4:24pm ET on September 8, 2016
- Operating system (Windows 7, Mac OS X Yosemite 10.10.5, etc.)
- Email address used (if relevant and not sensitive)
