<h2><a id="user-content----utilidades-de-desarrollo-de-aplicaciones" class="anchor" href="#---utilidades-de-desarrollo-de-aplicaciones" aria-hidden="true"><span class="octicon octicon-link"></span></a><a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro.png" style="max-width:100%;"></a>- Utilidades de Desarrollo de Aplicaciones</h2>

<p><a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" style="max-width:100%;"></a> es el conjunto de <a href="https://github.com/UDA-EJIE/uda-ejie.github.io/wiki/Componentes">utilidades, herramientas, librerías, plugins, guías, y recomendaciones funcionales y técnicas</a> que permiten acelerar el proceso de desarrollo de sistemas software con tecnología Java.<br>
<br>
El espíritu del proyecto, y por tanto su principal objetivo, es aumentar la productividad del desarrollador, sin coartar por ello su imaginación ni su libertad para crear software. <a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" style="max-width:100%;"></a> ayuda y colabora en las tareas repetitivas y de poco (o nulo) valor añadido, pero que sin embargo, son imprescindibles. Pero también persigue otros fines:<br>
<br></p>

<ul>
<li>Minimizar la curva de aprendizaje. No pretende ser un framework más, <a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" style="max-width:100%;"></a> adopta y explota los ya consolidados y de uso extendido y se aprovecha del conocimiento compartido por sus creadores y usuarios.</li>
<li>Proponer patrones de usabilidad web, que aprovechen las mejoras proporcionadas por las tecnologías <a href="https://es.wikipedia.org/wiki/Rich_Internet_Application" target="_blank">RIA</a> - <a href="https://es.wikipedia.org/wiki/AJAX" target="_blank">Ajax</a>. Se cubren los escenarios de uso más habituales para las aplicaciones web con dicha tecnología.</li>
<li>Generar  interfaces  de usuario. Crea <b>automáticamente</b> las <a href="https://github.com/UDA-EJIE/uda-ejie.github.io/wiki/Patrones#14._Mantenimiento_con_formulario">interfaces de mantenimiento de datos</a> (acciones <a href="https://es.wikipedia.org/wiki/CRUD" target="_blank">CRUD</a>), y otras de uso común (combos enlazados, fechas-horas, feedback, etc.)</li>
<li>Generar código. Crea el código imprescindible en toda aplicación con arquitectura en capas y bajo el paradigma <a href="https://es.wikipedia.org/wiki/Modelo%E2%80%93vista%E2%80%93controlador" target="_blank">MVC</a> (Modelo-Vista-Controlador).</li>
<li>Ser flexible y configurable. Permite adaptar el código generado por los asistentes a las necesidades de cada organización (libro de estilo, estándares de codificación, etc.)</li>
<li>Ser adaptable y ampliable. Su arquitectura modular y desacoplada permitirá ampliar y/o sustituir las tecnologías utilizadas en cada una de las capas de responsabilidad que la componen.</li>
<li>No imponer un modelo de uso único. En algún caso ya se proponen tecnologías alternativas para la misma capa de la arquitectura.</li>
<li>Crear aplicaciones accesibles. Hasta donde sea posible, se cumplen con las recomendaciones <a href="http://www.w3.org/TR/WCAG20/" target="_blank">WCAG2.0</a> y <a href="http://www.w3.org/TR/wai-aria/" target="_blank">WAI-ARIA</a></li>
<li>Integración con <a href="https://github.com/UDA-EJIE/uda-ejie.github.io/wiki/Hdiv">Hdiv</a> para mayor seguridad.</li>
</ul>


<h2>Una aplicación operativa y usable, en solo 5 minutos</h2>

<a href='http://www.youtube.com/watch?feature=player_embedded&v=5T7VHQeNyuk' target='_blank'><img src='http://img.youtube.com/vi/5T7VHQeNyuk/0.jpg' width='640' height=360 /></a><br>
<br>
<a href="https://github.com/UDA-EJIE/uda-ejie.github.io/wiki/Videos">Videos</a>

<h2>Novedades</h2>

[Ver la portada del proyecto](http://uda-ejie.github.io/)

<br>

<h2>Actualizaciones y mejoras</h2>

Si quieres estar al día de los cambios y actualizaciones que se generen en <img src='https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png' /> tienes varias posibilidades:
<ul>
<li>activar el <a href="https://guides.github.com/activities/socialize/#watch-a-project" target="_blank">seguimiento de proyecto</a></li>
<li>incluir un repositorio en tu <a href="https://guides.github.com/activities/socialize/#explore" target="_blank">lista de favoritos</a></li>
</li>

</ul>
<br>


La documentación y la información contenida en estas páginas se ofrecen bajo licencia
<a href="http://creativecommons.org/licenses/by-nc-sa/3.0/"><img src="https://camo.githubusercontent.com/cc898278e77203243a0b63be665d38fa75dcf04a/687474703a2f2f692e6372656174697665636f6d6d6f6e732e6f72672f6c2f62792d6e632d73612f332e302f38387833312e706e67" data-canonical-src="http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png" style="max-width:100%;"></a> <a href="http://creativecommons.org/licenses/by-nc-sa/3.0/"> </a>

El plugin <a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" style="max-width:100%;"></a>, las extensiones para Hibernate Tools, las plantillas de generación de código, las librerías de utilidades <a href="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" target="_blank"><img src="https://uda-ejie.github.io/images/imgwikis/uda-mini-micro2.png" style="max-width:100%;"></a> y los componentes RUP se ofrecen con arreglo a la
<a href="https://joinup.ec.europa.eu/community/eupl/og_page/european-union-public-licence-eupl-v11">European Union Public Licence (EUPL)</a>, exclusivamente en su versión 1.1.
