# 揣摩研习社论文阅读列表

> 本项目是揣摩研习社整理的论文阅读列表，我们关注自然语言处理、信息检索、多模态检索与理解等多个人工智能前沿领域。
>
> 我们每周会阅读分享最新的顶会文章。点击[揣摩工作](#揣摩工作)查看本社社员发表的顶会文章。

<div align=center>
    <img src="fig/logo_new.png" width = "30%" /><img src="fig/qrcode.jpg" width = "28.2%" />
</div>

# 快速导览
[【对话生成】](#对话生成) [【文本检索】](#文本检索) [【多模态检索】](#多模态检索) [【因果推断】](#因果推断) [【文本生成】](#文本生成) [【信息抽取】](#信息抽取) [【揣摩工作】](#揣摩工作) [【其他】](#其他)

## 对话生成
- (ACL 2021) BoB: BERT Over BERT for Training Persona-based Dialogue Models from Limited Personalized Data. [[Video]](https://www.bilibili.com/video/BV15S4y1k7a5/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483687&idx=1&sn=d989550e1c552ada2b9e56e75556c7c2&chksm=9bcf64abacb8edbde9d9d141de38c129c7a137c580bc985a1919907f949db9c4214182feb0e9&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) Dialogue Response Selection with Hierarchical Curriculum Learning. [[Video]](https://www.bilibili.com/video/BV1eP4y1c7DE/)[[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483736&idx=1&sn=1242203fcbae08d8681098571365a529&chksm=9bcf64d4acb8edc2ebce0bcace9f8b9562d9ce4f4f6fb09c14113a3ead9a3e142e84711d5f01&token=1540349124&lang=zh_CN#rd)

- (ACL 2020) Learning to Customize Model Structures for Few-shot Dialogue Generation Tasks [[Video]](https://www.bilibili.com/video/BV1dL4y1T7hQ/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484388&idx=1&sn=916682c908d93d4ce6f14816abbeabf4&chksm=9bcf6668acb8ef7e552c09c632e3075e2f39f172992bcba1c569c0669c8a83d353525f575032&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) Learning from Perturbations: Diverse and Informative Dialogue Generation with Inverse Adversarial Training [[Video]](https://www.bilibili.com/video/BV1HS4y1u7ip/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484420&idx=1&sn=96445e227d9091918da1a61cc3a6bf2c&chksm=9bcf6188acb8e89edd1eb103cfaf71865ffe63bd9a3e6e48a5c3f0697a235c1a5ab755236d7f&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) PLANET: Dynamic Content Planning in Autoregressive Transformers for Long-form Text Generation [[Video]](https://www.bilibili.com/video/BV1i94y1o74W) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484835&idx=1&sn=4ff6436e9ec2b5bbd3fd1d0ebf729ef1&chksm=9bcf602facb8e9396010a15fbab85aa42b20507301b84d8d2de7533bbbd095ace839a604271e&token=1540349124&lang=zh_CN#rd)

- (EMNLP 2020) Will I Sound Like Me? Improving Persona Consistency in Dialogues through Pragmatic Self-Consciousness [[Video]](https://www.bilibili.com/video/BV1pZ4y1m7ro/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485211&idx=1&sn=54953bdefbe30cacbd276871bfc49b08&chksm=9bcf6297acb8eb81ae9770e2a3a91c1d5f5ec3644d2a56b76c536e0afc5f7f40caa2a999aec8&token=904163038&lang=zh_CN#rd)

- (EMNLP 2020) Regularizing Dialogue Generation by Imitating Implicit Scenarios [[Video]](https://www.bilibili.com/video/BV1Q44y137xy/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485255&idx=1&sn=3418ef905919832b1a99becb0808d36d&chksm=9bcf62cbacb8ebdda6767e28df03cd5a7d7b9fafc22ed37763d1bb3415c3b41c9f11a5ce5213&token=904163038&lang=zh_CN#rd)

- (SIGIR 2021) Partner Matters! An Empirical Study on Fusing Personas for Personalized Response Selection in Retrieval-Based Chatbots [[Video]](https://www.bilibili.com/video/BV1kR4y1K7nU) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485589&idx=1&sn=51e0849ec4da47f3a65f5311de8ea94c&chksm=9bcf6d19acb8e40fa1c628d9fa03bdbd44160150e50b8149c0848698217084c4f0e4fecb5137&token=447217193&lang=zh_CN#rd)

- (ACL 2022) Beyond Goldfish Memory: Long-Term Open-Domain Conversation [[Video]](https://www.bilibili.com/video/BV1nF411L7zx) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485933&idx=1&sn=72a0e019152075ac6f392860b70c394c&chksm=9bcf6c61acb8e57791c3f33df202bbc47f9b06c72c0a5e0a5868a415233ce7ead369082dc4e2&token=1589472580&lang=zh_CN#rd)

- (ACL 2020) Generate, Delete and Rewrite: A Three-Stage Framework for Improving Persona Consistency of Dialogue Generation [[Video]](https://www.bilibili.com/video/BV1bU4y117mE) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485967&idx=1&sn=ff768b546ee0bf4544fdbff0401cfe47&chksm=9bcf6f83acb8e695e748a5ef00655df7c6fadc8b32b27f9bcd9bd423ce2503871d929090783d&token=1589472580&lang=zh_CN#rd)

- (ACL 2022) A Model-Agnostic Data Manipulation Method for Persona-based Dialogue Generation [[Video]](https://www.bilibili.com/video/BV1JB4y1s7Lw) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486444&idx=1&sn=53aab414a95a9aeaa4aebcc7ab592d43&chksm=9bcf6e60acb8e7765b680c0a1f344d21cd418c0b2881b3b55b7c2ff438b759e16f88a9702c81&token=384057229&lang=zh_CN#rd)

- (AAAI 2022) Call for Customized Conversation: Customized Conversation Grounding Persona and Knowledge  [[Video]](https://www.bilibili.com/video/BV1na411s7vj) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486447&idx=1&sn=d5de573bacd228fa2b47586cd007d3b0&chksm=9bcf6e63acb8e77592df5440958ef7a5fb3461a96d9e0f5f12021d0ae2cbf21f13b99cb8bda5&token=384057229&lang=zh_CN#rd)

## 文本检索

- (EMNLP 2021) Simple Entity-Centric Questions Challenge Dense Retrievers [[Video]](https://www.bilibili.com/video/BV1Q34y1r7Au/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483716&idx=1&sn=a75372366ba684bd1ab832e1e3af19be&chksm=9bcf64c8acb8eddeeec4687df591f1f0a69edc7e62d500f3833377f3049fef42cf6f4b62b12c&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) Evaluating Entity Disambiguation and the Role of Popularity in Retrieval-Based NLP [[Video]](https://www.bilibili.com/video/BV1iL411T7Ac/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483788&idx=1&sn=a7cbcca99542319d435c7b6e11353c78&chksm=9bcf6400acb8ed161cb78bda1641c4dbf2261eea091db11b75509f67380b092a5885a24ab452&token=1540349124&lang=zh_CN#rd)

- (SIGIR 2021) Optimizing Dense Retrieval Model Training with Hard Negatives [[Video]](https://www.bilibili.com/video/BV1Fm4y1d7jF/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483882&idx=1&sn=2fef11c6b7987361b599ec4939d8365e&chksm=9bcf6466acb8ed7082a1d3e78baa209b0d00e31f38de1ff518866094444e13e451a585ba0a5a&token=1540349124&lang=zh_CN#rd)

- (NeurIPS 2021) BEIR: A Heterogenous Benchmark for Zero-shot Evaluation of Information Retrieval Models [[Video]](https://www.bilibili.com/video/BV12S4y1677X/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483902&idx=1&sn=fdc3237840ce1fee46b386ee54a15336&chksm=9bcf6472acb8ed648bb20894187445f5093f6c50bc5e5907f65e07f91e7e00c3a6e99d9ded9e&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) Training Data is More Valuable than You Think: A Simple and Effective Method by Retrieving from Training Data [[Video]](https://www.bilibili.com/video/BV1jq4y1Y7Q3/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484583&idx=1&sn=77b366e0830fd324ffe1dee56f6ba581&chksm=9bcf612bacb8e83d195f7c7d47e83791b123deb4ac8457041c36ea475d94a90ac8451671ac3d&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) Challenges in Information-Seeking QA: Unanswerable Questions and Paragraph Retrieval [[Video]](https://www.bilibili.com/video/BV1KU4y1o7Qf/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484609&idx=1&sn=bf47b6ef86d823fda3b49d0fadd43afc&chksm=9bcf614dacb8e85b2d2311959035e7308369b15a830fced0aa5da1a45fd96b497cd3a6e229da&token=1540349124&lang=zh_CN#rd)

- (SIGIR 2021) Efficiently Teaching an Effective Dense Retriever with Balanced Topic Aware Sampling [[Video]](https://www.bilibili.com/video/BV1hi4y1k7yv/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484444&idx=1&sn=c321a6aa51c8bedd4602da7eace2e793&chksm=9bcf6190acb8e886d92ac0781538a1dc22a2287beb2c63d64425726b420abc1f06c9886472a7&token=1540349124&lang=zh_CN#rd)

- (ICLR 2021) Adversarial Retriever-Ranker for Dense Text Retrieval [[Video]](https://www.bilibili.com/video/BV1L94y1f7cM/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484490&idx=1&sn=ee9217c71fcd679b4ccbba0c9e7db237&chksm=9bcf61c6acb8e8d001169e403b9e146082414781ae3a6cc930aea3b87af20d94d565d78d43b3&token=1540349124&lang=zh_CN#rd)

- (EMNLP 2021) Condenser: a Pre-training Architecture for Dense Retrieval [[Video]](https://www.bilibili.com/video/BV1uT4y1a7ar) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485486&idx=1&sn=8e668b85a423fc15bab445cc1a39eb88&chksm=9bcf6da2acb8e4b4faf060ad6c97702dd763bbd68e182f98f9f0745e40662e2a29ef8cd7d616&token=447217193&lang=zh_CN#rd) 

- [SIGIR-Forum] Rethinking Search: Making Domain Experts out of Dilettantes [[Video]](https://www.bilibili.com/video/BV1444y1G7Sn) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485464&idx=1&sn=a99b04cd4d4b2b282ba80ef8e7e386b7&chksm=9bcf6d94acb8e48225fa04384bd5a904642c1f82f61725ca79c66eac50503dc9dbca0a3b37f0&token=447217193&lang=zh_CN#rd)

- (EMNLP 2021) Learning with Instance Bundles for Reading Comprehension [[Video]](https://www.bilibili.com/video/BV1vS4y1A7Fn) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485440&idx=1&sn=9dfd3b147dde7db55006aa92ef4e4c79&chksm=9bcf6d8cacb8e49a0833972f8a2bbfd5dfcc3581d9dee83c7a9bf151903c2513d04ae2a96899&token=447217193&lang=zh_CN#rd)

- (ACL 2022) Simulating Bandit Learning from User Feedback for Extractive Question Answering [[Video]](https://www.bilibili.com/video/BV1iA4y1Q7zH) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485404&idx=1&sn=bddf00f9c38094ba46cee6bd33127802&chksm=9bcf6250acb8eb46e083a7fbfb937ee8199acde84f288a87f99a7c61b2d0b887dece1a106a21&token=447217193&lang=zh_CN#rd)

- (ACL 2022) Hey AI, Can You Solve Complex Tasks by Talking to Agents? [[Video]](https://www.bilibili.com/video/BV1tt4y1s7cj) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486036&idx=1&sn=417b985c9165109a51666ad3780f366b&chksm=9bcf6fd8acb8e6ce425f122b6124eaf53b018f38635312108c8241eed0ddba13aa70c4eb832d&token=1589472580&lang=zh_CN#rd)

- (ACL 2022) Perceiving the World: Question-guided Reinforcement Learning for Text-based Games [[Video]](https://www.bilibili.com/video/BV13Y411u72Z) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486074&idx=1&sn=db6fdc25590151e161f5eb0d62f75c2e&chksm=9bcf6ff6acb8e6e063662a7876f96a473e9b97e6a91ab004fca02fc62d99c30a203d60cda97f&token=396426454&lang=zh_CN#rd)

- (ACL 2021) Answering Ambiguous Questions through Generative Evidence Fusion and Round-Trip Prediction [[Video]](https://www.bilibili.com/video/BV1V54y1o7d9) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486113&idx=1&sn=2a7328d0eeaa93e132a79455349e50b2&chksm=9bcf6f2dacb8e63b5ef32bde58f7b5cb19a3f745a35254fb489679ba775093dcd6a3c2b6ba77&token=396426454&lang=zh_CN#rd)

- (ACL 2022) Answering Open-Domain Multi-Answer Questions via a Recall-then-Verify Framework [[Video]](https://www.bilibili.com/video/BV1Fr4y1x7kL) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486114&idx=1&sn=6c68691e078677e01458e6c3b09994e3&chksm=9bcf6f2eacb8e63806f74ac2d484f81b9139a9a141b09a4bab27f18c1ddedff192143f4ce985&token=396426454&lang=zh_CN#rd)

- (ACL 2022) Multi-View Document Representation Learning for Open-Domain Dense Retrieval [[Video]](https://www.bilibili.com/video/BV11Z4y1i764) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486254&idx=1&sn=330edeca21bd2e5eb8a53a7d1f38f449&chksm=9bcf6ea2acb8e7b4d2240084f833c3a3139e4bb8a1c1af8457218ab18ef1ef7ed9dbce3df241&token=384057229&lang=zh_CN#rd)

- (Arxiv) Training Language Models with Memory Augmentation [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486295&idx=1&sn=7246ea1260ceef7a5bf1c4e149c533ed&chksm=9bcf6edbacb8e7cd4ba7e0ba3cb1e06c4a9a81e034c61c46a5eea49f9d871144be3ce16f1667&token=384057229&lang=zh_CN#rd)

- (SIGIR 2022) LoL: A Comparative Regularization Loss over Query Reformulation Losses for Pseudo-Relevance Feedback [[Video]](https://www.bilibili.com/video/BV15v4y137AJ) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486351&idx=1&sn=355715bda239736e33347604c895ba02&chksm=9bcf6e03acb8e7158d2ee3432394da7ab7f08d51cd511cb0c47073556e53ab529e9bd38398bc&token=384057229&lang=zh_CN#rd)

- (Arxiv) VIRT: Improving Representation-based Models for Text Matchingthrough Virtual Interaction [[Video]](https://www.bilibili.com/video/BV1GL4y1A7Cs) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486843&idx=1&sn=ac6d16d55989bbb2641ee181d3bb2fa4&chksm=9bcf68f7acb8e1e1b43e959ed407c6e3526643cfb8b0955252d37109569484f8155f31df30d2&token=384057229&lang=zh_CN#rd)

- (ACL 2022) Divide and Conquer: Text Semantic Matching with Disentangled Keywords and Intents [[Video]](https://www.bilibili.com/video/BV13S4y1H7Ru) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486874&idx=1&sn=c58e77f838eafb0f581f2e6c9928aece&chksm=9bcf6816acb8e100fdf80b17e99903b98c45f0bc8dcadca029332930d9f73183aecb0072f0ea&token=384057229&lang=zh_CN#rd)

- (ICLR 2022) P-ADAPTERS Robustly Extracting Factual Information from Language Models with Diverse Prompts [[Video]](https://www.bilibili.com/video/BV1hG4y1n74E) [[PPT]](https://mp.weixin.qq.com/s/yHwoO6PBbd5w716_P_lrlw)

- (ACL 2022) Zero-Shot Dense Retrieval with Momentum Adversarial Domain Invariant Representations [[Video]](https://www.bilibili.com/video/BV1EP411N7rD) [[PPT]](https://mp.weixin.qq.com/s/lDrjdsUt9G71lzWzhwQbpA)

## 多模态检索

- (SIGIR 2021) Dynamic Modality Interaction Modeling for Image-Text Retrieval [[Video]](https://www.bilibili.com/video/BV14Y41137aK/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484148&idx=1&sn=c6bf492a9571c3d30d595117518fa05a&chksm=9bcf6778acb8ee6ebbd87d2f4de46f31f16713d74317d9ef74766b97be18d3b73991f31578f9&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) VisualSparta: An Embarrassingly Simple Approach to Large-scale Text-to-Image Search with Weighted Bag-of-words [[Video]](https://www.bilibili.com/video/BV1e34y1872J/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484180&idx=1&sn=150d65874de6fd857bfabb65464d55fd&chksm=9bcf6698acb8ef8efea5068acfc392d7057f1273afa095ed645799c1065f2c00e5c62e24200b&token=1540349124&lang=zh_CN#rd)

- (CVPR 2022) Balanced Multimodal Learning via On-the-fly Gradient Modulation [[Video]](https://www.bilibili.com/video/BV17Y4y1h7FV) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485741&amp;idx=1&amp;sn=1abde1521e2d3c2a9b5905a8c0de1a93&amp;chksm=9bcf6ca1acb8e5b73f14fde0374b4aebf984907ea3f24b91d820802fa49d643a5dfe4200d6d7&token=385689359&lang=zh_CN#rd)

- (ACM MM 2021) CONQUER: Contextual Query-aware Ranking for Video Corpus Moment Retrieval [[Video]](https://www.bilibili.com/video/BV1vB4y117Fz) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485690&amp;idx=1&amp;sn=1dcafb93932d74624cfd2734a4806587&amp;chksm=9bcf6d76acb8e46030c53e699a021156df6b57c2a20275f2ce29ab180835dfd0401c492a45e6&token=385689359&lang=zh_CN#rd)

- (ICML 2022) Characterizing and overcoming the greedy nature of learning in multi-modal deep neural networks [[Video]](https://www.bilibili.com/video/BV1oT411V7f3) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486223&idx=1&sn=3a3677957a18a1f48e7d9a7b9077130d&chksm=9bcf6e83acb8e795808a2180d80076fb5839c6050b5bb97bbe2a17c594f9a3f114d48ebaf8c2&token=396426454&lang=zh_CN#rd)

- (ICCV 2021) Ask&Confirm: Active Detail Enriching for Cross-Modal Retrieval with Partial Query [[Video]](https://www.bilibili.com/video/BV1594y1R7jK) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486775&idx=1&sn=26c74d1d6d58ff76a7e3b52f47ce6e7f&chksm=9bcf68bbacb8e1adf05c3ef59d0979c4705e7acde330d49cd4040962bc98964eb07bac8ca923&token=384057229&lang=zh_CN#rd)

- (SIGIR 2022) Modality-Balanced Embedding for Video Retrieval  [[Video]](https://www.bilibili.com/video/BV1av4y1T7CK) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486815&idx=1&sn=758ffc94731cffadb43c26e5fbf263ac&chksm=9bcf68d3acb8e1c57a2b4a0797415068285d24c55d8d536c51707398860599dcd3f0b4bc0caf&token=384057229&lang=zh_CN#rd)

- (NeurIPS 2021) Align before Fuse: Vision and Language Representation Learning with Momentum Distillation [[Video]](https://www.bilibili.com/video/BV1je4y1q7pm/) [[PPT]](https://mp.weixin.qq.com/s/cwgbgdP8BHMPJVTKKW9JjQ)

- (NAACL 2022) MCSE: Multimodal Contrastive Learning of Sentence Embeddings [[Video]](https://www.bilibili.com/video/BV1dd4y1i7kk) [[PPT]](https://mp.weixin.qq.com/s/RzxZTmls0HtqykQaJdsmLQ)

## 因果推断

- (CVPR 2021) Counterfactual VQA: A Cause-Effect Look at Language Bias [[Video]](https://www.bilibili.com/video/BV17b4y1x7YV) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483849&idx=1&sn=5693f33b55faa8880a330040205e8c17&chksm=9bcf6445acb8ed5302cb34fc02622dd0c89bd9e115e787b08e48f6c19789462bb5da127817a4&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) Can Prompt Probe Pretrained Language Models? Understanding the Invisible Risks from a Causal View [[Video]](https://www.bilibili.com/video/BV1u44y1V766/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485097&idx=1&sn=8d7e8f26c19a9eb98a963429def61b83&chksm=9bcf6325acb8ea3362d3885e37fba670b2d5bf0acd5b0f9ea54d39f5c3482aa05c8dfc5c9e8a&token=1540349124&lang=zh_CN#rd)

## 文本生成

- (ICLR 2021) CoCon: A Self-Supervised Approach for Controlled Text Generation [[Video]](https://www.bilibili.com/video/BV1Yq4y147mg) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247483930&idx=1&sn=7440fd3e3b17eb07b0bd13e7457b2097&chksm=9bcf6796acb8ee8057d90489c3b8358d48d952006325bbe72c777fe5e2dfe87882ec572873a6&token=1540349124&lang=zh_CN#rd)

- (NAACL 2021) FUDGE: Controlled Text Generation With Future Discriminators [[Video]](https://www.bilibili.com/video/BV1mu411B7H4/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484091&idx=1&sn=384eb2dd94653370e007470a52e748ab&chksm=9bcf6737acb8ee2187e949aae35be1b29767d52f93094f7c7ae6a2d2849a5c0682d9432f9a54&token=1540349124&lang=zh_CN#rd)

- (NeurIPS 2021) Controlled Text Generation as Continuous Optimization with Multiple Constraints [[Video]](https://www.bilibili.com/video/BV1iq4y1i7uX/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484118&idx=1&sn=ed894c52c8d545935de9357d061ae04e&chksm=9bcf675aacb8ee4cfa02dd80df51a501b26ba33f471a7216c196b13cdd773c4e6e994d39a98c&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) A Well-Composed Text is Half Done! Composition Sampling for Diverse Conditional Generation [[Video]](https://www.bilibili.com/video/BV1ku411e7L6) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485141&idx=1&sn=6f67f08a84582f83a88962e087120040&chksm=9bcf6359acb8ea4f193d19a41ed442b4e57c9cc6b515183e419beb7862abef6b01b70b146b42&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) Mix and Match: Learning-free Controllable Text Generation using Energy Language Models [[Video]](https://www.bilibili.com/video/BV1ki4y1m7mN) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485641&amp;idx=1&amp;sn=8650e659516563b4bf35f70115fd1a06&amp;chksm=9bcf6d45acb8e45336256b55d25653dadd7927a15414d744617b91b3a5b0629a0eb07e5fcb61&token=385689359&lang=zh_CN#rd)

- (ACL 2022) Controllable Natural Language Generation with Contrastive Preﬁxes [[Video]](https://www.bilibili.com/video/BV1VF411u7jV) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485668&amp;idx=1&amp;sn=8ce11ac9a6c37f965aec57427a1e253c&amp;chksm=9bcf6d68acb8e47efcd2b201e3bbb9ee041dded02be4bb0ca8f721d3c72fb43e4f2aef27dbf0&token=385689359&lang=zh_CN#rd)

- (Arxiv) Tailor: A Prompt-Based Approach to Attribute-Based Controlled Text Generation [[Video]](https://www.bilibili.com/video/BV1BL4y1K7yW) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486162&idx=1&sn=02fe64470fd1ba6bf040b0dc93859162&chksm=9bcf6f5eacb8e6481a6a2622760dd4d5c5670f71bc47f96d6504941d11f24cc24f5add32f387&token=396426454&lang=zh_CN#rd)

- (AAAI 2022) Search and Learn: Improving Semantic Coverage for Data-to-Text Generation [[Video]](https://www.bilibili.com/video/BV1gg411X7cz) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486594&idx=1&sn=e60a8e74d28f2a1c34d9603eb848e86c&chksm=9bcf690eacb8e0184a1fe0f9a701a0fd402b6e2e95ce25d1ed084d66a049a73ac39f151acbdf&token=384057229&lang=zh_CN#rd)

- (NAACL 2022) Learning to Transfer Prompts for Text Generation  [[Video]](https://www.bilibili.com/video/BV1jL4y1w7iw)  [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486678&idx=1&sn=0f9e9f359d431cabc736d70ca55f40e3&chksm=9bcf695aacb8e04c934c1fd008b1bf85dd2ee107a361a39c9de0340a44388dc2466c5f316975&token=384057229&lang=zh_CN#rd)

- (Arxiv) Learning to Break the Loop: Analyzing and Mitigating Repetitions for Neural Text Generation [[Video]](https://www.bilibili.com/video/BV1LY4y1n73H) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486728&idx=1&sn=1630cecbdaf0f86cd40fbe35ef0ad603&chksm=9bcf6884acb8e192169ece2ccc39ad7cc8e23bfe3fb28677ec7d0fa6083788f8cba96eacb564&token=384057229&lang=zh_CN#rd)

- (NAACL 2022) Re2G: Retrieve, Rerank, Generate [[Video]](https://www.bilibili.com/video/BV1o24y197jy) [[PPT]](https://mp.weixin.qq.com/s/bes8x6L3jKt2-LDJA1x7VQ)

- (NeurIPS 2022) Decoupling Knowledge from Memorization: Retrieval-augmented Prompt Learning [[Video]](https://www.bilibili.com/video/BV148411W7NJ) [[PPT]](https://mp.weixin.qq.com/s/Jpv_FD-FObMiVaPQEC9FYw)

- (NeurIPS 2022) Learning to Drop Out: An Adversarial Approach to Training Sequence VAEs [[Video]](https://www.bilibili.com/video/BV1AG41177yt) [[PPT]](https://mp.weixin.qq.com/s/wwQ359gH1hy5P7IURQIeyA)

- (NeurIPS 2022) Diffusion-LM Improves Controllable Text Generation [[Video]](https://www.bilibili.com/video/BV1Ce4y1e7L2) [[PPT]](https://mp.weixin.qq.com/s/rgpwrILyNxAITc5hGXVsJQ)

## 信息抽取

- (ACL 2020) FLAT: Chinese NER Using Flat-LAttice Transformer [[Video]](https://www.bilibili.com/video/BV1rr4y1B7pt/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484357&idx=1&sn=057e14f4c2236f3b87472e317eb86353&chksm=9bcf6649acb8ef5ff8a826def3b41496ed9273dca9d83121687c899f43dcbe7a4216f5a2c925&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) De-biasing Distantly Supervised Named Entity Recognition via Causal Intervention [[Video]](https://www.bilibili.com/video/BV12a41147kT) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484793&idx=1&sn=9a8550d05d5bb737d9cf8951029a1778&chksm=9bcf60f5acb8e9e3534ca0d1db76f5061bc2680c8468e65764b061a2e41cce5021195bd9f717&token=1540349124&lang=zh_CN#rd)

- (CIKM 2020) Mining Infrequent High-Quality Phrases from Domain-Specific Corpora [[Video]](https://www.bilibili.com/video/BV1tA4y197VD) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485342&idx=1&sn=642750c6ef7eb57c7c7dc24000349d2b&chksm=9bcf6212acb8eb04602b465317294d659d2c5b3e4ea4c4d93d0388f3270f041500efc1adafb6&token=904163038&lang=zh_CN#rd)

- (KDD 2021) UCPhrase: Unsupervised Context-aware Quality Phrase Tagging [[Video]](https://www.bilibili.com/video/BV1v94y1d7VR) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485338&idx=1&sn=c3bf74984a64308409bec95bfb439deb&chksm=9bcf6216acb8eb00c646987fcedd269e9e9488456434265e24b20506a0469fc3ddfd2ef03f9c&token=904163038&lang=zh_CN#rd)

- (NAACL 2021) A Frustratingly Easy Approach for Entity and Relation Extraction [[Video]](https://www.bilibili.com/video/BV1M5411R7wB) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485993&idx=1&sn=5f4763359440c3f447ff2b401b9fb0df&chksm=9bcf6fa5acb8e6b3d85c32f706a18fd23b6a70506eedd37207f71c8fd1b83404c49db82fb9ff&token=1589472580&lang=zh_CN#rd)

- (ACL 2022) Packed Levitated Marker for Entity and Relation Extraction [[Video]](https://www.bilibili.com/video/BV1Q3411A7pf) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486017&idx=1&sn=19457188c6b46ec2865017357383b22a&chksm=9bcf6fcdacb8e6dbd36fbb18f3e98b27056891b9bafd7c3c0f967e80fe3b4110865a80a71f5c&token=1589472580&lang=zh_CN#rd)

- (ACL 2020) A Novel Cascade Binary Tagging Framework for Relational Triple Extraction [[Video]](https://www.bilibili.com/video/BV1jW4y1S7e3) [[PPT]](https://mp.weixin.qq.com/s/kLeReQPUDYVBSQ2IZr76Jg)

- (COLING 2020) TPLinker: Single-stage Joint Extraction of Entities and Relations Through Token Pair Linking [[Video]](https://www.bilibili.com/video/BV1cr4y1E74g) [[PPT]](https://mp.weixin.qq.com/s/EaWyIN538Zj0F-afSf_9Qw)

## 揣摩工作

- (CVPR 2021) Transformation Driven Visual Reasoning [[Video]](https://www.bilibili.com/video/BV1Xi4y1U7yk) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485377&idx=1&sn=93e9b73476a1841f0e3db853b0adde05&chksm=9bcf624dacb8eb5b164b259f2dd14a9cae1c49ba7213809624235cb2aadf6016c71b2c363c83&token=904163038&lang=zh_CN#rd)

- (EMNLP 2020) Beyond Language: Learning Commonsense from Images for Reasoning [[Video]](https://www.bilibili.com/video/BV1Qu411C7fc) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485176&idx=1&sn=8aa27e16e76224aafe80546a26d03af4&chksm=9bcf6374acb8ea62d179479c18032a6f53a27e2db583409292f30d6ea7de860d2a0109420f26&token=1540349124&lang=zh_CN#rd)

- (NeurIPS 2021) Uncertainty calibration for ensemble-based debiasing methods [[Video]](https://www.bilibili.com/video/BV1nq4y1i7w9) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484047&idx=1&sn=319a4fc222ae5d91852150f69636c239&chksm=9bcf6703acb8ee153b4510fd2926245291fc068c9e527bb93c94504fed63fa7086dc22855658&token=1540349124&lang=zh_CN#rd)

- (EMNLP 2021) Adaptive Information Seeking for Open-Domain Question Answering [[Video]](https://www.bilibili.com/video/BV15Z4y1z76F) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484650&idx=1&sn=0d879d65a0ee2889ef2af6b735031226&chksm=9bcf6166acb8e8709fc75eb48f90dd160a168307cb1fbbd9d13c8a35f430d1ddee0286f12483&token=1540349124&lang=zh_CN#rd)

- (AAAI 2021) Sketch and Customize: A Counterfactual Story Generator [[Video]](https://www.bilibili.com/video/BV1BS4y1u7Qi) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484213&idx=1&sn=be9fafaf799c659a1a2e7f8a000fb3f2&chksm=9bcf66b9acb8efafed3a49defc87fb7c834ab548708afdefccbae2245a36ac501909c2815224&token=1540349124&lang=zh_CN#rd)

- (EMNLP 2021) Transductive Learning for Unsupervised Text Style Transfer [[Video]](https://www.bilibili.com/video/BV1k3411n7Rv) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485018&idx=1&sn=98e2d8a0c70a7dde1abb10aef85379b3&chksm=9bcf63d6acb8eac011d77c5cc69e71580bc12ed130fbfa57c6ea1590a51026a669be0ce164a2&token=1540349124&lang=zh_CN#rd)

- (TASLP) Distribution  Distance Regularized Sequence Representation for Text Matching in  Asymmetrical Domains [[Video]](https://www.bilibili.com/video/BV1rY411P73E) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485520&amp;idx=1&amp;sn=c8ef0018ec2eb17bb00da933f54c10f7&amp;chksm=9bcf6ddcacb8e4ca80df70e2e7fc14607a552895b5dae9d9f422e201140123078cffb9176a0d&token=447217193&lang=zh_CN#rd)

- (WSDM 2021) Adversarial Immunization for Certifiable Robustness on Graphs [[Video]](https://www.bilibili.com/video/BV1n5411m7ZH) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&amp;mid=2247485552&amp;idx=1&amp;sn=ac2e7fa7d4f46f667dcd82e6e1fa27ee&amp;chksm=9bcf6dfcacb8e4eaee4e5c3517cf9321e55f50160fb0bf3ad1649cd78f3fc1a92cd24232dc53&token=447217193&lang=zh_CN#rd)


## 其他

- (Nature) Highly accurate protein structure prediction with AlphaFold [[Video]](https://www.bilibili.com/video/BV1sr4y1i7Yf/) [[PPT Part 1]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484265&idx=1&sn=cb7740cb6ba1b585b7b7c7d13f2a55cd&chksm=9bcf66e5acb8eff35b7ec6a9a0a8fab80d070ce1dcca16c3de30851e105448f301c00b543c12&token=1540349124&lang=zh_CN#rd) [[PPT Part2]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484309&idx=1&sn=6605469abceb7a3e76a2c0f6a794436f&chksm=9bcf6619acb8ef0f9719826b6ec9ee6941a4e77a010f48b4e05f29496c4eaa794fbb207ed517&token=1540349124&lang=zh_CN#rd)

- (DeepMind) Improving language models by retrieving from trillions of tokens [[Video]](https://www.bilibili.com/video/BV1si4y1Q7Ej) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484710&idx=1&sn=f9db25de7ac41aa9fedae8f81f3858b8&chksm=9bcf60aaacb8e9bc707243b3c7865e28845a205cbbde600095f4681ebb4470ddb35676d0becd&token=1540349124&lang=zh_CN#rd)

- (ICLR 2022) Towards a Unified View of Parameter-Efficient Transfer Learning. [[Video]](https://www.bilibili.com/video/BV1K5411D7iX) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247484987&idx=1&sn=c3d4748197ef84106684ae2fa4222398&chksm=9bcf63b7acb8eaa118a78ab7d6483077663fd04050e44f6f630f545e4aadecb279847c867af4&token=1540349124&lang=zh_CN#rd)

- (ACL 2021) Knowledgeable or Educated Guess? Revisiting Language Models as Knowledge Bases [[Video]](https://www.bilibili.com/video/BV1Mq4y1a7bY/) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485063&idx=1&sn=8ac169ec8158a23200ff018f6a97e142&chksm=9bcf630bacb8ea1d1762848aaf32fbf3c95a30ce0471f61d07fc753c9bc5dc9c57f65cfb2586&token=1540349124&lang=zh_CN#rd)

- (ACL 2022) Debiased Contrastive Learning of Unsupervised Sentence Representations  [[Video]](https://www.bilibili.com/video/BV1uZ4y187yn) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485859&idx=1&sn=16dc9c6f6957b01903743d9555ad1256&chksm=9bcf6c2facb8e539ca1a8ad29b00f0add08cfb4815967e209c3a1f879657ddce8f8c868a789b&token=1203210899&lang=zh_CN#rd)

- (ACL 2022) Virtual Augmentation Supported Contrastive Learning of Sentence Representations [[Video]](https://www.bilibili.com/video/BV12U4y1m7Q5) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485861&idx=1&sn=bbd9e5c28af290670469a7780ef2dd68&chksm=9bcf6c29acb8e53fc04719517d67234fbf657f61dc2b4bac125c9b970d98b8b8cf78a7c4573d&token=1203210899&lang=zh_CN#rd)

- (EMNLP 2021) SimCSE: Simple  Contrastive Learning of Sentence Embeddings [[Video]](https://www.bilibili.com/video/BV1sF411L7GG) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486116&idx=1&sn=f4d35f98edde8dfc163c47e3d3d8f50d&chksm=9bcf6f28acb8e63edd2aeab8451745cac14205e237a64ede5c1416ff96054ea51190a525e202&token=396426454&lang=zh_CN#rd)

- (EMNLP 2021) Do Transformer Modifications Transfer Across Implementations and Applications? [[Video Part 1]](https://www.bilibili.com/video/BV1RU4y127dk) [[Video Part 2]](https://www.bilibili.com/video/BV1WY4y1474E) [[PPT Part 1]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485791&idx=1&sn=e386bb9e2af444d68f852cb2cf332aa2&chksm=9bcf6cd3acb8e5c5f4c216830d4a66c11601f7624112ee052d49ed18cdf08fa6f044a937ff8a&token=1203210899&lang=zh_CN#rd) [[PPT Part 2]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247485813&idx=1&sn=a2471e560e33bcd4c455bb4663824de3&chksm=9bcf6cf9acb8e5ef56a17bcacdd3e8347029cb3449ea7cd433bea452a77cb570868b18071f00&token=1203210899&lang=zh_CN#rd)

- (ACL 2022) A Simple but Effective Pluggable Entity Lookup Table for Pre-trained Language Models [[Video]](https://www.bilibili.com/video/BV1LY4y137jF) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486497&idx=1&sn=6a64c7f49d3acb1c63710fe11ed3eedf&chksm=9bcf69adacb8e0bb3c4d0e333274e401f0e1d909246441f42341f593dc9bd0640f1cc752c354&token=384057229&lang=zh_CN#rd)

- (NeurIPS 2021) R-Drop: Regularized Dropout for Neural Networks [[Video]](https://www.bilibili.com/video/BV1Zf4y1Z73T) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486554&idx=1&sn=ebb39757bce35866fb759ac519e5ccc1&chksm=9bcf69d6acb8e0c0b84e9b9f2a106a8b0cd216a678c14f1daf12b0e1f8f4b10b19ff592c0917&token=384057229&lang=zh_CN#rd)

- (ICLR 2022) Language modeling via stochastic processes [[Video]](https://www.bilibili.com/video/BV1Fa411s7bY) [[PPT]](https://mp.weixin.qq.com/s?__biz=MzAxODk2OTgyNw==&mid=2247486637&idx=1&sn=36111995de0ba0c77c4db4a066c7f910&chksm=9bcf6921acb8e037b1c66ae07be65771b407994cce10d4fae2ca23f504bcdc412b8abfa598fb&token=384057229&lang=zh_CN#rd)

- (NeurIPS 2021) Adversarial GLUE: A Multi-Task Benchmark for Robustness Evaluation of Language Models [[Video]](https://www.bilibili.com/video/BV17e4y1i7Eo) [[PPT]](https://mp.weixin.qq.com/s/2tfRUpQMbLa_getep6IaOw)

- (Arxiv) Understanding Diffusion Models: A Unified Perspective [[Video Part1]](https://www.bilibili.com/video/BV1wP4y1S7cM) [[Video Part2]](https://www.bilibili.com/video/BV1184y1B7bq) [[Video Part3]](https://www.bilibili.com/video/BV1bP411A7y4) [[Video Part4]](https://www.bilibili.com/video/BV1iV4y1G7Ny) [[PPT Part1]](https://mp.weixin.qq.com/s/CLazUdl4telDoZZ0owvXoA) [[PPT Part2]](https://mp.weixin.qq.com/s/Bbx4tgK47CE93dB5l1vapw) [[PPT Part3]](https://mp.weixin.qq.com/s/8tFhjap9qVg80aVI_fGsaw) [[PPT Part4]](https://mp.weixin.qq.com/s/24dL9lWmJbdSyG6dBmdrzw) 

## 关于我们

更多内容，欢迎关注我们的微信公众号和[B站账号](https://space.bilibili.com/2128513093)。

同时也欢迎分享自己或他人的顶会文章。投稿请填写[揣摩研习社Paper Reading收集表](https://wj.qq.com/s2/9854958/e8ed)。
