# truelayer-signing

![GitHub Workflow Status (with branch)](https://img.shields.io/github/actions/workflow/status/TrueLayer/truelayer-signing/ruby.yml?branch=main)
![Gem](https://img.shields.io/gem/v/truelayer-signing)
![Gem](https://img.shields.io/gem/dt/truelayer-signing)

Ruby gem to produce and verify TrueLayer API requests signatures.

## Installation

You can install the gem manually using:

```shell
gem install truelayer-signing
```

Alternatively you can add it to your `Gemfile` to install it with Bundler:

```ruby
source "https://rubygems.org"

gem "truelayer-signing"
```

## Configuration

You will need to set a couple of environment variables in order to be able to use this library:

* `TRUELAYER_SIGNING_CERTIFICATE_ID` (defaults to `nil`)
* `TRUELAYER_SIGNING_PRIVATE_KEY` (defaults to `nil`)

The private key can be generated by following our [request-signing documentation] and the
certificate ID (a.k.a. KID) will be available to you once you have shared your public key through
the [Payments API settings] page of our developer console.

Those two environment variables will automatically be picked-up by our library, but you can also
choose to set them directly in your application code:

```ruby
require "truelayer-signing"

TrueLayerSigning.certificate_id = "your-certificate-id"
TrueLayerSigning.private_key = "your-private-key"
```

## Generating a signature

```ruby
# `Tl-Signature` header value to send with the request
tl_signature = TrueLayerSigning.sign_with_pem
  .set_method("POST")
  .set_path(path)
  .add_header("Idempotency-Key", idempotency_key)
  .set_body(body)
  .sign
```

See full example of [request signing].

## Verifying webhooks

The `verify_with_jwks` method may be used to verify webhook `Tl-Signature` header signatures.

```ruby
# The `jku` field is included in webhook signatures
jku = TrueLayerSigning.extract_jws_header(webhook_signature).jku

# You should check that the `jku` is a valid TrueLayer URL (not provided by this library)
ensure_jku_allowed(jku)

# Then fetch JSON Web Key Set from the public URL (not provided by this library)
jwks = fetch_jwks(jku)

# The raw JWKS value may be used directly to verify a signature
TrueLayerSigning.verify_with_jwks(jwks)
  .set_method(method)
  .set_path(path)
  .set_headers(headers)
  .set_body(body)
  .verify(tl_signature)
```

See full example of [signature verification].

## Testing

Run the test suite from this `truelayer-signing/ruby` folder:

```sh
$ rake test
```

[request-signing documentation]: https://docs.truelayer.com/docs/sign-your-requests-for-payments-v3#generate-a-signing-key-pair
[Payments API settings]: https://console.truelayer.com/payments/v3/settings
[request signing]: examples/sign-request
[signature verification]: examples/webhook-server
