/* eslint-ignore */
/* eslint-env browser */

/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2012, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/

ace.define("ace/mode/dbml_highlight_rules", ["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module) {
  "use strict";

  var oop = require("../lib/oop");
  var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

  var DBMLHighlightRules = function() {
    // regexp must not have capturing parentheses. Use (?:) instead.
    // regexps are ordered -> the first match is used

    this.$rules = {
      start: [{
        include: "#structures"
      }, {
        include: "#comments"
      }, {
        include: "#strings"
      }, {
        include: "#relationships"
      }, {
        token: "keyword.control.dbml",
        regex: /\bas\b/,
        caseInsensitive: true
      }, {
        token: "text",
        regex: /\{/,
        push: [{
          token: "text",
          regex: /\}/,
          next: "pop"
        }, {
          include: "#comments"
        }, {
          include: "#strings"
        }, {
          include: "#keywords"
        }, {
          include: "#structures"
        }, {
          token: "text",
          regex: /\[/,
          push: [{
            token: "text",
            regex: /\]/,
            next: "pop"
          }, {
            include: "#structures"
          }, {
            include: "#strings"
          }, {
            include: "#booleans"
          }, {
            include: "#relationships"
          }]
        }]
      }],
      "#booleans": [{
        token: "variable.parameter.dbml",
        regex: /\b(?:true|false)\b/
      }],
      "#btstrings": [{
        token: "string.quoted.single.dbml",
        regex: /[`]/,
        push: [{
          token: "string.quoted.single.dbml",
          regex: /[`]/,
          next: "pop"
        }, {
          include: "#escapes"
        }, {
          defaultToken: "string.quoted.single.dbml"
        }]
      }],
      "#comments": [{
        token: "comment.line.double-slash",
        regex: /\/\/.*$/
      }],
      "#dqstrings": [{
        token: "string.quoted.double.dbml",
        regex: /["]/,
        push: [{
          token: "string.quoted.double.dbml",
          regex: /["]/,
          next: "pop"
        }, {
          include: "#escapes"
        }, {
          defaultToken: "string.quoted.double.dbml"
        }]
      }],
      "#escapes": [{
        token: "constant.character.escape.dbml",
        regex: /\\./
      }],
      "#keywords": [{
        token: "keyword.dbml",
        regex: /\b(?:guid|uuid|as|by|bool|boolean|bit|blob|decimal|double|enum|float|long|longblob|longtext|medium|mediumblob|mediumint|mediumtext|time|timestamp|timestamptz|tinyblob|tinyint|tinytext|text|bigint|int|int1|int2|int3|int4|int8|integer|float|float4|float8|double|char|varbinary|varchar|varcharacter|precision|date|datetime|year|unsigned|signed|numeric|ucase|lcase|mid|len|round|rank|now|format|coalesce|ifnull|isnull|nvl)\b/
      }],
      "#mlstrings": [{
        token: "string.quoted.single.dbml",
        regex: /'''/,
        push: [{
          token: "string.quoted.single.dbml",
          regex: /'''/,
          next: "pop"
        }, {
          token: "constant.character.escape.dbml",
          regex: /\\'''/
        }, {
          include: "#escapes"
        }, {
          token: "constant.character.escape.dbml",
          regex: /\\/
        }, {
          defaultToken: "string.quoted.single.dbml"
        }]
      }],
      "#relationships": [{
        token: "support.type.dbml",
        regex: /[<>\\-]/,
        comment: "Relationship operators"
      }],
      "#sqstrings": [{
        token: "string.quoted.single.dbml",
        regex: /'/,
        push: [{
          token: "string.quoted.single.dbml",
          regex: /'/,
          next: "pop"
        }, {
          include: "#escapes"
        }, {
          defaultToken: "string.quoted.single.dbml"
        }]
      }],
      "#strings": [{
        include: "#mlstrings"
      }, {
        include: "#sqstrings"
      }, {
        include: "#dqstrings"
      }, {
        include: "#btstrings"
      }],
      "#structures": [{
        token: "storage.entity.class.name.type.dbml",
        regex: /\b(?:[pP]roject|[tT]able|[rR]ef|[eE]num|[iI]ndexes|[nN]ote|[tT]able[gG]roup)\b/,
        comment: "Main data structure tags"
      }]
    }

    this.normalizeRules();
  };

  DBMLHighlightRules.metaData = {
    "$schema": "https://raw.githubusercontent.com/martinring/tmlanguage/master/tmlanguage.json",
    name: "DBML",
    scopeName: "source.dbml"
  }


  oop.inherits(DBMLHighlightRules, TextHighlightRules);

  exports.DBMLHighlightRules = DBMLHighlightRules;
});

ace.define("ace/mode/matching_brace_outdent", ["require", "exports", "module", "ace/range"], function (require, exports, module) {
  "use strict";

  var Range = require("../range").Range;

  var MatchingBraceOutdent = function () {
  };

  (function () {

    this.checkOutdent = function (line, input) {
      if (!/^\s+$/.test(line))
        return false;

      return /^\s*\}/.test(input);
    };

    this.autoOutdent = function (doc, row) {
      var line = doc.getLine(row);
      var match = line.match(/^(\s*\})/);

      if (!match) return 0;

      var column = match[1].length;
      var openBracePos = doc.findMatchingBracket({ row: row, column: column });

      if (!openBracePos || openBracePos.row == row) return 0;

      var indent = this.$getIndent(doc.getLine(openBracePos.row));
      doc.replace(new Range(row, 0, row, column - 1), indent);
    };

    this.$getIndent = function (line) {
      return line.match(/^\s*/)[0];
    };

  }).call(MatchingBraceOutdent.prototype);

  exports.MatchingBraceOutdent = MatchingBraceOutdent;
});

ace.define("ace/mode/folding/cstyle", ["require", "exports", "module", "ace/lib/oop", "ace/range", "ace/mode/folding/fold_mode"], function (require, exports, module) {
  "use strict";

  var oop = require("../../lib/oop");
  var Range = require("../../range").Range;
  var BaseFoldMode = require("./fold_mode").FoldMode;

  var FoldMode = exports.FoldMode = function (commentRegex) {
    if (commentRegex) {
      this.foldingStartMarker = new RegExp(
        this.foldingStartMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.start)
      );
      this.foldingStopMarker = new RegExp(
        this.foldingStopMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.end)
      );
    }
  };
  oop.inherits(FoldMode, BaseFoldMode);

  (function () {

    this.foldingStartMarker = /([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;
    this.foldingStopMarker = /^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;
    this.singleLineBlockCommentRe = /^\s*(\/\*).*\*\/\s*$/;
    this.tripleStarBlockCommentRe = /^\s*(\/\*\*\*).*\*\/\s*$/;
    this.startRegionRe = /^\s*(\/\*|\/\/)#?region\b/;
    this._getFoldWidgetBase = this.getFoldWidget;
    this.getFoldWidget = function (session, foldStyle, row) {
      var line = session.getLine(row);

      if (this.singleLineBlockCommentRe.test(line)) {
        if (!this.startRegionRe.test(line) && !this.tripleStarBlockCommentRe.test(line))
          return "";
      }

      var fw = this._getFoldWidgetBase(session, foldStyle, row);

      if (!fw && this.startRegionRe.test(line))
        return "start"; // lineCommentRegionStart

      return fw;
    };

    this.getFoldWidgetRange = function (session, foldStyle, row, forceMultiline) {
      var line = session.getLine(row);

      if (this.startRegionRe.test(line))
        return this.getCommentRegionBlock(session, line, row);

      var match = line.match(this.foldingStartMarker);
      if (match) {
        var i = match.index;

        if (match[1])
          return this.openingBracketBlock(session, match[1], row, i);

        var range = session.getCommentFoldRange(row, i + match[0].length, 1);

        if (range && !range.isMultiLine()) {
          if (forceMultiline) {
            range = this.getSectionRange(session, row);
          } else if (foldStyle != "all")
            range = null;
        }

        return range;
      }

      if (foldStyle === "markbegin")
        return;

      var match = line.match(this.foldingStopMarker);
      if (match) {
        var i = match.index + match[0].length;

        if (match[1])
          return this.closingBracketBlock(session, match[1], row, i);

        return session.getCommentFoldRange(row, i, -1);
      }
    };

    this.getSectionRange = function (session, row) {
      var line = session.getLine(row);
      var startIndent = line.search(/\S/);
      var startRow = row;
      var startColumn = line.length;
      row = row + 1;
      var endRow = row;
      var maxRow = session.getLength();
      while (++row < maxRow) {
        line = session.getLine(row);
        var indent = line.search(/\S/);
        if (indent === -1)
          continue;
        if (startIndent > indent)
          break;
        var subRange = this.getFoldWidgetRange(session, "all", row);

        if (subRange) {
          if (subRange.start.row <= startRow) {
            break;
          } else if (subRange.isMultiLine()) {
            row = subRange.end.row;
          } else if (startIndent == indent) {
            break;
          }
        }
        endRow = row;
      }

      return new Range(startRow, startColumn, endRow, session.getLine(endRow).length);
    };
    this.getCommentRegionBlock = function (session, line, row) {
      var startColumn = line.search(/\s*$/);
      var maxRow = session.getLength();
      var startRow = row;

      var re = /^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;
      var depth = 1;
      while (++row < maxRow) {
        line = session.getLine(row);
        var m = re.exec(line);
        if (!m) continue;
        if (m[1]) depth--;
        else depth++;

        if (!depth) break;
      }

      var endRow = row;
      if (endRow > startRow) {
        return new Range(startRow, startColumn, endRow, line.length);
      }
    };

  }).call(FoldMode.prototype);

});

ace.define('ace/mode/dbml', ["require","exports","module","ace/lib/oop","ace/mode/text", "ace/mode/dbml_highlighting_rules", "ace/mode/matching_brace_outdent", "ace/range", "ace/mode/behaviour/cstyle", "ace/mode/folding/cstyle"], function(require, exports, module) {
  "use strict";


  var oop = require("../lib/oop");
  var TextMode = require("./text").Mode;
  var DBMLHighlightRules = require("./dbml_highlight_rules").DBMLHighlightRules;
  var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
  var Range = require("../range").Range;
  var CstyleBehaviour = require("./behaviour/cstyle").CstyleBehaviour;
  var CStyleFoldMode = require("./folding/cstyle").FoldMode;

  var Mode = function() {
    this.HighlightRules = DBMLHighlightRules;

    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CstyleBehaviour();

    this.foldingRules = new CStyleFoldMode();
  };
  oop.inherits(Mode, TextMode);

  (function() {
    this.lineCommentStart = "//";

    this.getNextLineIndent = function (state, line, tab) {
      var indent = this.$getIndent(line);

      var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
      var tokens = tokenizedLine.tokens;
      var endState = tokenizedLine.state;

      if (tokens.length && tokens[tokens.length - 1].type == "comment") {
        return indent;
      }

      if (state == "start") {
        var match = line.match(/^.*[\{\(\[]\s*$/);
        if (match) {
          indent += tab;
        }
      } else if (state == "doc-start") {
        if (endState == "start") {
          return "";
        }
        var match = line.match(/^\s*(\/?)\*/);
        if (match) {
          if (match[1]) {
            indent += " ";
          }
          indent += "* ";
        }
      }

      return indent;
    };

    this.checkOutdent = function (state, line, input) {
      return this.$outdent.checkOutdent(line, input);
    };

    this.autoOutdent = function (state, doc, row) {
      this.$outdent.autoOutdent(doc, row);
    };

    this.$id = "ace/mode/dbml"
  }).call(Mode.prototype);

  exports.Mode = Mode;
});
(function () {
  ace.require(["ace/mode/dbml"], function (m) {
    if (typeof module == "object" && typeof exports == "object" && module) {
      module.exports = m;
    }
  });
})();

