# 朱雀宋朝

![](preview.png)

「<ruby>朱雀<rp>(</rp><rt>すざく</rt><rp>)</rp>宋<rp>(</rp><rt>そう</rt><rp>)</rp>朝<rp>(</rp><rt>ちょう</rt><rp>)</rp></ruby>」は[<ruby>璇<rp>(</rp><rt>せん</rt><rp>)</rp>璣<rp>(</rp><rt>き</rt><rp>)</rp>造<rp>(</rp><rt>ぞう</rt><rp>)</rp>字<rp>(</rp><rt>じ</rt><rp>)</rp></ruby>](http://trionestype.com/)のオープンソースの宋朝体プロジェクトであり、高品質かつ多言語対応の本文書体を目指しています。**日本語版の開発は現在進行中です。**

唐・宋期の木版印刷から発祥し、出版文化の厚みと古典籍の雅趣とを富んだ中文基本書体である仿宋体（宋朝体）は、長期間にわたって、オープンソースのライセンスの下の選択肢が不足していました。私たちは、「朱雀宋朝」がこの空白を埋め、オープンソースソフトウェアや TeX コミュニティに貢献できることを願っています。

20 世紀初め、仿宋体の活字は中国で一世を風靡し、一時期は開発の全盛期を迎えました。日本も中国から様々な宋朝活字を導入し、古典や名刺などの場面での組版に応用しました。しかしその後、DTP 時代に入ってから、本場中国に残された仿宋書体の外観はほぼ皆「華豐真宋」系のままに収束し、スタイルはほんの一握りだけとなっています。「朱雀宋朝」は、民国時代の仿宋活字「南宋」をベースにして、現代タイポグラフィの需要に対応しながら、本文書体としての宋朝体に新しい風を吹き込むことを試みています。

現在公開されている「朱雀宋朝」はまだ「プレビュー版」であり、プロジェクトは初期段階にあるため、日本語の漢字はまだ完全には含まれていません。デザインスタイル、文字数、字形、レイアウトの品質などは、正式版の状態を反映しているわけではありません。したがって、

## 「朱雀」の未来は、あなたが定義する

何かご質問やご意見・提案、またはご協力の意向がございましたら、[Discord のサーバー](https://discord.gg/jqmc2eHWS5)に参加していただくことも歓迎いたします。 [Issues](https://github.com/TrionesType/zhuque/issues) からもお問い合わせいただけます。

璇璣は、新しい漢字フォントのデザインパターンを模索しています。最新技術の開発進展により、璇璣のデザイナーは人工知能をデザインツールとして使用できるようになりました。そのため、私たちはイテレーションの方法で「朱雀」を開発できるようになりました。

最新技術の開発によっても、壮絶な目標を持つ「朱雀」プロジェクトには、未だ想像のつかない課題が残されています。そのため、プロジェクトをより迅速かつ持続可能に推進するために、私たちはより多くのサポートを得ることを望んでいます。

## ダウンロード

バージョンとダウンロードリンクは、[Releases リリースページ](https://github.com/TrionesType/zhuque/releases)で更新されます 。

## デザインストーリー

オープンソースの宋朝体フォントの開発というアイデアは、2021年初頭に発案され、[「ヒカリ角ゴ」](https://github.com/welai/glow-sans)プロジェクトに続く、より有意義で、より難易度の高い挑戦だと考えました。デザイン研究の深化と技術の進歩、特に昨年以降の人工知能技術の急速な発展により、この発想の実現が今日に至って可能になりました。

「朱雀宋朝」は、民国時代の活字「南宋」を改刻し、数十年間眠っていた古い活字書体に新生を与えることを目指しています。「南宋」活字は 1932 年、「百宋鋳字印刷局」によって発表され、韓佑之が原稿をデザインし、鄒根培が母型を彫刻しました。発表されるとすぐに、書籍や雑誌の印刷に広く使用されました。「南宋」は、多くの本文向け書体とは異なり、独特の魅力を放っています。重心がやや右下に偏っており、文字構造は懐が引き締まり、払いが広がっており、筆画の太さの変化が強調されています。含蓄的で優雅でありながら、力強さも感じられ、見出しや本文の印刷において「書物の雰囲気」を醸し出しています。

「南宋」活字をベースにしており、「朱雀宋朝」は筆画の対比をやや抑え、字形の構造とレイアウト効果を適度に整え、同時に「南宋」の独特な雰囲気と本来活字の流儀を最大限に保持します。

「朱雀」は、中国の伝統文化の「四象」の一つであり、南方七宿の神です。「朱雀」という名前は、「南宋」と深く結びついており、また「璇璣」のブランド名とも調和しています。

### 参考文献

- 孫明遠：《中国近现代平面设计和文字设计发展历程研究——从一八〇五年至一九四九年》，厦門大学出版社，2021 年第 1 版，168-172頁
- 周博：《中国现代文字设计图史》，北京大学出版社，2018 年第 1 版，122-124頁

## ライセンス

© 2023 [JadeFoci](https://jadefoci.com/)， [SIL Open Font License 1.1](http://scripts.sil.org/OFL) に基づいて公開されています。

以下のことが**できます**：

- 本フォントを**無料で商用できます**。印刷、ロゴ、ソフトウェア、ウェブサイト、動画など、どのような場面でも使用可能です。
- 本フォントを複製および再配布することができます。

以下のことは**できません**：

- フォントのオリジナルバージョンまたは変更バージョンを単体で販売することはできません。

ライセンスは、[SIL Open Font License 1.1 の英文原文](http://scripts.sil.org/OFL)に基づいています。

「朱雀宋朝」正式版がリリースされるまで、「朱雀」チーム以外によって修正された本フォントの**非公式版を大量に広めないでください**。もし「朱雀仿宋」を改良したい場合、また私たちのデザインのワークに参加する方法などについて、貴重なご意見やご提案をお待ちしております。

「朱雀」のラテン文字と記号などは現在、 [Alegreya](https://github.com/huertatipografica/Alegreya) の外挿補間インスタンスを使用しています。Alegreyaは、Huerta Tipográfica の Juan Pablo del Peral によって作成され、SIL Open Font License 1.1 で公開されています。

## 「朱雀」のチーム

**主要創作者：**[余俊益](https://github.com/Lottin0113)

**仮名・記号（制作中）：**[韓泳思](https://github.com/yeongsy)

**技術サポート：**[殷葉航](https://github.com/celestialphineas)、[余俊益](https://github.com/Lottin0113)

## 璇璣造字について

[「璇璣造字」](http://trionestype.com/)は、[JadeFoci](https://jadefoci.com/) 社に所属するフォントメーカーです。カスタム書体デザイン・書体デザインツール・人工知能による書体生成・フォントエンジニアリングなどのサービスを提供しています。

『書経・舜典』「在璇璣玉衡、以斉七政。」璇璣は伝説上の天体観測器具、また出土した螺旋状の玉器、北斗七星の別名でもあります。名前の通り、「璇璣造字」は伝統の文化に根ざし、自然の風物から霊感を得て、先端技術で文字の風景を革新します。

- **私たちは多元的：** 東アジアの文字デザインの伝統に精通し、国際的な視点も持っています。私たちは様々な文字体系のデザインの特徴を巧みに翻訳できます。
- **私たちは創造的：** 「璇璣造字」は数多くの受賞歴のある若いチームです。均一性が高い本格的な本文書体であれ、豊富で多彩なデザイン書体であれ、私たちは伝統と現代の間の最も適切な交差点を見つけることができます。
- **私たちは技術的：** AI を活用した設計支援の分野で豊富な実績を持つ情報工学系の研究室から生まれた「璇璣造字」は、文字デザインの可能性を広げます。最新の技術で漢字書体デザインの効率と品質を飛躍的に向上させ、理想の文字を実現します。

技術の進歩に関わらず、私たちは常に「人」を第一に考えます。デザイナーの創造力と読者の体験を大切にします。

未来の文字を、璇璣造字と一緒に。

## 謝辞

- 特別感謝：特里王さんによる南宋の活字の収集、整理、研究における貢献。
- [Siphercase](https://github.com/Siphercase) は一部の国際音声記号のグリフを補充しました。
- [落霞孤鶩](https://github.com/lxgw)の[「霞鶩文楷」](https://github.com/lxgw/LxgwWenKai)・[Fontworks Klee One](https://github.com/fontworks-fonts/Klee)・[源ノ明朝](https://github.com/adobe-fonts/source-han-serif)、これらのオープンソースフォントは、本プロジェクトにおいて人と機械のデザインプロセスにおける文字の字体の参考として使用されました。