# 朱雀仿宋

[English](docs/README-en.md) | [繁體中文](docs/README-zh-Hant.md) | [日本語](docs/README-ja.md)

![](docs/preview.png)

「朱雀仿宋」是[璇玑造字](http://trionestype.com/)的开源仿宋字体计划，志在最终提供高质量的、支持多语言的正文仿宋解决方案。

仿宋作为「宋黑仿楷」中文四大基础字体之一，长期缺乏开源许可证下的选择。我们希望「朱雀仿宋」可以弥补这一空缺，为开源软件与 TeX 社区贡献一份力。

上世纪初，仿宋活字一度品类繁盛，开发、应用风行一时。然而时过境迁，市面上的仿宋最终收敛于「华丰真宋」一系，这也是今天大多数人所熟悉的仿宋样貌。「朱雀仿宋」则以民国仿宋活字「南宋」为蓝本，在满足现代排印需求的前提下，尝试为正文仿宋字库带来一缕新鲜空气。

当前我们发布的「朱雀仿宋」仍为「预览测试版」，尚处于项目早期阶段；无论是设计风格、字数，还是字形、排版质量，都不代表正式版情况。因此，

## 「朱雀」的未来，由你定义

如果您有任何问题、意见建议、合作意向，我们也欢迎您加入「朱雀仿宋反馈」微信群；或移步 [Issues](https://github.com/TrionesType/zhuque/issues) 提出。

<p align="center">
  <img src="docs/wechat_qr.png" width="150px"/>
</p>

璇玑正在尝试一种全新中文字库设计模式。得益于我们开发的最新技术，璇玑的设计师可以直接将人工智能作为设计工具去使用，我们也因此能以迭代的方式开发「朱雀」。

在测试阶段中，我们发布了一个调查问卷，有 335 人参与了填写，其中有 72 份有效专业意见。[问卷结论](docs/survey_result-zh.md)对我们改进朱雀的造型、以及合理规划后续工作方向作用良多。

即便有技术加持，我们宏伟的目标也让「朱雀」项目有着难以想象的工作量。为了让项目推进更快、更可持续，我们也希望能获得更多的支持。

## 下载

版本与下载链接将会更新在 [Releases 发布页](https://github.com/TrionesType/zhuque/releases)。

## 设计故事

开发一套开源仿宋字库的想法最早始于 2021 年初，是继[「未来荧黑」](https://github.com/welai/glow-sans)项目之后，我们认为更有意义、也更具难度的挑战。随着设计研究的深入与技术进步，特别是去年以来 AIGC 技术的爆发，实现这一想法在今日遂成可能。

「朱雀仿宋」改刻自民国活字「南宋」，试图为这套沉睡数十年的字体赋予新生。「南宋」于 1932 年由「百宋铸字印刷局」推出，韩佑之设计原稿，邹根培雕刻字模。一经面世，即广泛用于书籍、期刊排印。「南宋」与大多数正文字体的设定不同，重心略靠右下；结构中宫收紧、撇捺舒展，笔画的粗细变化强烈；含蓄秀美而充满力量感，在排印标题和正文时展现出浓厚的「书卷气」。

在「南宋」活字的基础上，「朱雀仿宋」稍稍削弱了笔画的对比度，适当地规整了字形结构与版面效果，同时最大程度地保留了「南宋」的独特气质与活字趣味。

「朱雀」是中国传统文化中「四象」之一，南方七宿之神。「朱雀」之名，与「南宋」渊源以及「璇玑造字」的品牌名相合。

### 参考文献

- 孙明远：《中国近现代平面设计和文字设计发展历程研究——从一八〇五年至一九四九年》，厦门大学出版社，2021 年第 1 版，第 168～172 页
- 周博：《中国现代文字设计图史》，北京大学出版社，2018 年第 1 版，第 122～124 页

## 许可证

© 2023 [智琮科技](https://jadefoci.com/)，以 [SIL Open Font License 1.1](http://scripts.sil.org/OFL) 发布。

您**可以**：

- **免费商用本字体**，无论是用于印刷、LOGO、软件、网页还是视频。
- 复制与再分发本字体。

您**不可以**：

- 单独销售字体的原始版本或是修改版本。

授权方式以 [SIL Open Font License 1.1 的英文原文](http://scripts.sil.org/OFL)为准。

我们恳请您**暂时不要**在「朱雀仿宋」正式版发布之前大量传播非「朱雀」团队所修改的本字体。如果您有改进「朱雀仿宋」意愿，我们非常欢迎您提出宝贵的意见建议——包括与我们讨论如何参与到朱雀的设计工作。

朱雀的西文与符号暂采用 [Alegreya](https://github.com/huertatipografica/Alegreya) 的一个外插值实例。Alegreya 由 Huerta Tipográfica 的 Juan Pablo del Peral 创作，同样以 SIL Open Font License 1.1 发布。

## 捐赠

如果朱雀帮助到了您，我们非常感谢您能捐赠本项目，您的捐赠将会帮助项目更好向前发展。捐赠时，烦请添加**付款备注「捐赠朱雀」**，付款前请确认收款方为「智琮科技」。在此过程中遇到任何问题，可通过「朱雀仿宋反馈」微信群联系我们。

![](docs/sponsor_qr.png)

## 「朱雀」团队

**主创：**[余俊益](https://github.com/Lottin0113)

**假名与符号（制作中）：**[韩泳思](https://github.com/yeongsy)

**技术：**[殷叶航](https://github.com/celestialphineas)、[余俊益](https://github.com/Lottin0113)

## 关于璇玑造字

[「璇玑造字」](http://trionestype.com/)是[智琮科技](https://jadefoci.com/)的字库品牌。我们以传统文化为立足基本，从自然风物汲取设计灵感，藉前沿科技更新文字风景。无论技术如何变迁，我们将始终把「人」置于第一位，关心设计者的创意与读者的体验。

欢迎你来和璇玑造字一起塑造属于未来的文字！

## 致谢

- 特别鸣谢：特里王，在「南宋」活字收集、整理、研究上的贡献。
- [Siphercase](https://github.com/Siphercase) 补充了部分国际音标字形。
- [落霞孤鹜](https://github.com/lxgw)的[「霞鹜文楷」](https://github.com/lxgw/LxgwWenKai)、[Fontworks Klee One](https://github.com/fontworks-fonts/Klee)、[思源宋体](https://github.com/adobe-fonts/source-han-serif)，这些开源字体是本项目人与机在设计过程中的写法参考。