# Miyoo Custom Firmware

> The definitive custom firmware for **BittBoy**, **PocketGo**, **PowKiddy V90-Q90-Q20** _(and 3rd party consoles)_ allows you unlock the potential of the hardware and use software from a wide variety of consoles and computers thanks to the availability of numerous emulators and native ports of several games!

<div align="center">

![miyoo-cfw](https://github.com/TriForceX/MiyooCFW/assets/16083854/51119d94-24a5-47b7-8bbd-f93b997c36c1)

[![version](https://img.shields.io/github/v/release/TriForceX/MiyooCFW?include_prereleases&label=Current%20Version&color=brightgreen&style=flat)](https://github.com/TriForceX/MiyooCFW/releases)
[![discord](https://discord.gznetwork.com/badge/?id=202879976599453696)](https://discord.gznetwork.com)
[![threads](https://img.shields.io/github/discussions/TriForceX/MiyooCFW.svg?label=Threads&color=orange&style=flat)](https://github.com/TriForceX/MiyooCFW/discussions)
[![wiki](https://img.shields.io/badge/Wiki-Guides-blueviolet.svg?style=flat)](https://github.com/TriForceX/MiyooCFW/wiki)
[![stars](https://img.shields.io/github/stars/TriForceX/MiyooCFW.svg?label=Stars&style=flat)](https://github.com/TriForceX/MiyooCFW/stargazers)
[![issues](https://img.shields.io/github/issues/TriForceX/MiyooCFW.svg?label=Issues&color=red&style=flat)](https://github.com/TriForceX/MiyooCFW/issues)
[![license](https://img.shields.io/github/license/TriForceX/MiyooCFW.svg?label=License&color=yellow&style=flat)](#license)

_This project is not affiliated or related with any company or manufacturer. We do not pay or get paid for this work._

</div>

---

# Information

- Get the latest release [here](https://github.com/TriForceX/MiyooCFW/releases)
- Check main guides for setup in our **wiki** [here](https://github.com/TriForceX/MiyooCFW/wiki)
- Give us your **feedback** or **comments** on the discussion **forums** [here](https://github.com/TriForceX/MiyooCFW/discussions)
- Check the version details history in our **changelog** [here](https://github.com/TriForceX/MiyooCFW/blob/master/CHANGELOG.md)
- Join our **Discord** chat server for more support [here](https://discord.gznetwork.com)
- For development chat join our **Matrix** server [here](https://matrix.to/#/#miyoocfw:matrix.org)

<br>

<div align="center">

![miyoo-consoles](https://user-images.githubusercontent.com/16083854/221029395-26b04557-dccf-40bd-a059-b9928553ee4f.png)

</div>

---

# Resources

<details><summary> Homebrews & Ports</summary><br>

The next list is the latest homebrews games and ports available _(click the user name for more info)_. 

Download | Dev / Port by
:------: | :------:
[Just4Qix](https://github.com/szymor/just4qix/releases/latest) | [szymor](https://github.com/szymor/just4qix)
[REminiscence](https://github.com/jamesofarrell/REminiscence/releases/latest) | [jamesofarrell](https://github.com/jamesofarrell/REminiscence/)
[Xrick](https://github.com/jamesofarrell/miyoo_xrick/releases/latest) | [jamesofarrell](https://github.com/jamesofarrell/miyoo_xrick)
[Evil Australians](https://drive.google.com/file/d/1c45WxVTbg_iodVCUD4ScJl5UeojGWBYp/view) | [gameblabla](https://github.com/gameblabla/evilaustralians)
[Yatka](https://github.com/szymor/yatka/releases/latest) | [szymor](https://github.com/szymor/yatka)
[Hocoslamfy](https://github.com/Apaczer/hocoslamfy/releases/latest) | [Apaczer](https://github.com/Apaczer/hocoslamfy)
[Circuit Dude](http://www.crait.net/download.php?file=CircuitDudePG.zip) | [crait](http://www.crait.net)
[Midnight Wild](http://www.crait.net/download.php?file=MidnightWildPG.zip) | [crait](http://www.crait.net)
[Hydra Castle Labyrinth](https://github.com/szymor/hydracastlelabyrinth/releases/latest) | [szymor](https://github.com/szymor/hydracastlelabyrinth)
[Homing Fever](https://github.com/szymor/HomingFever/releases/latest) | [szymor](https://github.com/szymor/HomingFever)
[l\'Abbaye des Morts](https://github.com/szymor/abbayedesmorts-gpl/releases/latest) | [szymor](https://github.com/szymor/abbayedesmorts-gpl)
[Shifty Pills](https://github.com/szymor/Shifty-Pills/releases/latest) | [szymor](https://github.com/szymor/Shifty-Pills)
[Shisen-Seki (四川石)](https://github.com/szymor/shisen-seki/releases/latest) | [szymor](https://github.com/szymor/shisen-seki)
[Super Methane Brothers](https://github.com/szymor/methane-sdl/releases/latest) | [szymor](https://github.com/szymor/methane-sdl)
[H.E.R.O.E.S](https://github.com/szymor/heroes-tron/releases/latest) | [szymor](https://github.com/szymor/heroes-tron)
[Wizznic](https://github.com/szymor/Wizznic/releases/latest) | [szymor](https://github.com/szymor/Wizznic)
[Super Transball 2](https://github.com/szymor/stransball2/releases/latest) | [szymor](https://github.com/szymor/stransball2)
[Hermes](https://www.retroguru.com/hermes/hermes-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.retroguru.com/hermes)
[Worship Vector](https://github.com/szymor/Worship-Vector/releases/latest) | [szymor](https://github.com/szymor/Worship-Vector)
[Spout](https://github.com/szymor/spout/releases/latest) | [szymor](https://github.com/szymor/spout)
[Profanation Deluxe](https://github.com/salvacam/profanation/releases/latest) | [salvacam](https://github.com/salvacam/profanation)
[Manic Miner](https://github.com/salvacam/manicminer/releases/latest) | [salvacam](https://github.com/salvacam/manicminer)
[Sqrxz](https://www.retroguru.com/sqrxz/sqrxz-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.sqrxz.de/sqrxz)
[Sqrxz 2](https://www.retroguru.com/sqrxz2/sqrxz2-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.retroguru.com/sqrxz2)
[Sqrxz 3](https://www.retroguru.com/sqrxz3/sqrxz3-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.sqrxz.de/sqrxz-3)
[Sqrxz 4](https://retroguru.com/sqrxz4/sqrxz4-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.sqrxz.de/sqrxz-4)
[Zelda Picross](https://github.com/salvacam/zeldapicross/releases/latest) | [salvacam](https://github.com/salvacam/zeldapicross)
[FleshChasmer](https://github.com/szymor/FleshChasmer/releases/latest) | [szymor](https://github.com/szymor/FleshChasmer)
[Paranoia](https://github.com/szymor/c-paranoia/releases/latest) | [szymor](https://github.com/szymor/c-paranoia)
[Apricots](https://github.com/salvacam/apricots/releases/latest) | [salvacam](https://github.com/salvacam/apricots)
[Arkanoid](https://github.com/salvacam/arkanoid/releases/latest) | [salvacam](https://github.com/salvacam/arkanoid)
[Rockbot](https://github.com/salvacam/rockbot/releases/latest) | [salvacam](https://github.com/salvacam/rockbot)
[MineSweeper](https://github.com/szymor/MineSweeper/releases/latest) | [szymor](https://github.com/szymor/MineSweeper)
[BlockOut 2](https://github.com/salvacam/blockout2/releases/latest) | [salvacam](https://github.com/salvacam/blockout2)
[Sonic Robo Blast 2](https://github.com/salvacam/srb2/releases/latest) | [salvacam](https://github.com/salvacam/srb2)
[Haunted](https://github.com/szymor/haunted/releases/latest) | [szymor](https://github.com/szymor/haunted)
[Spartak Chess](https://github.com/szymor/Spartak-Chess/releases/latest) | [szymor](https://github.com/szymor/Spartak-Chess)
[OpenJazz (aka Jazz Jackrabbit)](https://github.com/Apaczer/openjazz/releases/latest) | [Apaczer](https://github.com/Apaczer/openjazz)
[Tile World](https://github.com/salvacam/tileworld/releases/latest) | [salvacam](https://github.com/salvacam/tileworld)
[Xump](https://www.retroguru.com/xump/xump-v.latest-bittboy-pocketgo.zip) | [szymor](https://www.retroguru.com/xump)
[Sokoban](https://github.com/szymor/sokoban/releases/latest) | [szymor](https://github.com/szymor/sokoban)
[2048](https://github.com/szymor/2048/releases/latest) | [szymor](https://github.com/szymor/2048)
[Slitherlink](https://github.com/szymor/od-slitherlink/releases/latest) | [szymor](https://github.com/szymor/od-slitherlink)
[SuperTux](https://github.com/andrigamerita/supertux/releases/latest) | [andrigamerita](https://github.com/andrigamerita)
[Treasure Chasers](http://www.crait.net/download.php?file=TreasureChasersPG.zip) | [crait](http://www.crait.net)
[Super Mario War (April Fools Edition)](https://github.com/andrigamerita/super-mario-war/releases/latest) | [andrigamerita](https://github.com/andrigamerita/super-mario-war)
[Meritous](https://github.com/andrigamerita/meritous/releases/latest) | [andrigamerita](https://github.com/andrigamerita/meritous)
[Zelda Return of the Hylian](https://github.com/andrigamerita/zelda_roth/releases/latest) | [andrigamerita](https://github.com/andrigamerita/zelda_roth)
[Falling Time](https://github.com/szymor/FallingTime/releases/latest) | [szymor](https://github.com/szymor/FallingTime)
[VWordle](https://github.com/szymor/vwordle/releases/latest) | [szymor](https://github.com/szymor/vwordle)
[Anarch](https://github.com/szymor/anarch/releases/latest) | [szymor](https://github.com/szymor/anarch)
[Heart of the Alien](https://github.com/MiyanoOsu/hota_redux/releases/latest) | [MiyanoOsu](https://github.com/MiyanoOsu/hota_redux)
[Duke Nukem 3D](https://github.com/Apaczer/eduke32/releases/latest) | [Apaczer](https://github.com/Apaczer/eduke32)
[Final Snake](https://github.com/szymor/finalsnake/releases/latest) | [szymor](https://github.com/szymor/finalsnake)
[quartermaster](https://github.com/Apaczer/quartermaster/releases/latest) | [hi-ban](https://github.com/Apaczer/quartermaster)
[Biniax2](https://github.com/salvacam/biniax2/releases/latest) | [salvacam](https://github.com/salvacam/biniax2)
[Quake](https://github.com/tiopex/sdlquake/releases/latest) | [gameblabla](https://github.com/tiopex/sdlquake)
[Promesst](https://github.com/szymor/promesst/releases/latest) | [szymor](https://github.com/szymor/promesst)
[NXEngine (aka CaveStory)](https://github.com/Apaczer/NXEngine/releases/latest) | [Apaczer](https://github.com/Apaczer/NXEngine)
[Chocolate Doom](https://github.com/tiopex/Chocolate-Doom-miyoo/releases/latest) | [Tiopex](https://github.com/tiopex/Chocolate-Doom-miyoo)
[Another World](https://github.com/MiyanoOsu/re-aw-miyoo/releases/latest) | [MiyanoOsu](https://github.com/MiyanoOsu/re-aw-miyoo)
[Zelda Navi 's Quest](https://github.com/MiyanoOsu/Zelda_NSQ/releases/latest) | [MiyanoOsu](https://github.com/MiyanoOsu/Zelda_NSQ)
[Zelda Oni Link Begin](https://github.com/MiyanoOsu/Zelda_OLB/releases/latest) | [MiyanoOsu](https://github.com/MiyanoOsu/Zelda_OLB)
[Zelda Time To Triumph](https://github.com/MiyanoOsu/Zelda_3T/releases/latest) | [MiyanoOsu](https://github.com/MiyanoOsu/Zelda_3T)
[ASCIIpOrtal](https://github.com/Apaczer/ASCIIpOrtal/releases/latest) | [Apaczer](https://github.com/Apaczer/ASCIIpOrtal)
[Liero](https://github.com/tiopex/liero/releases/latest) | [Tiopex](https://github.com/tiopex/liero)

---

</details>

<details><summary> Emulators</summary><br>

The next list is for the latest emulators available _(click the user name for more info)_.

Download | Dev / Port by
:------: | :------:
[RetroArch](https://www.retroarch.com/?page=platforms) | [RetroArch](https://www.retroarch.com)
[Gambatte-DMS](https://github.com/bardeci/dot-matrix-simulator/releases/latest) | [hi-ban](https://github.com/bardeci/dot-matrix-simulator)
[BittBoy MSX](https://github.com/pthalin/bittboy-msx/releases/latest) | [pthalin](https://github.com/pthalin)
[PocketSNES](https://github.com/m45t3r/pocketsnes-miyoo/releases) | [m45t3r](https://github.com/m45t3r/pocketsnes-miyoo)
[DrPocketSNES](https://github.com/Apaczer/DrPocketSNES/releases/latest) | [bitrider](https://github.com/Apaczer/DrPocketSNES)
[snes9x4d](https://github.com/m45t3r/snes9x4d-miyoo/releases/latest) | [m45t3r](https://github.com/m45t3r/snes9x4d-miyoo)
[BittBoy J2ME (Experimental)](https://github.com/pthalin/bittboy-j2me/releases/latest) | [pthalin](https://github.com/pthalin)
[Fuse, ZX Spectrum](https://github.com/salvacam/fuse-od/releases/latest) | [salvacam](https://github.com/salvacam/fuse-od)
[Speccy, ZX Spectrum](https://github.com/salvacam/speccy/releases/latest) | [salvacam](https://github.com/salvacam/speccy)
[Amstrad CPC, Dingux-Cap32](https://github.com/salvacam/dingux-cap32/releases/latest) | [salvacam](https://github.com/salvacam/dingux-cap32)
[SZ81, ZX80 and ZX81](https://github.com/salvacam/sz81-miyoo/releases/latest) | [salvacam](https://github.com/salvacam/sz81-miyoo)
[ScummVM](https://www.scummvm.org/downloads) | [scummvm](https://github.com/scummvm/scummvm)
[Dingux-Atari, Atari 800 and Atari 5200](https://github.com/salvacam/dingux-atari/releases/latest) | [salvacam](https://github.com/salvacam/dingux-atari)
[SamCoupe Home Computer](https://github.com/salvacam/miyoo-sim/releases/latest) | [salvacam](https://github.com/salvacam/miyoo-sim)
[Vectrex](https://github.com/salvacam/dingux-vectrex/releases/latest) | [salvacam](https://github.com/salvacam/dingux-vectrex)
[Atari 7800](https://github.com/salvacam/dingux-7800/releases/latest) | [salvacam](https://github.com/salvacam/dingux-7800)
[Dcastway, Atari ST](https://github.com/salvacam/dcastaway/releases/latest) | [salvacam](https://github.com/salvacam/dcastaway)
[Wiz-colem, Colecovision](https://github.com/salvacam/dingux-colem/releases/latest) | [salvacam](https://github.com/salvacam/dingux-colem)
[Atari 5200](https://github.com/salvacam/a5200/releases/latest) | [salvacam](https://github.com/salvacam/a5200)
[Beebem, BBC Micro Model B](https://github.com/salvacam/beebem-rg350/releases/latest) | [salvacam](https://github.com/salvacam/beebem-rg350)
[GP2X-Dragon, Dragon32/64 and Tandy Coco](https://github.com/salvacam/dragon/releases/latest) | [salvacam](https://github.com/salvacam/dragon)
[Jzint, Intellivision](https://github.com/salvacam/jzintv/releases/latest) | [salvacam](https://github.com/salvacam/jzintv)
[Watara Supervision](https://github.com/salvacam/potator/releases/latest) | [salvacam](https://github.com/salvacam/potator)
[Thomson TO7-70](https://github.com/salvacam/caanoo-thom/releases/latest) | [salvacam](https://github.com/salvacam/caanoo-thom)
[Thomson MO5](https://github.com/salvacam/caanoo-mo5/releases/latest) | [salvacam](https://github.com/salvacam/caanoo-mo5)
[CHIP8](https://github.com/salvacam/gpchip/releases/latest) | [salvacam](https://github.com/salvacam/gpchip)
[Texas instruments TI92](https://github.com/salvacam/dingux-ti92/releases/latest) | [salvacam](https://github.com/salvacam/dingux-ti92)
[Texas instruments TI99](https://github.com/salvacam/dingux-ti99/releases/latest) | [salvacam](https://github.com/salvacam/dingux-ti99)
[Arnold Amstrad GX4000](https://github.com/salvacam/arnold_gcw0/releases/latest) | [salvacam](https://github.com/salvacam/arnold_gcw0)
[O2EM Libretro](https://github.com/salvacam/libretro-o2em/releases/latest) | [salvacam](https://github.com/salvacam/libretro-o2em)
[VMU Dingoo](https://github.com/salvacam/vmu-dingoo/releases/latest) | [salvacam](https://github.com/salvacam/vmu-dingoo)
[gpSP, Game Boy Advance](https://github.com/Apaczer/gpsp/releases/latest) | [Apaczer](https://github.com/Apaczer/gpsp)
[FBA-A320](https://github.com/Rezzy-dev/fba-miyoo-playable/releases/latest) | [Rezzy](https://github.com/Rezzy-dev/fba-miyoo-playable)
[PokeMini](https://github.com/Rezzy-dev/pokemini/releases/latest) | [gameblabla](https://github.com/Rezzy-dev/pokemini)
[GnGeo, Neo Geo](https://github.com/Apaczer/gngeo/releases/latest) | [Apaczer](https://github.com/Apaczer/gngeo)
[Game & Watch](https://github.com/salvacam/gw_miyoo/releases/latest) | [salvacam](https://github.com/salvacam/gw_miyoo)
[Pico 8](https://github.com/jtothebell/fake-08/releases/latest) | [jtothebell](https://github.com/jtothebell/fake-08/)
[UAE4ALL, Amiga 500](https://github.com/Apaczer/uae4all/releases/latest) | [Apaczer](https://github.com/Apaczer/uae4all)
[race, Neo Geo Pocket](https://github.com/Apaczer/race-od/releases/latest) | [eggs](https://github.com/Apaczer/race-od)
[PicoDrive, Sega MS/GG/MD/MD-CD/32X](https://github.com/irixxxx/picodrive/releases/latest) | [irixxxx](https://github.com/irixxxx/picodrive)
[Gnash, Flash player](https://github.com/Apaczer/gnash-miyoo/releases/latest) | [Apaczer](https://github.com/Apaczer/gnash-miyoo)
[FCEUX, Famicom/NES](https://github.com/Apaczer/fceux-for-miyoo/releases/latest) | [Apaczer](https://github.com/Apaczer/fceux-for-miyoo)
[PCSX-ReARMed](https://github.com/tiopex/pcsx_rearmed/releases/latest) | [Tiopex](https://github.com/tiopex/pcsx_rearmed/)

---

</details>

<details><summary> Skins & Frontends</summary><br>

The next list is the current skins, themes and frontends available _(click the user name for more info)_.

Download | Dev / Port by
:------: | :------:
[Simple Menu](https://github.com/fgl82/simplemenu/releases) | [fgl82](https://github.com/fgl82/simplemenu)
[Coverflow](https://github.com/peterthrees/Coverflow/raw/master/build/Coverflow/CoverflowV1.0.zip) | [peterthrees](https://github.com/peterthrees/Coverflow)
[SimUI](https://github.com/dkodr/SimUI/releases/latest) | [dkodr](https://github.com/dkodr/SimUI)
[TheWebWolfe Themes](https://github.com/thewebwolfe/Miyoo_Themes/tree/main/.github/workflows) | [thewebwolfe](https://github.com/thewebwolfe/Miyoo_Themes)

---

</details>

<details><summary> Tools & Demos</summary><br>

The next list is the current tools available _(click the user name for more info)_.

Download | Dev / Port by
:------: | :------:
[Commander](https://github.com/Apaczer/commander/releases/latest) | [Apaczer](https://github.com/Apaczer/commander)
[Simple Terminal](https://github.com/Apaczer/miyoo_st-sdl/releases/latest) | [Apaczer](https://github.com/Apaczer/miyoo_st-sdl)
[Calculator for BittBoy](https://github.com/szymor/bittboy-calc/releases/latest) | [szymor](https://github.com/szymor/bittboy-calc)
[I/O Tester](https://github.com/Apaczer/iotester/releases/latest) | [Apaczer](https://github.com/Apaczer/iotester)
[PV2X Picture Viewer](https://github.com/Apaczer/pv2x/releases/latest) | [Apaczer](https://github.com/Apaczer/pv2x)
[Wormhole Demo](https://github.com/szymor/wormhole/releases/latest) | [szymor](https://github.com/szymor/wormhole)
[Lorenz Attractor Demo](https://github.com/szymor/lorenz/releases/latest) | [szymor](https://github.com/szymor/lorenz)
[S.k.y. Demo](https://github.com/szymor/gynvael-sky/releases/latest) | [szymor](https://github.com/szymor/gynvael-sky)
[Pixel Reader](https://github.com/Apaczer/pixel-reader/releases/latest) | [Apaczer](https://github.com/Apaczer/pixel-reader)
[Gmu Music Player](https://github.com/Apaczer/gmu/releases/latest) | [Apaczer](https://github.com/Apaczer/gmu)
[Bard Storyteller](https://github.com/Apaczer/bard/releases/latest) | [Apaczer](https://github.com/Apaczer/bard)

---

</details>

<details><summary> Debug</summary><br>

Below is the list of practical debugging programs _(click the user name for more info)_.

Download | Dev / Port by
:------: | :------:
[QEMU](https://github.com/steward-fu/archives/releases/download/fc3000/qemu_20220929.7z) | [steward-fu](https://steward-fu.github.io/website/handheld/fc3000/qemu.htm)
[GDB](https://github.com/Apaczer/miyoo_tools/releases/download/apps/gdb.zip) | [gameblabla](https://github.com/Apaczer/miyoo_tools/tree/main/gdb)

---

</details>

<details><summary> Free Roms</summary><br>

Below is the list of some free homebrew (legal) roms and demos websites _(click the name for more info)_.

Console | Website
:------: | :------:
GB / GBC | [GameBoy Demospotting](http://privat.bahnhof.se/wb800787/gb/demos)
SNES | [Snes Central](https://snescentral.com/homebrew.php)
NES  | [NesDev](https://forums.nesdev.org/viewforum.php?f=22)
ALL | [RomHacking](https://www.romhacking.net/homebrew)
ALL | [Pouet](https://www.pouet.net/prodlist.php)

---

</details>

<details><summary> Other Resources</summary><br>

Here you have a list some of some **old betas* or custom files, to access them go to **Beta Testing** folder [here](https://drive.google.com/drive/folders/1AT3LVlJPCZf_csTh8qdgL0Bp1MlZQONV?usp=sharing). This section is for advanced users, no guides are provided for this (please read the **.txt** files before using them).

File | Notes
:------------: | :------------
GMenu2x AutoStart | Loads the last game/app/rom you were playing at startup
Screen Tearing | Improved screen driver for Pocket Go and BittBoy
FCEUX Rumble | Modified NES emulator FCEUX with rumble support
FCEUX Improved | Modified NES emulator FCEUX with improved performance
FS Corruption Daemon | Daemon file to fix file system corruptions
NSF Player | Simple NES emulator FCEUX shortcut to play NSF sound files
Switch PWM Scripts | Scripts to improve the background sound noise
Mame4All Improved | Untested Mame32 emulator with improved performance
PCSX Rearmed CFG | Custom PCSX-Rearmed Config Library
PocketSNES Improved | Modified SNES emulator with improved performance
Fake 08 | Alternative Pico 8 emulator under development

_**Note:** If you are looking for other stuff or **old resources** (stock firmware, drivers, schematics, etc...) you can take a look [here](https://drive.google.com/drive/folders/1GEumIF7XNOAGNOtPoe4kjP97Wzk7jj1E?usp=sharing)._

---

</details>

<details><summary> Console Revisions Differences</summary><br>

The next list is for some differences between Miyoo &  Powkiddy devices:

_**Note:** Some people have been receiving consoles with parts of different versions, if any **CFW** does not work let us know in our **Discord** indicated above._

Rev | Release | Notes
:------------: | :------------: | :------------
PowKiddy Q20 | July 13, 2021 | Mini landscape form factor with extra "Rfunction" button (and "Lfunction" for RESET)
PowKiddy V90 | June 17, 2020 | New GBA SP form factor with extra L2 and R2 buttons
PowKiddy Q90 | Dec 18, 2019 | New landscape form factor with analog stick & additional "+" button (and "-" for RESET)
Pocket Go 1 | May 14, 2019 | Changed circuit board (see [here](https://user-images.githubusercontent.com/16083854/65437766-c351ef00-ddfa-11e9-902c-5b83677b436e.png))
Pocket Go 0.5 | May 10, 2019 | Added shoulder buttons (L & R)
Pocket Go 0.5 | May 10, 2019 | Added physical volume control
Pocket Go 0.5 | May 10, 2019 | New landscape form factor
BittBoy 3.5 | May 14, 2019 | Changed circuit board (see [here](https://user-images.githubusercontent.com/16083854/61262811-a5aa3e80-a754-11e9-97b5-e9f2d4c8cda2.png))
BittBoy 3.5 | May 14, 2019 | Barcode changed to 20190424 005 (newers no longer include it)
BittBoy 3.5 | May 14, 2019 | Glass screen is thinner
BittBoy 3 | April 23, 2019 | New non-registered key combos detected
BittBoy 3 | April 23, 2019 | Fixed Ghost Key issues
BittBoy 3 | April 23, 2019 | Added tempered glass screen
BittBoy 3 | April 23, 2019 | Added rumble/vibration features
BittBoy 3 | April 23, 2019 | Micro USB port is flush with the shell
BittBoy 3 | April 23, 2019 | Bigger lightning symbol on battery LED
BittBoy 3 | April 23, 2019 | Changed screen (Still IPS but different model)
BittBoy 3 | April 23, 2019 | Barcode (20190410 004) added at the rear top of the console
BittBoy 3 | April 23, 2019 | Processor changed to Allwinner F1C100s (Not F1C500s anymore)
BittBoy 3 | April 23, 2019 | Box design changed (see [here](https://user-images.githubusercontent.com/16083854/61263177-fa01ee00-a755-11e9-8f16-fca6ae217a80.jpg))
BittBoy 3 | April 23, 2019 | Changed color shell (Slightly darker than the rev1)
BittBoy 2.5 | March 05, 2019 | Removed internal chip storage, no stock firmware
BittBoy 2.5 | March 05, 2019 | Only runs **CFW** from SD Card
BittBoy 2.5 | March 05, 2019 | Changed color shell to gray
BittBoy 2 | Jan 10, 2019 | Three display options (I: Normal, II: Pixel Perfect, III: Full)
BittBoy 2 | Jan 10, 2019 | Changed screen (Still IPS, removed 2nd display)
BittBoy 2 | Jan 10, 2019 | Clicky **Start** and **Select** buttons
BittBoy 2 | Jan 10, 2019 | 4bit hardware
BittBoy 2 | Jan 10, 2019 | Changed the button scan code sequence
BittBoy 2 | Jan 10, 2019 | Can run Stock Firmware and Custom Firmware
BittBoy 1 | Nov 30, 2018 | Two display options (I: Normal, II: Full)
BittBoy 1 | Nov 30, 2018 | Soft **Start** and **Select** click buttons
BittBoy 1 | Nov 30, 2018 | Internal 2nd display (Not used)
BittBoy 1 | Nov 30, 2018 | 1bit hardware
BittBoy 1 | Nov 30, 2018 | CFW requires hardware modifications

</details>

---

# Maintainers

Active contributors:

<table>
	<tr>
		<td align="center">
			<a href="https://github.com/tiopex">
				<img src="https://avatars.githubusercontent.com/u/67048640?s=64&v=4" width="64" height="64">
			</a>
		</td>
		<td align="center">
			<a href="https://github.com/Apaczer">
				<img src="https://avatars.githubusercontent.com/u/94932128?s=64&v=4" width="64" height="64">
			</a>
		</td>
		<td align="center">
			<a href="https://github.com/nfriedly">
				<img src="https://avatars.githubusercontent.com/u/114976?s=64&v=4" width="64" height="64">
			</a>
		<td align="center">
			<a href="https://github.com/TriForceX">
				<img src="https://avatars.githubusercontent.com/u/16083854?s=64&v=4" width="64" height="64">
			</a>
		</td>
	</tr>
	<tr>
		<td align="center">
			<a href="https://github.com/tiopex">
				@tiopex
			</a>
		</td>
		<td align="center">
			<a href="https://github.com/Apaczer">
				@Apaczer
			</a>
		</td>
		<td align="center">
			<a href="https://github.com/nfriedly">
				@nfriedly
			</a>
		</td>
		<td align="center">
			<a href="https://github.com/TriForceX">
				@TriForceX
			</a>
		</td>
	</tr>
</table>

# Special Thanks

The next people is contributing to all development of **Miyoo CFW** and its related stuff:

Main Developers | Support & Testing | Theme Developers | Misc Support
:------------ | :------------ | :------------ | :------------
[steward](https://github.com/steward-fu) | [Augen(히힛마스터)](https://github.com/AugenKOR) | 2TMAU5 | [pingflood](https://github.com/pingflood)
[sauce](https://github.com/gameblabla) | TakoSalad | da1writer | [Tony Jih](https://github.com/tonyjih)
[TriForce](https://github.com/TriForceX) | Mystic_Morgan | Fontes | Vincent
[H1BAN](https://github.com/hi-ban) | MrRobotSK | [mrwasterbr](https://github.com/mrwasterbr) | Dmm1138
superpuissant | WenTao | Segich | Alexai-MikeX
[scooterpsu](https://github.com/scooterpsu) | dElAvA | SimplEasy | Merisy
CountDuckula | Jutleys | Harsh B. (bhardwaj) | [Nikolay Minaylov](https://github.com/nminaylov)
[vamastah](https://github.com/szymor) | ToTo | [s4ilence](https://github.com/s4ilence) | [MiyanoOsu](https://github.com/MiyanoOsu)
[Christian_Haitian](https://github.com/christianhaitian) | [Turtle](https://github.com/turtleletortue) | [dkodr](https://github.com/dkodr) | 
[BytePorter](https://github.com/byteporter) | James Dull | [thewebwolfe](https://github.com/thewebwolfe) | 
[JamesOFarrell](https://github.com/jamesofarrell) | HYJiNX187 |  | 
dee | a64 |  | 
[crait](http://www.crait.net) | Rich |  | 
koroneo | [CanMurray](https://www.youtube.com/canmurray) |  | 
Roast风格 | [natopwns](https://github.com/natopwns) |  | 
[SantX27](https://github.com/SantX27) | [zargonbr](https://github.com/zargonbr) |  | 
[fgl82](https://github.com/fgl82) | [cricri-pingouin](https://github.com/cricri-pingouin) |  | 
[peterthrees](https://github.com/peterthrees) | [MayanKoyote](https://github.com/MayanKoyote) |  | 
madjester |  |  | 
[pthalin](https://github.com/pthalin) |  |  | 
[m45t3r](https://github.com/m45t3r) |  |  | 
[luali](https://github.com/lualiliu) |  |  | 
[mysterioustrashninja](https://github.com/ericrkjones) |  |  | 
PlataformerAndroid |  |  | 
[salvacam](https://github.com/salvacam) |  |  | 
[flabbergast](https://github.com/flabbergast) |  |  | 
[andrigamerita](https://github.com/andrigamerita) |  |  | 
[nfriedly](https://github.com/nfriedly) |  |  | 
[Tiopex](https://github.com/tiopex) |  |  | 
[Apaczer](https://github.com/Apaczer) |  |  | 
[YeuxNoir](https://github.com/NoNamedCat) |  |  | 
[Rezzy](https://github.com/Rezzy-dev) |  |  | 
[jSTE0](https://github.com/jSTE0) |  |  | 
Nyomen |  |  | 
[takano32](https://github.com/takano32) |  |  | 
  
# Contributing
> Theres many ways to contribute to this project, even if you don't know how to code. All kind of **support** or **testing** will be grateful. If you have plans to **contribute** in code, please **fork** the desired module from [here](https://github.com/MiyooCFW), create a branch with your changes and send us a **pull request** to upstream. For more info you can join our **Discord** chat [here](https://discord.gznetwork.com)

# License

> **OpenDingux** for Miyoo was initially ported for BittBoy console by [steward-fu](https://github.com/steward-fu) and **GMenu2X** is a fork of GMenuNX by [pingflood](https://github.com/pingflood). All other sub-modules or components that have been integrated from other forks have their credits in their respective repositories. This project is licensed under GPLv2 as free software. You are free to use, modify and redistribute them following the terms in License.txt
