// This file is auto-generated by @hey-api/openapi-ts

import type { CancelablePromise } from './core/CancelablePromise';
import { OpenAPI } from './core/OpenAPI';
import { request as __request } from './core/request';
import type { PublicIncomingWebhookData, PublicIncomingWebhookResponse, PublicIncomingWebhookWaitData, PublicIncomingWebhookWaitResponse, WorkspacesListWorkspacesResponse, WorkspacesCreateWorkspaceData, WorkspacesCreateWorkspaceResponse, WorkspacesSearchWorkspacesData, WorkspacesSearchWorkspacesResponse, WorkspacesGetWorkspaceData, WorkspacesGetWorkspaceResponse, WorkspacesUpdateWorkspaceData, WorkspacesUpdateWorkspaceResponse, WorkspacesDeleteWorkspaceData, WorkspacesDeleteWorkspaceResponse, WorkspacesListWorkspaceMembershipsData, WorkspacesListWorkspaceMembershipsResponse, WorkspacesCreateWorkspaceMembershipData, WorkspacesCreateWorkspaceMembershipResponse, WorkspacesGetWorkspaceMembershipData, WorkspacesGetWorkspaceMembershipResponse, WorkspacesDeleteWorkspaceMembershipData, WorkspacesDeleteWorkspaceMembershipResponse, WorkflowsListWorkflowsData, WorkflowsListWorkflowsResponse, WorkflowsCreateWorkflowData, WorkflowsCreateWorkflowResponse, WorkflowsGetWorkflowData, WorkflowsGetWorkflowResponse, WorkflowsUpdateWorkflowData, WorkflowsUpdateWorkflowResponse, WorkflowsDeleteWorkflowData, WorkflowsDeleteWorkflowResponse, WorkflowsCommitWorkflowData, WorkflowsCommitWorkflowResponse, WorkflowsExportWorkflowData, WorkflowsExportWorkflowResponse, WorkflowsGetWorkflowDefinitionData, WorkflowsGetWorkflowDefinitionResponse, WorkflowsCreateWorkflowDefinitionData, WorkflowsCreateWorkflowDefinitionResponse, TriggersCreateWebhookData, TriggersCreateWebhookResponse, TriggersGetWebhookData, TriggersGetWebhookResponse, TriggersUpdateWebhookData, TriggersUpdateWebhookResponse, WorkflowExecutionsListWorkflowExecutionsData, WorkflowExecutionsListWorkflowExecutionsResponse, WorkflowExecutionsCreateWorkflowExecutionData, WorkflowExecutionsCreateWorkflowExecutionResponse, WorkflowExecutionsGetWorkflowExecutionData, WorkflowExecutionsGetWorkflowExecutionResponse, WorkflowExecutionsListWorkflowExecutionEventHistoryData, WorkflowExecutionsListWorkflowExecutionEventHistoryResponse, WorkflowExecutionsCancelWorkflowExecutionData, WorkflowExecutionsCancelWorkflowExecutionResponse, WorkflowExecutionsTerminateWorkflowExecutionData, WorkflowExecutionsTerminateWorkflowExecutionResponse, ActionsListActionsData, ActionsListActionsResponse, ActionsCreateActionData, ActionsCreateActionResponse, ActionsGetActionData, ActionsGetActionResponse, ActionsUpdateActionData, ActionsUpdateActionResponse, ActionsDeleteActionData, ActionsDeleteActionResponse, WorkflowsListTagsData, WorkflowsListTagsResponse, WorkflowsAddTagData, WorkflowsAddTagResponse, WorkflowsRemoveTagData, WorkflowsRemoveTagResponse, SecretsSearchSecretsData, SecretsSearchSecretsResponse, SecretsListSecretsData, SecretsListSecretsResponse, SecretsCreateSecretData, SecretsCreateSecretResponse, SecretsGetSecretByNameData, SecretsGetSecretByNameResponse, SecretsUpdateSecretByIdData, SecretsUpdateSecretByIdResponse, SecretsDeleteSecretByIdData, SecretsDeleteSecretByIdResponse, SchedulesListSchedulesData, SchedulesListSchedulesResponse, SchedulesCreateScheduleData, SchedulesCreateScheduleResponse, SchedulesGetScheduleData, SchedulesGetScheduleResponse, SchedulesUpdateScheduleData, SchedulesUpdateScheduleResponse, SchedulesDeleteScheduleData, SchedulesDeleteScheduleResponse, SchedulesSearchSchedulesData, SchedulesSearchSchedulesResponse, TagsListTagsData, TagsListTagsResponse, TagsCreateTagData, TagsCreateTagResponse, TagsGetTagData, TagsGetTagResponse, TagsUpdateTagData, TagsUpdateTagResponse, TagsDeleteTagData, TagsDeleteTagResponse, UsersSearchUserData, UsersSearchUserResponse, OrganizationListOrgMembersResponse, OrganizationDeleteOrgMemberData, OrganizationDeleteOrgMemberResponse, OrganizationUpdateOrgMemberData, OrganizationUpdateOrgMemberResponse, OrganizationListSessionsResponse, OrganizationDeleteSessionData, OrganizationDeleteSessionResponse, EditorListFunctionsData, EditorListFunctionsResponse, EditorListActionsData, EditorListActionsResponse, RegistryRepositoriesSyncRegistryRepositoryData, RegistryRepositoriesSyncRegistryRepositoryResponse, RegistryRepositoriesSyncExecutorFromRegistryRepositoryData, RegistryRepositoriesSyncExecutorFromRegistryRepositoryResponse, RegistryRepositoriesListRegistryRepositoriesResponse, RegistryRepositoriesCreateRegistryRepositoryData, RegistryRepositoriesCreateRegistryRepositoryResponse, RegistryRepositoriesGetRegistryRepositoryData, RegistryRepositoriesGetRegistryRepositoryResponse, RegistryRepositoriesUpdateRegistryRepositoryData, RegistryRepositoriesUpdateRegistryRepositoryResponse, RegistryRepositoriesDeleteRegistryRepositoryData, RegistryRepositoriesDeleteRegistryRepositoryResponse, RegistryActionsListRegistryActionsResponse, RegistryActionsCreateRegistryActionData, RegistryActionsCreateRegistryActionResponse, RegistryActionsGetRegistryActionData, RegistryActionsGetRegistryActionResponse, RegistryActionsUpdateRegistryActionData, RegistryActionsUpdateRegistryActionResponse, RegistryActionsDeleteRegistryActionData, RegistryActionsDeleteRegistryActionResponse, UsersUsersCurrentUserResponse, UsersUsersPatchCurrentUserData, UsersUsersPatchCurrentUserResponse, UsersUsersUserData, UsersUsersUserResponse, UsersUsersPatchUserData, UsersUsersPatchUserResponse, UsersUsersDeleteUserData, UsersUsersDeleteUserResponse, AuthAuthDatabaseLoginData, AuthAuthDatabaseLoginResponse, AuthAuthDatabaseLogoutResponse, AuthRegisterRegisterData, AuthRegisterRegisterResponse, AuthResetForgotPasswordData, AuthResetForgotPasswordResponse, AuthResetResetPasswordData, AuthResetResetPasswordResponse, AuthVerifyRequestTokenData, AuthVerifyRequestTokenResponse, AuthVerifyVerifyData, AuthVerifyVerifyResponse, AuthOauthGoogleDatabaseAuthorizeData, AuthOauthGoogleDatabaseAuthorizeResponse, AuthOauthGoogleDatabaseCallbackData, AuthOauthGoogleDatabaseCallbackResponse, AuthSamlDatabaseLoginResponse, AuthSsoAcsData, AuthSsoAcsResponse, PublicCheckHealthResponse } from './types.gen';

/**
 * Incoming Webhook
 * Webhook endpoint to trigger a workflow.
 *
 * This is an external facing endpoint is used to trigger a workflow by sending a webhook request.
 * The workflow is identified by the `path` parameter, which is equivalent to the workflow id.
 * @param data The data for the request.
 * @param data.path
 * @param data.secret
 * @param data.contentType
 * @returns CreateWorkflowExecutionResponse Successful Response
 * @throws ApiError
 */
export const publicIncomingWebhook = (data: PublicIncomingWebhookData): CancelablePromise<PublicIncomingWebhookResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/webhooks/{path}/{secret}',
    path: {
        path: data.path,
        secret: data.secret
    },
    headers: {
        'content-type': data.contentType
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Incoming Webhook Wait
 * Webhook endpoint to trigger a workflow.
 *
 * This is an external facing endpoint is used to trigger a workflow by sending a webhook request.
 * The workflow is identified by the `path` parameter, which is equivalent to the workflow id.
 * @param data The data for the request.
 * @param data.path
 * @param data.secret
 * @param data.contentType
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const publicIncomingWebhookWait = (data: PublicIncomingWebhookWaitData): CancelablePromise<PublicIncomingWebhookWaitResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/webhooks/{path}/{secret}/wait',
    path: {
        path: data.path,
        secret: data.secret
    },
    headers: {
        'content-type': data.contentType
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Workspaces
 * List workspaces.
 *
 * Access Level
 * ------------
 * - Basic: Can list workspaces where they are a member.
 * - Admin: Can list all workspaces regardless of membership.
 * @returns WorkspaceMetadataResponse Successful Response
 * @throws ApiError
 */
export const workspacesListWorkspaces = (): CancelablePromise<WorkspacesListWorkspacesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workspaces'
}); };

/**
 * Create Workspace
 * Create a new workspace.
 *
 * Access Level
 * ------------
 * - Admin: Can create a workspace for any user.
 * @param data The data for the request.
 * @param data.requestBody
 * @returns WorkspaceMetadataResponse Successful Response
 * @throws ApiError
 */
export const workspacesCreateWorkspace = (data: WorkspacesCreateWorkspaceData): CancelablePromise<WorkspacesCreateWorkspaceResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workspaces',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Search Workspaces
 * Return Workflow as title, description, list of Action JSONs, adjacency list of Action IDs.
 * @param data The data for the request.
 * @param data.name
 * @returns WorkspaceMetadataResponse Successful Response
 * @throws ApiError
 */
export const workspacesSearchWorkspaces = (data: WorkspacesSearchWorkspacesData = {}): CancelablePromise<WorkspacesSearchWorkspacesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workspaces/search',
    query: {
        name: data.name
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Workspace
 * Return Workflow as title, description, list of Action JSONs, adjacency list of Action IDs.
 * @param data The data for the request.
 * @param data.workspaceId
 * @returns WorkspaceResponse Successful Response
 * @throws ApiError
 */
export const workspacesGetWorkspace = (data: WorkspacesGetWorkspaceData): CancelablePromise<WorkspacesGetWorkspaceResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workspaces/{workspace_id}',
    path: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Workspace
 * Update a workspace.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns void Successful Response
 * @throws ApiError
 */
export const workspacesUpdateWorkspace = (data: WorkspacesUpdateWorkspaceData): CancelablePromise<WorkspacesUpdateWorkspaceResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/workspaces/{workspace_id}',
    path: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Workspace
 * Delete a workspace.
 * @param data The data for the request.
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const workspacesDeleteWorkspace = (data: WorkspacesDeleteWorkspaceData): CancelablePromise<WorkspacesDeleteWorkspaceResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/workspaces/{workspace_id}',
    path: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Workspace Memberships
 * List memberships of a workspace.
 * @param data The data for the request.
 * @param data.workspaceId
 * @returns WorkspaceMembershipResponse Successful Response
 * @throws ApiError
 */
export const workspacesListWorkspaceMemberships = (data: WorkspacesListWorkspaceMembershipsData): CancelablePromise<WorkspacesListWorkspaceMembershipsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workspaces/{workspace_id}/memberships',
    path: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Workspace Membership
 * Create a workspace membership for a user.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const workspacesCreateWorkspaceMembership = (data: WorkspacesCreateWorkspaceMembershipData): CancelablePromise<WorkspacesCreateWorkspaceMembershipResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workspaces/{workspace_id}/memberships',
    path: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Workspace Membership
 * Get a workspace membership for a user.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.userId
 * @returns WorkspaceMembershipResponse Successful Response
 * @throws ApiError
 */
export const workspacesGetWorkspaceMembership = (data: WorkspacesGetWorkspaceMembershipData): CancelablePromise<WorkspacesGetWorkspaceMembershipResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workspaces/{workspace_id}/memberships/{user_id}',
    path: {
        workspace_id: data.workspaceId,
        user_id: data.userId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Workspace Membership
 * Delete a workspace membership.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.userId
 * @returns void Successful Response
 * @throws ApiError
 */
export const workspacesDeleteWorkspaceMembership = (data: WorkspacesDeleteWorkspaceMembershipData): CancelablePromise<WorkspacesDeleteWorkspaceMembershipResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/workspaces/{workspace_id}/memberships/{user_id}',
    path: {
        workspace_id: data.workspaceId,
        user_id: data.userId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Workflows
 * List workflows.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.tag Filter workflows by tags
 * @returns WorkflowReadMinimal Successful Response
 * @throws ApiError
 */
export const workflowsListWorkflows = (data: WorkflowsListWorkflowsData): CancelablePromise<WorkflowsListWorkflowsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows',
    query: {
        tag: data.tag,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Workflow
 * Create a new Workflow.
 *
 * Optionally, you can provide a YAML file to create a workflow.
 * You can also provide a title and description to create a blank workflow.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.formData
 * @returns WorkflowReadMinimal Successful Response
 * @throws ApiError
 */
export const workflowsCreateWorkflow = (data: WorkflowsCreateWorkflowData): CancelablePromise<WorkflowsCreateWorkflowResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflows',
    query: {
        workspace_id: data.workspaceId
    },
    formData: data.formData,
    mediaType: 'multipart/form-data',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Workflow
 * Return Workflow as title, description, list of Action JSONs, adjacency list of Action IDs.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns WorkflowRead Successful Response
 * @throws ApiError
 */
export const workflowsGetWorkflow = (data: WorkflowsGetWorkflowData): CancelablePromise<WorkflowsGetWorkflowResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows/{workflow_id}',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Workflow
 * Update a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns void Successful Response
 * @throws ApiError
 */
export const workflowsUpdateWorkflow = (data: WorkflowsUpdateWorkflowData): CancelablePromise<WorkflowsUpdateWorkflowResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/workflows/{workflow_id}',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Workflow
 * Delete a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const workflowsDeleteWorkflow = (data: WorkflowsDeleteWorkflowData): CancelablePromise<WorkflowsDeleteWorkflowResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/workflows/{workflow_id}',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Commit Workflow
 * Commit a workflow.
 *
 * This deploys the workflow and updates its version. If a YAML file is provided, it will override the workflow in the database.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns WorkflowCommitResponse Successful Response
 * @throws ApiError
 */
export const workflowsCommitWorkflow = (data: WorkflowsCommitWorkflowData): CancelablePromise<WorkflowsCommitWorkflowResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflows/{workflow_id}/commit',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Export Workflow
 * Export a workflow's current state and optionally its definitions and logs.
 *
 * Supported formats are JSON and CSV.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.format Export format: 'json' or 'yaml'
 * @param data.version Workflow definition version. If not provided, the latest version is exported.
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const workflowsExportWorkflow = (data: WorkflowsExportWorkflowData): CancelablePromise<WorkflowsExportWorkflowResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows/{workflow_id}/export',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        format: data.format,
        version: data.version,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Workflow Definition
 * Get the latest version of a workflow definition.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.version
 * @returns WorkflowDefinition Successful Response
 * @throws ApiError
 */
export const workflowsGetWorkflowDefinition = (data: WorkflowsGetWorkflowDefinitionData): CancelablePromise<WorkflowsGetWorkflowDefinitionResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows/{workflow_id}/definition',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        version: data.version,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Workflow Definition
 * Get the latest version of a workflow definition.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns WorkflowDefinition Successful Response
 * @throws ApiError
 */
export const workflowsCreateWorkflowDefinition = (data: WorkflowsCreateWorkflowDefinitionData): CancelablePromise<WorkflowsCreateWorkflowDefinitionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflows/{workflow_id}/definition',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Webhook
 * Create a webhook for a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const triggersCreateWebhook = (data: TriggersCreateWebhookData): CancelablePromise<TriggersCreateWebhookResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflows/{workflow_id}/webhook',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Webhook
 * Get the webhook from a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns WebhookResponse Successful Response
 * @throws ApiError
 */
export const triggersGetWebhook = (data: TriggersGetWebhookData): CancelablePromise<TriggersGetWebhookResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows/{workflow_id}/webhook',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Webhook
 * Update the webhook for a workflow. We currently supprt only one webhook per workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns void Successful Response
 * @throws ApiError
 */
export const triggersUpdateWebhook = (data: TriggersUpdateWebhookData): CancelablePromise<TriggersUpdateWebhookResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/workflows/{workflow_id}/webhook',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Workflow Executions
 * List all workflow executions.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.workflowId
 * @returns WorkflowExecutionResponse Successful Response
 * @throws ApiError
 */
export const workflowExecutionsListWorkflowExecutions = (data: WorkflowExecutionsListWorkflowExecutionsData): CancelablePromise<WorkflowExecutionsListWorkflowExecutionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflow-executions',
    query: {
        workflow_id: data.workflowId,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Workflow Execution
 * Create and schedule a workflow execution.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns CreateWorkflowExecutionResponse Successful Response
 * @throws ApiError
 */
export const workflowExecutionsCreateWorkflowExecution = (data: WorkflowExecutionsCreateWorkflowExecutionData): CancelablePromise<WorkflowExecutionsCreateWorkflowExecutionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflow-executions',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Workflow Execution
 * Get a workflow execution.
 * @param data The data for the request.
 * @param data.executionId
 * @param data.workspaceId
 * @returns WorkflowExecutionResponse Successful Response
 * @throws ApiError
 */
export const workflowExecutionsGetWorkflowExecution = (data: WorkflowExecutionsGetWorkflowExecutionData): CancelablePromise<WorkflowExecutionsGetWorkflowExecutionResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflow-executions/{execution_id}',
    path: {
        execution_id: data.executionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Workflow Execution Event History
 * Get a workflow execution.
 * @param data The data for the request.
 * @param data.executionId
 * @param data.workspaceId
 * @returns EventHistoryResponse Successful Response
 * @throws ApiError
 */
export const workflowExecutionsListWorkflowExecutionEventHistory = (data: WorkflowExecutionsListWorkflowExecutionEventHistoryData): CancelablePromise<WorkflowExecutionsListWorkflowExecutionEventHistoryResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflow-executions/{execution_id}/history',
    path: {
        execution_id: data.executionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Cancel Workflow Execution
 * Get a workflow execution.
 * @param data The data for the request.
 * @param data.executionId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const workflowExecutionsCancelWorkflowExecution = (data: WorkflowExecutionsCancelWorkflowExecutionData): CancelablePromise<WorkflowExecutionsCancelWorkflowExecutionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflow-executions/{execution_id}/cancel',
    path: {
        execution_id: data.executionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Terminate Workflow Execution
 * Get a workflow execution.
 * @param data The data for the request.
 * @param data.executionId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns void Successful Response
 * @throws ApiError
 */
export const workflowExecutionsTerminateWorkflowExecution = (data: WorkflowExecutionsTerminateWorkflowExecutionData): CancelablePromise<WorkflowExecutionsTerminateWorkflowExecutionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflow-executions/{execution_id}/terminate',
    path: {
        execution_id: data.executionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Actions
 * List all actions for a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns ActionReadMinimal Successful Response
 * @throws ApiError
 */
export const actionsListActions = (data: ActionsListActionsData): CancelablePromise<ActionsListActionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/actions',
    query: {
        workflow_id: data.workflowId,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Action
 * Create a new action for a workflow.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns ActionReadMinimal Successful Response
 * @throws ApiError
 */
export const actionsCreateAction = (data: ActionsCreateActionData): CancelablePromise<ActionsCreateActionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/actions',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Action
 * Get an action.
 * @param data The data for the request.
 * @param data.actionId
 * @param data.workflowId
 * @param data.workspaceId
 * @returns ActionRead Successful Response
 * @throws ApiError
 */
export const actionsGetAction = (data: ActionsGetActionData): CancelablePromise<ActionsGetActionResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/actions/{action_id}',
    path: {
        action_id: data.actionId
    },
    query: {
        workflow_id: data.workflowId,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Action
 * Update an action.
 * @param data The data for the request.
 * @param data.actionId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns ActionRead Successful Response
 * @throws ApiError
 */
export const actionsUpdateAction = (data: ActionsUpdateActionData): CancelablePromise<ActionsUpdateActionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/actions/{action_id}',
    path: {
        action_id: data.actionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Action
 * Delete an action.
 * @param data The data for the request.
 * @param data.actionId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const actionsDeleteAction = (data: ActionsDeleteActionData): CancelablePromise<ActionsDeleteActionResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/actions/{action_id}',
    path: {
        action_id: data.actionId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Tags
 * List all tags for a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns TagRead Successful Response
 * @throws ApiError
 */
export const workflowsListTags = (data: WorkflowsListTagsData): CancelablePromise<WorkflowsListTagsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/workflows/{workflow_id}/tags',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Add Tag
 * Add a tag to a workflow.
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const workflowsAddTag = (data: WorkflowsAddTagData): CancelablePromise<WorkflowsAddTagResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/workflows/{workflow_id}/tags',
    path: {
        workflow_id: data.workflowId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Remove Tag
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.tagId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const workflowsRemoveTag = (data: WorkflowsRemoveTagData): CancelablePromise<WorkflowsRemoveTagResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/workflows/{workflow_id}/tags/{tag_id}',
    path: {
        workflow_id: data.workflowId,
        tag_id: data.tagId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Search Secrets
 * Search secrets.
 * @param data The data for the request.
 * @param data.environment
 * @param data.name Filter by secret name
 * @param data.id Filter by secret ID
 * @param data.type Filter by secret type
 * @param data.level Filter by secret level
 * @param data.workspaceId
 * @returns SecretRead Successful Response
 * @throws ApiError
 */
export const secretsSearchSecrets = (data: SecretsSearchSecretsData): CancelablePromise<SecretsSearchSecretsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/secrets/search',
    query: {
        environment: data.environment,
        name: data.name,
        id: data.id,
        type: data.type,
        level: data.level,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Secrets
 * List user secrets.
 * @param data The data for the request.
 * @param data.type Filter by secret type
 * @param data.level Filter by secret level
 * @param data.workspaceId
 * @returns SecretReadMinimal Successful Response
 * @throws ApiError
 */
export const secretsListSecrets = (data: SecretsListSecretsData = {}): CancelablePromise<SecretsListSecretsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/secrets',
    query: {
        type: data.type,
        level: data.level,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Secret
 * Create a secret.
 * @param data The data for the request.
 * @param data.requestBody
 * @param data.workspaceId
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const secretsCreateSecret = (data: SecretsCreateSecretData): CancelablePromise<SecretsCreateSecretResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/secrets',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Secret By Name
 * Get a secret.
 * @param data The data for the request.
 * @param data.secretName
 * @param data.workspaceId
 * @returns SecretRead Successful Response
 * @throws ApiError
 */
export const secretsGetSecretByName = (data: SecretsGetSecretByNameData): CancelablePromise<SecretsGetSecretByNameResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/secrets/{secret_name}',
    path: {
        secret_name: data.secretName
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Secret By Id
 * Update a secret by ID.
 * @param data The data for the request.
 * @param data.secretId
 * @param data.requestBody
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const secretsUpdateSecretById = (data: SecretsUpdateSecretByIdData): CancelablePromise<SecretsUpdateSecretByIdResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/secrets/{secret_id}',
    path: {
        secret_id: data.secretId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Secret By Id
 * Delete a secret by ID.
 * @param data The data for the request.
 * @param data.secretId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const secretsDeleteSecretById = (data: SecretsDeleteSecretByIdData): CancelablePromise<SecretsDeleteSecretByIdResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/secrets/{secret_id}',
    path: {
        secret_id: data.secretId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Schedules
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.workflowId
 * @returns Schedule Successful Response
 * @throws ApiError
 */
export const schedulesListSchedules = (data: SchedulesListSchedulesData): CancelablePromise<SchedulesListSchedulesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/schedules',
    query: {
        workflow_id: data.workflowId,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Schedule
 * Create a schedule for a workflow.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns Schedule Successful Response
 * @throws ApiError
 */
export const schedulesCreateSchedule = (data: SchedulesCreateScheduleData): CancelablePromise<SchedulesCreateScheduleResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/schedules',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Schedule
 * Get a schedule from a workflow.
 * @param data The data for the request.
 * @param data.scheduleId
 * @param data.workspaceId
 * @returns Schedule Successful Response
 * @throws ApiError
 */
export const schedulesGetSchedule = (data: SchedulesGetScheduleData): CancelablePromise<SchedulesGetScheduleResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/schedules/{schedule_id}',
    path: {
        schedule_id: data.scheduleId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Schedule
 * Update a schedule from a workflow. You cannot update the Workflow Definition, but you can update other fields.
 * @param data The data for the request.
 * @param data.scheduleId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns Schedule Successful Response
 * @throws ApiError
 */
export const schedulesUpdateSchedule = (data: SchedulesUpdateScheduleData): CancelablePromise<SchedulesUpdateScheduleResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/schedules/{schedule_id}',
    path: {
        schedule_id: data.scheduleId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Schedule
 * Delete a schedule from a workflow.
 * @param data The data for the request.
 * @param data.scheduleId
 * @param data.workspaceId
 * @returns void Successful Response
 * @throws ApiError
 */
export const schedulesDeleteSchedule = (data: SchedulesDeleteScheduleData): CancelablePromise<SchedulesDeleteScheduleResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/schedules/{schedule_id}',
    path: {
        schedule_id: data.scheduleId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Search Schedules
 * **[WORK IN PROGRESS]** Search for schedules.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns Schedule Successful Response
 * @throws ApiError
 */
export const schedulesSearchSchedules = (data: SchedulesSearchSchedulesData): CancelablePromise<SchedulesSearchSchedulesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/schedules/search',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Tags
 * List all tags for the current workspace.
 * @param data The data for the request.
 * @param data.workspaceId
 * @returns TagRead Successful Response
 * @throws ApiError
 */
export const tagsListTags = (data: TagsListTagsData): CancelablePromise<TagsListTagsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/tags',
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Create Tag
 * Create a new tag.
 * @param data The data for the request.
 * @param data.workspaceId
 * @param data.requestBody
 * @returns TagRead Successful Response
 * @throws ApiError
 */
export const tagsCreateTag = (data: TagsCreateTagData): CancelablePromise<TagsCreateTagResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/tags',
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Tag
 * Get a specific tag by ID.
 * @param data The data for the request.
 * @param data.tagId
 * @param data.workspaceId
 * @returns TagRead Successful Response
 * @throws ApiError
 */
export const tagsGetTag = (data: TagsGetTagData): CancelablePromise<TagsGetTagResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/tags/{tag_id}',
    path: {
        tag_id: data.tagId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Tag
 * Update an existing tag.
 * @param data The data for the request.
 * @param data.tagId
 * @param data.workspaceId
 * @param data.requestBody
 * @returns TagRead Successful Response
 * @throws ApiError
 */
export const tagsUpdateTag = (data: TagsUpdateTagData): CancelablePromise<TagsUpdateTagResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/tags/{tag_id}',
    path: {
        tag_id: data.tagId
    },
    query: {
        workspace_id: data.workspaceId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Tag
 * Delete a tag.
 * @param data The data for the request.
 * @param data.tagId
 * @param data.workspaceId
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const tagsDeleteTag = (data: TagsDeleteTagData): CancelablePromise<TagsDeleteTagResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/tags/{tag_id}',
    path: {
        tag_id: data.tagId
    },
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Search User
 * Create new user.
 * @param data The data for the request.
 * @param data.email
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const usersSearchUser = (data: UsersSearchUserData = {}): CancelablePromise<UsersSearchUserResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/users/search',
    query: {
        email: data.email
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Org Members
 * @returns OrgMemberRead Successful Response
 * @throws ApiError
 */
export const organizationListOrgMembers = (): CancelablePromise<OrganizationListOrgMembersResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/organization/members'
}); };

/**
 * Delete Org Member
 * @param data The data for the request.
 * @param data.userId
 * @returns void Successful Response
 * @throws ApiError
 */
export const organizationDeleteOrgMember = (data: OrganizationDeleteOrgMemberData): CancelablePromise<OrganizationDeleteOrgMemberResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/organization/members/{user_id}',
    path: {
        user_id: data.userId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Org Member
 * @param data The data for the request.
 * @param data.userId
 * @param data.requestBody
 * @returns OrgMemberRead Successful Response
 * @throws ApiError
 */
export const organizationUpdateOrgMember = (data: OrganizationUpdateOrgMemberData): CancelablePromise<OrganizationUpdateOrgMemberResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/organization/members/{user_id}',
    path: {
        user_id: data.userId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Sessions
 * @returns SessionRead Successful Response
 * @throws ApiError
 */
export const organizationListSessions = (): CancelablePromise<OrganizationListSessionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/organization/sessions'
}); };

/**
 * Delete Session
 * @param data The data for the request.
 * @param data.sessionId
 * @returns void Successful Response
 * @throws ApiError
 */
export const organizationDeleteSession = (data: OrganizationDeleteSessionData): CancelablePromise<OrganizationDeleteSessionResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/organization/sessions/{session_id}',
    path: {
        session_id: data.sessionId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Functions
 * @param data The data for the request.
 * @param data.workspaceId
 * @returns EditorFunctionRead Successful Response
 * @throws ApiError
 */
export const editorListFunctions = (data: EditorListFunctionsData): CancelablePromise<EditorListFunctionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/editor/functions',
    query: {
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Actions
 * @param data The data for the request.
 * @param data.workflowId
 * @param data.workspaceId
 * @returns EditorActionRead Successful Response
 * @throws ApiError
 */
export const editorListActions = (data: EditorListActionsData): CancelablePromise<EditorListActionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/editor/actions',
    query: {
        workflow_id: data.workflowId,
        workspace_id: data.workspaceId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Sync Registry Repository
 * Load actions from a specific registry repository.
 * @param data The data for the request.
 * @param data.repositoryId
 * @returns void Successful Response
 * @throws ApiError
 */
export const registryRepositoriesSyncRegistryRepository = (data: RegistryRepositoriesSyncRegistryRepositoryData): CancelablePromise<RegistryRepositoriesSyncRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/registry/repos/{repository_id}/sync',
    path: {
        repository_id: data.repositoryId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Sync Executor From Registry Repository
 * @param data The data for the request.
 * @param data.repositoryId
 * @returns void Successful Response
 * @throws ApiError
 */
export const registryRepositoriesSyncExecutorFromRegistryRepository = (data: RegistryRepositoriesSyncExecutorFromRegistryRepositoryData): CancelablePromise<RegistryRepositoriesSyncExecutorFromRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/registry/repos/{repository_id}/sync-executor',
    path: {
        repository_id: data.repositoryId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Registry Repositories
 * List all registry repositories.
 * @returns RegistryRepositoryReadMinimal Successful Response
 * @throws ApiError
 */
export const registryRepositoriesListRegistryRepositories = (): CancelablePromise<RegistryRepositoriesListRegistryRepositoriesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/registry/repos'
}); };

/**
 * Create Registry Repository
 * Create a new registry repository.
 * @param data The data for the request.
 * @param data.requestBody
 * @returns RegistryRepositoryRead Successful Response
 * @throws ApiError
 */
export const registryRepositoriesCreateRegistryRepository = (data: RegistryRepositoriesCreateRegistryRepositoryData): CancelablePromise<RegistryRepositoriesCreateRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/registry/repos',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Registry Repository
 * Get a specific registry repository by origin.
 * @param data The data for the request.
 * @param data.repositoryId
 * @returns RegistryRepositoryRead Successful Response
 * @throws ApiError
 */
export const registryRepositoriesGetRegistryRepository = (data: RegistryRepositoriesGetRegistryRepositoryData): CancelablePromise<RegistryRepositoriesGetRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/registry/repos/{repository_id}',
    path: {
        repository_id: data.repositoryId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Registry Repository
 * Update an existing registry repository.
 * @param data The data for the request.
 * @param data.repositoryId
 * @param data.requestBody
 * @returns RegistryRepositoryRead Successful Response
 * @throws ApiError
 */
export const registryRepositoriesUpdateRegistryRepository = (data: RegistryRepositoriesUpdateRegistryRepositoryData): CancelablePromise<RegistryRepositoriesUpdateRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/registry/repos/{repository_id}',
    path: {
        repository_id: data.repositoryId
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Registry Repository
 * Delete a registry repository.
 * @param data The data for the request.
 * @param data.repositoryId
 * @returns void Successful Response
 * @throws ApiError
 */
export const registryRepositoriesDeleteRegistryRepository = (data: RegistryRepositoriesDeleteRegistryRepositoryData): CancelablePromise<RegistryRepositoriesDeleteRegistryRepositoryResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/registry/repos/{repository_id}',
    path: {
        repository_id: data.repositoryId
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * List Registry Actions
 * List all actions in a registry.
 * @returns RegistryActionRead Successful Response
 * @throws ApiError
 */
export const registryActionsListRegistryActions = (): CancelablePromise<RegistryActionsListRegistryActionsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/registry/actions'
}); };

/**
 * Create Registry Action
 * Create a new registry action.
 * @param data The data for the request.
 * @param data.requestBody
 * @returns RegistryActionRead Successful Response
 * @throws ApiError
 */
export const registryActionsCreateRegistryAction = (data: RegistryActionsCreateRegistryActionData): CancelablePromise<RegistryActionsCreateRegistryActionResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/registry/actions',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Get Registry Action
 * Get a specific registry action.
 * @param data The data for the request.
 * @param data.actionName
 * @returns RegistryActionRead Successful Response
 * @throws ApiError
 */
export const registryActionsGetRegistryAction = (data: RegistryActionsGetRegistryActionData): CancelablePromise<RegistryActionsGetRegistryActionResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/registry/actions/{action_name}',
    path: {
        action_name: data.actionName
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Update Registry Action
 * Update a custom registry action.
 * @param data The data for the request.
 * @param data.actionName
 * @param data.requestBody
 * @returns void Successful Response
 * @throws ApiError
 */
export const registryActionsUpdateRegistryAction = (data: RegistryActionsUpdateRegistryActionData): CancelablePromise<RegistryActionsUpdateRegistryActionResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/registry/actions/{action_name}',
    path: {
        action_name: data.actionName
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Delete Registry Action
 * Delete a template action.
 * @param data The data for the request.
 * @param data.actionName
 * @returns void Successful Response
 * @throws ApiError
 */
export const registryActionsDeleteRegistryAction = (data: RegistryActionsDeleteRegistryActionData): CancelablePromise<RegistryActionsDeleteRegistryActionResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/registry/actions/{action_name}',
    path: {
        action_name: data.actionName
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Users:Current User
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const usersUsersCurrentUser = (): CancelablePromise<UsersUsersCurrentUserResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/users/me',
    errors: {
        401: 'Missing token or inactive user.'
    }
}); };

/**
 * Users:Patch Current User
 * @param data The data for the request.
 * @param data.requestBody
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const usersUsersPatchCurrentUser = (data: UsersUsersPatchCurrentUserData): CancelablePromise<UsersUsersPatchCurrentUserResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/users/me',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        400: 'Bad Request',
        401: 'Missing token or inactive user.',
        422: 'Validation Error'
    }
}); };

/**
 * Users:User
 * @param data The data for the request.
 * @param data.id
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const usersUsersUser = (data: UsersUsersUserData): CancelablePromise<UsersUsersUserResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/users/{id}',
    path: {
        id: data.id
    },
    errors: {
        401: 'Missing token or inactive user.',
        403: 'Not a superuser.',
        404: 'The user does not exist.',
        422: 'Validation Error'
    }
}); };

/**
 * Users:Patch User
 * @param data The data for the request.
 * @param data.id
 * @param data.requestBody
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const usersUsersPatchUser = (data: UsersUsersPatchUserData): CancelablePromise<UsersUsersPatchUserResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/users/{id}',
    path: {
        id: data.id
    },
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        400: 'Bad Request',
        401: 'Missing token or inactive user.',
        403: 'Not a superuser.',
        404: 'The user does not exist.',
        422: 'Validation Error'
    }
}); };

/**
 * Users:Delete User
 * @param data The data for the request.
 * @param data.id
 * @returns void Successful Response
 * @throws ApiError
 */
export const usersUsersDeleteUser = (data: UsersUsersDeleteUserData): CancelablePromise<UsersUsersDeleteUserResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/users/{id}',
    path: {
        id: data.id
    },
    errors: {
        401: 'Missing token or inactive user.',
        403: 'Not a superuser.',
        404: 'The user does not exist.',
        422: 'Validation Error'
    }
}); };

/**
 * Auth:Database.Login
 * @param data The data for the request.
 * @param data.formData
 * @returns unknown Successful Response
 * @returns void No Content
 * @throws ApiError
 */
export const authAuthDatabaseLogin = (data: AuthAuthDatabaseLoginData): CancelablePromise<AuthAuthDatabaseLoginResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/login',
    formData: data.formData,
    mediaType: 'application/x-www-form-urlencoded',
    errors: {
        400: 'Bad Request',
        422: 'Validation Error'
    }
}); };

/**
 * Auth:Database.Logout
 * @returns unknown Successful Response
 * @returns void No Content
 * @throws ApiError
 */
export const authAuthDatabaseLogout = (): CancelablePromise<AuthAuthDatabaseLogoutResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/logout',
    errors: {
        401: 'Missing token or inactive user.'
    }
}); };

/**
 * Register:Register
 * @param data The data for the request.
 * @param data.requestBody
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const authRegisterRegister = (data: AuthRegisterRegisterData): CancelablePromise<AuthRegisterRegisterResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/register',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        400: 'Bad Request',
        422: 'Validation Error'
    }
}); };

/**
 * Reset:Forgot Password
 * @param data The data for the request.
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const authResetForgotPassword = (data: AuthResetForgotPasswordData): CancelablePromise<AuthResetForgotPasswordResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/forgot-password',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Reset:Reset Password
 * @param data The data for the request.
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const authResetResetPassword = (data: AuthResetResetPasswordData): CancelablePromise<AuthResetResetPasswordResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/reset-password',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        400: 'Bad Request',
        422: 'Validation Error'
    }
}); };

/**
 * Verify:Request-Token
 * @param data The data for the request.
 * @param data.requestBody
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const authVerifyRequestToken = (data: AuthVerifyRequestTokenData): CancelablePromise<AuthVerifyRequestTokenResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/request-verify-token',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Verify:Verify
 * @param data The data for the request.
 * @param data.requestBody
 * @returns UserRead Successful Response
 * @throws ApiError
 */
export const authVerifyVerify = (data: AuthVerifyVerifyData): CancelablePromise<AuthVerifyVerifyResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/verify',
    body: data.requestBody,
    mediaType: 'application/json',
    errors: {
        400: 'Bad Request',
        422: 'Validation Error'
    }
}); };

/**
 * Oauth:Google.Database.Authorize
 * @param data The data for the request.
 * @param data.scopes
 * @returns OAuth2AuthorizeResponse Successful Response
 * @throws ApiError
 */
export const authOauthGoogleDatabaseAuthorize = (data: AuthOauthGoogleDatabaseAuthorizeData = {}): CancelablePromise<AuthOauthGoogleDatabaseAuthorizeResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/auth/oauth/authorize',
    query: {
        scopes: data.scopes
    },
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Oauth:Google.Database.Callback
 * The response varies based on the authentication backend used.
 * @param data The data for the request.
 * @param data.code
 * @param data.codeVerifier
 * @param data.state
 * @param data.error
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const authOauthGoogleDatabaseCallback = (data: AuthOauthGoogleDatabaseCallbackData = {}): CancelablePromise<AuthOauthGoogleDatabaseCallbackResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/auth/oauth/callback',
    query: {
        code: data.code,
        code_verifier: data.codeVerifier,
        state: data.state,
        error: data.error
    },
    errors: {
        400: 'Bad Request',
        422: 'Validation Error'
    }
}); };

/**
 * Saml:Database.Login
 * @returns SAMLDatabaseLoginResponse Successful Response
 * @throws ApiError
 */
export const authSamlDatabaseLogin = (): CancelablePromise<AuthSamlDatabaseLoginResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/auth/saml/login'
}); };

/**
 * Sso Acs
 * Handle the SAML SSO response from the IdP post-authentication.
 * @param data The data for the request.
 * @param data.formData
 * @returns unknown Successful Response
 * @throws ApiError
 */
export const authSsoAcs = (data: AuthSsoAcsData): CancelablePromise<AuthSsoAcsResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/auth/saml/acs',
    formData: data.formData,
    mediaType: 'application/x-www-form-urlencoded',
    errors: {
        422: 'Validation Error'
    }
}); };

/**
 * Check Health
 * @returns string Successful Response
 * @throws ApiError
 */
export const publicCheckHealth = (): CancelablePromise<PublicCheckHealthResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/health'
}); };
