// This file is auto-generated by @hey-api/openapi-ts

export const $AccessLevel = {
    type: 'integer',
    enum: [0, 999],
    title: 'AccessLevel',
    description: 'Access control levels for roles.'
} as const;

export const $ActionControlFlow = {
    properties: {
        run_if: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Run If'
        },
        for_each: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'For Each'
        },
        retry_policy: {
            '$ref': '#/components/schemas/ActionRetryPolicy'
        },
        start_delay: {
            type: 'number',
            title: 'Start Delay',
            description: 'Delay before starting the action in seconds.',
            default: 0
        },
        join_strategy: {
            allOf: [
                {
                    '$ref': '#/components/schemas/JoinStrategy'
                }
            ],
            default: 'all'
        }
    },
    type: 'object',
    title: 'ActionControlFlow'
} as const;

export const $ActionCreate = {
    properties: {
        workflow_id: {
            type: 'string',
            title: 'Workflow Id'
        },
        type: {
            type: 'string',
            title: 'Type'
        },
        title: {
            type: 'string',
            title: 'Title'
        }
    },
    type: 'object',
    required: ['workflow_id', 'type', 'title'],
    title: 'ActionCreate'
} as const;

export const $ActionRead = {
    properties: {
        id: {
            type: 'string',
            title: 'Id'
        },
        type: {
            type: 'string',
            title: 'Type'
        },
        title: {
            type: 'string',
            title: 'Title'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        status: {
            type: 'string',
            title: 'Status'
        },
        inputs: {
            type: 'object',
            title: 'Inputs'
        },
        control_flow: {
            '$ref': '#/components/schemas/ActionControlFlow'
        }
    },
    type: 'object',
    required: ['id', 'type', 'title', 'description', 'status', 'inputs'],
    title: 'ActionRead'
} as const;

export const $ActionReadMinimal = {
    properties: {
        id: {
            type: 'string',
            title: 'Id'
        },
        workflow_id: {
            type: 'string',
            title: 'Workflow Id'
        },
        type: {
            type: 'string',
            title: 'Type'
        },
        title: {
            type: 'string',
            title: 'Title'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        status: {
            type: 'string',
            title: 'Status'
        }
    },
    type: 'object',
    required: ['id', 'workflow_id', 'type', 'title', 'description', 'status'],
    title: 'ActionReadMinimal'
} as const;

export const $ActionRetryPolicy = {
    properties: {
        max_attempts: {
            type: 'integer',
            title: 'Max Attempts',
            description: 'Total number of execution attempts. 0 means unlimited, 1 means no retries.',
            default: 1
        },
        timeout: {
            type: 'integer',
            title: 'Timeout',
            description: 'Timeout for the action in seconds.',
            default: 300
        }
    },
    type: 'object',
    title: 'ActionRetryPolicy'
} as const;

export const $ActionStatement = {
    properties: {
        ref: {
            type: 'string',
            pattern: '^[a-z0-9_]+$',
            title: 'Ref',
            description: 'Unique reference for the task'
        },
        description: {
            type: 'string',
            title: 'Description',
            default: ''
        },
        action: {
            type: 'string',
            pattern: '^[a-z0-9_.]+$',
            title: 'Action',
            description: 'Action type. Equivalent to the UDF key.'
        },
        args: {
            type: 'object',
            title: 'Args',
            description: 'Arguments for the action'
        },
        depends_on: {
            items: {
                type: 'string'
            },
            type: 'array',
            title: 'Depends On',
            description: 'Task dependencies'
        },
        run_if: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Run If',
            description: 'Condition to run the task'
        },
        for_each: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'For Each',
            description: 'Iterate over a list of items and run the task for each item.'
        },
        retry_policy: {
            allOf: [
                {
                    '$ref': '#/components/schemas/ActionRetryPolicy'
                }
            ],
            description: 'Retry policy for the action.'
        },
        start_delay: {
            type: 'number',
            title: 'Start Delay',
            description: 'Delay before starting the action in seconds.',
            default: 0
        },
        join_strategy: {
            allOf: [
                {
                    '$ref': '#/components/schemas/JoinStrategy'
                }
            ],
            description: 'The strategy to use when joining on this task. By default, all branches must complete successfully before the join task can complete.',
            default: 'all'
        }
    },
    type: 'object',
    required: ['ref', 'action'],
    title: 'ActionStatement'
} as const;

export const $ActionStep = {
    properties: {
        ref: {
            type: 'string',
            title: 'Ref',
            description: 'The reference of the step'
        },
        action: {
            type: 'string',
            title: 'Action'
        },
        args: {
            type: 'object',
            title: 'Args'
        }
    },
    type: 'object',
    required: ['ref', 'action', 'args'],
    title: 'ActionStep'
} as const;

export const $ActionUpdate = {
    properties: {
        title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Title'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        status: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Status'
        },
        inputs: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Inputs'
        },
        control_flow: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/ActionControlFlow'
                },
                {
                    type: 'null'
                }
            ]
        }
    },
    type: 'object',
    title: 'ActionUpdate'
} as const;

export const $Body_auth_reset_forgot_password = {
    properties: {
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        }
    },
    type: 'object',
    required: ['email'],
    title: 'Body_auth-reset:forgot_password'
} as const;

export const $Body_auth_reset_reset_password = {
    properties: {
        token: {
            type: 'string',
            title: 'Token'
        },
        password: {
            type: 'string',
            title: 'Password'
        }
    },
    type: 'object',
    required: ['token', 'password'],
    title: 'Body_auth-reset:reset_password'
} as const;

export const $Body_auth_sso_acs = {
    properties: {
        saml_response: {
            type: 'string',
            title: 'Saml Response'
        }
    },
    type: 'object',
    required: ['saml_response'],
    title: 'Body_auth-sso_acs'
} as const;

export const $Body_auth_verify_request_token = {
    properties: {
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        }
    },
    type: 'object',
    required: ['email'],
    title: 'Body_auth-verify:request-token'
} as const;

export const $Body_auth_verify_verify = {
    properties: {
        token: {
            type: 'string',
            title: 'Token'
        }
    },
    type: 'object',
    required: ['token'],
    title: 'Body_auth-verify:verify'
} as const;

export const $Body_workflows_create_workflow = {
    properties: {
        title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Title'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        file: {
            anyOf: [
                {
                    type: 'string',
                    format: 'binary'
                },
                {
                    type: 'null'
                }
            ],
            title: 'File'
        }
    },
    type: 'object',
    title: 'Body_workflows-create_workflow'
} as const;

export const $CreateWorkflowExecutionParams = {
    properties: {
        workflow_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Workflow Id'
        },
        inputs: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Inputs'
        }
    },
    type: 'object',
    required: ['workflow_id'],
    title: 'CreateWorkflowExecutionParams'
} as const;

export const $CreateWorkflowExecutionResponse = {
    properties: {
        message: {
            type: 'string',
            title: 'Message'
        },
        wf_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Wf Id'
        },
        wf_exec_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}:(exec-[\\w-]+|sch-[0-9a-f]{32}-.*)',
            title: 'Wf Exec Id'
        }
    },
    type: 'object',
    required: ['message', 'wf_id', 'wf_exec_id'],
    title: 'CreateWorkflowExecutionResponse'
} as const;

export const $CreateWorkspaceMembershipParams = {
    properties: {
        user_id: {
            type: 'string',
            format: 'uuid4',
            title: 'User Id'
        }
    },
    type: 'object',
    required: ['user_id'],
    title: 'CreateWorkspaceMembershipParams'
} as const;

export const $CreateWorkspaceParams = {
    properties: {
        name: {
            type: 'string',
            title: 'Name'
        },
        settings: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Settings'
        },
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id',
            default: '00000000-0000-0000-0000-000000000000'
        }
    },
    type: 'object',
    required: ['name'],
    title: 'CreateWorkspaceParams'
} as const;

export const $DSLConfig_Input = {
    properties: {
        scheduler: {
            type: 'string',
            enum: ['static', 'dynamic'],
            title: 'Scheduler',
            description: 'The type of scheduler to use.',
            default: 'dynamic'
        },
        environment: {
            type: 'string',
            title: 'Environment',
            description: "The workflow's target execution environment. This is used to isolate secrets across different environments.If not provided, the default environment (default) is used.",
            default: 'default'
        },
        timeout: {
            type: 'number',
            title: 'Timeout',
            description: 'The maximum number of seconds to wait for the workflow to complete.',
            default: 300
        }
    },
    type: 'object',
    title: 'DSLConfig',
    description: `This is the runtime configuration for the workflow.

Activities don't need access to this.`
} as const;

export const $DSLConfig_Output = {
    properties: {
        environment: {
            type: 'string',
            title: 'Environment',
            description: "The workflow's target execution environment. This is used to isolate secrets across different environments.If not provided, the default environment (default) is used.",
            default: 'default'
        },
        timeout: {
            type: 'number',
            title: 'Timeout',
            description: 'The maximum number of seconds to wait for the workflow to complete.',
            default: 300
        }
    },
    type: 'object',
    title: 'DSLConfig',
    description: `This is the runtime configuration for the workflow.

Activities don't need access to this.`
} as const;

export const $DSLEntrypoint = {
    properties: {
        ref: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Ref',
            description: 'The entrypoint action ref'
        },
        expects: {
            anyOf: [
                {
                    additionalProperties: {
                        '$ref': '#/components/schemas/ExpectedField'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Expects',
            description: 'Expected trigger input schema. Use this to specify the expected shape of the trigger input.'
        }
    },
    type: 'object',
    title: 'DSLEntrypoint'
} as const;

export const $DSLInput = {
    properties: {
        title: {
            type: 'string',
            title: 'Title'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        entrypoint: {
            '$ref': '#/components/schemas/DSLEntrypoint'
        },
        actions: {
            items: {
                '$ref': '#/components/schemas/ActionStatement'
            },
            type: 'array',
            title: 'Actions'
        },
        config: {
            '$ref': '#/components/schemas/DSLConfig-Output'
        },
        triggers: {
            items: {
                '$ref': '#/components/schemas/Trigger'
            },
            type: 'array',
            title: 'Triggers'
        },
        inputs: {
            type: 'object',
            title: 'Inputs',
            description: 'Static input parameters'
        },
        returns: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Returns',
            description: 'The action ref or value to return.'
        },
        error_handler: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Error Handler',
            description: 'The action ref to handle errors.'
        }
    },
    type: 'object',
    required: ['title', 'description', 'entrypoint', 'actions'],
    title: 'DSLInput',
    description: `DSL definition for a workflow.

The difference between this and a normal workflow engine is that here,
our workflow execution order is defined by the DSL itself, independent
of a workflow scheduler.

With a traditional
This allows the execution of the workflow to be fully deterministic.`
} as const;

export const $DSLRunArgs = {
    properties: {
        role: {
            '$ref': '#/components/schemas/Role'
        },
        dsl: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/DSLInput'
                },
                {
                    type: 'null'
                }
            ]
        },
        wf_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Wf Id'
        },
        trigger_inputs: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Trigger Inputs'
        },
        parent_run_context: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RunContext'
                },
                {
                    type: 'null'
                }
            ]
        },
        runtime_config: {
            allOf: [
                {
                    '$ref': '#/components/schemas/DSLConfig-Output'
                }
            ],
            description: 'Runtime configuration that can be set on workflow entry. Note that this can override the default config in DSLInput.'
        },
        timeout: {
            type: 'string',
            format: 'duration',
            title: 'Timeout',
            description: 'The maximum time to wait for the workflow to complete.'
        },
        schedule_id: {
            anyOf: [
                {
                    type: 'string',
                    pattern: 'sch-[0-9a-f]{32}'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Schedule Id',
            description: 'The schedule ID that triggered this workflow, if any.'
        }
    },
    type: 'object',
    required: ['role', 'wf_id'],
    title: 'DSLRunArgs'
} as const;

export const $EditorActionRead = {
    properties: {
        type: {
            type: 'string',
            title: 'Type'
        },
        ref: {
            type: 'string',
            title: 'Ref'
        },
        description: {
            type: 'string',
            title: 'Description'
        }
    },
    type: 'object',
    required: ['type', 'ref', 'description'],
    title: 'EditorActionRead'
} as const;

export const $EditorFunctionRead = {
    properties: {
        name: {
            type: 'string',
            title: 'Name'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        parameters: {
            items: {
                '$ref': '#/components/schemas/EditorParamRead'
            },
            type: 'array',
            title: 'Parameters'
        },
        return_type: {
            type: 'string',
            title: 'Return Type'
        }
    },
    type: 'object',
    required: ['name', 'description', 'parameters', 'return_type'],
    title: 'EditorFunctionRead'
} as const;

export const $EditorParamRead = {
    properties: {
        name: {
            type: 'string',
            title: 'Name'
        },
        type: {
            type: 'string',
            title: 'Type'
        },
        optional: {
            type: 'boolean',
            title: 'Optional'
        }
    },
    type: 'object',
    required: ['name', 'type', 'optional'],
    title: 'EditorParamRead'
} as const;

export const $ErrorModel = {
    properties: {
        detail: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                }
            ],
            title: 'Detail'
        }
    },
    type: 'object',
    required: ['detail'],
    title: 'ErrorModel'
} as const;

export const $EventFailure = {
    properties: {
        message: {
            type: 'string',
            title: 'Message'
        },
        stack_trace: {
            type: 'string',
            title: 'Stack Trace'
        },
        cause: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Cause'
        },
        application_failure_info: {
            type: 'object',
            title: 'Application Failure Info'
        }
    },
    type: 'object',
    required: ['message', 'stack_trace'],
    title: 'EventFailure'
} as const;

export const $EventGroup = {
    properties: {
        event_id: {
            type: 'integer',
            title: 'Event Id'
        },
        udf_namespace: {
            type: 'string',
            title: 'Udf Namespace'
        },
        udf_name: {
            type: 'string',
            title: 'Udf Name'
        },
        udf_key: {
            type: 'string',
            title: 'Udf Key'
        },
        action_id: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Action Id'
        },
        action_ref: {
            type: 'string',
            title: 'Action Ref'
        },
        action_title: {
            type: 'string',
            title: 'Action Title'
        },
        action_description: {
            type: 'string',
            title: 'Action Description'
        },
        action_input: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RunActionInput'
                },
                {
                    '$ref': '#/components/schemas/DSLRunArgs'
                },
                {
                    '$ref': '#/components/schemas/GetWorkflowDefinitionActivityInputs'
                }
            ],
            title: 'Action Input'
        },
        action_result: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Action Result'
        },
        current_attempt: {
            anyOf: [
                {
                    type: 'integer'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Current Attempt'
        },
        retry_policy: {
            '$ref': '#/components/schemas/ActionRetryPolicy'
        },
        start_delay: {
            type: 'number',
            title: 'Start Delay',
            default: 0
        },
        join_strategy: {
            allOf: [
                {
                    '$ref': '#/components/schemas/JoinStrategy'
                }
            ],
            default: 'all'
        },
        related_wf_exec_id: {
            anyOf: [
                {
                    type: 'string',
                    pattern: 'wf-[0-9a-f]{32}:(exec-[\\w-]+|sch-[0-9a-f]{32}-.*)'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Related Wf Exec Id'
        }
    },
    type: 'object',
    required: ['event_id', 'udf_namespace', 'udf_name', 'udf_key', 'action_id', 'action_ref', 'action_title', 'action_description', 'action_input'],
    title: 'EventGroup'
} as const;

export const $EventHistoryResponse = {
    properties: {
        event_id: {
            type: 'integer',
            title: 'Event Id'
        },
        event_time: {
            type: 'string',
            format: 'date-time',
            title: 'Event Time'
        },
        event_type: {
            '$ref': '#/components/schemas/EventHistoryType'
        },
        task_id: {
            type: 'integer',
            title: 'Task Id'
        },
        event_group: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/EventGroup'
                },
                {
                    type: 'null'
                }
            ],
            description: 'The action group of the event. We use this to keep track of what events are related to each other.'
        },
        failure: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/EventFailure'
                },
                {
                    type: 'null'
                }
            ]
        },
        result: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Result'
        },
        role: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/Role'
                },
                {
                    type: 'null'
                }
            ]
        },
        parent_wf_exec_id: {
            anyOf: [
                {
                    type: 'string',
                    pattern: 'wf-[0-9a-f]{32}:(exec-[\\w-]+|sch-[0-9a-f]{32}-.*)'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Parent Wf Exec Id'
        },
        workflow_timeout: {
            anyOf: [
                {
                    type: 'number'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Workflow Timeout'
        }
    },
    type: 'object',
    required: ['event_id', 'event_time', 'event_type', 'task_id'],
    title: 'EventHistoryResponse'
} as const;

export const $EventHistoryType = {
    type: 'string',
    enum: ['WORKFLOW_EXECUTION_STARTED', 'WORKFLOW_EXECUTION_COMPLETED', 'WORKFLOW_EXECUTION_FAILED', 'WORKFLOW_EXECUTION_TERMINATED', 'WORKFLOW_EXECUTION_CANCELED', 'WORKFLOW_EXECUTION_CONTINUED_AS_NEW', 'WORKFLOW_EXECUTION_TIMED_OUT', 'ACTIVITY_TASK_SCHEDULED', 'ACTIVITY_TASK_STARTED', 'ACTIVITY_TASK_COMPLETED', 'ACTIVITY_TASK_FAILED', 'ACTIVITY_TASK_TIMED_OUT', 'CHILD_WORKFLOW_EXECUTION_STARTED', 'CHILD_WORKFLOW_EXECUTION_COMPLETED', 'CHILD_WORKFLOW_EXECUTION_FAILED', 'START_CHILD_WORKFLOW_EXECUTION_INITIATED'],
    title: 'EventHistoryType',
    description: 'The event types we care about.'
} as const;

export const $ExpectedField = {
    properties: {
        type: {
            type: 'string',
            title: 'Type'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        default: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Default'
        }
    },
    type: 'object',
    required: ['type'],
    title: 'ExpectedField'
} as const;

export const $ExprContext = {
    type: 'string',
    enum: ['ACTIONS', 'SECRETS', 'FN', 'INPUTS', 'ENV', 'TRIGGER', 'var', 'inputs', 'steps'],
    title: 'ExprContext',
    description: 'Expression contexts.'
} as const;

export const $GetWorkflowDefinitionActivityInputs = {
    properties: {
        role: {
            '$ref': '#/components/schemas/Role'
        },
        workflow_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Workflow Id'
        },
        version: {
            anyOf: [
                {
                    type: 'integer'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Version'
        },
        task: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/ActionStatement'
                },
                {
                    type: 'null'
                }
            ]
        }
    },
    type: 'object',
    required: ['role', 'workflow_id'],
    title: 'GetWorkflowDefinitionActivityInputs'
} as const;

export const $HTTPValidationError = {
    properties: {
        detail: {
            items: {
                '$ref': '#/components/schemas/ValidationError'
            },
            type: 'array',
            title: 'Detail'
        }
    },
    type: 'object',
    title: 'HTTPValidationError'
} as const;

export const $JoinStrategy = {
    type: 'string',
    enum: ['any', 'all'],
    title: 'JoinStrategy'
} as const;

export const $OAuth2AuthorizeResponse = {
    properties: {
        authorization_url: {
            type: 'string',
            title: 'Authorization Url'
        }
    },
    type: 'object',
    required: ['authorization_url'],
    title: 'OAuth2AuthorizeResponse'
} as const;

export const $OrgMemberRead = {
    properties: {
        user_id: {
            type: 'string',
            format: 'uuid4',
            title: 'User Id'
        },
        first_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Name'
        },
        last_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Name'
        },
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        },
        role: {
            '$ref': '#/components/schemas/UserRole'
        },
        is_active: {
            type: 'boolean',
            title: 'Is Active'
        },
        is_superuser: {
            type: 'boolean',
            title: 'Is Superuser'
        },
        is_verified: {
            type: 'boolean',
            title: 'Is Verified'
        },
        last_login_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Login At'
        }
    },
    type: 'object',
    required: ['user_id', 'first_name', 'last_name', 'email', 'role', 'is_active', 'is_superuser', 'is_verified', 'last_login_at'],
    title: 'OrgMemberRead'
} as const;

export const $RegistryActionCreate = {
    properties: {
        name: {
            type: 'string',
            title: 'Name',
            description: 'The name of the action'
        },
        description: {
            type: 'string',
            title: 'Description',
            description: 'The description of the action'
        },
        namespace: {
            type: 'string',
            title: 'Namespace',
            description: 'The namespace of the action'
        },
        type: {
            type: 'string',
            enum: ['udf', 'template'],
            title: 'Type',
            description: 'The type of the action'
        },
        origin: {
            type: 'string',
            title: 'Origin',
            description: 'The origin of the action as a url'
        },
        secrets: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/RegistrySecret'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Secrets',
            description: 'The secrets required by the action'
        },
        interface: {
            '$ref': '#/components/schemas/RegistryActionInterface'
        },
        implementation: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionTemplateImpl-Input'
                },
                {
                    '$ref': '#/components/schemas/RegistryActionUDFImpl'
                }
            ],
            title: 'Implementation'
        },
        default_title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Default Title',
            description: 'The default title of the action'
        },
        display_group: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Display Group',
            description: 'The presentation group of the action'
        },
        options: {
            allOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionOptions'
                }
            ],
            description: 'The options for the action'
        },
        repository_id: {
            type: 'string',
            format: 'uuid4',
            title: 'Repository Id',
            description: 'The repository id'
        }
    },
    type: 'object',
    required: ['name', 'description', 'namespace', 'type', 'origin', 'interface', 'repository_id'],
    title: 'RegistryActionCreate',
    description: 'API create model for a registered action.'
} as const;

export const $RegistryActionInterface = {
    properties: {
        expects: {
            type: 'object',
            title: 'Expects'
        },
        returns: {
            title: 'Returns'
        }
    },
    type: 'object',
    required: ['expects', 'returns'],
    title: 'RegistryActionInterface'
} as const;

export const $RegistryActionOptions = {
    properties: {
        include_in_schema: {
            type: 'boolean',
            title: 'Include In Schema',
            default: true
        }
    },
    type: 'object',
    title: 'RegistryActionOptions'
} as const;

export const $RegistryActionRead = {
    properties: {
        name: {
            type: 'string',
            title: 'Name',
            description: 'The name of the action'
        },
        description: {
            type: 'string',
            title: 'Description',
            description: 'The description of the action'
        },
        namespace: {
            type: 'string',
            title: 'Namespace',
            description: 'The namespace of the action'
        },
        type: {
            type: 'string',
            enum: ['udf', 'template'],
            title: 'Type',
            description: 'The type of the action'
        },
        origin: {
            type: 'string',
            title: 'Origin',
            description: 'The origin of the action as a url'
        },
        secrets: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/RegistrySecret'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Secrets',
            description: 'The secrets required by the action'
        },
        interface: {
            '$ref': '#/components/schemas/RegistryActionInterface'
        },
        implementation: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionTemplateImpl-Output'
                },
                {
                    '$ref': '#/components/schemas/RegistryActionUDFImpl'
                }
            ],
            title: 'Implementation'
        },
        default_title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Default Title',
            description: 'The default title of the action'
        },
        display_group: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Display Group',
            description: 'The presentation group of the action'
        },
        options: {
            allOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionOptions'
                }
            ],
            description: 'The options for the action'
        },
        repository_id: {
            type: 'string',
            format: 'uuid4',
            title: 'Repository Id',
            description: 'The repository id'
        },
        action: {
            type: 'string',
            title: 'Action',
            description: 'The full action identifier.',
            readOnly: true
        },
        is_template: {
            type: 'boolean',
            title: 'Is Template',
            description: 'Whether the action is a template.',
            readOnly: true
        }
    },
    type: 'object',
    required: ['name', 'description', 'namespace', 'type', 'origin', 'interface', 'repository_id', 'action', 'is_template'],
    title: 'RegistryActionRead',
    description: 'API read model for a registered action.'
} as const;

export const $RegistryActionTemplateImpl_Input = {
    properties: {
        type: {
            const: 'template',
            title: 'Type',
            default: 'template'
        },
        template_action: {
            allOf: [
                {
                    '$ref': '#/components/schemas/TemplateAction-Input'
                }
            ],
            description: 'The template action'
        }
    },
    type: 'object',
    required: ['template_action'],
    title: 'RegistryActionTemplateImpl'
} as const;

export const $RegistryActionTemplateImpl_Output = {
    properties: {
        type: {
            const: 'template',
            title: 'Type',
            default: 'template'
        },
        template_action: {
            allOf: [
                {
                    '$ref': '#/components/schemas/TemplateAction-Output'
                }
            ],
            description: 'The template action'
        }
    },
    type: 'object',
    required: ['template_action'],
    title: 'RegistryActionTemplateImpl'
} as const;

export const $RegistryActionUDFImpl = {
    properties: {
        type: {
            const: 'udf',
            title: 'Type',
            default: 'udf'
        },
        url: {
            type: 'string',
            title: 'Url',
            description: 'The package url'
        },
        module: {
            type: 'string',
            title: 'Module',
            description: 'The module name'
        },
        name: {
            type: 'string',
            title: 'Name',
            description: 'The name of the UDF function name'
        }
    },
    type: 'object',
    required: ['url', 'module', 'name'],
    title: 'RegistryActionUDFImpl'
} as const;

export const $RegistryActionUpdate = {
    properties: {
        name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Name',
            description: 'Update the name of the action'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description',
            description: 'Update the description of the action'
        },
        secrets: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/RegistrySecret'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Secrets',
            description: 'Update the secrets of the action'
        },
        interface: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionInterface'
                },
                {
                    type: 'null'
                }
            ],
            description: 'Update the interface of the action'
        },
        implementation: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionTemplateImpl-Input'
                },
                {
                    '$ref': '#/components/schemas/RegistryActionUDFImpl'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Implementation',
            description: 'Update the implementation of the action'
        },
        default_title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Default Title',
            description: 'Update the default title of the action'
        },
        display_group: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Display Group',
            description: 'Update the display group of the action'
        },
        options: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/RegistryActionOptions'
                },
                {
                    type: 'null'
                }
            ],
            description: 'Update the options of the action'
        }
    },
    type: 'object',
    title: 'RegistryActionUpdate',
    description: 'API update model for a registered action.'
} as const;

export const $RegistryActionValidateResponse = {
    properties: {
        ok: {
            type: 'boolean',
            title: 'Ok'
        },
        message: {
            type: 'string',
            title: 'Message'
        },
        detail: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Detail'
        },
        action_ref: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Action Ref'
        }
    },
    type: 'object',
    required: ['ok', 'message'],
    title: 'RegistryActionValidateResponse'
} as const;

export const $RegistryRepositoryCreate = {
    properties: {
        origin: {
            type: 'string',
            title: 'Origin'
        }
    },
    type: 'object',
    required: ['origin'],
    title: 'RegistryRepositoryCreate'
} as const;

export const $RegistryRepositoryRead = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        origin: {
            type: 'string',
            title: 'Origin'
        },
        last_synced_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Synced At'
        },
        commit_sha: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Commit Sha'
        },
        actions: {
            items: {
                '$ref': '#/components/schemas/RegistryActionRead'
            },
            type: 'array',
            title: 'Actions'
        }
    },
    type: 'object',
    required: ['id', 'origin', 'last_synced_at', 'commit_sha', 'actions'],
    title: 'RegistryRepositoryRead'
} as const;

export const $RegistryRepositoryReadMinimal = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        origin: {
            type: 'string',
            title: 'Origin'
        },
        last_synced_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Synced At'
        },
        commit_sha: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Commit Sha'
        }
    },
    type: 'object',
    required: ['id', 'origin', 'last_synced_at', 'commit_sha'],
    title: 'RegistryRepositoryReadMinimal'
} as const;

export const $RegistryRepositoryUpdate = {
    properties: {
        last_synced_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Synced At'
        },
        commit_sha: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Commit Sha'
        },
        origin: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Origin'
        }
    },
    type: 'object',
    title: 'RegistryRepositoryUpdate'
} as const;

export const $RegistrySecret = {
    properties: {
        name: {
            type: 'string',
            pattern: '[a-z0-9_]+',
            title: 'Name'
        },
        keys: {
            anyOf: [
                {
                    items: {
                        type: 'string',
                        pattern: '[a-zA-Z0-9_]+'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Keys'
        },
        optional_keys: {
            anyOf: [
                {
                    items: {
                        type: 'string',
                        pattern: '[a-zA-Z0-9_]+'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Optional Keys'
        },
        optional: {
            type: 'boolean',
            title: 'Optional',
            default: false
        }
    },
    type: 'object',
    required: ['name'],
    title: 'RegistrySecret'
} as const;

export const $Role = {
    properties: {
        type: {
            type: 'string',
            enum: ['user', 'service'],
            title: 'Type'
        },
        workspace_id: {
            anyOf: [
                {
                    type: 'string',
                    format: 'uuid4'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Workspace Id'
        },
        user_id: {
            anyOf: [
                {
                    type: 'string',
                    format: 'uuid4'
                },
                {
                    type: 'null'
                }
            ],
            title: 'User Id'
        },
        access_level: {
            allOf: [
                {
                    '$ref': '#/components/schemas/AccessLevel'
                }
            ],
            default: 0
        },
        service_id: {
            type: 'string',
            enum: ['tracecat-runner', 'tracecat-api', 'tracecat-cli', 'tracecat-schedule-runner', 'tracecat-service', 'tracecat-executor'],
            title: 'Service Id'
        }
    },
    type: 'object',
    required: ['type', 'service_id'],
    title: 'Role',
    description: `The identity and authorization of a user or service.

Params
------
type : Literal["user", "service"]
    The type of role.
user_id : UUID | None
    The user's ID, or the service's user_id.
    This can be None for internal services, or when a user hasn't been set for the role.
service_id : str | None = None
    The service's role name, or None if the role is a user.


User roles
----------
- User roles are authenticated via JWT.
- The \`user_id\` is the user's JWT 'sub' claim.
- User roles do not have an associated \`service_id\`, this must be None.

Service roles
-------------
- Service roles are authenticated via API key.
- Used for internal services to authenticate with the API.
- A service's \`user_id\` is the user it's acting on behalf of. This can be None for internal services.`
} as const;

export const $RunActionInput = {
    properties: {
        task: {
            '$ref': '#/components/schemas/ActionStatement'
        },
        exec_context: {
            type: 'object',
            title: 'Exec Context'
        },
        run_context: {
            '$ref': '#/components/schemas/RunContext'
        }
    },
    type: 'object',
    required: ['task', 'exec_context', 'run_context'],
    title: 'RunActionInput',
    description: 'This object contains all the information needed to execute an action.'
} as const;

export const $RunContext = {
    properties: {
        wf_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Wf Id'
        },
        wf_exec_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}:(exec-[\\w-]+|sch-[0-9a-f]{32}-.*)',
            title: 'Wf Exec Id'
        },
        wf_run_id: {
            type: 'string',
            format: 'uuid4',
            title: 'Wf Run Id'
        },
        environment: {
            type: 'string',
            title: 'Environment'
        }
    },
    type: 'object',
    required: ['wf_id', 'wf_exec_id', 'wf_run_id', 'environment'],
    title: 'RunContext',
    description: 'This is the runtime context model for a workflow run. Passed into activities.'
} as const;

export const $SAMLDatabaseLoginResponse = {
    properties: {
        redirect_url: {
            type: 'string',
            title: 'Redirect Url'
        }
    },
    type: 'object',
    required: ['redirect_url'],
    title: 'SAMLDatabaseLoginResponse'
} as const;

export const $Schedule = {
    properties: {
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        updated_at: {
            type: 'string',
            format: 'date-time',
            title: 'Updated At'
        },
        id: {
            type: 'string',
            title: 'Id'
        },
        status: {
            type: 'string',
            title: 'Status',
            default: 'online'
        },
        cron: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Cron'
        },
        inputs: {
            type: 'object',
            title: 'Inputs'
        },
        every: {
            type: 'string',
            format: 'duration',
            title: 'Every',
            description: 'ISO 8601 duration string'
        },
        offset: {
            anyOf: [
                {
                    type: 'string',
                    format: 'duration'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Offset',
            description: 'ISO 8601 duration string'
        },
        start_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Start At',
            description: 'ISO 8601 datetime string'
        },
        end_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'End At',
            description: 'ISO 8601 datetime string'
        },
        timeout: {
            anyOf: [
                {
                    type: 'number'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Timeout',
            description: 'The maximum number of seconds to wait for the workflow to complete'
        },
        workflow_id: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Workflow Id'
        }
    },
    type: 'object',
    required: ['owner_id', 'every', 'workflow_id'],
    title: 'Schedule'
} as const;

export const $ScheduleCreate = {
    properties: {
        workflow_id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Workflow Id'
        },
        inputs: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Inputs'
        },
        cron: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Cron'
        },
        every: {
            type: 'string',
            format: 'duration',
            title: 'Every',
            description: 'ISO 8601 duration string'
        },
        offset: {
            anyOf: [
                {
                    type: 'string',
                    format: 'duration'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Offset',
            description: 'ISO 8601 duration string'
        },
        start_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Start At',
            description: 'ISO 8601 datetime string'
        },
        end_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'End At',
            description: 'ISO 8601 datetime string'
        },
        status: {
            type: 'string',
            enum: ['online', 'offline'],
            title: 'Status',
            default: 'online'
        },
        timeout: {
            type: 'number',
            title: 'Timeout',
            description: 'The maximum number of seconds to wait for the workflow to complete',
            default: 300
        }
    },
    type: 'object',
    required: ['workflow_id', 'every'],
    title: 'ScheduleCreate'
} as const;

export const $ScheduleSearch = {
    properties: {
        workflow_id: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Workflow Id'
        },
        limit: {
            type: 'integer',
            title: 'Limit',
            default: 100
        },
        order_by: {
            type: 'string',
            title: 'Order By',
            default: 'created_at'
        },
        query: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Query'
        },
        group_by: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Group By'
        },
        agg: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Agg'
        }
    },
    type: 'object',
    title: 'ScheduleSearch'
} as const;

export const $ScheduleUpdate = {
    properties: {
        inputs: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Inputs'
        },
        cron: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Cron'
        },
        every: {
            anyOf: [
                {
                    type: 'string',
                    format: 'duration'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Every',
            description: 'ISO 8601 duration string'
        },
        offset: {
            anyOf: [
                {
                    type: 'string',
                    format: 'duration'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Offset',
            description: 'ISO 8601 duration string'
        },
        start_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Start At',
            description: 'ISO 8601 datetime string'
        },
        end_at: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'End At',
            description: 'ISO 8601 datetime string'
        },
        status: {
            anyOf: [
                {
                    type: 'string',
                    enum: ['online', 'offline']
                },
                {
                    type: 'null'
                }
            ],
            title: 'Status'
        }
    },
    type: 'object',
    title: 'ScheduleUpdate'
} as const;

export const $SecretCreate = {
    properties: {
        type: {
            allOf: [
                {
                    '$ref': '#/components/schemas/SecretType'
                }
            ],
            default: 'custom'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        keys: {
            items: {
                '$ref': '#/components/schemas/SecretKeyValue'
            },
            type: 'array',
            title: 'Keys'
        },
        tags: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Tags'
        },
        environment: {
            type: 'string',
            title: 'Environment',
            default: 'default'
        }
    },
    type: 'object',
    required: ['name', 'keys'],
    title: 'SecretCreate',
    description: `Create a new secret.

Secret types
------------
- \`custom\`: Arbitrary user-defined types
- \`token\`: A token, e.g. API Key, JWT Token (TBC)
- \`oauth2\`: OAuth2 Client Credentials (TBC)`
} as const;

export const $SecretKeyValue = {
    properties: {
        key: {
            type: 'string',
            title: 'Key'
        },
        value: {
            type: 'string',
            format: 'password',
            title: 'Value',
            writeOnly: true
        }
    },
    type: 'object',
    required: ['key', 'value'],
    title: 'SecretKeyValue'
} as const;

export const $SecretLevel = {
    type: 'string',
    enum: ['workspace', 'organization'],
    title: 'SecretLevel',
    description: 'The level of a secret.'
} as const;

export const $SecretRead = {
    properties: {
        id: {
            type: 'string',
            title: 'Id'
        },
        type: {
            '$ref': '#/components/schemas/SecretType'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        encrypted_keys: {
            type: 'string',
            format: 'binary',
            title: 'Encrypted Keys'
        },
        environment: {
            type: 'string',
            title: 'Environment'
        },
        tags: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Tags'
        },
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        updated_at: {
            type: 'string',
            format: 'date-time',
            title: 'Updated At'
        }
    },
    type: 'object',
    required: ['id', 'type', 'name', 'encrypted_keys', 'environment', 'owner_id', 'created_at', 'updated_at'],
    title: 'SecretRead'
} as const;

export const $SecretReadMinimal = {
    properties: {
        id: {
            type: 'string',
            title: 'Id'
        },
        type: {
            '$ref': '#/components/schemas/SecretType'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        keys: {
            items: {
                type: 'string'
            },
            type: 'array',
            title: 'Keys'
        },
        environment: {
            type: 'string',
            title: 'Environment'
        }
    },
    type: 'object',
    required: ['id', 'type', 'name', 'keys', 'environment'],
    title: 'SecretReadMinimal'
} as const;

export const $SecretType = {
    type: 'string',
    enum: ['custom', 'ssh-key'],
    title: 'SecretType',
    description: 'The type of a secret.'
} as const;

export const $SecretUpdate = {
    properties: {
        type: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/SecretType'
                },
                {
                    type: 'null'
                }
            ]
        },
        name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Name'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        keys: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/SecretKeyValue'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Keys'
        },
        tags: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Tags'
        },
        environment: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Environment'
        },
        level: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/SecretLevel'
                },
                {
                    type: 'null'
                }
            ]
        }
    },
    type: 'object',
    title: 'SecretUpdate',
    description: `Update a secret.

Secret types
------------
- \`custom\`: Arbitrary user-defined types
- \`token\`: A token, e.g. API Key, JWT Token (TBC)
- \`oauth2\`: OAuth2 Client Credentials (TBC)`
} as const;

export const $SessionRead = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        user_id: {
            type: 'string',
            format: 'uuid4',
            title: 'User Id'
        },
        user_email: {
            type: 'string',
            format: 'email',
            title: 'User Email'
        }
    },
    type: 'object',
    required: ['id', 'created_at', 'user_id', 'user_email'],
    title: 'SessionRead'
} as const;

export const $TagCreate = {
    properties: {
        name: {
            type: 'string',
            title: 'Name'
        },
        color: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Color'
        }
    },
    type: 'object',
    required: ['name'],
    title: 'TagCreate'
} as const;

export const $TagRead = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        color: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Color'
        }
    },
    type: 'object',
    required: ['id', 'name'],
    title: 'TagRead'
} as const;

export const $TagUpdate = {
    properties: {
        name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Name'
        },
        color: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Color'
        }
    },
    type: 'object',
    title: 'TagUpdate'
} as const;

export const $TemplateAction_Input = {
    properties: {
        type: {
            const: 'action',
            title: 'Type',
            default: 'action'
        },
        definition: {
            '$ref': '#/components/schemas/TemplateActionDefinition'
        }
    },
    type: 'object',
    required: ['definition'],
    title: 'TemplateAction'
} as const;

export const $TemplateAction_Output = {
    properties: {
        type: {
            const: 'action',
            title: 'Type',
            default: 'action'
        },
        definition: {
            '$ref': '#/components/schemas/TemplateActionDefinition'
        }
    },
    type: 'object',
    required: ['definition'],
    title: 'TemplateAction'
} as const;

export const $TemplateActionDefinition = {
    properties: {
        name: {
            type: 'string',
            title: 'Name',
            description: 'The action name'
        },
        namespace: {
            type: 'string',
            title: 'Namespace',
            description: 'The namespace of the action'
        },
        title: {
            type: 'string',
            title: 'Title',
            description: 'The title of the action'
        },
        description: {
            type: 'string',
            title: 'Description',
            description: 'The description of the action',
            default: ''
        },
        display_group: {
            type: 'string',
            title: 'Display Group',
            description: 'The display group of the action'
        },
        secrets: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/RegistrySecret'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Secrets',
            description: 'The secrets to pass to the action'
        },
        expects: {
            additionalProperties: {
                '$ref': '#/components/schemas/ExpectedField'
            },
            type: 'object',
            title: 'Expects',
            description: 'The arguments to pass to the action'
        },
        steps: {
            items: {
                '$ref': '#/components/schemas/ActionStep'
            },
            type: 'array',
            title: 'Steps',
            description: 'The sequence of steps for the action'
        },
        returns: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'object'
                }
            ],
            title: 'Returns',
            description: 'The result of the action'
        }
    },
    type: 'object',
    required: ['name', 'namespace', 'title', 'display_group', 'expects', 'steps', 'returns'],
    title: 'TemplateActionDefinition'
} as const;

export const $TerminateWorkflowExecutionParams = {
    properties: {
        reason: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Reason'
        }
    },
    type: 'object',
    title: 'TerminateWorkflowExecutionParams'
} as const;

export const $Trigger = {
    properties: {
        type: {
            type: 'string',
            enum: ['schedule', 'webhook'],
            title: 'Type'
        },
        ref: {
            type: 'string',
            pattern: '^[a-z0-9_]+$',
            title: 'Ref'
        },
        args: {
            type: 'object',
            title: 'Args'
        }
    },
    type: 'object',
    required: ['type', 'ref'],
    title: 'Trigger'
} as const;

export const $UpdateWorkspaceParams = {
    properties: {
        name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Name'
        },
        settings: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Settings'
        }
    },
    type: 'object',
    title: 'UpdateWorkspaceParams'
} as const;

export const $UpsertWebhookParams = {
    properties: {
        status: {
            anyOf: [
                {
                    type: 'string',
                    enum: ['online', 'offline']
                },
                {
                    type: 'null'
                }
            ],
            title: 'Status'
        },
        entrypoint_ref: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Entrypoint Ref'
        },
        method: {
            anyOf: [
                {
                    type: 'string',
                    enum: ['GET', 'POST']
                },
                {
                    type: 'null'
                }
            ],
            title: 'Method'
        }
    },
    type: 'object',
    title: 'UpsertWebhookParams'
} as const;

export const $UserCreate = {
    properties: {
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        },
        password: {
            type: 'string',
            title: 'Password'
        },
        is_active: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Active',
            default: true
        },
        is_superuser: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Superuser',
            default: false
        },
        is_verified: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Verified',
            default: false
        },
        role: {
            allOf: [
                {
                    '$ref': '#/components/schemas/UserRole'
                }
            ],
            default: 'basic'
        },
        first_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Name'
        },
        last_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Name'
        }
    },
    type: 'object',
    required: ['email', 'password'],
    title: 'UserCreate'
} as const;

export const $UserRead = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid',
            title: 'Id'
        },
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        },
        is_active: {
            type: 'boolean',
            title: 'Is Active',
            default: true
        },
        is_superuser: {
            type: 'boolean',
            title: 'Is Superuser',
            default: false
        },
        is_verified: {
            type: 'boolean',
            title: 'Is Verified',
            default: false
        },
        role: {
            '$ref': '#/components/schemas/UserRole'
        },
        first_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Name'
        },
        last_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Name'
        },
        settings: {
            type: 'object',
            title: 'Settings'
        }
    },
    type: 'object',
    required: ['id', 'email', 'role', 'settings'],
    title: 'UserRead'
} as const;

export const $UserRole = {
    type: 'string',
    enum: ['basic', 'admin'],
    title: 'UserRole'
} as const;

export const $UserUpdate = {
    properties: {
        password: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Password'
        },
        email: {
            anyOf: [
                {
                    type: 'string',
                    format: 'email'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Email'
        },
        is_active: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Active'
        },
        is_superuser: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Superuser'
        },
        is_verified: {
            anyOf: [
                {
                    type: 'boolean'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Is Verified'
        },
        role: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/UserRole'
                },
                {
                    type: 'null'
                }
            ]
        },
        first_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Name'
        },
        last_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Name'
        },
        settings: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Settings'
        }
    },
    type: 'object',
    title: 'UserUpdate'
} as const;

export const $ValidationError = {
    properties: {
        loc: {
            items: {
                anyOf: [
                    {
                        type: 'string'
                    },
                    {
                        type: 'integer'
                    }
                ]
            },
            type: 'array',
            title: 'Location'
        },
        msg: {
            type: 'string',
            title: 'Message'
        },
        type: {
            type: 'string',
            title: 'Error Type'
        }
    },
    type: 'object',
    required: ['loc', 'msg', 'type'],
    title: 'ValidationError'
} as const;

export const $WebhookResponse = {
    properties: {
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        updated_at: {
            type: 'string',
            format: 'date-time',
            title: 'Updated At'
        },
        id: {
            type: 'string',
            title: 'Id'
        },
        secret: {
            type: 'string',
            title: 'Secret'
        },
        status: {
            type: 'string',
            enum: ['online', 'offline'],
            title: 'Status'
        },
        entrypoint_ref: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Entrypoint Ref'
        },
        filters: {
            type: 'object',
            title: 'Filters'
        },
        method: {
            type: 'string',
            enum: ['GET', 'POST'],
            title: 'Method'
        },
        workflow_id: {
            type: 'string',
            title: 'Workflow Id'
        },
        url: {
            type: 'string',
            title: 'Url'
        }
    },
    type: 'object',
    required: ['owner_id', 'id', 'secret', 'status', 'filters', 'method', 'workflow_id', 'url'],
    title: 'WebhookResponse'
} as const;

export const $WorkflowCommitResponse = {
    properties: {
        workflow_id: {
            type: 'string',
            title: 'Workflow Id'
        },
        status: {
            type: 'string',
            enum: ['success', 'failure'],
            title: 'Status'
        },
        message: {
            type: 'string',
            title: 'Message'
        },
        errors: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/RegistryActionValidateResponse'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Errors'
        },
        metadata: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Metadata'
        }
    },
    type: 'object',
    required: ['workflow_id', 'status', 'message'],
    title: 'WorkflowCommitResponse'
} as const;

export const $WorkflowDefinition = {
    properties: {
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        updated_at: {
            type: 'string',
            format: 'date-time',
            title: 'Updated At'
        },
        id: {
            type: 'string',
            title: 'Id'
        },
        version: {
            type: 'integer',
            title: 'Version',
            description: 'DSL spec version'
        },
        workflow_id: {
            type: 'string',
            title: 'Workflow Id'
        },
        content: {
            type: 'object',
            title: 'Content'
        }
    },
    type: 'object',
    required: ['owner_id', 'version', 'workflow_id', 'content'],
    title: 'WorkflowDefinition',
    description: `A workflow definition.

This is the underlying representation/snapshot of a workflow in the system, which
can directly execute in the runner.

Shoulds
-------
1. Be convertible into a Workspace Workflow + Acitons
2. Be convertible into a YAML DSL
3. Be able to be versioned

Shouldn'ts
----------
1. Have any stateful information

Relationships
-------------
- 1 Workflow to many WorkflowDefinitions`
} as const;

export const $WorkflowExecutionResponse = {
    properties: {
        id: {
            type: 'string',
            title: 'Id',
            description: 'The ID of the workflow execution'
        },
        run_id: {
            type: 'string',
            title: 'Run Id',
            description: 'The run ID of the workflow execution'
        },
        start_time: {
            type: 'string',
            format: 'date-time',
            title: 'Start Time',
            description: 'The start time of the workflow execution'
        },
        execution_time: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Execution Time',
            description: 'When this workflow run started or should start.'
        },
        close_time: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Close Time',
            description: 'When the workflow was closed if closed.'
        },
        status: {
            type: 'string',
            enum: ['RUNNING', 'COMPLETED', 'FAILED', 'CANCELED', 'TERMINATED', 'CONTINUED_AS_NEW', 'TIMED_OUT']
        },
        workflow_type: {
            type: 'string',
            title: 'Workflow Type'
        },
        task_queue: {
            type: 'string',
            title: 'Task Queue'
        },
        history_length: {
            type: 'integer',
            title: 'History Length',
            description: 'Number of events in the history'
        }
    },
    type: 'object',
    required: ['id', 'run_id', 'start_time', 'status', 'workflow_type', 'task_queue', 'history_length'],
    title: 'WorkflowExecutionResponse'
} as const;

export const $WorkflowRead = {
    properties: {
        id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Id'
        },
        title: {
            type: 'string',
            title: 'Title'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        status: {
            type: 'string',
            title: 'Status'
        },
        actions: {
            additionalProperties: {
                '$ref': '#/components/schemas/ActionRead'
            },
            type: 'object',
            title: 'Actions'
        },
        object: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Object'
        },
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        version: {
            anyOf: [
                {
                    type: 'integer'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Version'
        },
        webhook: {
            '$ref': '#/components/schemas/WebhookResponse'
        },
        schedules: {
            items: {
                '$ref': '#/components/schemas/Schedule'
            },
            type: 'array',
            title: 'Schedules'
        },
        entrypoint: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Entrypoint'
        },
        static_inputs: {
            type: 'object',
            title: 'Static Inputs'
        },
        expects: {
            anyOf: [
                {
                    additionalProperties: {
                        '$ref': '#/components/schemas/ExpectedField'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Expects'
        },
        returns: {
            title: 'Returns'
        },
        config: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/DSLConfig-Output'
                },
                {
                    type: 'null'
                }
            ]
        },
        alias: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Alias'
        },
        error_handler: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Error Handler'
        }
    },
    type: 'object',
    required: ['id', 'title', 'description', 'status', 'actions', 'object', 'owner_id', 'webhook', 'schedules', 'entrypoint', 'static_inputs', 'returns', 'config'],
    title: 'WorkflowRead'
} as const;

export const $WorkflowReadMinimal = {
    properties: {
        id: {
            type: 'string',
            pattern: 'wf-[0-9a-f]{32}',
            title: 'Id'
        },
        title: {
            type: 'string',
            title: 'Title'
        },
        description: {
            type: 'string',
            title: 'Description'
        },
        status: {
            type: 'string',
            title: 'Status'
        },
        icon_url: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Icon Url'
        },
        created_at: {
            type: 'string',
            format: 'date-time',
            title: 'Created At'
        },
        updated_at: {
            type: 'string',
            format: 'date-time',
            title: 'Updated At'
        },
        version: {
            anyOf: [
                {
                    type: 'integer'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Version'
        },
        tags: {
            anyOf: [
                {
                    items: {
                        '$ref': '#/components/schemas/TagRead'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Tags'
        },
        alias: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Alias'
        },
        error_handler: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Error Handler'
        }
    },
    type: 'object',
    required: ['id', 'title', 'description', 'status', 'icon_url', 'created_at', 'updated_at', 'version'],
    title: 'WorkflowReadMinimal'
} as const;

export const $WorkflowTagCreate = {
    properties: {
        tag_id: {
            type: 'string',
            format: 'uuid4',
            title: 'Tag Id'
        }
    },
    type: 'object',
    required: ['tag_id'],
    title: 'WorkflowTagCreate'
} as const;

export const $WorkflowUpdate = {
    properties: {
        title: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Title'
        },
        description: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Description'
        },
        status: {
            anyOf: [
                {
                    type: 'string',
                    enum: ['online', 'offline']
                },
                {
                    type: 'null'
                }
            ],
            title: 'Status'
        },
        object: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Object'
        },
        version: {
            anyOf: [
                {
                    type: 'integer'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Version'
        },
        entrypoint: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Entrypoint'
        },
        icon_url: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Icon Url'
        },
        static_inputs: {
            anyOf: [
                {
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Static Inputs'
        },
        expects: {
            anyOf: [
                {
                    additionalProperties: {
                        '$ref': '#/components/schemas/ExpectedField'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Expects'
        },
        returns: {
            anyOf: [
                {},
                {
                    type: 'null'
                }
            ],
            title: 'Returns'
        },
        config: {
            anyOf: [
                {
                    '$ref': '#/components/schemas/DSLConfig-Input'
                },
                {
                    type: 'null'
                }
            ]
        },
        alias: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Alias'
        },
        error_handler: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Error Handler'
        }
    },
    type: 'object',
    title: 'WorkflowUpdate'
} as const;

export const $WorkspaceMember = {
    properties: {
        user_id: {
            type: 'string',
            format: 'uuid4',
            title: 'User Id'
        },
        first_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Name'
        },
        last_name: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Name'
        },
        email: {
            type: 'string',
            format: 'email',
            title: 'Email'
        },
        role: {
            '$ref': '#/components/schemas/UserRole'
        }
    },
    type: 'object',
    required: ['user_id', 'first_name', 'last_name', 'email', 'role'],
    title: 'WorkspaceMember'
} as const;

export const $WorkspaceMembershipResponse = {
    properties: {
        user_id: {
            type: 'string',
            format: 'uuid4',
            title: 'User Id'
        },
        workspace_id: {
            type: 'string',
            format: 'uuid4',
            title: 'Workspace Id'
        }
    },
    type: 'object',
    required: ['user_id', 'workspace_id'],
    title: 'WorkspaceMembershipResponse'
} as const;

export const $WorkspaceMetadataResponse = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        n_members: {
            type: 'integer',
            title: 'N Members'
        }
    },
    type: 'object',
    required: ['id', 'name', 'n_members'],
    title: 'WorkspaceMetadataResponse'
} as const;

export const $WorkspaceResponse = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid4',
            title: 'Id'
        },
        name: {
            type: 'string',
            title: 'Name'
        },
        settings: {
            anyOf: [
                {
                    additionalProperties: {
                        type: 'string'
                    },
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Settings'
        },
        owner_id: {
            type: 'string',
            format: 'uuid',
            title: 'Owner Id'
        },
        n_members: {
            type: 'integer',
            title: 'N Members'
        },
        members: {
            items: {
                '$ref': '#/components/schemas/WorkspaceMember'
            },
            type: 'array',
            title: 'Members'
        }
    },
    type: 'object',
    required: ['id', 'name', 'owner_id', 'n_members', 'members'],
    title: 'WorkspaceResponse'
} as const;

export const $login = {
    properties: {
        grant_type: {
            anyOf: [
                {
                    type: 'string',
                    pattern: 'password'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Grant Type'
        },
        username: {
            type: 'string',
            title: 'Username'
        },
        password: {
            type: 'string',
            title: 'Password'
        },
        scope: {
            type: 'string',
            title: 'Scope',
            default: ''
        },
        client_id: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Client Id'
        },
        client_secret: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Client Secret'
        }
    },
    type: 'object',
    required: ['username', 'password'],
    title: 'Body_auth-auth:database.login'
} as const;
