"""Add repo last synced at and commit sha

Revision ID: da03a0dfa2db
Revises: b7a3a2146bac
Create Date: 2024-12-15 19:01:06.608544

"""
from collections.abc import Sequence

import sqlalchemy as sa
import sqlmodel.sql.sqltypes

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "da03a0dfa2db"
down_revision: str | None = "b7a3a2146bac"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "registryrepository",
        sa.Column("last_synced_at", sa.TIMESTAMP(timezone=True), nullable=True),
    )
    op.add_column(
        "registryrepository",
        sa.Column("commit_sha", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("registryrepository", "commit_sha")
    op.drop_column("registryrepository", "last_synced_at")
    # ### end Alembic commands ###
