"""Add workflow alias

Revision ID: 8be6393b2ee0
Revises: 3bc0a0970817
Create Date: 2024-12-24 18:10:17.717675

"""
from collections.abc import Sequence

import sqlalchemy as sa
import sqlmodel.sql.sqltypes

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "8be6393b2ee0"
down_revision: str | None = "3bc0a0970817"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "workflow",
        sa.Column("alias", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    )
    op.create_index(op.f("ix_workflow_alias"), "workflow", ["alias"], unique=False)
    op.create_unique_constraint(
        "uq_workflow_alias_owner_id", "workflow", ["alias", "owner_id"]
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("uq_workflow_alias_owner_id", "workflow", type_="unique")
    op.drop_index(op.f("ix_workflow_alias"), table_name="workflow")
    op.drop_column("workflow", "alias")
    # ### end Alembic commands ###
