"""Add registry repository and action tables

Revision ID: 5273ec029b1b
Revises: 5308ffdd79f3
Create Date: 2024-10-03 19:54:16.459544

"""

from collections.abc import Sequence

import sqlalchemy as sa
import sqlmodel
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "5273ec029b1b"
down_revision: str | None = "5308ffdd79f3"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "registryrepository",
        sa.Column("surrogate_id", sa.Integer(), nullable=False),
        sa.Column("owner_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("version", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("origin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.PrimaryKeyConstraint("surrogate_id"),
        sa.UniqueConstraint("id"),
    )
    op.create_table(
        "registryaction",
        sa.Column("surrogate_id", sa.Integer(), nullable=False),
        sa.Column("owner_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("description", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("namespace", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("version", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("origin", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("type", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("default_title", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("display_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("secrets", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.Column("interface", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.Column(
            "implementation", postgresql.JSONB(astext_type=sa.Text()), nullable=True
        ),
        sa.Column("options", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.Column("repository_id", sa.UUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["repository_id"], ["registryrepository.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("surrogate_id"),
        sa.UniqueConstraint("id"),
        sa.UniqueConstraint(
            "namespace",
            "name",
            "version",
            name="uq_registry_action_namespace_name_version",
        ),
    )
    op.drop_index("ix_udfspec_id", table_name="udfspec")
    op.drop_table("udfspec")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "udfspec",
        sa.Column("surrogate_id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("owner_id", sa.UUID(), autoincrement=False, nullable=False),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("description", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("namespace", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("key", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("version", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "json_schema",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "meta",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("surrogate_id", name="udfspec_pkey"),
    )
    op.create_index("ix_udfspec_id", "udfspec", ["id"], unique=True)
    op.drop_table("registryaction")
    op.drop_table("registryrepository")
    # ### end Alembic commands ###
