"""Remove versioning from registry tables

Revision ID: 36f47d3628bf
Revises: 5273ec029b1b
Create Date: 2024-10-09 18:13:55.735234

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "36f47d3628bf"
down_revision: str | None = "5273ec029b1b"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "uq_registry_action_namespace_name_version", "registryaction", type_="unique"
    )
    op.create_unique_constraint(
        "uq_registry_action_namespace_name", "registryaction", ["namespace", "name"]
    )
    op.drop_column("registryaction", "version")
    op.alter_column(
        "registryrepository", "origin", existing_type=sa.VARCHAR(), nullable=False
    )
    op.create_unique_constraint(None, "registryrepository", ["origin"])
    op.drop_column("registryrepository", "version")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "registryrepository",
        sa.Column("version", sa.VARCHAR(), autoincrement=False, nullable=False),
    )
    op.drop_constraint(None, "registryrepository", type_="unique")
    op.alter_column(
        "registryrepository", "origin", existing_type=sa.VARCHAR(), nullable=True
    )
    op.add_column(
        "registryaction",
        sa.Column("version", sa.VARCHAR(), autoincrement=False, nullable=False),
    )
    op.drop_constraint(
        "uq_registry_action_namespace_name", "registryaction", type_="unique"
    )
    op.create_unique_constraint(
        "uq_registry_action_namespace_name_version",
        "registryaction",
        ["namespace", "name", "version"],
    )
    # ### end Alembic commands ###
