"""Remove cases

Revision ID: 054e842cb078
Revises: eba1f1b8f56d
Create Date: 2024-10-10 21:46:07.042351

"""

from collections.abc import Sequence

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "054e842cb078"
down_revision: str | None = "eba1f1b8f56d"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_caseevent_id", table_name="caseevent")
    op.drop_table("caseevent")
    op.drop_index("ix_case_id", table_name="case")
    op.drop_table("case")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "case",
        sa.Column(
            "surrogate_id",
            sa.INTEGER(),
            server_default=sa.text("nextval('case_surrogate_id_seq'::regclass)"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("owner_id", sa.UUID(), autoincrement=False, nullable=False),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("workflow_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("case_title", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column(
            "payload",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("malice", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("status", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("priority", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("action", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "context",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "tags",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("surrogate_id", name="case_pkey"),
        postgresql_ignore_search_path=False,
    )
    op.create_index("ix_case_id", "case", ["id"], unique=True)
    op.create_table(
        "caseevent",
        sa.Column("surrogate_id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("owner_id", sa.UUID(), autoincrement=False, nullable=False),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("type", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("case_id", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("initiator_role", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column(
            "data",
            postgresql.JSONB(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["case_id"], ["case.id"], name="caseevent_case_id_fkey", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("surrogate_id", name="caseevent_pkey"),
    )
    op.create_index("ix_caseevent_id", "caseevent", ["id"], unique=True)
    # ### end Alembic commands ###
