"""Add org secrets

Revision ID: 046d417c113f
Revises: 054e842cb078
Create Date: 2024-10-11 17:32:12.582693

"""

from collections.abc import Sequence

import sqlalchemy as sa
import sqlmodel
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "046d417c113f"
down_revision: str | None = "054e842cb078"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "organizationsecret",
        sa.Column("surrogate_id", sa.Integer(), nullable=False),
        sa.Column("owner_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("(now() AT TIME ZONE 'utc'::text)"),
            nullable=False,
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("type", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("description", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("encrypted_keys", sa.LargeBinary(), nullable=False),
        sa.Column("environment", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("tags", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.PrimaryKeyConstraint("surrogate_id"),
        sa.UniqueConstraint("name", "environment"),
    )
    op.create_index(
        op.f("ix_organizationsecret_id"), "organizationsecret", ["id"], unique=True
    )
    op.create_index(
        op.f("ix_organizationsecret_name"), "organizationsecret", ["name"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_organizationsecret_name"), table_name="organizationsecret")
    op.drop_index(op.f("ix_organizationsecret_id"), table_name="organizationsecret")
    op.drop_table("organizationsecret")
    # ### end Alembic commands ###
