const PRIMARY_COLOR_PALETTE = [
	{
		bgcolor: 'primary.light',
		color: 'denim-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'primary.100',
		color: 'denim-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'primary.200',
		color: 'denim-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'primary.300',
		color: 'denim-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'primary.400',
		color: 'denim-400',
		hex: '#1973E2',
		dark: false,
	},
	{
		bgcolor: 'primary.main',
		color: 'denim-500',
		hex: '#1560BD',
		dark: false,
	},
	{
		bgcolor: 'primary.dark',
		color: 'denim-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'primary.700',
		color: 'denim-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'primary.800',
		color: 'denim-800',
		hex: '#041326',
		dark: false,
	},
];
const SECONDARY_COLOR_PALETTE = [
	{
		bgcolor: 'secondary.light',
		color: 'supernova-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'secondary.100',
		color: 'supernova-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'secondary.200',
		color: 'supernova-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'secondary.300',
		color: 'supernova-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'secondary.400',
		color: 'supernova-400',
		hex: '#1973E2',
		dark: true,
	},
	{
		bgcolor: 'secondary.main',
		color: 'supernova-500',
		hex: '#1560BD',
		dark: true,
	},
	{
		bgcolor: 'secondary.dark',
		color: 'supernova-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'secondary.700',
		color: 'supernova-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'secondary.800',
		color: 'supernova-800',
		hex: '#041326',
		dark: false,
	},
];
const TERTIARY_COLOR_PALETTE = [
	{
		bgcolor: 'tertiary.light',
		color: 'supernova-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'tertiary.100',
		color: 'supernova-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'tertiary.200',
		color: 'supernova-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'tertiary.300',
		color: 'supernova-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'tertiary.400',
		color: 'supernova-400',
		hex: '#1973E2',
		dark: false,
	},
	{
		bgcolor: 'tertiary.main',
		color: 'supernova-500',
		hex: '#1560BD',
		dark: false,
	},
	{
		bgcolor: 'tertiary.dark',
		color: 'supernova-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'tertiary.700',
		color: 'supernova-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'tertiary.800',
		color: 'supernova-800',
		hex: '#041326',
		dark: false,
	},
];
const CUATERNARY_COLOR_PALETTE = [
	{
		bgcolor: 'cuaternary.light',
		color: 'dodger-blue-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'cuaternary.100',
		color: 'dodger-blue-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'cuaternary.200',
		color: 'dodger-blue-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'cuaternary.300',
		color: 'dodger-blue-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'cuaternary.400',
		color: 'dodger-blue-400',
		hex: '#1973E2',
		dark: true,
	},
	{
		bgcolor: 'cuaternary.main',
		color: 'dodger-blue-500',
		hex: '#1560BD',
		dark: false,
	},
	{
		bgcolor: 'cuaternary.dark',
		color: 'dodger-blue-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'cuaternary.700',
		color: 'dodger-blue-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'cuaternary.800',
		color: 'dodger-blue-800',
		hex: '#041326',
		dark: false,
	},
];
const SUCCESS_COLOR_PALETTE = [
	{
		bgcolor: 'success.light',
		color: 'sea-green-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'success.100',
		color: 'sea-green-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'success.200',
		color: 'sea-green-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'success.300',
		color: 'sea-green-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'success.400',
		color: 'sea-green-400',
		hex: '#1973E2',
		dark: true,
	},
	{
		bgcolor: 'success.main',
		color: 'sea-green-500',
		hex: '#1560BD',
		dark: false,
	},
	{
		bgcolor: 'success.dark',
		color: 'sea-green-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'success.700',
		color: 'sea-green-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'success.800',
		color: 'sea-green-800',
		hex: '#041326',
		dark: false,
	},
];
const WARNING_COLOR_PALETTE = [
	{
		bgcolor: 'warning.light',
		color: 'sea-green-50',
		hex: '#96C0F3',
		dark: false,
	},
	{
		bgcolor: 'warning.main',
		color: 'sea-green-100',
		hex: '#84B5F1',
		dark: false,
	},
	{
		bgcolor: 'warning.dark',
		color: 'sea-green-200',
		hex: '#5F9FED',
		dark: false,
	},
];
const INFO_COLOR_PALETTE = [
	{
		bgcolor: 'info.light',
		color: 'sea-green-50',
		hex: '#96C0F3',
		dark: false,
	},
	{
		bgcolor: 'info.main',
		color: 'sea-green-100',
		hex: '#84B5F1',
		dark: false,
	},
	{
		bgcolor: 'info.dark',
		color: 'sea-green-200',
		hex: '#5F9FED',
		dark: false,
	},
];
const ERROR_COLOR_PALETTE = [
	{
		bgcolor: 'error.light',
		color: 'sea-green-50',
		hex: '#96C0F3',
		dark: true,
	},
	{
		bgcolor: 'error.100',
		color: 'sea-green-100',
		hex: '#84B5F1',
		dark: true,
	},
	{
		bgcolor: 'error.200',
		color: 'sea-green-200',
		hex: '#5F9FED',
		dark: true,
	},
	{
		bgcolor: 'error.300',
		color: 'sea-green-300',
		hex: '#3A88E9',
		dark: true,
	},
	{
		bgcolor: 'error.400',
		color: 'sea-green-400',
		hex: '#1973E2',
		dark: false,
	},
	{
		bgcolor: 'error.main',
		color: 'sea-green-500',
		hex: '#1560BD',
		dark: false,
	},
	{
		bgcolor: 'error.dark',
		color: 'sea-green-600',
		hex: '#0F468B',
		dark: false,
	},
	{
		bgcolor: 'error.700',
		color: 'sea-green-700',
		hex: '#0A2D58',
		dark: false,
	},
	{
		bgcolor: 'error.800',
		color: 'sea-green-800',
		hex: '#041326',
		dark: false,
	},
];
const TEXT_COLOR_PALETTE = [
	{
		bgcolor: 'text.primary',
		dark: false,
	},
	{
		bgcolor: 'text.secondary',
		dark: false,
	},
	{
		bgcolor: 'text.tertiary',
		dark: false,
	},
	{
		bgcolor: 'text.hint',
		dark: true,
	},
];
const BACKGROUND_COLOR_PALETTE = [
	{
		bgcolor: 'background.default',
		dark: true,
	},
	{
		bgcolor: 'background.paper',
		dark: true,
	},
	{
		bgcolor: 'border',
		dark: true,
	},
];
const EXTRA_COLOR_PALETTE = [
	{
		title: 'Text color',
		palette: TEXT_COLOR_PALETTE,
	},
	{
		title: 'Background color',
		palette: BACKGROUND_COLOR_PALETTE,
	},
];

const MAIN_COLORS = [
	{
		title: 'Primary color',
		palette: PRIMARY_COLOR_PALETTE,
	},
	{
		title: 'Secondary color',
		palette: SECONDARY_COLOR_PALETTE,
	},
	{
		title: 'Tertiary color',
		palette: TERTIARY_COLOR_PALETTE,
	},
	{
		title: 'Cuaternary color',
		palette: CUATERNARY_COLOR_PALETTE,
	},
];
const SYSTEM_COLORS = [
	{
		title: 'Succes',
		palette: SUCCESS_COLOR_PALETTE,
	},
	{
		title: 'Warning',
		palette: WARNING_COLOR_PALETTE,
	},
	{
		title: 'Info',
		palette: INFO_COLOR_PALETTE,
	},
	{
		title: 'Error',
		palette: ERROR_COLOR_PALETTE,
	},
];

export default {
	extraColor: EXTRA_COLOR_PALETTE,
	mainColor: MAIN_COLORS,
	systemColor: SYSTEM_COLORS,
};
