# slim-mui-template &middot; ![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg) ![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg) ![Price](https://img.shields.io/badge/price-FREE-0098f7.svg)

<a href="https://github.com/Tono2007/slim-free-react-mui-template/stargazers">
  <img alt="Stars" src="https://img.shields.io/github/stars/Tono2007/slim-free-react-mui-template?style=social">
<a href="https://github.com/Tono2007/slim-free-react-mui-template/forks">
  <img alt="Forks" src="https://img.shields.io/github/forks/Tono2007/slim-free-react-mui-template?style=social">
</a>
<a href="https://github.com/Tono2007/slim-free-react-mui-template/releases">
  <img alt="Version" src="https://img.shields.io/github/package-json/v/Tono2007/slim-free-react-mui-template?filename=complete-template%2Fpackage.json">
</a>
<a href="https://github.com/Tono2007/slim-free-react-mui-template/graphs/contributors">
  <img alt="React contributors" src="https://img.shields.io/github/contributors/Tono2007/slim-free-react-mui-template">
</a>
<a href="https://github.com/Tono2007/slim-free-react-mui-template/releases"><img src="https://img.shields.io/github/release/Tono2007/slim-free-react-mui-template"></a>
<a href="https://github.com/Tono2007/slim-free-react-mui-template/issues"><img src="https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat"></a>

![CI/CD](https://github.com/Tono2007/slim-free-react-mui-template/actions/workflows/pipeline.yml/badge.svg)

<div align="center">
<img src="complete-template//src/assets/images/logo/png/Color_logo_nobg.png" />  
</div>
<h3 align="justify">Modern and clean mui Template

Slim - a free and open source React dashboard template made using Material UI React component library with aim of flexibility and better customizability.

Modern & Clean Responsive MUI Material-ui Admin Dashboard Template. It is fully responsive.

It can be used for most type of dashboard and app templates like analytics, admin or messenger app for your desktop or mobile applications. Amazing flexibility and reusability. **85+** Demo pages </h3>

<div align="center">
<img src="complete-template/src/assets/images/logo/png/Color_logotext_nobg.png"  height="50px"/>  

⭐ ⭐ ⭐ Do not forget to star (Top right of this page) it if you like the theme ⭐ ⭐ ⭐
</div>

![slim-free-react-mui-template netlify app_](https://github.com/Tono2007/slim-free-react-mui-template/assets/35477201/89d5c71f-b25d-4627-83d2-580ff845927d)

-   Support React18.
-   Professional user interface.
-   Material UI React components.
-   Fully responsive, all modern browser supported.
-   Easy to use code & folder structure.
-   Flexible & high-Performance code
-   Hundreds of customized MUI components.
-   Pre-build useful pages & Apps.
-   Dark & light mode

## Free SLIM MUI React js version

-   [Complete Version Preview](https://slim-free-react-mui-template.netlify.app/)
-   [Clean Version Preview](https://slim-free-react-mui-clean-template.netlify.app/)
Version with only components, styles, theme and sample page
-   [Download from Github](https://github.com/Tono2007/slim-free-react-mui-template/releases)

## Getting Started

Clone from Github

```
git clone https://github.com/Tono2007/slim-free-react-mui-template.git
```

## Technology Stack

-   [Material UI V5](https://mui.com/)
-   React 18
-   Built with React Hooks API
-   Redux & React Context API for State Management
-   React Router for Navigation Routing
-   Vite
-   Code Splitting
-   Aliases
-   Light/Dark theme support
-   Eslint - airbnb style guide
-   ApexCharts

![JavaScript](https://img.shields.io/badge/JavaScript-%23323330.svg?style=for-the-badge&logo=Javascript&logoColor=%23F7DF1E)
![React](https://img.shields.io/badge/React-149eca?style=for-the-badge&logo=react&logoColor=fff)
![Prettier](https://img.shields.io/badge/Prettier-crimson?style=for-the-badge&logo=Prettier&logoColor=fff)
![ESLint](https://img.shields.io/badge/ESLint-000?style=for-the-badge&logo=ESLint&logoColor=fff)
![MUI](https://img.shields.io/badge/Material%20UI-007FFF?style=for-the-badge&logo=mui&logoColor=white)

## Issues

To report a bug, please submit an [issue](https://github.com/Tono2007/slim-free-react-mui-template/issues) on Github. We will respond as soon as possible to resolve the issue.

## Roadmap
### Priorities
- More components!
- More Pages
- Better customization
- Better documentation
- Performance
- Bundle size
---
## In future
- User issues & support
- Typescript version
- Next/CRA/Remix versions
- Accessibility.


## Color Presets

We use different colors

| ![#f03c15](https://placehold.it/40/1560BD/1560BD?text=.) | ![#f03c15](https://placehold.it/40/FEC604/FEC604?text=.) | ![#f03c15](https://placehold.it/40/E219D7/E219D7?text=.) | ![#f03c15](https://placehold.it/40/17A3F1/17A3F1?text=.) | ![#f03c15](https://placehold.it/40/F0F2F7/F0F2F7?text=.) |
| -------------------------------------------------------- | -------------------------------------------------------- | -------------------------------------------------------- | -------------------------------------------------------- | -------------------------------------------------------- |

## Changelog

<!-- https://ascii-tree-generator.com/ -->

## Folder Structure

```bash
├── package.json           -> Package json file.
├── public
├── README.md
├── src
│   ├── _mocks             -> Mock Json data to be used for working apps
│   ├── assets
│   │   ├── images
│   │   ├── css            -> Template css files
│   │   │   ├── style.css  -> Application main css file
│   ├── components
│   │   │── layouts
│   │   │   ├── LandingLayout  -> Layout for landing components & routers
│   │   │   ├── MainLayout     -> Layout for main components & routers
│   │   │   ├── MinimalLayout  -> Layout for mimimal components & routers
│   │   ├── loader
│   │   ├── modal
│   │── pages              -> View files for all pages
│   ├── contexts/redux     -> State management
│   ├── utils
│   │   ├── helpers        -> helpers utilities
│   │   ├── hocs           -> Custom hocs
│   │   ├── hooks          -> Custom hooks
│   │   ├── routes         -> router
│   │   ├── theme          -> custom theme provider
│   │   ├── constants      -> general app constants
│   ├──App.js              -> starting point of application
├── vite.config.js         -> Template constant value and live customization
├── index.html
```

## DOC

Slim routing system is based on [react-router](https://reacttraining.com/react-router) and its package [react-router-dom](https://reactrouter.com/en/main), it's also using code splitting for better performance.

## License

-   Licensed cover under [MIT](https://github.com/codedthemes/datta-able-bootstrap-dashboard/blob/master/LICENSE)
