# Awesome APIs

[![](https://camo.githubusercontent.com/13c4e50d88df7178ae1882a203ed57b641674f94/68747470733a2f2f63646e2e7261776769742e636f6d2f73696e647265736f726875732f617765736f6d652f643733303566333864323966656437386661383536353265336136336531353464643865383832392f6d656469612f62616467652e737667)](https://github.com/sindresorhus/awesome)
[![](https://camo.githubusercontent.com/15a53d5ec5d896319068168a27da0203156bbdb9/68747470733a2f2f6a617977636a6c6f76652e6769746875622e696f2f73622f6c616e672f656e676c6973682e737667)](README.md)
[![](https://camo.githubusercontent.com/cb8cb80af654f3dae14a4aa62e44bf62f16953d6/68747470733a2f2f6a617977636a6c6f76652e6769746875622e696f2f73622f6c616e672f6368696e6573652e737667)](README-zh.md)
[![Backers on Open Collective](https://opencollective.com/awesome_apis/backers/badge.svg)](#backers)
 [![Sponsors on Open Collective](https://opencollective.com/awesome_apis/sponsors/badge.svg)](#sponsors)

This repo is a collection of **AWESOME** APIs for developers. Feel free to **Star** and **Fork**. Any comments, suggestions? [Let us know](https://github.com/TonnyL/Awesome_APIs/issues). we love PRs :), please follow the [awesome](https://github.com/sindresorhus/awesome) list.

English | [中文](README-zh.md)
## Table of Contents

+ [Anime](#anime)
+ [Blogging](#blogging)
+ [Books](#books)
+ [Business](#business)
+ [Calendar](#calendar)
+ [Carsharing](#carsharing)
+ [Cloud](#cloud)
+ [Cloud Storage](#cloud-storage)
+ [Delivery tracking](#delivery-tracking)
+ [Design](#design)
+ [Development](#development)
+ [Email](#email)
+ [Fitness & Wearables](#fitness--wearables)
+ [Food](#food)
+ [Forex & Currencies](#forex--currencies)
+ [Games](#games)
+ [IoT](#iot)
+ [Machine Learning](#machine-learning)
+ [Maps](#maps)
+ [Messaging](#messaging)
+ [Music](#music)
+ [News & Information](#news--information)
+ [Notes](#notes)
+ [Payment](#payment)
+ [Photography](#photography)
+ [Places](#places)
+ [Social](#social)
+ [Shopping](#shopping)
+ [Takeout](#takeout)
+ [Teamwork](#teamwork)
+ [Text Analysis](#text-analysis)
+ [To-dos](#to-dos)
+ [Tourism](#tourism)
+ [Translation](#translation)
+ [Video](#video)
+ [Voice Analysis](#voice-analysis)
+ [Vision Analysis](#vision-analysis)
+ [Weather](#weather)
+ [More Resources](#more-resources)

### Anime
+ [AcgClub](https://github.com/Rabtman/AcgClub/wiki/%E5%AE%85%E7%A4%BEAcgClub-API) - AcgClub API provides ACG-related aggregation services.
+ [AniList](https://github.com/AniList/ApiV2-GraphQL-Docs) - The AniList GraphQL Api provides quick and powerful access to over 500k anime and manga entries, including character, staff, and live airing data.
+ [hitokoto](https://hitokoto.cn/api) - hitokoto API provides a one-word service, which can be a line in anime, or a variety of small paragraphs on the network.
+ [Kitsu API](https://kitsu.docs.apiary.io/#) - Kitsu is a modern anime discovery platform that helps you track the anime you're watching, discover new anime and socialize with other fans.


### Blogging
+ [Blogger](https://developers.google.com/blogger/) - The Blogger API v3 allows you to create new blog posts, edit or delete existing posts, and query for posts that match particular criteria.
+ [Medium](https://github.com/Medium/medium-api-docs) - Access to the data of [medium.com](https://medium.com/).
+ [Weebly](https://cloud-developer.weebly.com/) - With Weebly Cloud, you provide Weebly’s best-in-class website builder to enable your customers to create their own website, blog or online store in minutes, while you maintain full control over billing, support, and the customer relationship.
+ [WordPress](https://codex.wordpress.org/WordPress_APIs) - Access to WordPress's APIs.
+ [Telegraph](http://telegra.ph/api) - Access to Telegraph's APIs, Telegram's publishing service.

### Books
+ [An API Of Ice And Fire](https://anapioficeandfire.com/) - The An API of Ice And Fire provide data about all Book, Characters, Houses from the universe of 'A Song of Ice and Fire' in JSON format. Authentication is not required. Node and Swift libraries available.
+ [Open Library Books API](https://openlibrary.org/developers/api) - Open Library is an open, editable library catalog, building towards a web page for every book ever published.
+ [The New York Public Library Digital Collections API](http://api.repo.nypl.org/) - For more than a century, The NY Public Library has amassed an extraordinary trove of rare and unique material covering the full spectrum of recorded knowledge.
+ [Bookshare](http://developer.bookshare.org/) - The Bookshare API allows our partners to enable their customers with qualified print disabilities to search,browse and download books and periodicals.

### Business
+ [Airtable](https://airtable.com/api) - The Airtable Standard API allows you to create, read, update, and destroy records.
+ [Buffer](https://buffer.com/developers/api) - The Buffer API provides access to user's pending and sent updates, social media profiles, scheduled times and more.
+ [Concur Labs](https://developer.concur.com/api-reference/) - Access to Concur's RESTful API.
+ [Envoy](https://developers.envoy.com/) - Access to Envoy's API.
+ [JotForm](http://api.jotform.com/docs/) - The JotForm API makes it possible to connect to your form data without using the JotForm web site.
+ [MailChimp](https://developer.mailchimp.com/) - Access to MailChimp's API.
+ [Pruvan](https://pruvan.com/resources/pruvan-api/) - Access to Pruvan's API.
+ [Quip](https://quip.com/api/) - The Quip REST API enables you to automate processes and integrate Quip with other products you or your company uses.
+ [Salesforce](https://developer.salesforce.com/page/Salesforce_APIs) - Access to Salesforce's API.
+ [Square](https://connect.squareup.com/) - Square offers easy credit card processing and complete solutions for every type of business.
+ [Wolfram Data Drop](https://www.wolfram.com/datadrop/quick-reference/web-api/) - Access to Wolfram Data Drop's RESTful API.

### Calendar
+ [Google Calendar](https://developers.google.com/google-apps/calendar/) - The Google Calendar API lets you integrate your app with Google Calendar, creating new ways for you to engage your users.
+ [Outlook Calendar](https://msdn.microsoft.com/en-us/office/office365/api/calendar-rest-operations) - The Calendar API provides access to events, calendar, and calendar group data secured by Azure Active Directory on Office 365, and to similar data in Microsoft accounts specifically in these domains: Hotmail.com, Live.com, MSN.com, Outlook.com, and Passport.com.

### Carsharing
+ [Lyft](https://www.lyft.com/developers) - Allows to get real-time ETAs, availability, price estimates, ride status.
+ [Shenzhou](http://developer.10101111.com/resourceCenter/doc?r=api/content) - A Chinese carsharing company.(**Missing English Docs**)
+ [Uber](https://developer.uber.com/) - Allows to customize trip experiences, request ride, power logistics, create bot and so much more.

### Cloud
+ [aliyun](https://develop.aliyun.com/api/) - (**Missing English Docs**)
+ [Baidu Cloud](https://cloud.baidu.com/doc/index.html) - (**Missing English Docs**)
+ [Bmob](http://www.bmob.cn/) - (**Missing English Docs**)
+ [Google Cloud Platform](https://cloud.google.com/apis/docs/overview)
+ [LeanCloud](https://leancloud.cn/) -	(**Missing English Docs**)
+ [Oracle Cloud](https://cloud.oracle.com/home)
+ [qiniu](http://www.qiniu.com/) - (**Missing English Docs**)
+ [Tencent Cloud](https://cloud.tencent.com/document/api?lang=en)
+ [wilddog](https://www.wilddog.com/) - (**Missing English Docs**)
+ [upyun](https://www.upyun.com/) - (**Missing English Docs**)

### Cloud Storage
+ [Amazon Cloud Drive](https://developer.amazon.com/amazon-drive) - With the Amazon Cloud Drive's updated RESTful API and SDKs for Android and iOS, Amazon Drive is moving to an invite-only developer offering to ensure they can provide a consistently viable cloud drive service available for supported use-cases.
+ [Box](https://developer.box.com/) - Search, metadata, granular permission models, enterprise-grade security, retention policies, preview capabilities for 120 file types.
+ [Digital Ocean](https://developers.digitalocean.com/) - Deploy an SSD cloud server in 55 seconds.
+ [Document Cloud](http://www.documentcloud.org/help/api) - DocumentCloud runs every document you upload through OpenCalais,giving you access to extensive information about the people, places and organizations mentioned in each.
+ [Dropbox](https://www.dropbox.com/developers) - A powerful API for apps that work with files.
+ [Google Drive](https://developers.google.com/drive/)- Google Drive APIs allow you to read, write, and sync files stored in Google Drive from your mobile and web apps.
+ [OneDrive](https://dev.onedrive.com/) - Access to OneDrive files.
+ [QNAP](https://www.qnap.com/event/dev/useng/p_about.php) - With QNAP Development Toolkit (API & SDK), developers can design applications that can run on a client’s device (such as a smart phone or PC) and remotely manage and access files and documents stored on the NAS.
+ [Verizon Cloud](http://www.verizonenterprise.com/cloud/documentation/StorageAPIReference.htm) - Upload, retrieve, and manage large amounts of data, access data through an API call, view prepackaged reports, rely on Verizon security to keep data safe and accessible at all times.

### Delivery-Tracking
+ [AfterShip](https://docs.aftership.com/api/) - Supports shipment tracking and notifications for over 200 couriers.
+ [aikuaidi](http://www.aikuaidi.cn/api/) - Supports shipment tracking for over 200 Chinese couriers.(**Missing English Docs**)
+ [Aramex](https://www.aramex.com/developers/aramex-apis) - Provides parcel, package, and freight delivery via a global network of shipping providers.
+ [Canada Post](http://www.canadapost.ca/cpo/mc/business/productsservices/developers/services/fundamentals.jsf) - Allows e-commerce solution providers and online merchants to integrate Canada Post services, such as shipping, rating and tracking data, into a platform or website.
+ [DHL](http://www.dhl-usa.com/en/express/resource_center/integrated_shipping_solutions.html) - DHL XML Services provides developers the ability to integrate DHL's service availability, transit times, rates, shipment tracking and more from more than 140 countries.
+ [FedEx](https://www.fedex.com/us/developer/web-services/index.html) - FedEx web services allow businesses to integrate FedEx shipping functionality into their existing warehouse management systems without hosting on-site.
+ [kuaidi100](http://www.kuaidi100.com/openapi/) - Supports shipment tracking for over 100 Chinese couriers and 300 international couriers.(**Missing English Docs**)
+ [kuaidi.com](http://www.kuaidi.com/openapi.html) - Supports shipment tracking for over 100 couriers.(**Missing English Docs**)
+ [kdniao](http://www.kdniao.com/) - Supports shipment tracking for over 400 couriers.(**Missing English Docs**)
+ [UPS](http://www.ups.com/content/us/en/resources/techsupport/developercenter.html) - Provides UPS shipping functionalities to be integrated into websites and enterprise applications.  

### Design
+ [Dribbble](http://developer.dribbble.com/v1/) - Access to buckets, projects, shots, teams, users, jobs data.
+ [Behance](https://www.behance.net/dev/api/endpoints/) - Get information of projects, creatives to follow, creative fields, users, collections.
+ [deviantART](https://www.deviantart.com/developers/) - Allows to get data of deviantart.com.

### Development
+ [ARTIK Cloud](https://developer.artik.cloud/documentation/api-reference/) - The ARTIK Cloud API provides access to the ARTIK Cloud platform.
+ [AT&T M2X](https://m2x.att.com/developer/documentation/v2/overview) - M2X's RESTful API streamlines the connection between devices and the M2X service, allowing you to build applications and services that leverage time-series data analytics and distributed, high-availability time-series data storage, to deliver meaningful information to your customers and end-users and build IOT and M2M solutions without managing your own storage infrastructure.
+ [Bitbucket](https://developer.atlassian.com/cloud/bitbucket/) - Bitbucket is a web-based hosting service that is owned by Atlassian, used for source code and development projects that use either Mercurial or Git revision control systems.
+ [bitly](https://dev.bitly.com/) - bitly is the easiest and most fun way to save, share and discover links from around the web.
+ [Buddy](https://buddy.works/api/reference/getting-started/overview) - Buddy is a Continuous Integration service. It supports GitHub, Bitbucket, and Gitlab projects. Automate the lifecycle of web & Docker apps: Build, Test & Deploy.
+ [Bugzilla](https://wiki.mozilla.org/Bugzilla:REST_API) - Bugzilla is a Web-based general-purpose bugtracker and testing tool originally developed and used by the Mozilla project, and licensed under the Mozilla Public License.
+ [CircleCI](https://circleci.com/docs/api/v1-reference/) - The CircleCI API is a RESTful, fully-featured API that allows you to access all information and trigger all actions in CircleCI.
+ [Coding](https://open.coding.net/) - Access to https://coding.net/ .
+ [Dataflow kit](https://github.com/slotix/dataflowkit) - Dataflow kit is a Web Scraping framework for Gophers. It helps to extract data from web pages, following the specified CSS Selectors.
+ [diycode](https://www.diycode.cc/api) - Access to https://www.diycode.cc/ .
+ [gank.io](http://gank.io/api) - Access to API of http://gank.io/ .(**Missing English Docs**)
+ [GitHub](https://developer.github.com/v3/) - The world's leading software development platform.
+ [Gitter](https://developer.gitter.im/docs/welcome) - Chat tools for GitHub.
+ [GitLab](https://docs.gitlab.com/ee/api/README.html) - Automate GitLab via a simple and powerful API.
+ [Google Play Developer](https://developers.google.com/android-publisher/) - The Google Play Developer API allows you to perform a number of publishing and app-management tasks.
+ [IPInfo.io](https://ipinfo.io/developers) - Use the ipinfo.io IP lookup API to quickly and simply integrate IP geolocation into your script or website.
+ [Laravel China](https://laravel-china.org/topics/3097) - Access to API of https://laravel-china.org/ .(**Missing English Docs**)
+ [MAC Address Vendor Lookup](https://macaddress.io/api-documentation) - Retrieve vendor details and other information regarding a given MAC address or an OUI.
+ [openHAB](https://github.com/openhab/openhab1-addons/wiki/REST-API) - The REST API of openHAB serves different purposes. It can be used to integrate openHAB with other systems as it allows read access to items and item states as well as status updates or the sending of commands for items. Furthermore, it gives access to the sitemaps, so that it is the interface to be used by remote user interfaces (e.g. fat clients or fully Javascript based web clients).
+ [oschina](http://www.oschina.net/openapi) - Access to API of https://oschina.net/ .(**Missing English Docs**)
+ [Particle](https://docs.particle.io/reference/api/) - The Particle Cloud API is a REST API.
+ [ProxyCrawl](https://proxycrawl.com) -  Scrape and crawl any website without blocks, captchas or proxies.
+ [QR Code Generator](http://goqr.me/api/) - You can generate and decode / read QR code graphics with the QR code generator web API at api.qrserver.com.
+ [Ruby China](https://ruby-china.org/api-doc/) - Access to API of https://ruby-china.org/ .(**Missing English Docs**)
+ [Scraper API](https://www.scraperapi.com/documentation) -  Easily build scalable web scrapers with Scraper API.
+ [StackExchange](https://api.stackexchange.com/docs) Access to Stack Exchange API.
+ [SVN](https://subversion.apache.org/docs/api/1.8/) - This documentation covers the public APIs provided by the Subversion libraries. It is intended mainly for programmers, both those working on Subversion itself, as well as developers of 3rd-party applications intending to use these APIs.
+ [TravisCI](https://docs.travis-ci.com/api/) - This is the API used by the official Travis CI web interface, so everything the web ui is able to do can also be accomplished via the API.
+ [upyun](http://docs.upyun.com/api/developer_guide/) - Access to API of https://www.upyun.com/ .(**Missing English Docs**)
+ [V2EX](https://www.v2ex.com/p/7v9TEc53) - Access to API of https://www.v2ex.com/ .(**Missing English Docs**)
+ [W3C](https://github.com/w3c/w3c-api) - In response to demand from developers in W3C community wanting to interact with [W3C](http://www.w3.org/)'s data, the W3C Systems Team has developed a Web API. Through it they are making available data on Specifications, Groups, Organizations and Users.The W3C API is a read-only Web API based on the JSON format exposing only public data.
+ [ZenHub](https://github.com/ZenHubIO/API) - ZenHub is the only project management tool that integrates natively within GitHub’s user interface.

### Email
+ [Context.IO](http://context.io/) - Context.IO is a modern, scalable email API that simplifies working with email data.
+ [Gmail](https://developers.google.com/gmail/api/) - Modern, easy, fast, RESTful.
+ [Inbox](https://www.inboxapp.com/docs) - Inbox provides modern RESTful APIs for working with mail providers. Stop fighting the old protocols and focus on building great apps.
+ [Mandrill](https://mandrillapp.com/api/docs/) - Mandrill is like MailChimp, for apps. Send transactional, triggered, and personalized email, then track results.
+ [Outlook Mail](https://msdn.microsoft.com/en-us/office/office365/api/mail-rest-operations) - The Outlook Mail API lets you read, create, and send messages and attachments, view and respond to event messages, and manage folders that are secured by Azure Active Directory in Office 365. It also provides the same functionality in Microsoft accounts specifically in these domains: Hotmail.com, Live.com, MSN.com, Outlook.com, and Passport.com.

### Fitness & Wearables
+ [Adidas AG](https://developers.adidas.com/services) - Access to Adidas AG's API.
+ [Fitbit](https://dev.fitbit.com/) - The Fitbit API allows developers to interact with Fitbit data in their own applications, products and services.
+ [Jawbone UP](https://jawbone.com/up/developer) - Harness the power of step, activity, food, and sleep tracking to build your own products and experiences.
+ [Lifelog](https://developer.sony.com/develop/services/lifelog-api/) - Sony’s Lifelog API gives you secure access to your users’ lifestyle, fitness and health data, collected through sensors in their smartphone and connected SmartWear devices. Use it to create innovative new use cases in your app or service.
+ [Misfit](https://build.misfit.com/) - You can now leverage a suite of tools to integrate Misfit’s activity tracking, sleep tracking and wearable control functionality into your products and services.
+ [Nike+](https://developer.nike.com/content/nike-developer-cq/us/en_us/index/documentation/api-docs.html) - Activity Services return detailed information aggregated from a user’s activity with Nike+. For example, a user’s run details, like average pace, time, distance, NikeFuel earned from his/her Nike+ FuelBand, lifetime achievements and more.
+ [Recon](http://www.reconinstruments.com/developers/develop/for-recon-engage/api-documentation/) - Access to [Recon instruments](http://www.reconinstruments.com/)'s data.
+ [Strava](https://strava.github.io/api/) - The Strava V3 API is a publicly available interface allowing developers access to the rich Strava dataset.
+ [Withings](http://www.withings.com/us/en/developers) - The Withings API allows developers to create applications that take advantage of the Withings devices and the data they record.

## Food
+ [Order Pizza REST API](https://order-pizza-api.herokuapp.com/api/ui) - 🍕 A RESTful API as pizza restaurant ordering system.


### Forex & Currencies
+ [1Forge.com](https://1forge.com/) - Real-time forex and crypto quotes via JSON and WebSocket.
+ [CurrencyScoop.com](https://currencyscoop.com/) - Free Real-time and historical currency rates JSON API.

### Games
+ [Battle.net](https://dev.battle.net/) - Battle.net is an online video game Web site that features a collection of games developed by Blizzard Entertainment. The available Battle.net APIs include D3, WoW, SC2, Community APIs, and Game Data APIs.
+ [Clash of Clans](https://developer.clashofclans.com/#/) - The Clash of Clans API provides near real­time access to game related data.
+ [EVE Online](https://developers.eveonline.com/) - EVE Online is one of the most popular science fiction massively multiplayer online role-playing games (MMORPG). The EVE Online CREST and XML APIs provide programmatic access to characters, industries, markets, solar system, alliances and corporations, and other game data.
+ [Facebook Games Services](https://developers.facebook.com/docs/games) - The Facebook Games Developer Center features a variety of services for game developers including (but not limited to) Achievements API, Scores API, App Notifications, Requests, Feed Gaming, and Facebook SDK for Unity.
+ [Google Play Games Services](https://developers.google.com/games/) - The Google Developers Games site provides a variety of APIs, SDKs, and services including (but not limited to) game publishing API, Unity Plugin, Play Games Services (achievements, leaderboards, player stats, etc.), and Google AdMob.
+ [Riot Games](https://developer.riotgames.com/) - Provides the League of Legends developer community with access to game data in a secure and reliable way.
+ [Steam Web APIs](https://steamcommunity.com/dev) - The Steam Web APIs allow developers to query Steam for information that they can present on their own sites.At the moment the only APIs we offer provide item data for Team Fortress 2, but this list will grow over time.
+ [Giant Bomb](http://www.giantbomb.com/api/) - The Giant Bomb API provides programmatic access to a lot of the information available on the Giant Bomb Web site such as game titles, ratings, videos, companies, themes, genres, and much more.
+ [Guild Wars 2](https://wiki.guildwars2.com/wiki/API:Main) The Guild Wars 2 API is an interface that enables third-party applications to access data directly from the Guild Wars 2 servers.

### IoT
+ [Automatic](https://developer.automatic.com/) - Provides REST API, Real-time Event API and Streaming API for interacting with Automatic data.
+ [Amazon Alexa](https://developer.amazon.com/public/solutions/alexa/alexa-voice-service/content/avs-api-overview) - The Alexa Voice Service API allows developers to voice-enable connected products with a microphone and speaker.
+ [Google Assistant](https://developers.google.com/actions/) - Actions on Google let you build for the Google Assistant.
+ [Home8](https://developer.home8systems.com/) - 100% wireless IoT System, Home8 simplifies Smart Alarm systems with DIY installation while providing you with the best Video-Verified Alarm protection.
+ [Homey](https://developers.athom.com/api/) - Access to Homey's API.
+ [HP Print](https://developers.hp.com/printos/printos) - Access to HP Print's API.
+ [LIFX](https://api.developer.lifx.com/) - LIFX is a multi-color smart WiFi-enabled LED lightbulb. The LIFX HTTP API lets you control LIFX devices over the internet and is REST inspired API for interacting with LIFX devices.
+ [LightwaveRF](https://api.lightwaverf.com/) - This API outlines the local command protocols currently in use in the LightwaveRF system.
+ [microBees](http://developers.microbees.com/documentation/#reference) - Easily execute REST APIs and subscribe for real-time messaging.
+ [Mojio](https://www.moj.io/developer/) - Use the REST endpoints for request and response type integrations and the PUSH API to push data in real-time.
+ [myStrom](https://mystrom.ch/de/mystrom-api) - The myStrom WLAN Energy Control Switch offers a REST API which allows you to access/control the switch from directly from your local network independent from myStrom.
+ [Neurio](http://neur.io/developers/) - Neurio is an open platform with a public API so you can extend it any way you like. Connect it to web services, or write your own applications.
+ [Philips Hue](https://developers.meethue.com/) - Philips Hue connected bulbs and bridge let you to take full control of your lighting.
+ [Smappee](https://smappee.atlassian.net/wiki/display/DEVAPI/SmappeeDevAPI+Home) - Access to Smappee's API which helps you measure your electrical energy consumption and solar production.
+ [SmartThins](https://developers.athom.com/api/) - Access to SmartThings' API.
+ [Stack Lighting](http://developers.stacklighting.com/) - The Stack API is a REST API, which defines a set of functions that allow developers to perform requests and to receive responses via the HTTP protocol. This API provides developers with the ability to control brightness, color temperature, motion settings, ambient light sensing settings, and other features to tailor Stack’s responsive lighting to one's unique preferences.
+ [Vinli](https://dev.vin.li/#/home) - Vinli is a platform for easily and quickly building connected car apps.
+ [Yeelight](http://www.yeelight.com/en_US/developer) - Yeelight smart LED products support remote control through WiFi.

### Machine Learning
+ [Amazon Machine Learning](https://aws.amazon.com/cn/documentation/machine-learning/) - Amazon Machine Learning makes it easy for developers to build smart applications, including applications for fraud detection, demand forecasting, targeted marketing, and click prediction.
+ [BigML](https://bigml.com/api) - The BigML platform features anomaly detection, cluster analysis, SunBurst visualization for decision trees, text analysis, and more.
+ [Diffbot](https://www.diffbot.com/dev/docs/) - The Diffbot platform utilizes a combination of AI, computer vision, machine learning, and natural language processing to automatically extract data from web pages such as text, images, video, product information, and comments.
+ [Google Cloud Prediction](https://cloud.google.com/prediction/docs/) - Google Cloud Prediction API provides a RESTful API to build Machine Learning models. Prediction's cloud-based machine learning tools can help analyze your data to add various features to your applications, such as customer sentiment analysis, spam detection, recommendation systems, and more.
+ [IBM Watson](https://developer.ibm.com/watson/) - Allow developers to build applications that utilize machine learning technologies such as natural language processing, computer vision, and prediction.
+ [Microsoft Azure Machine Learning](https://azure.microsoft.com/en-us/services/cognitive-services/) - The Microsoft Azure Machine Learning platform provides capabilities such as natural language processing, recommendation engine, pattern recognition, computer vision, and predictive modeling.

### Maps
+ [Amap](http://lbs.amap.com/) - Access to Amap's web APIs.(**Missing English Docs**)
+ [Baidu Map](http://lbsyun.baidu.com/index.php?title=webapi) - Access to Baidu Map's web APIs.(**Missing English Docs**)
+ [Bing maps](https://www.microsoft.com/maps/choose-your-bing-maps-API.aspx) - Access to Bing maps' APIs.
+ [Google Maps](https://developers.google.com/maps/web-services/?hl=en) - The Google Maps web services are a collection of HTTP interfaces to Google services providing geographic data for your maps applications.
+ [Here Maps](https://developer.here.com/develop/rest-apis) - Use simple HTTP GET methods providing maps, routing, geocoding, places, positioning, traffic, transit and weather information.
+ [Tencent Map](http://lbs.qq.com/webservice_v1/index.html) - Access to Tencent Map's WebService APIs.(**Missing English Docs**)

### Messaging
+ [Cisco Spark](https://developer.ciscospark.com/) - Create a room and invite people, search for people in your company, post messages into a room, get room history or be notified in real-time when new messages are posted by others.
+ [Dingtalk](https://open-doc.dingtalk.com/) - Access to Dingtalk's APIs.(**Missing English Docs**)
+ [dondeEsta Family](http://docs.dondeesta.apiary.io/#introduction/api) - Access to dondeEsta family API.
+ [Fleep](https://fleep.io/fleepapi/) - Fleep is a messenger for all your teams and projects.
+ [GroupMe](https://dev.groupme.com/docs/v3) - The GroupMe API will enable you to enhance existing apps with our group messaging abilities, build interesting new experiences, or simply add a little spice to your existing groups.
+ [indoona](https://developer.indoona.com/) - The indoona RESTful API over HTTPS that lets you: send messages to indoona users and groups, create special address book contacts to let indoona users chat with your application.
+ [LINE](https://developers.line.me/) - LINE is a freeware app for instant communications on electronic devices such as smartphones, tablet computers, and personal computers.
+ [MessageBird](https://developers.messagebird.com/) - The MessageBird API connects your website or application to operators around the world. With the API you can integrate SMS, Chat & Voice.
+ [Slack](https://api.slack.com/) - Slack is a cloud-based set of proprietary team collaboration tools and services.
+ [Telegram](https://core.telegram.org/api) - The Bot API allows you to easily create programs that use Telegram messages for an interface. The Telegram API allows you to build your own customized Telegram clients.
+ [Yo](http://docs.justyo.co/) - Yo is the simplest notification platform.

### Music
+ [Deezer](https://developers.deezer.com/) - Deezer is an Internet-based music streaming service.
+ [KaolaFM](https://github.com/kaolafm/api) - Allows to access the data of KaolaFM.(**Missing English Docs**)
+ [Last.fm](http://www.last.fm/zh/api?setlang=en) - The Last.fm API allows anyone to build their own programs using Last.fm data, whether they're on the web, the desktop or mobile devices.
+ [MusicGraph](https://developer.musicgraph.com/) - MusicGraph API, launched by Senzari, is the world's first knowledge engine for music, which will be available as a powerful 'graph API' that can be leveraged by developers to enhance their applications with deep musical intelligence.
+ [Musixmatch](https://developer.musixmatch.com/) - Bring lyrics on your application with the Musixmatch API.
+ [One Music](http://www.onemusicapi.com/) - OneMusicAPI is able to provide metadata about an astonishing range of music because it aggregates existing, well maintained, online databases.
+ [QingtingFM](http://open.qingting.fm/) - Allows to access the data fo QingtingFM.(**Missing English Docs**)
+ [Qi'eFM](http://wq.qq.com/) - Allows to access the data of Qi'eFM.(**Missing English Docs**)
+ [SearchLy](https://github.com/AlbertSuarez/searchly) - Similarities search based on song lyrics.
+ [SoundCloud](https://developers.soundcloud.com/) - Allow users to upload and share sounds across the web.
+ [Spotify](https://developer.spotify.com/web-api/) - Spotify's Web API lets your applications fetch data from the Spotify music catalog and manage user’s playlists and saved music.

### News & information
+ [aztro](https://aztro.sameerkumar.website) - aztro is a REST API for retrieving horoscope information.
+ [BrewereyDB](http://www.brewerydb.com/developers) - BreweryDB is a database of breweries, beers, beer events and guilds.
+ [Diigo](https://www.diigo.com/api_dev) - The Diigo API allows you to build apps that interact with the Diigo service.
+ [feedly](https://developer.feedly.com/) - Access to feedly's API.
+ [Genius](https://docs.genius.com/) - The Genius API to help build the world's greatest public knowledge project since Wikipedia.
+ [goodreads](https://www.goodreads.com/api) - The Goodreads API allows developers access to Goodreads data in order to help websites or applications that deal with books be more personalized, social, and engaging.
+ [HackerNews](https://github.com/HackerNews/API) - Documentation and Samples for the Official HN API.
+ [Inoreader](https://www.inoreader.com/developers/) - The Inoreader API allows you to help users subscribe to feeds, read articles or catalogue them for viewing later.
+ [Instapaper](https://www.instapaper.com/api) - The Instapaper API allows third-party applications to add URLs to Instapaper.
+ [Narro](https://docs.narro.co/#introduction) - Access articles and readings, as well as submit them on behalf of customers.
+ [Newsblur](https://newsblur.com/api) - NewsBlur's API allows users to retrieve their feeds, feed counts, feed icons, feed statistics, and individual feed stories.
+ [NPR](http://www.npr.org/api/index) - NPR's API provides a flexible, powerful way to access your favorite NPR content.
+ [Pinboard](https://pinboard.in/api) - The Pinboard API is a way to interact programmatically with your bookmarks, notes and other Pinboard data.
+ [Pocket](https://getpocket.com/developer/) - Bring the power of save for later to your users and applications by integrating the Pocket API.
+ [Product Hunt](https://api.producthunt.com/v1/docs) - Access to [producthunt.com](https://www.producthunt.com/)'s API.
+ [The New York Times](https://developer.nytimes.com/) - Access to The New York Times's API.
+ [USA TODAY](https://developer.usatoday.com/docs/) - Access to the latest news and most interesting stories from USA TODAY.

### Notes
+ [Evernote](https://dev.evernote.com/doc/) - Access to Evernote's API references as well as guides
+ [OneNote](https://msdn.microsoft.com/en-us/office/office365/howto/onenote-supported-ops) - Access to OneNote's RESTful APIs.
+ [Youdao Note](http://note.youdao.com/open/) - Access to Youdao Note's web APIs.(**Missing English Docs**)

### Payment
+ [PayPal](https://developer.paypal.com/docs/api/) - Access to PayPal's REST APIs.
+ [Paymill](https://developers.paymill.com/index) - Access the full API reference and get any information you need to know to implement PAYMILL.
+ [Paytm](https://paytm.com/business/payments/developers) - Access to the details of the APIs you need to work with to take payments on your app/website using Paytm Wallet and for handling operational issues related to payments (eg: refunds, transaction status check).
+ [WePay](https://www.wepay.com/) - WePay is designed for platforms like marketplaces, crowdfunding sites & small business tools. Get a seamless user experience & fraud protection.
+ [Phonepe](https://developer.phonepe.com/docs) - PhonePe provides a cashless and seamless payment experience to customers. PhonePe is a multi-instrument payment container and allows customers to pay through UPI, Debit Card, Credit Card, and Wallet.

### Photography
+ [500px](https://github.com/500px/api-documentation) - 500px API provides programmatic access to 500px functionality and content.
+ [Giphy](https://developers.giphy.com/docs/) - The largest GIF library in the world.
+ [Imgur](https://api.imgur.com/) - Using Imgur's RESTful API, you can do just about anything you can do on [imgur.com](http://imgur.com/).
+ [Pixabay](https://pixabay.com/api/docs/) - The pixabay API is a RESTful interface for searching and retrieving Pixabay images and videos released under Creative Commons CC0.
+ [Unsplash](https://unsplash.com/documentation) - Access to the most powerful photo engine in the world.
+ [Unsplash It](https://unsplash.it/) - Beautiful placeholders using images from [unsplash](https://unsplash.com/).
+ [Unsplash Resource](https://source.unsplash.com/) - A simple API for embedding [Unsplash](https://unsplash.com/) photos.

### Places
+ [Yelp](https://www.yelp.com/developers/documentation/v2/overview) - Access to Yelp's API.
+ [Zomato](https://developers.zomato.com/api) - Zomato APIs give you access to the freshest and most exhaustive information for over 1.5 million restaurants across 10,000 cities globally.

### Social
+ [Disqus](https://disqus.com/api/docs/) - Disqus' platform includes various features, such as social integration, social networking, user profiles, spam and moderation tools, analytics, email notifications, and mobile commenting.
+ [Facebook](https://developers.facebook.com/docs/?locale=en_US) - Facebook is an American for-profit corporation and an online social media and social networking service.
+ [Flickr](https://www.flickr.com/services/api/) - Almost certainly the best online photo management and sharing application in the world.
+ [Foursquare](https://developer.foursquare.com/) - The Foursquare API gives you access to our world-class places database and the ability to interact with Foursquare users and merchants.
+ [Instagram](https://www.instagram.com/developer/) - A simple, fun & creative way to capture, edit & share photos, videos & messages with friends & family.
+ [LinkedIn](https://developer.linkedin.com/) - World's largest professional network.
+ [Pinterest](https://developers.pinterest.com/) - The Pinterest API lets you access users' Pinterest data, like their boards, Pins, followers and more.
+ [Reddit](https://www.reddit.com/dev/api/) - Reddit is an American social news aggregation, web content rating, and discussion website.
+ [Tumblr](https://www.tumblr.com/docs/en/api/v2) - Tumblr is a place to express yourself, discover yourself, and bond over the stuff you love.
+ [Twitter](https://dev.twitter.com/) - Access to Twitter's data.
+ [Weibo](http://open.weibo.com/wiki/API) - Access to posts, users, comments, favorites, etc.(**Missing English Docs**)

### Shopping
+ [Amazon](https://developer.amazon.com/services-and-apis) - Access to Amazon's APIs.
+ [Best Buy](https://developer.bestbuy.com/) - Access to Best Buy's APIs.
+ [Dangdang](http://open.dangdang.com/) - Access to Dangdang's APIs.
+ [eBay](https://go.developer.ebay.com/) - Access to eBay's APIs.
+ [Home Depot](https://developer.homedepot.com/) - Access to Home Depot's APIs.
+ [JD](https://jos.jd.com/api/index.htm) - Access to JD's APIs.
+ [Semantics3](http://docs.semantics3.com/reference) - Access to Semantics3's RESTful APIs.
+ [Slice](https://developer.slice.com/) - Access to Slice's REST APIs.
+ [Taobao](https://open.taobao.com/doc2/api_list.htm) - Access to Taobao's APIs.

### Takeout
+ [Baidu Waimai](http://dev.waimai.baidu.com/) - Baidu Waimai is a Chinese takeout platform.(**Missing English Docs**)
+ [Dianping](http://developer.dianping.com) - Dianping is a Chinese takeout platform.(**Missing English Docs**)
+ [Eleme](http://openapi.eleme.io/v2/quickstart.html) - Eleme is a Chinese takeout platform.(**Missing English Docs**)
+ [Meituan](http://developer.waimai.meituan.com/doc/show) - Meituan is a Chinese takeout platform.(**Missing English Docs**)

### Teamwork
+ [Asana](https://asana.com/guide/help/api/api) - Allows you to programmatically update and access much of your data on the platform.
+ [join.me](https://developer.join.me/) - join.me is the online meeting tool that just gets out of the way so that people can accomplish great things together.
+ [Teambition](https://www.teambition.com/developer/open-platform) - Teambition's Open Platform offers complete set of Open API for data acquisition. Building an app based on project data will make the most use of your collaboration data, such as project tracking, data mining and more.
+ [TeamSnap](http://developer.teamsnap.com/) - Empower your users with the world's best team management solution.
+ [Trello](https://developers.trello.com/) - Trello is a web-based project management application.
+ [Worktile](https://dev.worktile.com/document/overview) - Access to Worktile's APIs.(**Missing English Docs**)

### Text Analysis
+ [BosonNLP](http://docs.bosonnlp.com/) - Chinese text analysis.(**Missing English Docs**)
+ [Detect Language API](https://rapidapi.com/BigLobster/api/language-identification-prediction) - Automatic language identification for any texts.
+ [Tencent NLP](http://nlp.qq.com/help.cgi) - Chinese text analysis.(**Missing English Docs**)
+ [Text Analytics API](https://azure.microsoft.com/en-us/services/cognitive-services/text-analytics/) - The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms.
+ [Watson Natural Language Understanding](https://www.ibm.com/watson/developercloud/natural-language-understanding/api/v1/) - Natural Language Understanding by Watson uses natural language processing to analyze semantic features of any text.

### To-dos
+ [Beeminder](https://www.beeminder.com/api) - Access to Beeminder's APIs.
+ [FollowUp.cc](http://docs.followup.cc/) - Access to FollowUp.cc's APIs.
+ [Todoist](https://developer.todoist.com/) - Todoist API (also known as the “Sync API”) is specially designed for efficient data sync between clients (e.g. mobile apps) and Todoist.
+ [Toodledo](https://api.toodledo.com/3/) - The Toodledo API is free to use and provides access to a user's tasks, notes, outlines and lists.

### Tourism
+ [ctrip](http://u.ctrip.com/union/help/Termsofuse.aspx) - Access to the data of ctrip.(**Missing English Docs**)
+ [elong](http://open.elong.com/home/index) - Provides access to the data of hotels and air tickets.(**Missing English Docs**)
+ [qunar](http://open.qunar.com/) - Access to qunar's hotel, train tickets, air tickets and insurance data.(**Missing English Docs**)
+ [tuniu](http://open.tuniu.cn/) - Access to the data of tuniu. Only available to suppliers.(**Missing English Docs**)

### Translation
+ [Baidu Translate](http://api.fanyi.baidu.com/api/trans/product/index) - Supports translation between multiple languages.(**Missing English Docs**)
+ [Google Translate](https://cloud.google.com/translate/docs/) - Dynamically translate between thousands of available language pairs.
+ [iciba](http://open.iciba.com/?c=api) - Support simple translation.(**Missing English Docs**)
+ [Microsoft Translator](https://www.microsoft.com/en-us/translator/translatorapi.aspx) -  A cloud-based machine translation service supporting multiple languages that reach more than 95% of world's gross domestic product (GDP).
+ [Oxford Dictionaries](https://developer.oxforddictionaries.com/) - Access to Oxford Dictionaries' APIs.
+ [Shanbay](https://www.shanbay.com/help/developer/api_v1/) - Provides complete APIs which support users in query, adding study records, writing note, etc.(**Missing English Docs**)
+ [Yandex Translate](https://tech.yandex.com/translate/) - Supports more than 70 languages and can translate separate words or complete texts.
+ [yeekit](http://api.yeekit.com/) - Support translation between several languages.(**Missing English Docs**)
+ [Youdao](http://fanyi.youdao.com/openapi) - Support simple translation.(**Missing English Docs**)

### Video
+ [Dailymotion](https://developer.dailymotion.com/api) - Dailymotion is the second largest video hosting platform in the world.
+ [Narrative](http://open.getnarrative.com/) - Customize your clip, get players, badges, and play with the Narrative API.
+ [iqiyi](http://open.iqiyi.com/lib/scheme.html) - Supports query data of iqiyi.(**Missing English Docs**)
+ [LeTV](http://www.lecloud.com/zh-cn/help/2016/07/27/150.html?LeftMenu=api_db_guide) - Allows to query data, upload, download, etc.(**Missing English Docs**)
+ [Rotten Tomatoes](https://developer.fandango.com/Rotten_Tomatoes) - The Rotten Tomatoes API provides access to Rotten Tomatoes' ratings and reviews, allowing approved companies and individuals to enrich their applications and widgets with Rotten Tomatoes data.
+ [Sohu TV](http://lm.tv.sohu.com/union/open_platform.do) - Allows to query data.(**Missing English Docs**)
+ [The Movie Database (TMDb)](https://developers.themoviedb.org) - The Movie Database API provides access to Top rated movies, Upcoming movies, Now playing movies, Popular movies, Popular TV shows, Top rated TV shows, On the air TV shows, Airing today TV shows, Popular people and more.
+ [TVmaze](https://www.tvmaze.com/api) - TV Show and web series database. Episode guide, cast, crew and character information. Recaps, reviews, episode trailers, celebrity photos and more.
+ [Vimeo](https://developer.vimeo.com/) - The web's most supportive community of creators and get high-quality tools for hosting, sharing, and streaming videos in gorgeous HD with no ads.
+ [Youtube](https://developers.google.com/youtube/documentation/) - Embed YouTube functionality into your own website and applications.
+ [Youku](https://doc.open.youku.com/) - Allows to upload, download, log in, etc.(**Missing English Docs**)

### Voice Analysis
+ [Baidu Yuyin](http://yuyin.baidu.com/docs) - Access to Baidu Yuyin's voice analysis REST APIs.(**Missing English Docs**)
+ [Cloud Speech API](https://cloud.google.com/speech/) - Google Cloud Speech API enables developers to convert audio to text by applying powerful neural network models in an easy to use API.

### Vision Analysis
+ [CamScanner](https://dev.camscanner.com/?language=en-us) - Allows to digitalize paper documents with cutting-edge image processing technologies.
+ [clarifai](https://clarifai.com/developer/guide/) - The Clarifai API offers image and video recognition as a service.
+ [Cloud Vision API](https://cloud.google.com/vision/) - Google Cloud Vision API enables developers to understand the content of an image by encapsulating powerful machine learning models in an easy to use REST API.
+ [Computer Vision API](https://azure.microsoft.com/en-us/services/cognitive-services/computer-vision/) - The Computer Vision API by Microsoft provides state-of-the-art algorithms to process images and return information.
+ [Face++](https://console.faceplusplus.com/documents/5678948) - Face++ Cognitive Services is a platform offering computer vision technologies that enable your applications to read and understand the world better.
+ [Watson Visual Recognition](https://www.ibm.com/watson/developercloud/visual-recognition/api/v3/#introduction) - The IBM Watson™ Visual Recognition service identifies scenes, objects, and celebrity faces in images you upload to the service. You can create and train a custom classifier to identify subjects that suit your needs.
+ [wozhitu](http://api1.wozhitu.com/) - Access to wozhitu's vision analysis APIs.(**Missing English Docs**)

### Weather
+ [AccuWeather](http://apidev.accuweather.com/developers/) - The AccuWeather API provides subscribers access to location based weather data via a simple RESTful web interface.
+ [Aeris Weather](http://www.aerisweather.com/develop/) - An advanced weather API to power all of your custom applications, offering a breath of fresh air from the basic to the most complex solutions.
+ [Caiyun Weather](https://caiyunapp.com/index.html#api) - Weather information of China.(**Missing English Docs**)
+ [heweather](https://www.heweather.com/documents/) - Weather information of China.(**Missing English Docs**)
+ [Open Weather Map](https://openweathermap.org/api) - The OpenWeatherMap service provides free weather data and forecast API suitable for any cartographic services like web and smartphones applications.
+ [Weather Underground](https://www.wunderground.com/weather/api/) - Reliable data, accurate forecast, & global coverage in 80 languages.
+ [Weather Unlocked](https://developer.weatherunlocked.com/documentation) - Weather driven solutions for digital advertising, eCommerce and developers.
+ [Seniverse](https://www.seniverse.com/doc) - Weather information of China.(**Missing English Docs**)
+ [Yandex.Weather](https://tech.yandex.com/weather/) - Yandex.Weather uses proprietary forecasting technology Meteum to assess current weather conditions in specific locations on the territory of **Russia** and create forecasts for these geographic coordinates.
+ [Yahoo! Weather](https://developer.yahoo.com/weather/) - Get up-to-date weather information for any location, including 5-day forecast, wind, atmosphere, astronomy conditions, and more.

### More Resources
+ [Alidayu](http://www.alidayu.com/) - Provides APIs which are available in China.(**Missing English Docs**)
+ [Amazon Developer](https://developer.amazon.com/) - Allows to build software about the Amazon Apps&Games, the Alexa, the AWS, the Amazon Services&APIs and the Amazon Devices.
+ [APiX](https://www.apix.cn/) - Provides some credit APIs which are available in China.(**Missing English Docs**)
+ [Avatar Data](http://www.avatardata.cn/Docs) - Provides APIs which are available in China.(**Missing English Docs**)
+ [Baidu API STORE](http://apistore.baidu.com/) - Provides APIs which are available in China.(**Missing English Docs**)
+ [Datayes](https://m.datayes.com/) - Provides some financial APIs which are available in China.(**Missing English Docs**)
+ [Google API Library](https://console.developers.google.com/apis/library) - The Google API Library contains more than 100 apis such as the Google Cloud APIs, the Google Maps APIs, the Google Apps APIs, the Mobile APIs, the Social Media APIs, the Youtube APIs, the Advertising APIs, and the Other popular APIs.
+ [HaoService](http://www.haoservice.com/) - Provides APIs which are available in China.(**Missing English Docs**)
+ [iTunes Search API](https://affiliate.itunes.apple.com/resources/documentation/itunes-store-web-service-search-api/) - Allows to place search fields in the website to search for content within the iTunes Store, App Store, iBooks Store and Mac App Store.
+ [Microsoft Developer](https://developer.microsoft.com/en-us/) - Access to Microsoft's public APIs.
+ [Juhe Data](https://www.juhe.cn/) - Provides APIs which are available in China.(**Missing English Docs**)
+ [ProgrammableWeb](https://www.programmableweb.com/) - The leading source of news & information about APIs, chronicling the evolution of the global API economy & providing the web's most relied-on API Directory.
+ [Yahoo! Developer Network](https://developer.yahoo.com/everything.html) - The Yahoo Developer Network offers APIs and tools to make it easy for developers to build, advertise, enhance applications and earn money with Yahoo.

## Contributors

This project exists thanks to all the people who contribute.
<a href="graphs/contributors"><img src="https://opencollective.com/Awesome_APIs/contributors.svg?width=890&button=false" /></a>


## Backers

Thank you to all our backers! 🙏 [[Become a backer](https://opencollective.com/Awesome_APIs#backer)]

<a href="https://opencollective.com/Awesome_APIs#backers" target="_blank"><img src="https://opencollective.com/Awesome_APIs/backers.svg?width=890"></a>


## Sponsors

Support this project by becoming a sponsor. Your logo will show up here with a link to your website. [[Become a sponsor](https://opencollective.com/Awesome_APIs#sponsor)]

<a href="https://opencollective.com/Awesome_APIs/sponsor/0/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/1/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/2/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/3/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/4/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/5/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/6/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/7/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/8/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/Awesome_APIs/sponsor/9/website" target="_blank"><img src="https://opencollective.com/Awesome_APIs/sponsor/9/avatar.svg"></a>
