# A1. Jailbreak
- [2025/01] **[Jailbreaking Multimodal Large Language Models via Shuffle Inconsistency](https://arxiv.org/abs/2501.04931)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2025/01] **[Layer-Level Self-Exposure and Patch: Affirmative Token Mitigation for Jailbreak Attack Defense](https://arxiv.org/abs/2501.02629)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2025/01] **[Spot Risks Before Speaking! Unraveling Safety Attention Heads in Large Vision-Language Models](https://arxiv.org/abs/2501.02029)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2025/01] **[Safeguarding Large Language Models in Real-time with Tunable Safety-Performance Trade-offs](https://arxiv.org/abs/2501.02018)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2025/01] **[Auto-RT: Automatic Jailbreak Strategy Exploration for Red-Teaming Large Language Models](https://arxiv.org/abs/2501.01830)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2025/01] **[LLM-Virus: Evolutionary Jailbreak Attack on Large Language Models](https://arxiv.org/abs/2501.00055)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[Token Highlighter: Inspecting and Mitigating Jailbreak Prompts for Large Language Models](https://arxiv.org/abs/2412.18171)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/12] **[AEIOU: A Unified Defense Framework against NSFW Prompts in Text-to-Image Models](https://arxiv.org/abs/2412.18123)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/12] **[SATA: A Paradigm for LLM Jailbreak via Simple Assistive Task Linkage](https://arxiv.org/abs/2412.15289)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[JailPO: A Novel Black-box Jailbreak Framework via Preference Optimization against Aligned LLMs](https://arxiv.org/abs/2412.15623)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[No Free Lunch for Defending Against Prefilling Attack by In-Context Learning](https://arxiv.org/abs/2412.12192)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[Defending LVLMs Against Vision Attacks through Partial-Perception Supervision](https://arxiv.org/abs/2412.12722)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/12] **[AdvPrefix: An Objective for Nuanced LLM Jailbreaks](https://arxiv.org/abs/2412.10321)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[Model-Editing-Based Jailbreak against Safety-aligned Large Language Models](https://arxiv.org/abs/2412.08201)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[Antelope: Potent and Concealed Jailbreak Attack Strategy](https://arxiv.org/abs/2412.08156)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/12] **[AdvWave: Stealthy Adversarial Jailbreak Attack against Large Audio-Language Models](https://arxiv.org/abs/2412.08608)** ![SLM](https://img.shields.io/badge/SLM-39c5bb)
- [2024/12] **[FlexLLM: Exploring LLM Customization for Moving Target Defense on Black-Box LLMs Against Jailbreak Attacks](https://arxiv.org/abs/2412.07672)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[PrisonBreak: Jailbreaking Large Language Models with Fewer Than Twenty-Five Targeted Bit-flips](https://arxiv.org/abs/2412.07192)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/12] **[BAMBA: A Bimodal Adversarial Multi-Round Black-Box Jailbreak Attacker for LVLMs](https://arxiv.org/abs/2412.05892)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/12] **[Heuristic-Induced Multimodal Risk Distribution Jailbreak Attack for Multimodal Large Language Models](https://arxiv.org/abs/2412.05934)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/12] **[Improved Large Language Model Jailbreak Detection via Pretrained Embeddings](https://arxiv.org/abs/2412.01547)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/11] **[Immune: Improving Safety Against Jailbreaks in Multi-modal LLMs via Inference-Time Alignment](https://arxiv.org/abs/2411.18688)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/11] **[PEFT-as-an-Attack! Jailbreaking Language Models during Federated Parameter-Efficient Fine-Tuning](https://arxiv.org/abs/2411.19335)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[In-Context Experience Replay Facilitates Safety Red-Teaming of Text-to-Image Diffusion Models](https://arxiv.org/abs/2411.16769)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/11] **["Moralized" Multi-Step Jailbreak Prompts: Black-Box Testing of Guardrails in Large Language Models for Verbal Attacks](https://arxiv.org/abs/2411.16730)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[Preventing Jailbreak Prompts as Malicious Tools for Cybercriminals: A Cyber Defense Perspective](https://arxiv.org/abs/2411.16642)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[GASP: Efficient Black-Box Generation of Adversarial Suffixes for Jailbreaking LLMs](https://arxiv.org/abs/2411.14133)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[Rapid Response: Mitigating LLM Jailbreaks with a Few Examples](https://arxiv.org/abs/2411.07494)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/11] **[JailbreakLens: Interpreting Jailbreak Mechanism in the Lens of Representation and Circuit](https://arxiv.org/abs/2411.11114)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[SoK: Unifying Cybersecurity and Cybersafety of Multimodal Foundation Models with an Information Theory Approach](https://arxiv.org/abs/2411.11195)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2024/11] **[The VLLM Safety Paradox: Dual Ease in Jailbreak Attack and Defense](https://arxiv.org/abs/2411.08410)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/11] **[SequentialBreak: Large Language Models Can be Fooled by Embedding Jailbreak Prompts into Sequential Prompt Chains](https://arxiv.org/abs/2411.06426)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[MRJ-Agent: An Effective Jailbreak Agent for Multi-Round Dialogue](https://arxiv.org/abs/2411.03814)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Agent](https://img.shields.io/badge/Agent-87b800)
- [2024/11] **[What Features in Prompts Jailbreak LLMs? Investigating the Mechanisms Behind Attacks](https://arxiv.org/abs/2411.03343)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/11] **[SQL Injection Jailbreak: a structural disaster of large language models](https://arxiv.org/abs/2411.01565)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Transferable Ensemble Black-box Jailbreak Attacks on Large Language Models](https://arxiv.org/abs/2410.23558)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Effective and Efficient Adversarial Detection for Vision-Language Models via A Single Vector](https://arxiv.org/abs/2410.22888)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/10] **[RobustKV: Defending Large Language Models against Jailbreak Attacks via KV Eviction](https://arxiv.org/abs/2410.19937)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/10] **[You Know What I'm Saying: Jailbreak Attack via Implicit Reference](https://arxiv.org/abs/2410.03857)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Lucas-TY/llm_Implicit_reference) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Adversarial Attacks on Large Language Models Using Regularized Relaxation](https://arxiv.org/abs/2410.19160)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[SafeBench: A Safety Evaluation Framework for Multimodal Large Language Models ](https://arxiv.org/abs/2410.18927)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/10] **[AdvWeb: Controllable Black-box Attacks on VLM-powered Web Agents](https://arxiv.org/abs/2410.17401)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Agent](https://img.shields.io/badge/Agent-87b800)
- [2024/10] **[Feint and Attack: Attention-Based Strategies for Jailbreaking and Protecting LLMs](https://arxiv.org/abs/2410.16327)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Faster-GCG: Efficient Discrete Optimization Jailbreak Attacks against Aligned Large Language Models](https://arxiv.org/abs/2410.15362)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Jailbreaking and Mitigation of Vulnerabilities in Large Language Models](https://arxiv.org/abs/2410.15236)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Refusal-Trained LLMs Are Easily Jailbroken As Browser Agents](https://arxiv.org/abs/2410.13886)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[SoK: Prompt Hacking of Large Language Models](https://arxiv.org/abs/2410.13901)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Derail Yourself: Multi-turn LLM Jailbreak Attack through Self-discovered Clues](https://arxiv.org/abs/2410.10700)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Deciphering the Chaos: Enhancing Jailbreak Attacks via Adversarial Prompt Translation](https://arxiv.org/abs/2410.11317)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[BlackDAN: A Black-Box Multi-Objective Approach for Effective and Contextual Jailbreaking of Large Language Models](https://arxiv.org/abs/2410.09804)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[RePD: Defending Jailbreak Attack through a Retrieval-based Prompt Decomposition Process](https://arxiv.org/abs/2410.08660)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/10] **[AutoDAN-Turbo: A Lifelong Agent for Strategy Self-Exploration to Jailbreak LLMs](https://arxiv.org/abs/2410.05295)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Root Defence Strategies: Ensuring Safety of LLM at the Decoding Level](https://arxiv.org/abs/2410.06809)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/10] **[Chain-of-Jailbreak Attack for Image Generation Models via Editing Step by Step](https://arxiv.org/abs/2410.03869)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/10] **[Functional Homotopy: Smoothing Discrete Optimization via Continuous Parameters for LLM Jailbreak Attacks](https://arxiv.org/abs/2410.04234)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Harnessing Task Overload for Scalable Jailbreak Attacks on Large Language Models](https://arxiv.org/abs/2410.04190)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[FlipAttack: Jailbreak LLMs via Flipping](https://arxiv.org/abs/2410.02832)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[Jailbreak Antidote: Runtime Safety-Utility Balance via Sparse Representation Adjustment in Large Language Models](https://arxiv.org/abs/2410.02298)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/10] **[VLMGuard: Defending VLMs against Malicious Prompts via Unlabeled Data](https://arxiv.org/abs/2410.00296)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/10] **[Adversarial Suffixes May Be Features Too!](https://arxiv.org/abs/2410.00451)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[Multimodal Pragmatic Jailbreak on Text-to-image Models](https://arxiv.org/abs/2409.19149)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/09] **[Read Over the Lines: Attacking LLMs and Toxicity Detection Systems with ASCII Art to Mask Profanity](https://arxiv.org/abs/2409.18708)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[RED QUEEN: Safeguarding Large Language Models against Concealed Multi-Turn Jailbreaking](https://arxiv.org/abs/2409.17458)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[MoJE: Mixture of Jailbreak Experts, Naive Tabular Classifiers as Guard for Prompt Attacks](https://arxiv.org/abs/2409.17699)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/09] **[PathSeeker: Exploring LLM Security Vulnerabilities with a Reinforcement Learning-Based Jailbreak Approach](https://arxiv.org/abs/2409.14177)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[Effective and Evasive Fuzz Testing-Driven Jailbreaking Attacks against LLMs](https://arxiv.org/abs/2409.14866)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[AdaPPA: Adaptive Position Pre-Fill Jailbreak Attack Approach Targeting LLMs](https://arxiv.org/abs/2409.07503)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/09] **[Unleashing Worms and Extracting Data: Escalating the Outcome of Attacks against RAG-based Inference in Scale and Severity Using Jailbreaking](https://arxiv.org/abs/2409.08045)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![RAG](https://img.shields.io/badge/RAG-87b800)
- [2024/09] **[HSF: Defending against Jailbreak Attacks with Hidden State Filtering](https://arxiv.org/abs/2409.03788)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/08] **[Emerging Vulnerabilities in Frontier Models: Multi-Turn Jailbreak Attacks ](https://arxiv.org/abs/2409.00137)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[Detecting AI Flaws: Target-Driven Attacks on Internal Faults in Language Models](https://arxiv.org/abs/2408.14853)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[Advancing Adversarial Suffix Transfer Learning on Aligned Large Language Models](https://arxiv.org/abs/2408.14866)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[LLM Defenses Are Not Robust to Multi-Turn Human Jailbreaks Yet](https://arxiv.org/abs/2408.15221)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/08] **[RT-Attack: Jailbreaking Text-to-Image Models via Random Token](https://arxiv.org/abs/2408.13896)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/08] **[Unlocking Adversarial Suffix Optimization Without Affirmative Phrases: Efficient Black-box Jailbreaking via LLM as Optimizer](https://arxiv.org/abs/2408.11313)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[SAGE-RT: Synthetic Alignment data Generation for Safety Evaluation and Red Teaming](https://arxiv.org/abs/2408.11851)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/08] **[Hide Your Malicious Goal Into Benign Narratives: Jailbreak Large Language Models through Neural Carrier Articles](https://arxiv.org/abs/2408.11182)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[EEG-Defender: Defending against Jailbreak through Early Exit Generation of Large Language Models](https://arxiv.org/abs/2408.11308)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/08] **[Probing the Safety Response Boundary of Large Language Models via Unsafe Decoding Path Generation](https://arxiv.org/abs/2408.10668)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[Prefix Guidance: A Steering Wheel for Large Language Models to Defend Against Jailbreak Attacks](https://arxiv.org/abs/2408.08924)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[BaThe: Defense against the Jailbreak Attack in Multimodal Large Language Models by Treating Harmful Instruction as Backdoor Trigger](https://arxiv.org/abs/2408.09093)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/08] **[MMJ-Bench: A Comprehensive Study on Jailbreak Attacks and Defenses for Vision Language Models](https://arxiv.org/abs/2408.08464)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/08] **[Defending LLMs against Jailbreaking Attacks via Backtranslation](https://aclanthology.org/2024.findings-acl.948/)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/YihanWang617/LLM-Jailbreaking-Defense-Backtranslation) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ACL'24_(Findings)](https://img.shields.io/badge/ACL'24_(Findings)-f1b800)
- [2024/08] **[Jailbreak Open-Sourced Large Language Models via Enforced Decoding](https://aclanthology.org/2024.acl-long.299/)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2024/08] **[h4rm3l: A Dynamic Benchmark of Composable Jailbreak Attacks for LLM Safety Assessment](https://arxiv.org/abs/2408.04811)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/08] **[A Jailbroken GenAI Model Can Cause Substantial Harm: GenAI-powered Applications are Vulnerable to PromptWares](https://arxiv.org/abs/2408.05061)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[EnJa: Ensemble Jailbreak on Large Language Models](https://arxiv.org/abs/2408.03603)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/08] **[Jailbreaking Text-to-Image Models with LLM-Based Agents](https://arxiv.org/abs/2408.00523)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/07] **[Defending Jailbreak Attack in VLMs via Cross-modality Information Detector](https://arxiv.org/abs/2407.21659)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/07] **[Exploring Scaling Trends in LLM Robustness](https://arxiv.org/abs/2407.18213)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[The Dark Side of Function Calling: Pathways to Jailbreaking Large Language Models](https://arxiv.org/abs/2407.17915)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Can Large Language Models Automatically Jailbreak GPT-4V?](https://arxiv.org/abs/2407.16686)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/07] **[PrimeGuard: Safe and Helpful LLMs through Tuning-Free Routing](https://arxiv.org/abs/2407.16318)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/07] **[Figure it Out: Analyzing-based Jailbreak Attack on Large Language Models](https://arxiv.org/abs/2407.16205)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[RedAgent: Red Teaming Large Language Models with Context-aware Autonomous Language Agent](https://arxiv.org/abs/2407.16667)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Agent](https://img.shields.io/badge/Agent-87b800)
- [2024/07] **[Arondight: Red Teaming Large Vision Language Models with Auto-generated Multi-modal Jailbreak Prompts](https://arxiv.org/abs/2407.15050)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/07] **[When Do Universal Image Jailbreaks Transfer Between Vision-Language Models?](https://arxiv.org/abs/2407.15211)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/07] **[Imposter.AI: Adversarial Attacks with Hidden Intentions towards Aligned Large Language Models](https://arxiv.org/abs/2407.15399)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Does Refusal Training in LLMs Generalize to the Past Tense?](https://arxiv.org/abs/2407.11969)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Continuous Embedding Attacks via Clipped Inputs in Jailbreaking Large Language Models](https://arxiv.org/abs/2407.13796)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Jailbreak Attacks and Defenses Against Large Language Models: A Survey](https://arxiv.org/abs/2407.04295)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2024/07] **[DART: Deep Adversarial Automated Red Teaming for LLM Safety](https://arxiv.org/abs/2407.03876)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[JailbreakZoo: Survey, Landscapes, and Horizons in Jailbreaking Large Language and Vision-Language Models](https://arxiv.org/abs/2407.01599)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2024/07] **[SoP: Unlock the Power of Social Facilitation for Automatic Jailbreak Attack](https://arxiv.org/abs/2407.01902)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Image-to-Text Logic Jailbreak: Your Imagination can Help You Do Anything](https://arxiv.org/abs/2407.02534)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/07] **[A False Sense of Safety: Unsafe Information Leakage in 'Safe' AI Responses](https://arxiv.org/abs/2407.02551)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/07] **[Safe Unlearning: A Surprisingly Effective and Generalizable Solution to Defend Against Jailbreak Attacks](https://arxiv.org/abs/2407.02855)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/07] **[Badllama 3: removing safety finetuning from Llama 3 in minutes](https://arxiv.org/abs/2407.01376)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Virtual Context: Enhancing Jailbreak Attacks with Special Token Injection](https://arxiv.org/abs/2406.19845)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Covert Malicious Finetuning: Challenges in Safeguarding LLM Adaptation](https://arxiv.org/abs/2406.20053)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Poisoned LangChain: Jailbreak LLMs by LangChain](https://arxiv.org/abs/2406.18122)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[WildGuard: Open One-Stop Moderation Tools for Safety Risks, Jailbreaks, and Refusals of LLMs](https://arxiv.org/abs/2406.18495)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[WildTeaming at Scale: From In-the-Wild Jailbreaks to (Adversarially) Safer Language Models](https://arxiv.org/abs/2406.18510)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[SafeAligner: Safety Alignment against Jailbreak Attacks via Response Disparity Guidance](https://arxiv.org/abs/2406.18118)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/06] **[Adversaries Can Misuse Combinations of Safe Models](https://arxiv.org/abs/2406.14595)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Jailbreak Paradox: The Achilles' Heel of LLMs](https://arxiv.org/abs/2406.12702)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **["Not Aligned" is Not "Malicious": Being Careful about Hallucinations of Large Language Models' Jailbreak](https://arxiv.org/abs/2406.11668)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Knowledge-to-Jailbreak: One Knowledge Point Worth One Attack](https://arxiv.org/abs/2406.11682)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Understanding Jailbreak Success: A Study of Latent Space Dynamics in Large Language Models](https://arxiv.org/abs/2406.09289)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[StructuralSleight: Automated Jailbreak Attacks on Large Language Models Utilizing Uncommon Text-Encoded Structure](https://arxiv.org/abs/2406.08754)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[When LLM Meets DRL: Advancing Jailbreaking Efficiency via DRL-guided Search](https://arxiv.org/abs/2406.08705)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[RL-JACK: Reinforcement Learning-powered Black-box Jailbreaking Attack against LLMs](https://arxiv.org/abs/2406.08725)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Bag of Tricks: Benchmarking of Jailbreak Attacks on LLMs](https://arxiv.org/abs/2406.09324)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/usail-hkust/Bag_of_Tricks_for_LLM_Jailbreaking) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[MLLMGuard: A Multi-dimensional Safety Evaluation Suite for Multimodal Large Language Models](https://arxiv.org/abs/2406.07594)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/06] **[Merging Improves Self-Critique Against Jailbreak Attacks](https://arxiv.org/abs/2406.07188)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[How Alignment and Jailbreak Work: Explain LLM Safety through Intermediate Hidden States](https://arxiv.org/abs/2406.05644)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[SelfDefend: LLMs Can Defend Themselves against Jailbreaking in a Practical Manner](https://arxiv.org/abs/2406.05498)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/06] **[Unveiling the Safety of GPT-4o: An Empirical Study using Jailbreak Attacks](https://arxiv.org/abs/2406.06302)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/06] **[Adversarial Tuning: Defending Against Jailbreak Attacks for LLMs](https://arxiv.org/pdf/2406.06622)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/06] **[Improving Alignment and Robustness with Short Circuiting](https://arxiv.org/abs/2406.04313)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/06] **[Are PPO-ed Language Models Hackable? ](https://arxiv.org/abs/2406.02577)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Cross-Modal Safety Alignment: Is textual unlearning all you need?](https://arxiv.org/abs/2406.02575)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/06] **[Defending Large Language Models Against Attacks With Residual Stream Activation Analysis](https://arxiv.org/abs/2406.03230)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/06] **[Jailbreak Vision Language Models via Bi-Modal Adversarial Prompt](https://arxiv.org/abs/2406.04031)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/06] **[AutoJailbreak: Exploring Jailbreak Attacks and Defenses through a Dependency Lens](https://arxiv.org/abs/2406.03805)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[Improved Few-Shot Jailbreaking Can Circumvent Aligned Language Models and Their Defenses](https://arxiv.org/abs/2406.01288)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/06] **[BELLS: A Framework Towards Future Proof Benchmarks for the Evaluation of LLM Safeguards](https://arxiv.org/abs/2406.01364)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[Improved Techniques for Optimization-Based Jailbreaking on Large Language Models](https://arxiv.org/abs/2405.21018)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Jailbreaking Large Language Models Against Moderation Guardrails via Cipher Characters](https://arxiv.org/abs/2405.20413)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Visual-RolePlay: Universal Jailbreak Attack on MultiModal Large Language Models via Role-playing Image Characte](https://arxiv.org/abs/2405.20773)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/05] **[Cross-Modality Jailbreak and Mismatched Attacks on Medical Multimodal Large Language Models](https://arxiv.org/abs/2405.20775)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/05] **[Improved Generation of Adversarial Examples Against Safety-aligned LLMs](https://arxiv.org/abs/2405.20778)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Robustifying Safety-Aligned Large Language Models through Clean Data Curation](https://arxiv.org/abs/2405.19358)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[Defensive Prompt Patch: A Robust and Interpretable Defense of LLMs against Jailbreak Attacks](https://arxiv.org/abs/2405.20099)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[Voice Jailbreak Attacks Against GPT-4o](https://arxiv.org/abs/2405.19103)** ![SLM](https://img.shields.io/badge/SLM-39c5bb)
- [2024/05] **[Defending Large Language Models Against Jailbreak Attacks via Layer-specific Editing](https://arxiv.org/abs/2405.18166)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[Automatic Jailbreaking of the Text-to-Image Generative AI Systems](https://arxiv.org/abs/2405.16567)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/05] **[Hacc-Man: An Arcade Game for Jailbreaking LLMs](https://arxiv.org/abs/2405.15902)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Efficient Adversarial Training in LLMs with Continuous Attacks](https://arxiv.org/abs/2405.15589)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[JailbreakEval: An Integrated Safety Evaluator Toolkit for Assessing Jailbreaks Against Large Language Models](https://arxiv.org/abs/2406.09321)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/ThuCCSLab/JailbreakEval) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Toolkit](https://img.shields.io/badge/Toolkit-87b800)
- [2024/05] **[Cross-Task Defense: Instruction-Tuning LLMs for Content Safety](https://arxiv.org/abs/2405.15202)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/05] **[Lockpicking LLMs: A Logit-Based Jailbreak Using Token-level Manipulation](https://arxiv.org/abs/2405.13068)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[GPT-4 Jailbreaks Itself with Near-Perfect Success Using Self-Explanation](https://arxiv.org/abs/2405.13077)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Chain of Attack: a Semantic-Driven Contextual Multi-Turn attacker for LLM](https://arxiv.org/abs/2405.05610)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/05] **[Can LLMs Deeply Detect Complex Malicious Queries? A Framework for Jailbreaking via Obfuscating Intent](https://arxiv.org/abs/2405.03654)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Don't Say No: Jailbreaking LLM by Suppressing Refusal](https://arxiv.org/abs/2404.16369)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Universal Adversarial Triggers Are Not Universal](https://arxiv.org/abs/2404.16020)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[AdvPrompter: Fast Adaptive Adversarial Prompting for LLMs](https://arxiv.org/abs/2404.16873)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![AI_at_Meta](https://img.shields.io/badge/AI_at_Meta-f1b800)
- [2024/04] **[The Instruction Hierarchy: Training LLMs to Prioritize Privileged Instructions](https://arxiv.org/abs/2404.13208)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800) ![OpenAI](https://img.shields.io/badge/OpenAI-f1b800)
- [2024/04] **[Competition Report: Finding Universal Jailbreak Backdoors in Aligned LLMs](https://arxiv.org/abs/2404.14461)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Protecting Your LLMs with Information Bottleneck](https://arxiv.org/abs/2404.13968)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/04] **[JailbreakLens: Visual Analysis of Jailbreak Attacks Against Large Language Models](https://arxiv.org/abs/2404.08793)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[AmpleGCG: Learning a Universal and Transferable Generative Model of Adversarial Suffixes for Jailbreaking Both Open and Closed LLMs](https://arxiv.org/abs/2404.07921)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Sandwich attack: Multi-language Mixture Adaptive Attack on LLMs](https://arxiv.org/abs/2404.07242)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[AEGIS: Online Adaptive AI Content Safety Moderation with Ensemble of LLM Experts](https://arxiv.org/abs/2404.05993)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Eraser: Jailbreaking Defense in Large Language Models via Unlearning Harmful Knowledge](https://arxiv.org/abs/2404.05880)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Take a Look at it! Rethinking How to Evaluate Language Model Jailbreak](https://arxiv.org/abs/2404.06407)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Unbridled Icarus: A Survey of the Potential Perils of Image Inputs in Multimodal Large Language Model Security](https://arxiv.org/abs/2404.05264)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/04] **[Increased LLM Vulnerabilities from Fine-tuning and Quantization](https://arxiv.org/abs/2404.04392)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Red Teaming GPT-4V: Are GPT-4V Safe Against Uni/Multi-Modal Jailbreak Attacks?](https://arxiv.org/abs/2404.03411)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/04] **[Jailbreaking Prompt Attack: A Controllable Adversarial Attack against Diffusion Models](https://arxiv.org/abs/2404.02928)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2024/04] **[JailBreakV-28K: A Benchmark for Assessing the Robustness of MultiModal Large Language Models against Jailbreak Attacks](https://arxiv.org/abs/2404.03027)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/04] **[JailbreakBench: An Open Robustness Benchmark for Jailbreaking Large Language Models](https://arxiv.org/abs/2404.01318)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/04] **[Great, Now Write an Article About That: The Crescendo Multi-Turn LLM Jailbreak Attack](https://arxiv.org/abs/2404.01833)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Jailbreaking Leading Safety-Aligned LLMs with Simple Adaptive Attacks](https://arxiv.org/abs/2404.02151)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/04] **[Many-shot Jailbreaking](https://cdn.sanity.io/files/4zrzovbb/website/af5633c94ed2beb282f6a53c595eb437e8e7b630.pdf)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/03] **[Against The Achilles' Heel: A Survey on Red Teaming for Generative Models](https://arxiv.org/abs/2404.00629)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2024/03] **[Don't Listen To Me: Understanding and Exploring Jailbreak Prompts of Large Language Models](https://arxiv.org/abs/2403.17336)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![USENIX_Security'24](https://img.shields.io/badge/USENIX_Security'24-f1b800)
- [2024/03] **[Jailbreaking is Best Solved by Definition](https://arxiv.org/abs/2403.14725)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/03] **[Detoxifying Large Language Models via Knowledge Editing](https://arxiv.org/abs/2403.14472)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/zjunlp/EasyEdit) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/03] **[RigorLLM: Resilient Guardrails for Large Language Models against Undesired Content](https://arxiv.org/abs/2403.13031)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/03] **[Images are Achilles’ Heel of Alignment: Exploiting Visual Vulnerabilities for Jailbreaking Multimodal Large Language Models](https://arxiv.org/abs/2403.09792)** ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/03] **[AdaShield: Safeguarding Multimodal Large Language Models from Structure-based Attack via Adaptive Shield Prompting](https://arxiv.org/abs/2403.09513)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/03] **[Tastle: Distract Large Language Models for Automatic Jailbreak Attack](https://arxiv.org/abs/2403.08424)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/03] **[CodeAttack: Revealing Safety Generalization Challenges of Large Language Models via Code Completion](https://aclanthology.org/2024.findings-acl.679/)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ACL'24_(Findings)](https://img.shields.io/badge/ACL'24_(Findings)-f1b800)
- [2024/03] **[AutoDefense: Multi-Agent LLM Defense against Jailbreak Attacks](https://arxiv.org/abs/2403.04783)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/03] **[Gradient Cuff: Detecting Jailbreak Attacks on Large Language Models by Exploring Refusal Loss Landscapes](https://arxiv.org/abs/2403.00867)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/02] **[Leveraging the Context through Multi-Round Interactions for Jailbreaking Attacks](https://arxiv.org/abs/2402.09177)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Making Them Ask and Answer: Jailbreaking Large Language Models in Few Queries via Disguise and Reconstruction](https://arxiv.org/abs/2402.18104)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[DrAttack: Prompt Decomposition and Reconstruction Makes Powerful LLM Jailbreakers](https://arxiv.org/abs/2402.16914)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[GUARD: Role-playing to Generate Natural-language Jailbreakings to Test Guideline Adherence of Large Language Models](https://arxiv.org/abs/2402.03299)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[CodeChameleon: Personalized Encryption Framework for Jailbreaking Large Language Models](https://arxiv.org/abs/2402.16717)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[PRP: Propagating Universal Perturbations to Attack Large Language Model Guard-Rails](https://arxiv.org/abs/2402.15911)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Defending Large Language Models against Jailbreak Attacks via Semantic Smoothing ](https://arxiv.org/abs/2402.16192)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/UCSB-NLP-Chang/SemanticSmooth) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/02] **[LLMs Can Defend Themselves Against Jailbreaking in a Practical Manner: A Vision Paper](https://arxiv.org/abs/2402.15727)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/02] **[From Noise to Clarity: Unraveling the Adversarial Suffix of Large Language Model Attacks via Translation of Text Embeddings](https://arxiv.org/abs/2402.16006)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Semantic Mirror Jailbreak: Genetic Algorithm Based Jailbreak Prompts Against Open-source LLMs](https://arxiv.org/abs/2402.14872)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Is the System Message Really Important to Jailbreaks in Large Language Models?](https://arxiv.org/abs/2402.14857)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Break the Breakout: Reinventing LM Defense Against Jailbreak Attacks with Self-Refinement](https://arxiv.org/abs/2402.15180)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[How (un)ethical are instruction-centric responses of LLMs? Unveiling the vulnerabilities of safety guardrails to harmful queries](https://arxiv.org/abs/2402.15302)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Mitigating Fine-tuning Jailbreak Attack with Backdoor Enhanced Alignment](https://arxiv.org/abs/2402.14968)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/02] **[LLM Jailbreak Attack versus Defense Techniques -- A Comprehensive Study](https://arxiv.org/abs/2402.13457)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2024/02] **[Coercing LLMs to do and reveal (almost) anything](https://arxiv.org/abs/2402.14020)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[GradSafe: Detecting Unsafe Prompts for LLMs via Safety-Critical Gradient Analysis](https://aclanthology.org/2024.acl-long.30/)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/xyq7/GradSafe) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2024/02] **[Query-Based Adversarial Prompt Generation](https://arxiv.org/abs/2402.12329)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[ArtPrompt: ASCII Art-based Jailbreak Attacks against Aligned LLMs](https://arxiv.org/abs/2402.11753)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/uw-nsl/ArtPrompt) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2024/02] **[SPML: A DSL for Defending Language Models Against Prompt Attacks](https://arxiv.org/abs/2402.11755)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[A StrongREJECT for Empty Jailbreaks](https://arxiv.org/abs/2402.10260)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![New_dataset](https://img.shields.io/badge/New_dataset-87b800)
- [2024/02] **[Jailbreaking Proprietary Large Language Models using Word Substitution Cipher](https://arxiv.org/abs/2402.10601)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[ToolSword: Unveiling Safety Issues of Large Language Models in Tool Learning Across Three Stages](https://aclanthology.org/2024.acl-long.119/)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Junjie-Ye/ToolSword) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Tool_learning](https://img.shields.io/badge/Tool_learning-87b800) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2024/02] **[PAL: Proxy-Guided Black-Box Attack on Large Language Models ](https://arxiv.org/abs/2402.09674)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/chawins/pal) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Attacking Large Language Models with Projected Gradient Descent ](https://arxiv.org/abs/2402.09154)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[SafeDecoding: Defending against Jailbreak Attacks via Safety-Aware Decoding ](https://aclanthology.org/2024.acl-long.303/)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/uw-nsl/SafeDecoding) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2024/02] **[Play Guessing Game with LLM: Indirect Jailbreak Attack with Implicit Clues ](https://arxiv.org/abs/2402.09091)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[COLD-Attack: Jailbreaking LLMs with Stealthiness and Controllability](https://arxiv.org/abs/2402.08679)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Yu-Fangxu/COLD-Attack) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Agent Smith: A Single Image Can Jailbreak One Million Multimodal LLM Agents Exponentially Fast](https://arxiv.org/abs/2402.08567)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://sail-sg.github.io/Agent-Smith/) ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Agent](https://img.shields.io/badge/Agent-87b800) ![ICML'24](https://img.shields.io/badge/ICML'24-f1b800)
- [2024/02] **[Pandora: Jailbreak GPTs by Retrieval Augmented Generation Poisoning](https://arxiv.org/abs/2402.08416)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![RAG](https://img.shields.io/badge/RAG-87b800)
- [2024/02] **[Comprehensive Assessment of Jailbreak Attacks Against LLMs ](https://arxiv.org/abs/2402.05668)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/02] **[Safety Fine-Tuning at (Almost) No Cost: A Baseline for Vision Large Language Models](https://arxiv.org/abs/2402.02207)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/02] **[HarmBench: A Standardized Evaluation Framework for Automated Red Teaming and Robust Refusal](https://arxiv.org/abs/2402.04249)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/centerforaisafety/HarmBench) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2024/02] **[Jailbreaking Attack against Multimodal Large Language Model](https://arxiv.org/abs/2402.02309)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/abc03570128/Jailbreaking-Attack-against-Multimodal-Large-Language-Model) ![VLM](https://img.shields.io/badge/VLM-c7688b)
- [2024/02] **[Prompt-Driven LLM Safeguarding via Directed Representation Optimization](https://arxiv.org/abs/2401.18018)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/01] **[On Prompt-Driven Safeguarding for Large Language Models](https://arxiv.org/abs/2401.18018)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICML'24](https://img.shields.io/badge/ICML'24-f1b800)
- [2024/01] **[A Cross-Language Investigation into Jailbreak Attacks in Large Language Models](https://arxiv.org/abs/2401.16765)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[Weak-to-Strong Jailbreaking on Large Language Models ](https://arxiv.org/abs/2401.17256)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/XuandongZhao/weak-to-strong) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[Robust Prompt Optimization for Defending Language Models Against Jailbreaking Attacks](https://arxiv.org/abs/2401.17263)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/andyz245/rpo) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/01] **[Jailbreaking GPT-4V via Self-Adversarial Attacks with System Prompts](https://arxiv.org/abs/2311.09127)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[PsySafe: A Comprehensive Framework for Psychological-based Attack, Defense, and Evaluation of Multi-agent System Safety](https://arxiv.org/abs/2401.11880)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https:/github.com/AI4Good24/PsySafe) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Agent](https://img.shields.io/badge/Agent-87b800) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800) ![Best Paper](https://img.shields.io/badge/Best_paper-ff0000)
- [2024/01] **[Sowing the Wind, Reaping the Whirlwind: The Impact of Editing Language Models](https://arxiv.org/abs/2401.10647)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[Pruning for Protection: Increasing Jailbreak Resistance in Aligned LLMs Without Fine-Tuning](https://arxiv.org/abs/2401.10862)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/CrystalEye42/eval-safety) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/01] **[All in How You Ask for It: Simple Black-Box Method for Jailbreak Attacks](https://arxiv.org/abs/2401.09798)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/kztakemoto/simbaja) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[AttackEval: How to Evaluate the Effectiveness of Jailbreak Attacking on Large Language Models](https://arxiv.org/abs/2401.09002)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2024/01] **[Intention Analysis Prompting Makes Large Language Models A Good Jailbreak Defender](https://arxiv.org/abs/2401.06561)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2024/01] **[How Johnny Can Persuade LLMs to Jailbreak Them: Rethinking Persuasion to Challenge AI Safety by Humanizing LLMs](https://arxiv.org/abs/2401.06373)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/CHATS-lab/persuasive_jailbreaker) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ACL'24](https://img.shields.io/badge/ACL'24-f1b800)
- [2023/12] **[A Comprehensive Survey of Attack Techniques, Implementation, and Mitigation Strategies in Large Language Models](https://arxiv.org/abs/2312.10982)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2023/12] **[Analyzing the Inherent Response Tendency of LLMs: Real-World Instructions-Driven Jailbreak](https://arxiv.org/abs/2312.04127)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/12] **[Goal-Oriented Prompt Attack and Safety Evaluation for LLMs](https://arxiv.org/abs/2309.11830)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/12] **[Tree of Attacks: Jailbreaking Black-Box LLMs Automatically](https://arxiv.org/abs/2312.02119)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/12] **[Safety Alignment in NLP Tasks: Weakly Aligned Summarization as an In-Context Attack](https://arxiv.org/abs/2312.06924)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/12] **[A Mutation-Based Method for Multi-Modal Jailbreaking Attack Detection](https://arxiv.org/abs/2312.10766)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/12] **[Adversarial Attacks on GPT-4 via Simple Random Search](https://www.andriushchenko.me/gpt4adv.pdf)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/12] **[On Large Language Models’ Resilience to Coercive Interrogation](https://www.computer.org/csdl/proceedings-article/sp/2024/313000a252/1WPcZ9B0jCg)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![CodeGen](https://img.shields.io/badge/CodeGen-87b800) ![S&P'24](https://img.shields.io/badge/S&P'24-f1b800)
- [2023/11] **[MM-SafetyBench: A Benchmark for Safety Evaluation of Multimodal Large Language Models](https://arxiv.org/abs/2311.17600)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![ECCV'24](https://img.shields.io/badge/ECCV'24-f1b800)
- [2023/11] **[A Wolf in Sheep's Clothing: Generalized Nested Jailbreak Prompts Can Fool Large Language Models Easily](https://arxiv.org/abs/2311.08268)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[Exploiting Programmatic Behavior of LLMs: Dual-Use Through Standard Security Attacks](https://arxiv.org/abs/2302.05733)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[MART: Improving LLM Safety with Multi-round Automatic Red-Teaming](https://arxiv.org/abs/2311.07689)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[Scalable and Transferable Black-Box Jailbreaks for Language Models via Persona Modulation](https://arxiv.org/abs/2311.03348)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[SneakyPrompt: Jailbreaking Text-to-image Generative Models](https://arxiv.org/abs/2305.12082)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Yuchen413/text2image_safety) ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4) ![S&P'24](https://img.shields.io/badge/S&P'24-f1b800)
- [2023/11] **[DeepInception: Hypnotize Large Language Model to Be Jailbreaker](https://arxiv.org/abs/2311.03191)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/tmlr-group/DeepInception?tab=readme-ov-file) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[Summon a Demon and Bind it: A Grounded Theory of LLM Red Teaming in the Wild](https://arxiv.org/abs/2311.06237)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/11] **[Evil Geniuses: Delving into the Safety of LLM-based Agents](https://arxiv.org/abs/2311.11855)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Agent](https://img.shields.io/badge/Agent-87b800)
- [2023/11] **[FigStep: Jailbreaking Large Vision-language Models via Typographic Visual Prompts](https://arxiv.org/abs/2311.05608)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/ThuCCSLab/FigStep) ![VLM](https://img.shields.io/badge/VLM-c7688b) ![AAAI'25](https://img.shields.io/badge/AAAI'25-f1b800)
- [2023/10] **[Attack Prompt Generation for Red Teaming and Defending Large Language Models](https://arxiv.org/abs/2310.12505)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Aatrox103/SAP) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/10] **[Survey of Vulnerabilities in Large Language Models Revealed by Adversarial Attack](https://arxiv.org/abs/2310.10844)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Survey](https://img.shields.io/badge/Survey-87b800)
- [2023/10] **[Low-Resource Languages Jailbreak GPT-4](https://arxiv.org/abs/2310.02446)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/10] **[SC-Safety: A Multi-round Open-ended Question Adversarial Safety Benchmark for Large Language Models in Chinese](https://arxiv.org/abs/2310.05818)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800) ![_Chinese](https://img.shields.io/badge/_Chinese-87b800)
- [2023/10] **[SmoothLLM: Defending Large Language Models Against Jailbreaking Attacks](https://arxiv.org/abs/2310.03684)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/10] **[Adversarial Attacks on LLMs](https://lilianweng.github.io/posts/2023-10-25-adv-attack-llm/)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Blog](https://img.shields.io/badge/Blog-f1b800)
- [2023/10] **[AutoDAN: Interpretable Gradient-Based Adversarial Attacks on Large Language Models](https://arxiv.org/abs/2310.15140)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/10] **[Jailbreak and Guard Aligned Language Models with Only Few In-Context Demonstrations](https://arxiv.org/abs/2310.06387)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/10] **[Jailbreaking Black Box Large Language Models in Twenty Queries](https://arxiv.org/abs/2310.08419)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/patrickrchao/JailbreakingLLMs) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/09] **[Baseline Defenses for Adversarial Attacks Against Aligned Language Models](https://arxiv.org/abs/2309.00614)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/09] **[Certifying LLM Safety against Adversarial Prompting](https://arxiv.org/abs/2309.02705)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/09] **[SurrogatePrompt: Bypassing the Safety Filter of Text-To-Image Models via Substitution](https://arxiv.org/abs/2309.14122)** ![Diffusion](https://img.shields.io/badge/Diffusion-a99cf4)
- [2023/09] **[Catastrophic Jailbreak of Open-source LLMs via Exploiting Generation](https://openreview.net/forum?id=r42tSSCHPh)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/Princeton-SysML/Jailbreak_LLM) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24_(Spotlight)](https://img.shields.io/badge/ICLR'24_(Spotlight)-f1b800)
- [2023/09] **[AutoDAN: Generating Stealthy Jailbreak Prompts on Aligned Large Language Models](https://openreview.net/forum?id=7Jwpw4qKkb)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/SheltonLiu-N/AutoDAN) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[GPT-4 Is Too Smart To Be Safe: Stealthy Chat with LLMs via Cipher](https://openreview.net/forum?id=MbfAK4s61A)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/RobustNLP/CipherChat) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[Jailbreak in pieces: Compositional Adversarial Attacks on Multi-Modal Language Models](https://openreview.net/forum?id=plmBsXHxgR)** ![VLM](https://img.shields.io/badge/VLM-c7688b) ![ICLR'24_(Spotlight)](https://img.shields.io/badge/ICLR'24_(Spotlight)-f1b800)
- [2023/09] **[Multilingual Jailbreak Challenges in Large Language Models](https://openreview.net/forum?id=vESNKdEMGp)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[On the Humanity of Conversational AI: Evaluating the Psychological Portrayal of LLMs](https://openreview.net/forum?id=H3UayAQWoE)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24_(Oral)](https://img.shields.io/badge/ICLR'24_(Oral)-f1b800)
- [2023/09] **[RAIN: Your Language Models Can Align Themselves without Finetuning](https://openreview.net/forum?id=pETSfWMUzy)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[Safety-Tuned LLaMAs: Lessons From Improving the Safety of Large Language Models that Follow Instructions](https://openreview.net/forum?id=gT5hALch9z)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[Understanding Hidden Context in Preference Learning: Consequences for RLHF](https://openreview.net/forum?id=0tWTxYYPnW)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![ICLR'24](https://img.shields.io/badge/ICLR'24-f1b800)
- [2023/09] **[Defending Against Alignment-Breaking Attacks via Robustly Aligned LLM](https://arxiv.org/abs/2309.14348)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/09] **[FuzzLLM: A Novel and Universal Fuzzing Framework for Proactively Discovering Jailbreak Vulnerabilities in Large Language Models](https://arxiv.org/abs/2309.05274)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/09] **[GPTFUZZER: Red Teaming Large Language Models with Auto-Generated Jailbreak Prompts](https://arxiv.org/abs/2309.10253)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/sherdencooper/GPTFuzz) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/09] **[Open Sesame! Universal Black Box Jailbreaking of Large Language Models](https://arxiv.org/abs/2309.01446)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/08] **[Red-Teaming Large Language Models using Chain of Utterances for Safety-Alignment](https://arxiv.org/abs/2308.09662)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/declare-lab/red-instruct) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/08] **[XSTest: A Test Suite for Identifying Exaggerated Safety Behaviours in Large Language Models](https://arxiv.org/abs/2308.01263)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/paul-rottger/exaggerated-safety) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/08] **[“Do Anything Now”: Characterizing and Evaluating In-The-Wild Jailbreak Prompts on Large Language Models](https://arxiv.org/abs/2308.03825)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/verazuo/jailbreak_llms) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![CCS'24](https://img.shields.io/badge/CCS'24-f1b800)
- [2023/08] **[Detecting Language Model Attacks with Perplexity](https://arxiv.org/abs/2308.14132)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Defense](https://img.shields.io/badge/Defense-87b800)
- [2023/07] **[From ChatGPT to ThreatGPT: Impact of Generative AI in Cybersecurity and Privacy](https://ieeexplore.ieee.org/abstract/document/10198233)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![IEEE_Access](https://img.shields.io/badge/IEEE_Access-f1b800)
- [2023/07] **[LLM Censorship: A Machine Learning Challenge Or A Computer Security Problem?](https://arxiv.org/abs/2307.10719)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/07] **[Latent Jailbreak: A Benchmark for Evaluating Text Safety and Output Robustness of Large Language Models](https://arxiv.org/abs/2307.08487)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](qiuhuachuan/latent-jailbreak (github.com)) ![LLM](https://img.shields.io/badge/LLM-589cf4) ![Benchmark](https://img.shields.io/badge/Benchmark-87b800)
- [2023/07] **[Jailbroken: How Does LLM Safety Training Fail?](https://arxiv.org/abs/2307.02483)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![NeurIPS'23](https://img.shields.io/badge/NeurIPS'23-f1b800)
- [2023/07] **[MasterKey: Automated Jailbreak Across Multiple Large Language Model Chatbots](https://arxiv.org/abs/2307.08715)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![NDSS'24](https://img.shields.io/badge/NDSS'24-f1b800)
- [2023/07] **[Universal and Transferable Adversarial Attacks on Aligned Language Models](https://arxiv.org/abs/2307.15043)** [<img src="https://github.com/FortAwesome/Font-Awesome/blob/6.x/svgs/brands/github.svg" alt="Code" width="15" height="15">](https://github.com/llm-attacks/llm-attacks) ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/06] **[Visual Adversarial Examples Jailbreak Aligned Large Language Models](https://arxiv.org/abs/2306.13213)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![AAAI'24](https://img.shields.io/badge/AAAI'24-f1b800)
- [2023/05] **[Adversarial demonstration attacks on large language models.](https://arxiv.org/abs/2305.14950)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/05] **[Jailbreaking ChatGPT via Prompt Engineering: An Empirical Study](https://arxiv.org/abs/2305.13860)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/05] **[Tricking LLMs into Disobedience: Understanding, Analyzing, and Preventing Jailbreaks](https://arxiv.org/abs/2305.14965)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
- [2023/04] **[Multi-step Jailbreaking Privacy Attacks on ChatGPT](https://arxiv.org/abs/2304.05197)** ![LLM](https://img.shields.io/badge/LLM-589cf4) ![EMNLP'23_(Findings)](https://img.shields.io/badge/EMNLP'23_(Findings)-f1b800)
- [2023/03] **[Automatically Auditing Large Language Models via Discrete Optimization](https://arxiv.org/abs/2303.04381)** ![LLM](https://img.shields.io/badge/LLM-589cf4)
