# Contributing

First off, thanks for taking the time to contribute!

### How can I contribute?

* Fork this project;
* Make your changes / new implementatios;
* Use the pattern for git commts; 
* Make sure that the acceptance criteria are met (tests, docs, etc);
* Create a pull request;

### Pull Requests

Template [PULLREQUEST-TEMPLATE](PULLREQUEST-TEMPLATE.md)

### Git Commit Messages

* Use the present tense ("Adds feature" not "Added feature")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally
* Consider starting the commit message with an applicable emoji:
    * :art: `:art:` when improving the format/structure of the code
    * :racehorse: `:racehorse:` when improving performance
    * :non-potable_water: `:non-potable_water:` when plugging memory leaks
    * :memo: `:memo:` when writing docs
    * :penguin: `:penguin:` when fixing something on Linux
    * :apple: `:apple:` when fixing something on Mac OS
    * :checkered_flag: `:checkered_flag:` when fixing something on Windows
    * :bug: `:bug:` when fixing a bug
    * :fire: `:fire:` when removing code or files
    * :green_heart: `:green_heart:` when fixing the CI build
    * :white_check_mark: `:white_check_mark:` when adding tests
    * :lock: `:lock:` when dealing with security
    * :arrow_up: `:arrow_up:` when upgrading dependencies
    * :arrow_down: `:arrow_down:` when downgrading dependencies
    * :shirt: `:shirt:` when removing linter warnings
    * :bulb: `:bulb:` new idea
    * :construction: `:construction:` work in progress
    * :heavy_plus_sign: `:heavy_plus_sign:` when adding features
    * :heavy_minus_sign: `:heavy_minus_sign:` when removing features
    * :speaker: `:mute:` when adding logging
    * :mute: `:mute:` when reducing logging
    * :facepunch: `:facepunch:` when resolve conflict
    * :wrench: `:wrench:` when modify Web.config

