// Copyright © 2023 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import createRequestLogic from '@ttn-lw/lib/store/logics/create-request-logic'
import * as search from '@ttn-lw/lib/store/actions/search-accounts'

export default tts => {
  const getUserLogic = createRequestLogic({
    type: search.SEARCH_ACCOUNTS,
    process: async ({ action }) => {
      const { query, onlyUsers, collaboratorOf } = action.payload

      const request = {
        query,
        only_users: onlyUsers,
      }
      if (Boolean(collaboratorOf)) {
        request[collaboratorOf.path] = collaboratorOf.id
        request.complement_collaborators = true
      }

      return await tts.SearchAccounts.searchAccounts(request)
    },
  })

  return getUserLogic
}
