// Copyright © 2020 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Layout configurations. Keep these in line with
// `styles/variables/generic.styl`.

export default Object.freeze({
  BREAKPOINTS: {
    '3XS': 376,
    XXS: 480,
    XS: 620,
    S: 768,
    M: 1080,
    L: 1340,
    XL: 1600,
  },
  CONTAINER_WIDTHS: {
    XS: 768,
    S: 1000,
    M: 1140,
    L: 1280,
  },
  GUTTER_WIDTH: 28,
})
